/********************************************************************************
* Copyright (c) Razvan Surdulescu 1996
*               Erik Kunze        1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Razvan Surdulescu
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: menu.c,v 4.40 1999/04/23 15:33:12 erik Rel $";
#endif
#include <X11/keysym.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "z80.h"
#include "resource.h"
#include "mem.h"
#include "machine.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#include "emul.h"
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef XZX_KMOUSE
#include "kmouse.h"
#endif
#include "loadsave.h"
#include "monitor.h"
#include "scrdump.h"
#include "screen.h"
#include "snapshot.h"
#include "menu.h"
#define PARA_COLUMN 	24
static int displayKeyboardLayout(void);
static void genericMenu(void);
#ifdef AUDIO
static void soundMenu(void);
#endif
static void joyMenu(void);
#if defined(XZX_IF1) || defined(XZX_PLUS3)
static void diskMenu(void);
#endif
static void tapeMenu(void);
static const char *mainMenuTxt[] = {
"Main Menu",
"Keyboard layout             F1",
"Save snapshot               F2",
"Load snapshot               F3",
"Save screenshot             F4",
"Tape Options",
"Reset                       F5",
"NMI                         F6",
"Debugger                    F7",
"Generic Options",
#ifdef AUDIO
"Sound Options",
#else
"`Sound Options",
#endif
"Joystick Options",
#if defined(XZX_IF1) || defined(XZX_PLUS3)
"Interface I/+3 Options",
#else
"`Interface I/+3 Options",
#endif
"Choose Architecture         F9",
"Quit                       F10",
NULL
};
static const char *architMenuTxt[] = {
"Architecture Options",
"Spectrum 48K  (reset)",
"Spectrum 128k (reset)",
#ifdef XZX_PLUS3
"Spectrum +3   (reset)",
#else
"`Spectrum +3   (reset)",
#endif
#ifdef XZX_PENTAGON
"Pentagon      (reset)",
#else
"`Pentagon      (reset)",
#endif
#ifdef XZX_SCORPION
"Scorpion      (reset)",
#else
"`Scorpion      (reset)",
#endif
"",
"Spectrum 48K  (no reset)",
"Spectrum 128k (no reset)",
#ifdef XZX_PLUS3
"Spectrum +3   (no reset)",
#else
"`Spectrum +3   (no reset)",
#endif
#ifdef XZX_PENTAGON
"Pentagon      (no reset)",
#else
"`Pentagon      (no reset)",
#endif
#ifdef XZX_SCORPION
"Scorpion      (no reset)",
#else
"`Scorpion      (no reset)",
#endif
"",
#ifdef XZX_IF1
"Interface I           [ ]",
#else
"`Interface I           [ ]",
#endif
#ifdef XZX_MF
"Multiface             [ ]",
#else
"`Multiface             [ ]",
#endif
#ifdef XZX_KMOUSE
"Kempston Mouse        [ ]",
#else
"`Kempston Mouse        [ ]",
#endif
NULL
};
static const char *genericMenuTxt[] = {
"Generic Options",
"Speed                 [      ]",
"Fast mode             [ ]",
"Refresh rate          [      ]",
"Video cache           [ ]",
"Use XSync()           [ ]",
#ifdef XZX_KMOUSE
"Grab pointer          [ ]",
#else
"`Grab pointer          [ ]",
#endif
"Issue                 [ ]",
#ifdef DEBUG
"Debug                 [      ]",
#else
"`Debug                 [      ]",
#endif
NULL
};
#ifdef AUDIO
static const char *soundMenuTxt[] = {
"Sound Options",
#ifdef SPEAKER_AUDIO
"Speaker               [ ]",
#else
"`Speaker               [ ]",
#endif
#ifdef AYCHIP_AUDIO
"AY 8912               [ ]",
#else
"`AY 8912               [ ]",
#endif
#ifdef XBELL_AUDIO
"BEEP                  [ ]",
#else
"`BEEP                  [ ]",
#endif
NULL
};
#endif
static const char *joyMenuTxt[] = {
"Joystick Options",
"Up                    [      ]",
"Down                  [      ]",
"Left                  [      ]",
"Right                 [      ]",
"Fire                  [      ]",
"",
#ifdef JOY
"Analogue joystick     [ ]",
"Tolerance             [      ]",
"Autofire              [      ]",
"L-R Juggle            [      ]",
#else
"`Analogue Joystick     [ ]",
"`Tolerance             [      ]",
"`Autofire              [      ]",
"`L-R Juggle            [      ]",
#endif
NULL
};
#if defined(XZX_IF1) || defined(XZX_PLUS3)
static const char *diskMenuTxt[] = {
"Interface I/+3 Options",
#ifdef XZX_IF1
"Select microdrive     [ ]",
"Insert cartridge",
"Take cartridge out",
"",
"Translate NL          [ ]",
"Strip CR              [ ]",
#else
"`Select microdrive     [ ]",
"`Insert cartridge",
"`Take cartridge out",
"",
"`Translate NL          [ ]",
"`Strip CR              [ ]",
#endif
"",
#ifdef XZX_PLUS3
"Select drive          [ ]",
"Insert disk",
"Take disk out",
#else
"`Select drive          [ ]",
"`Insert disk",
"`Take disk out",
#endif
NULL
};
#endif
static const char *tapeMenuTxt[] = {
"Tape Options",
"Select inputfile",
"Close inputfile",
"Browse through inputfile",
"Playback inputfile    [    ]",
#ifdef NO_ED_TRAPS
"`Quick loading         [ ]",
#else
"Quick loading         [ ]",
#endif
#ifdef SPEAKER_AUDIO
"Loading noise         [ ]",
#else
"`Loading noise         [ ]",
#endif
"",
"Select outputfile",
"Close outputfile",
NULL
};
static int
displayKeyboardLayout()
{
FILE *ifp;
size_t nread;
if (!(ifp = Fopen(GETCFG(kbdlayout), "rb")))
{
Msg(M_PERR, "couldn't open keyboard layout image <%s> for reading",
GETCFG(kbdlayout));
return -1;
}
nread = fread(RealMemory[OSD], 1, PIXEL_LENGTH + ATTR_LENGTH, ifp);
if (nread != PIXEL_LENGTH + ATTR_LENGTH)
{
Msg(M_WARN, "layout image is only %d bytes", nread);
}
(void)fclose(ifp);
SetBorderColor(BLACK);
ForceScreenRefresh();
ScreenRefresh();
return 0;
}
void
MainMenu(unsigned int choice)
{
unsigned int item = choice;
int oldInDialog;
assert(choice < NOPTS(mainMenuTxt));
oldInDialog = EnterOSD();
again:
DisplayMenu(mainMenuTxt);
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(mainMenuTxt), NOPTS(mainMenuTxt),
NULL))
{
case XK_F1:
item = 0;
break;
case XK_F2:
item = 1;
break;
case XK_F3:
item = 2;
break;
case XK_F4:
item = 3;
break;
case XK_F5:
item = 5;
break;
case XK_F6:
item = 6;
break;
case XK_F7:
item = 7;
break;
case XK_F9:
item = 12;
break;
case XK_F10:
case XK_F12:
item = 13;
break;
case XK_Return:
switch(item)
{
case 0:
if (!displayKeyboardLayout())
{
(void)GetKey();
SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
}
break;
case 1:
WriteSnapshotWithFS();
break;
case 2:
ReadSnapshotWithFS();
break;
case 3:
WriteScreenDumpWithFS();
break;
case 4:
tapeMenu();
break;
case 5:
Z80_Reset();
break;
case 6:
Z80_NMI();
break;
case 7:
Debugger(DBG_OSD);
break;
case 8:
genericMenu();
break;
#ifdef AUDIO
case 9:
soundMenu();
break;
#endif
case 10:
joyMenu();
break;
#if defined(XZX_IF1) || defined(XZX_PLUS3)
case 11:
diskMenu();
break;
#endif
case 12:
HardwareMenu();
break;
case 13:
Quit(0);
break;
}
if (item != choice)
{
goto again;
}
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
static void
genericMenu(void)
{
unsigned int item = 0;
int oldInDialog;
int saveSpeed = GETCFG(speed);
char buffer[7];
int val;
oldInDialog = EnterOSD();
DisplayMenu(genericMenuTxt);
again:
SetAttr(MENU_SELECT_ATTR);
(void)sprintf(buffer, "%-6d", GETCFG(speed));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y);
PrintString(buffer);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 1);
PrintLetter(GETCFG(fast) ? 'Y' : 'N');
(void)sprintf(buffer, "%-6d", GETCFG(refresh));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 2);
PrintString(buffer);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 3);
PrintLetter(GETCFG(cache) ? 'Y' : 'N');
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 4);
PrintLetter(GETCFG(xsync) ? 'Y' : 'N');
#ifdef XZX_KMOUSE
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 5);
PrintLetter(GETCFG(kmouseGrab) ? 'Y' : 'N');
#endif
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 6);
PrintLetter('0' + GETCFG(issue));
#ifdef DEBUG
(void)sprintf(buffer, "%-6u", GETCFG(debug));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 7);
PrintString(buffer);
#endif
SetAttr(MENU_TEXT_ATTR);
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(genericMenuTxt),
NOPTS(genericMenuTxt), NULL))
{
case XK_Return:
switch(item)
{
case 0:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val >= 0 && val <= 200)
{
val = ((val + 5) / 10) * 10;
SETCFG(speed, val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
case 1:
SETCFG(fast, !GETCFG(fast));
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioControl(GETCFG(fast) ? AUC_FASTON : AUC_FASTOFF);
#endif
goto again;
case 2:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val > 0 && val <= 50)
{
SETCFG(refresh, val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
case 3:
SETCFG(cache, !GETCFG(cache));
goto again;
case 4:
SETCFG(xsync, !GETCFG(xsync));
goto again;
#ifdef XZX_KMOUSE
case 5:
SETCFG(kmouseGrab, !GETCFG(kmouseGrab));
if (GETCFG(kmouseActive))
{
KmouseOff();
KmouseOn();
}
goto again;
#endif
case 6:
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
val = GETCFG(issue) == 2 ? 3 : 2;
SETCFG(issue, val);
if (GETCFG(machine) <= SP_48_3)
{
SelectModel(val == 2 ? SP_48_2 : SP_48_3, 0);
}
goto again;
#ifdef DEBUG
case 7:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val >= 0 && val <= 99999)
{
SETCFG(debug, (unsigned int)val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
#endif
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
if (saveSpeed != GETCFG(speed))
{
EmuSetSpeed(GETCFG(speed));
}
}
void
HardwareMenu(void)
{
unsigned int item = 0;
int oldInDialog;
oldInDialog = EnterOSD();
DisplayMenu(architMenuTxt);
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(architMenuTxt) + 2);
PrintString("Current mode");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(architMenuTxt) + 3);
PrintString(Machine->name);
#if defined(XZX_IF1) || defined(XZX_MF) || defined(XZX_KMOUSE)
again:
#endif
SetAttr(MENU_SELECT_ATTR);
#ifdef XZX_IF1
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 12);
PrintLetter(GETCFG(if1Active) < 0 ? '-'
: GETCFG(if1Active) == 1 ? 'Y' : 'N');
#endif
#ifdef XZX_MF
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 13);
PrintLetter(GETCFG(mfActive) ? 'Y' : 'N');
#endif
#ifdef XZX_KMOUSE
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 14);
#ifdef XZX_PLUS3
PrintLetter(GETCFG(machine) <= SP_3 ? '-'
: GETCFG(kmouseActive) ? 'Y' : 'N');
#else
PrintLetter(GETCFG(machine) <= SP_128 ? '-'
: GETCFG(kmouseActive) ? 'Y' : 'N');
#endif
#endif
SetAttr(MENU_TEXT_ATTR);
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(architMenuTxt),
NOPTS(architMenuTxt), NULL))
{
case XK_Return:
switch(item)
{
case 0:
SelectModel(GETCFG(issue) == 2 ? SP_48_2 : SP_48_3, 1);
goto quit;
case 1:
SelectModel(SP_128, 1);
goto quit;
#ifdef XZX_PLUS3
case 2:
SelectModel(SP_3, 1);
goto quit;
#endif
#ifdef XZX_PENTAGON
case 3:
SelectModel(SP_PENTAGON, 1);
goto quit;
#endif
#ifdef XZX_SCORPION
case 4:
SelectModel(SP_SCORPION, 1);
goto quit;
#endif
case 6:
SelectModel(GETCFG(issue) == 2 ? SP_48_2 : SP_48_3, 0);
goto quit;
case 7:
SelectModel(SP_128, 0);
goto quit;
#ifdef XZX_PLUS3
case 8:
SelectModel(SP_3, 0);
goto quit;
#endif
#ifdef XZX_PENTAGON
case 9:
SelectModel(SP_PENTAGON, 0);
goto quit;
#endif
#ifdef XZX_SCORPION
case 10:
SelectModel(SP_SCORPION, 0);
goto quit;
#endif
#ifdef XZX_IF1
case 12:
if (GETCFG(if1Active) >= 0)
{
SETCFG(if1Active, !GETCFG(if1Active));
}
goto again;
#endif
#ifdef XZX_MF
case 13:
SETCFG(mfActive, !GETCFG(mfActive));
goto again;
#endif
#ifdef XZX_KMOUSE
case 14:
#ifdef XZX_PLUS3
if (GETCFG(machine) > SP_3)
#else
if (GETCFG(machine) > SP_128)
#endif
{
SETCFG(kmouseActive, !GETCFG(kmouseActive));
goto again;
}
#endif
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
#ifdef AUDIO
static void
soundMenu(void)
{
unsigned int item = 0;
int oldInDialog;
oldInDialog = EnterOSD();
DisplayMenu(soundMenuTxt);
again:
SetAttr(MENU_SELECT_ATTR);
#ifdef SPEAKER_AUDIO
SetCursor(PARA_COLUMN, MENU_CURSOR_Y);
PrintLetter(GETCFG(audioActive) >= 0 ? Audio.spOn ? 'Y' : 'N' : '-');
#endif
#ifdef AYCHIP_AUDIO
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 1);
PrintLetter(GETCFG(audioActive) >= 0 ? Audio.ayOn ? 'Y' : 'N' : '-');
#endif
#ifdef XBELL_AUDIO
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 2);
PrintLetter(GETCFG(audioActive) > 0 ? 'Y' : 'N');
#endif
SetAttr(MENU_SELECT_ATTR);
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(soundMenuTxt), NOPTS(soundMenuTxt),
NULL))
{
case XK_Return:
switch(item)
{
#ifdef SPEAKER_AUDIO
case 0:
if (GETCFG(audioActive) >= 0)
{
AudioControl(Audio.spOn ? AUC_SPOFF : AUC_SPON);
#ifdef AYCHIP_AUDIO
SETCFG(audioActive, Audio.spOn | Audio.ayOn);
#else
SETCFG(audioActive, Audio.spOn);
#endif
goto again;
}
break;
#endif
#ifdef AYCHIP_AUDIO
case 1:
if (GETCFG(audioActive) >= 0)
{
AudioControl(Audio.ayOn ? AUC_AYOFF : AUC_AYON);
#ifdef SPEAKER_AUDIO
SETCFG(audioActive, Audio.ayOn | Audio.spOn);
#else
SETCFG(audioActive, Audio.ayOn);
#endif
goto again;
}
break;
#endif
#ifdef XBELL_AUDIO
case 2:
SETCFG(audioActive, !GETCFG(audioActive));
goto again;
#endif
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
#endif
static void
joyMenu(void)
{
unsigned int item = 0;
int oldInDialog;
char *p;
int i, j;
#ifdef JOY
char buffer[7];
int val;
#endif
oldInDialog = EnterOSD();
DisplayMenu(joyMenuTxt);
again:
SetAttr(MENU_SELECT_ATTR);
for (i = 0; i < 5; i++)
{
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + i);
p = XKeysymToString(GETCFG(joyKeys[i]));
for (j = 0; j < 6 && *p; j++)
{
PrintLetter(*p++);
}
for (; j < 6; j++)
{
PrintLetter(' ');
}
}
#ifdef JOY
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 6);
PrintLetter(GETCFG(joyActive) >= 0 ? GETCFG(joyActive) ? 'Y' : 'N' : '-');
if (GETCFG(joyActive) >= 0)
{
(void)sprintf(buffer, "%-6d", GETCFG(joyTolerance));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 7);
PrintString(buffer);
if (GETCFG(joyAutofire) >= 0)
{
(void)sprintf(buffer, "%-6d", GETCFG(joyAutofire));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 8);
PrintString(buffer);
}
if (GETCFG(joyJuggle) >= 0)
{
(void)sprintf(buffer, "%-6d", GETCFG(joyJuggle));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 9);
PrintString(buffer);
}
}
#endif
SetAttr(MENU_SELECT_ATTR);
for(;;)
{
switch ((int)BrowseList(&item, NOPTS(joyMenuTxt), NOPTS(joyMenuTxt),
NULL))
{
case XK_Return:
switch(item)
{
case 0:
case 1:
case 2:
case 3:
case 4:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
PrintString("      ");
SetAttr(MENU_TEXT_ATTR);
ScreenRefresh();
SETCFG(joyKeys[item], GetKey());
goto again;
#ifdef JOY
case 6:
if (GETCFG(joyActive) >= 0)
{
SETCFG(joyActive, !GETCFG(joyActive));
goto again;
}
break;
case 7:
if (GETCFG(joyActive) >= 0)
{
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val > 0 && val <= 500)
{
SETCFG(joyTolerance, val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
}
break;
case 8:
if (GETCFG(joyActive) >= 0 && GETCFG(joyAutofire) >= 0)
{
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val > 0 && val <= 50)
{
SETCFG(joyAutofire, val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
}
break;
case 9:
if (GETCFG(joyActive) >= 0 && GETCFG(joyJuggle) >= 0)
{
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + item);
if (GetString(buffer, 6, 6))
{
val = atoi(buffer);
if (val > 0 && val <= 50)
{
SETCFG(joyJuggle, val);
}
}
SetAttr(MENU_TEXT_ATTR);
goto again;
}
break;
#endif
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
#if defined(XZX_IF1) || defined(XZX_PLUS3)
static void
diskMenu(void)
{
unsigned int item = 0;
int oldInDialog;
#ifdef XZX_IF1
static int mdr = 0;
#endif
#ifdef XZX_PLUS3
static int disk = 0;
#endif
oldInDialog = EnterOSD();
again:
DisplayMenu(diskMenuTxt);
again2:
#ifdef XZX_IF1
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 2);
PrintString("Current cartridge");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 3);
DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
PrintString(GetBaseName(If1CartName(mdr)));
#endif
#ifdef XZX_PLUS3
#ifdef XZX_IF1
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 5);
PrintString("Current disk");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 6);
DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
PrintString(GetBaseName(FdcDiskName(disk)));
#else
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 2);
PrintString("Current disk");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 3);
DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
PrintString(GetBaseName(FdcDiskName(disk)));
#endif
#endif
#ifdef XZX_IF1
again3:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 0);
PrintLetter(GETCFG(if1Active) < 0 ? '-' : (char)('1' + mdr));
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 4);
PrintLetter(GETCFG(if1Active) < 0 ? '-'
: GETCFG(if1TranslateNl) ? 'Y' : 'N');
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 5);
PrintLetter(GETCFG(if1Active) < 0 ? '-'
: GETCFG(if1StripNl) ? 'Y' : 'N');
SetAttr(MENU_TEXT_ATTR);
#endif
#ifdef XZX_PLUS3
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 7);
PrintLetter((char)('A' + disk));
SetAttr(MENU_TEXT_ATTR);
#endif
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(diskMenuTxt), NOPTS(diskMenuTxt),
NULL))
{
case XK_Return:
#ifdef XZX_IF1
if (GETCFG(if1Active >= 0))
{
switch(item)
{
case 0:
mdr = ++mdr % IF1_DRIVES;
goto again2;
case 1:
(void)If1InsertCart(mdr);
goto again;
case 2:
If1EjectCart(mdr);
goto again2;
case 4:
SETCFG(if1TranslateNl, !GETCFG(if1TranslateNl));
goto again3;
break;
case 5:
SETCFG(if1StripNl, !GETCFG(if1StripNl));
goto again3;
}
}
#endif
#ifdef XZX_PLUS3
switch (item)
{
case 7:
disk = !disk;
goto again2;
case 8:
(void)FdcInsertDisk(disk);
goto again;
case 9:
FdcEjectDisk(disk);
goto again2;
}
#endif
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
#endif
static void
tapeMenu(void)
{
unsigned int item = 0;
int oldInDialog;
oldInDialog = EnterOSD();
again:
DisplayMenu(tapeMenuTxt);
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 2);
PrintString("Current inputfile");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 3);
PrintString(GetBaseName(TpTapeName(TO_READ)));
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 5);
PrintString("Current outputfile");
SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 6);
PrintString(GetBaseName(TpTapeName(TO_WRITE)));
again2:
SetAttr(MENU_SELECT_ATTR);
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 3);
PrintString(TpState & TS_ERRIN ? "ERR "
: TpState & TS_PLAY ? "PLAY" : "STOP");
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 4);
#ifndef NO_ED_TRAPS
PrintLetter(TpState & TS_QUICKLOAD ? 'Y' : 'N');
#endif
#ifdef SPEAKER_AUDIO
SetCursor(PARA_COLUMN, MENU_CURSOR_Y + 5);
PrintLetter(GETCFG(noise) ? 'Y' : 'N');
#endif
SetAttr(MENU_TEXT_ATTR);
for (;;)
{
switch ((int)BrowseList(&item, NOPTS(tapeMenuTxt), NOPTS(tapeMenuTxt),
NULL))
{
case XK_Return:
switch(item)
{
case 0:
(void)TpInsertTape("Input Tape",
TO_READ | TO_TAP | TO_TZX);
goto again;
case 1:
TpEjectTape(TO_READ);
goto again;
case 2:
if (TpState & (TS_TAPIN | TS_TZXIN)
&& !(TpState & (TS_PLAY | TS_ERRIN)))
{
TpBrowser();
goto again;
}
break;
case 3:
if (TpState & (TS_TAPIN | TS_TZXIN)
&& !(TpState & TS_ERRIN))
{
if (TpState & TS_PLAY)
{
TpStopPlayback();
goto again2;
}
else if (!(TpState & TS_ENDIN))
{
TpStartPlayback();
goto again2;
}
}
break;
#ifndef NO_ED_TRAPS
case 4:
TpState ^= TS_QUICKLOAD;
goto again2;
#endif
#ifdef SPEAKER_AUDIO
case 5:
SETCFG(noise, !GETCFG(noise));
goto again2;
#endif
case 7:
(void)TpInsertTape("Ouput Tape", TO_WRITE | TO_TAP);
goto again;
case 8:
TpEjectTape(TO_WRITE);
goto again;
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
void
WriteSnapshotWithFS(void)
{
int types[4], i = 0;
char *fname;
types[i++] = FT_Z80;
if (GETCFG(machine) <= SP_48_3)
{
types[i++] = FT_SNA;
}
if (InSlt)
{
types[i++] = FT_SLT;
}
types[i] = FT_END;
if ((fname = FileSelector("Save Snapshot", 0, types)))
{
(void)WriteSnapshot(fname);
free(fname);
}
}
void
ReadSnapshotWithFS(void)
{
int types[4] = { FT_Z80, FT_SNA, FT_SLT, FT_END };
char *fname;
if ((fname = FileSelector("Load Snapshot", 1, types)))
{
(void)ReadSnapshot(fname);
free(fname);
if (InDialog)
{
SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
}
}
}
void
WriteScreenDumpWithFS(void)
{
int types[2] = { FT_SCR, FT_END };
char *fname;
if ((fname = FileSelector("Save Screenshot", 0, types)))
{
(void)WriteScreenDump(fname);
free(fname);
}
}
