/*
 * AdjustableValue - managing field and scrollbar for adjustable value
 *
 * created: apesen, 19961028
 *
 * changed: apesen, 19961114
 *
 * $Id: AdjustableValue.java,v 1.1 1997/01/15 13:42:55 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;


public class AdjustableValue  
{
  AdjScrollbar scrlbar;
  AdjTextField textfld;
  double maxVal;
  double minVal;
  final static int digits = 100;
  int barMax;
  public final static int visible= 10;
  int dec;
  int len;

// constructor
  public AdjustableValue(double minValue, double maxValue, double initValue, int precision)
  {
    int barVal;

    maxVal = maxValue;
    minVal = minValue;
    dec = precision;
    len = (int) (Math.log (Math.max (Math.abs (minVal),Math.abs (maxVal))) / Math.log(10)) + 1 + (dec > 0 ? dec + 1 : 0);
    len += (Math.abs (minVal) >= Math.abs (maxVal) ? (minVal<0 ? 1 : 0) : (maxVal < 0 ? 1 : 0));
    barMax = digits * (len - (dec>0?dec - 1:0));
    textfld = new AdjTextField ("", len, this);
    scrlbar = new AdjScrollbar (Scrollbar.HORIZONTAL, 0, (int) barMax/visible, 0, barMax, this); 
    setText(initValue);
  }

  void setText ()
  {
    double curValue = (double) (scrlbar.getValue () * (maxVal-minVal) / barMax) + minVal;
    textfld.setValue (curValue);
  } 

  public void setText (double initValue)
  {
    setBar (initValue);
  } 

  void setBar ()
  {
    double curValue = (double) (Double.valueOf(textfld.getText())).doubleValue() ;
    int barVal = (int) ((curValue-minVal) / (maxVal-minVal) * barMax);

    if (barVal > barMax)
    {
      barVal = barMax;
      curValue = maxVal;
    }
    if (barVal < 0)
    {
      barVal = 0;
      curValue = minVal;
    }
    textfld.setValue (curValue);
    scrlbar.setValue (barVal);
  }
  void setBar (double curValue)
  {
    int barVal = (int) ((curValue-minVal) / (maxVal-minVal) * barMax);

    if (barVal > barMax)
    {
      barVal = barMax;
      curValue = maxVal;
    }
    if (barVal < 0)
    {
      barVal = 0;
      curValue = minVal;
    }
    textfld.setValue (curValue);
    scrlbar.setValue (barVal);
  }
  public double getValue()
  {
    String txt = (textfld.getText()).trim();
    if ((txt == null) || txt.equals(""))
      return 0.0;
    else
      return (Double.valueOf(txt)).doubleValue();
  }
} // AdjustableValue



/* class AdjTextField */
class AdjTextField extends TextField
{
  AdjustableValue adjval;

  AdjTextField (String label, int len, AdjustableValue aval)
  {
    super (label, len);
    adjval = aval;
  }

  public void setValue (double val)
  {
    setText (NumConv.Num2Str (val, adjval.len, adjval.dec));
  }

  public boolean action(Event ev, Object arg)
  {
    double curValue = (double) (Double.valueOf (getText ())).doubleValue () ;
    int barVal = (int) (curValue / adjval.maxVal * adjval.barMax);

    adjval.setBar (curValue);
//    adjval.setBar ();
    return true;
  }
} // AdjTextField



class AdjScrollbar extends Scrollbar
{
  AdjustableValue adjval;

  AdjScrollbar (int dir, int val, int vis, int min, int max, AdjustableValue aval)
  {
    super (dir, val, vis, min, max);
    adjval = aval;
  }

// Methode handleEvent( )
  public boolean handleEvent( Event ev )
  {
    adjval.setText();
    adjval.textfld.requestFocus();
    return super.handleEvent (ev);
  }
  public boolean lostFocus( Event ev, Object what )
  {
    return super.lostFocus (ev, what);
  }

} // AdjScrollbar



/* class NumConv */
class NumConv 
{
  final static int MAX_LEN = 12;
  final static String Filler1 = "            ";
  final static int MAX_DEC = 10;
  final static String Filler2 = "0000000000";

  public static String Num2Str(int zahl, int len, int dec)
  { 
    return NumToStr((double) zahl, len, dec);
  }
  public static String Num2Str(int zahl, int len)
  { 
    return NumToStr((double) zahl, len, 0);
  }
  public static String Num2Str(double zahl, int len, int dec)
  { 
    return NumToStr(zahl, len, dec);
  }
  private static String NumToStr(double zahl, int len, int dec)
  { 
    String erg = Filler1;
    int dot = 0;
    if (len > MAX_LEN)
      len = MAX_LEN;
    if (dec > MAX_DEC)
      dec = MAX_DEC;
    erg = erg + zahl;
    if (erg.indexOf(".") == -1)
      erg = erg + ".";
    erg = erg + Filler2;
    dot = erg.indexOf(".");
    if (dec > 0)           
       erg = erg.substring(dot-(len-dec-1),dot + 1 + dec);
    else
       erg = erg.substring(dot-(len),dot);
    return erg;   
  }
} // NumConv
