#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "interface.h"

#include "treedata.h"

int do_save(s, format)
char *s;
file_type format;
{
	tree t;
	FILE *f;


	f=fopen(s, "w");
	if(f==NULL)
	{
		tterr("Couldn't open file for writing", Notice);
		return(0);
	}

	switch(format)
	{
        case PICT:
			tcanvas_start_printing(globals->c, f, shortname(s), tp_PICT);
			tcanvas_refresh(globals->c, 0, 0, 0, 0, 1);
			tcanvas_stop_printing(globals->c);
            break;
        case PostScript:
			tcanvas_start_printing(globals->c, f, shortname(s), tp_postscript);
			tcanvas_refresh(globals->c, 0, 0, 0, 0, 1);
			tcanvas_stop_printing(globals->c);
            break;
        case Prolog:
			write_all_trees(f, format);
            break;
        case Newick:
			write_all_trees(f, format);
            break;
        case Treetool:
			write_all_trees(f, format);
			change_filename(s);
			unmodify();
			break;
		case List:
			write_selected_names(f);
			break;
        case NoFileType:
        default:
            break;
	}
	fclose(f);
	return(1);
}
