/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int imageIndent;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        if (bl) {
            table.createItem(this, n2);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.imageIndent = 0;
        this.grayed = false;
        this.checked = false;
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int n = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.display, n);
    }

    public Color getBackground(int n) {
        this.checkWidget();
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        int n3 = this.cellBackground != null ? this.cellBackground[n] : -1;
        return n3 == -1 ? this.getBackground() : Color.win32_new(this.display, n3);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.handle;
        int n4 = OS.SendMessage(n3, 4127, 0, 0);
        int n5 = OS.SendMessage(n4, 4608, 0, 0);
        if (n < 0 || n >= n5) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = this.parent.getLinesVisible() ? this.parent.getGridLineWidth() : 0;
        RECT rECT = new RECT();
        rECT.top = n;
        rECT.left = 2;
        OS.SendMessage(n3, 4152, n2, rECT);
        if (n == 0) {
            RECT rECT2 = new RECT();
            rECT2.left = 1;
            OS.SendMessage(n3, 4152, n2, rECT2);
            rECT.left = rECT2.left - n6;
        }
        int n7 = Math.max(0, rECT.right - rECT.left - n6);
        int n8 = Math.max(0, rECT.bottom - rECT.top - n6);
        if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
            rECT.top -= n6;
        }
        return new Rectangle(rECT.left + n6, rECT.top + n6, n7, n8);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int n) {
        this.checkWidget();
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        int n3 = this.cellFont != null ? this.cellFont[n] : this.font;
        return n3 == -1 ? this.getFont() : Font.win32_new(this.display, n3);
    }

    public Color getForeground() {
        this.checkWidget();
        int n = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.display, n);
    }

    public Color getForeground(int n) {
        this.checkWidget();
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        int n3 = this.cellForeground != null ? this.cellForeground[n] : -1;
        return n3 == -1 ? this.getForeground() : Color.win32_new(this.display, n3);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (n == 0) {
            return super.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.handle;
        int n4 = OS.SendMessage(n3, 4127, 0, 0);
        int n5 = OS.SendMessage(n4, 4608, 0, 0);
        if (n < 0 || n >= n5) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = this.parent.getLinesVisible() ? this.parent.getGridLineWidth() : 0;
        RECT rECT = new RECT();
        rECT.top = n;
        rECT.left = 1;
        OS.SendMessage(n3, 4152, n2, rECT);
        if (n == 0) {
            rECT.left -= n6;
        }
        int n7 = Math.max(0, rECT.right - rECT.left - n6);
        int n8 = Math.max(0, rECT.bottom - rECT.top - n6);
        if (n != 0) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 2;
            lVITEM.iItem = n2;
            lVITEM.iSubItem = n;
            OS.SendMessage(n3, OS.LVM_GETITEM, 0, lVITEM);
            if (lVITEM.iImage < 0) {
                n7 = 0;
            }
        }
        if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
            rECT.top -= n6;
        }
        return new Rectangle(rECT.left + n6, rECT.top + n6, n7, n8);
    }

    public int getImageIndent() {
        this.checkWidget();
        return this.imageIndent;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText(int n) {
        this.checkWidget();
        if (n == 0) {
            return super.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    void redraw(int n, boolean bl, boolean bl2) {
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.parent.ignoreRedraw || this.parent.drawCount != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (OS.IsWindowVisible(n2)) {
            RECT rECT = new RECT();
            int n3 = this.parent.indexOf(this);
            if (n == -1) {
                OS.SendMessage(n2, 4117, n3, n3);
            } else {
                if (bl) {
                    rECT.left |= 2;
                }
                if (bl2) {
                    rECT.left |= 1;
                }
                if (n == 0) {
                    if (OS.SendMessage(n2, 4110, n3, rECT) != 0) {
                        OS.InvalidateRect(n2, rECT, true);
                    }
                } else {
                    rECT.top = n;
                    if (OS.SendMessage(n2, 4152, n3, rECT) != 0) {
                        if (bl && !bl2 && this.images != null) {
                            RECT rECT2 = new RECT();
                            rECT2.left = 1;
                            rECT2.top = n;
                            if (OS.SendMessage(n2, 4152, n3, rECT2) != 0) {
                                boolean bl3 = true;
                                if (n != 0) {
                                    LVITEM lVITEM = new LVITEM();
                                    lVITEM.mask = 2;
                                    lVITEM.iItem = n3;
                                    lVITEM.iSubItem = n;
                                    OS.SendMessage(n2, OS.LVM_GETITEM, 0, lVITEM);
                                    if (lVITEM.iImage < 0) {
                                        bl3 = false;
                                    }
                                }
                                if (bl3) {
                                    rECT.left = rECT2.right;
                                }
                            }
                        }
                        OS.InvalidateRect(n2, rECT, true);
                    }
                }
            }
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.background == n) {
            return;
        }
        this.background = n;
        this.redraw(-1, true, true);
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellBackground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellBackground[n] == n3) {
            return;
        }
        this.cellBackground[n] = n3;
        this.redraw(n, true, true);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.setChecked(bl, false);
    }

    void setChecked(boolean bl, boolean bl2) {
        this.checked = bl;
        if (bl2) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
        this.redraw(-1, true, true);
    }

    public void setFont(Font font) {
        int n;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (font != null) {
            this.parent.customDraw = true;
            n2 = font.handle;
        }
        if (this.font == n2) {
            return;
        }
        this.font = n2;
        if ((this.parent.style & 0x10000000) == 0 && this.cached && (n = this.parent.indexOf(this)) != -1) {
            int n3 = this.parent.handle;
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 1;
            lVITEM.iItem = n;
            lVITEM.pszText = -1;
            OS.SendMessage(n3, OS.LVM_SETITEM, 0, lVITEM);
            this.cached = false;
        }
        this.parent.setScrollWidth(this, false);
        this.redraw(-1, true, true);
    }

    public void setFont(int n, Font font) {
        int n2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (font != null) {
            this.parent.customDraw = true;
            n4 = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                this.cellFont[n2] = -1;
                ++n2;
            }
        }
        if (this.cellFont[n] == n4) {
            return;
        }
        this.cellFont[n] = n4;
        if (n == 0) {
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n2 = this.parent.indexOf(this)) != -1) {
                int n5 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n2;
                lVITEM.pszText = -1;
                OS.SendMessage(n5, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n, true, true);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        this.redraw(-1, true, true);
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n3 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.cellForeground[n4] = -1;
                ++n4;
            }
        }
        if (this.cellForeground[n] == n3) {
            return;
        }
        this.cellForeground[n] = n3;
        this.redraw(n, true, true);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        this.redraw(-1, true, true);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            super.setImage(image);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.images == null && n != 0) {
            this.images = new Image[n2];
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            this.images[n] = image;
        }
        this.parent.imageIndex(image);
        if (n == 0) {
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n, false, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.imageIndent == n) {
            return;
        }
        this.imageIndent = n;
        if ((this.parent.style & 0x10000000) == 0 && (n2 = this.parent.indexOf(this)) != -1) {
            int n3 = this.parent.handle;
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 16;
            lVITEM.iItem = n2;
            lVITEM.iIndent = n;
            OS.SendMessage(n3, OS.LVM_SETITEM, 0, lVITEM);
        }
        this.parent.setScrollWidth(this, false);
        this.redraw(-1, true, true);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.strings == null && n != 0) {
            this.strings = new String[n2];
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        if (n == 0) {
            int n3;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n3 = this.parent.indexOf(this)) != -1) {
                int n4 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n3;
                lVITEM.pszText = -1;
                OS.SendMessage(n4, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n, true, false);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

