/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHACTIVATEINFO;
import org.eclipse.swt.internal.win32.SIPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    Menu activeMenu;
    int hIMC;
    int hwndMDIClient;
    int toolTipHandle;
    int lpstrTip;
    int[] brushes;
    boolean showWithParent;
    Control lastActive;
    SHACTIVATEINFO psai;
    Region region;
    static final int DialogProc;
    static final TCHAR DialogClass;

    static {
        DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, DialogClass, wNDCLASS);
        DialogProc = wNDCLASS.lpfnWndProc;
    }

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, OS.IsWinCE ? 0 : 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0);
    }

    Shell(Display display, Shell shell, int n, int n2) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(n);
        this.parent = shell;
        this.display = display;
        this.handle = n2;
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, OS.IsWinCE ? 0 : 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0);
    }

    public static Shell win32_new(Display display, int n) {
        return new Shell(display, null, 8, n);
    }

    static int checkStyle(int n) {
        n = Decorations.checkStyle(n);
        int n2 = 229376;
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.parent != null) {
            if (this.handle == 0) {
                return 0;
            }
            switch (n) {
                case 7: 
                case 8: {
                    return OS.DefWindowProc(this.handle, n, n2, n3);
                }
            }
            return OS.CallWindowProc(DialogProc, this.handle, n, n2, n3);
        }
        if (this.handle == 0) {
            return 0;
        }
        if (this.hwndMDIClient != 0) {
            return OS.DefFrameProc(this.handle, this.hwndMDIClient, n, n2, n3);
        }
        return OS.DefWindowProc(this.handle, n, n2, n3);
    }

    public void close() {
        this.checkWidget();
        OS.PostMessage(this.handle, 16, 0, 0);
    }

    void createHandle() {
        boolean bl = this.handle != 0;
        super.createHandle();
        if (!bl) {
            int n = OS.GetWindowLong(this.handle, -16);
            n &= ~(OS.WS_OVERLAPPED | 0xC00000);
            if (!OS.IsWinCE) {
                n |= Integer.MIN_VALUE;
            }
            if ((this.style & 0x20) != 0) {
                n |= 0xC00000;
            }
            if ((this.style & 8) == 0 && (this.style & 0x810) == 0) {
                n |= 0x800000;
            }
            OS.SetWindowLong(this.handle, -16, n);
            int n2 = 55;
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n2);
            if (OS.IsWinCE) {
                this.setMaximized(true);
            }
            if (OS.IsPPC) {
                this.psai = new SHACTIVATEINFO();
                this.psai.cbSize = 12;
            }
        }
        if (OS.IsDBLocale) {
            this.hIMC = OS.ImmCreateContext();
            if (this.hIMC != 0) {
                OS.ImmAssociateContext(this.handle, this.hIMC);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    void enableWidget(boolean bl) {
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        if (Display.TrimEnabled) {
            if (this.isActive()) {
                this.setItemEnabled(61536, bl);
            }
        } else {
            OS.EnableWindow(this.handle, bl);
        }
    }

    int findBrush(int n) {
        int n2;
        if (n == OS.GetSysColor(OS.COLOR_BTNFACE)) {
            return OS.GetSysColorBrush(OS.COLOR_BTNFACE);
        }
        if (n == OS.GetSysColor(OS.COLOR_WINDOW)) {
            return OS.GetSysColorBrush(OS.COLOR_WINDOW);
        }
        if (this.brushes == null) {
            this.brushes = new int[4];
        }
        LOGBRUSH lOGBRUSH = new LOGBRUSH();
        int n3 = 0;
        while (n3 < this.brushes.length) {
            n2 = this.brushes[n3];
            if (n2 == 0) break;
            OS.GetObject(n2, 12, lOGBRUSH);
            if (lOGBRUSH.lbColor == n) {
                return n2;
            }
            ++n3;
        }
        n3 = this.brushes.length;
        n2 = this.brushes[--n3];
        if (n2 != 0) {
            OS.DeleteObject(n2);
        }
        System.arraycopy(this.brushes, 0, this.brushes, 1, n3);
        this.brushes[0] = n2 = OS.CreateSolidBrush(n);
        return n2;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    void fixShell(Shell shell, Control control) {
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if (this.toolTipHandle != 0) {
            this.setToolTipText(control.handle, null);
        }
        shell.setToolTipText(control.handle, control.toolTipText);
    }

    public void forceActive() {
        this.checkWidget();
        OS.SetForegroundWindow(this.handle);
    }

    void forceResize() {
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getBounds();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getImeInputMode() {
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return 0;
        }
        int n = OS.ImmGetContext(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl = OS.ImmGetOpenStatus(n);
        if (bl) {
            bl = OS.ImmGetConversionStatus(n, nArray, nArray2);
        }
        OS.ImmReleaseContext(this.handle, n);
        if (!bl) {
            return 0;
        }
        int n2 = 0;
        if ((nArray[0] & 0x10) != 0) {
            n2 |= 0x20;
        }
        if ((nArray[0] & 8) != 0) {
            n2 |= 2;
        }
        if ((nArray[0] & 2) != 0) {
            return n2 | 0x10;
        }
        if ((nArray[0] & 1) != 0) {
            return n2 | 8;
        }
        return n2 | 4;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getLocation();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        return new Point(rECT.left, rECT.top);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Point getSize() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getSize();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Point(n, n2);
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int hwndMDIClient() {
        if (this.hwndMDIClient == 0) {
            int n = 1174405121;
            this.hwndMDIClient = OS.CreateWindowEx(0, new TCHAR(0, "MDICLIENT", true), null, n, 0, 0, 0, 0, this.handle, 0, OS.GetModuleHandle(null), new CREATESTRUCT());
        }
        return this.hwndMDIClient;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop();
        if (OS.IsWinCE) {
            OS.SetForegroundWindow(this.handle);
        }
        OS.SendMessage(this.handle, 295, 3, 0);
        this.setVisible(true);
        MSG mSG = new MSG();
        int n = 0x400002;
        OS.PeekMessage(mSG, 0, 0, 0, n);
        if (!this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    void releaseChild() {
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndMDIClient = 0;
    }

    void releaseShells() {
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.releaseResources();
            }
            ++n;
        }
    }

    void releaseWidget() {
        int n;
        this.releaseShells();
        super.releaseWidget();
        this.activeMenu = null;
        this.display.clearModal(this);
        if (this.lpstrTip != 0) {
            n = OS.GetProcessHeap();
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        this.lpstrTip = 0;
        this.toolTipHandle = 0;
        if (this.brushes != null) {
            n = 0;
            while (n < this.brushes.length) {
                int n2 = this.brushes[n];
                if (n2 != 0) {
                    OS.DeleteObject(n2);
                }
                ++n;
            }
        }
        this.brushes = null;
        if (OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmDestroyContext(this.hIMC);
        }
        this.lastActive = null;
        this.region = null;
    }

    void removeMenu(Menu menu) {
        super.removeMenu(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    LRESULT selectPalette(int n) {
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SelectPalette(n2, n, false);
        int n4 = OS.RealizePalette(n2);
        if (n4 > 0) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            OS.SelectPalette(n2, n3, true);
            OS.RealizePalette(n2);
        }
        OS.ReleaseDC(this.handle, n2);
        return n4 > 0 ? LRESULT.ONE : LRESULT.ZERO;
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                controlArray2[n3].sendEvent(27);
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if (OS.IsWinCE) {
            this.swFlags = OS.SW_RESTORE;
        } else if (OS.IsIconic(this.handle) || OS.IsZoomed(this.handle)) {
            this.setPlacement(n, n2, n3, n4, n5);
            return;
        }
        this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        super.setEnabled(bl);
        if (bl && this.handle == OS.GetActiveWindow() && !this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    public void setImeInputMode(int n) {
        int[] nArray;
        int[] nArray2;
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return;
        }
        boolean bl = n != 0 && n != 32;
        int n2 = OS.ImmGetContext(this.handle);
        OS.ImmSetOpenStatus(n2, bl);
        if (bl && OS.ImmGetConversionStatus(n2, nArray2 = new int[1], nArray = new int[1])) {
            int n3 = 0;
            int n4 = 3;
            if ((n & 0x10) != 0) {
                n3 = 3;
                n4 = 0;
            } else if ((n & 8) != 0) {
                n3 = 1;
                n4 = 2;
            }
            if ((n & 2) != 0) {
                n3 |= 8;
            } else {
                n4 |= 8;
            }
            if ((n & 0x20) != 0) {
                n3 |= 0x10;
            } else {
                n4 |= 0x10;
            }
            nArray2[0] = nArray2[0] | n3;
            nArray2[0] = nArray2[0] & ~n4;
            OS.ImmSetConversionStatus(n2, nArray2[0], nArray[0]);
        }
        OS.ImmReleaseContext(this.handle, n2);
    }

    void setItemEnabled(int n, boolean bl) {
        int n2 = OS.GetSystemMenu(this.handle, false);
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (!bl) {
            n3 = 3;
        }
        OS.EnableMenuItem(n2, n, n3);
    }

    void setParent() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        if (region != null) {
            n = OS.CreateRectRgn(0, 0, 0, 0);
            OS.CombineRgn(n, region.handle, n, 2);
        }
        OS.SetWindowRgn(this.handle, n, true);
        this.region = region;
    }

    void setToolTipText(int n, String string) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.toolTipHandle == 0) {
            this.toolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 1, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
            if (this.toolTipHandle == 0) {
                this.error(2);
            }
            OS.SendMessage(this.toolTipHandle, 1048, 0, Short.MAX_VALUE);
        }
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.uId = n;
        tOOLINFO.hwnd = this.handle;
        if (string == null) {
            OS.SendMessage(this.toolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
        } else {
            tOOLINFO.uFlags = 17;
            tOOLINFO.lpszText = -1;
            OS.SendMessage(this.toolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
        }
        OS.SendMessage(this.toolTipHandle, 1053, 0, 0);
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, byte[] byArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        int n2 = byArray.length;
        this.lpstrTip = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(this.lpstrTip, byArray, n2);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, char[] cArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        int n2 = cArray.length * 2;
        this.lpstrTip = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(this.lpstrTip, cArray, n2);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.drawCount != 0 ? (this.state & 0x10) == 0 == bl : bl == OS.IsWindowVisible(this.handle)) {
            return;
        }
        int n = 229376;
        if ((this.style & n) != 0) {
            if (bl) {
                int n2;
                this.display.setModalShell(this);
                Control control = this.display.getFocusControl();
                if (control != null && !control.isActive()) {
                    this.bringToTop();
                }
                if ((n2 = OS.GetActiveWindow()) == 0 && this.parent != null) {
                    n2 = this.parent.handle;
                }
                if (n2 != 0) {
                    OS.SendMessage(n2, 31, 0, 0);
                }
                OS.ReleaseCapture();
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.showWithParent && !bl && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, false);
        }
        super.setVisible(bl);
        if (this.isDisposed()) {
            return;
        }
        if (this.showWithParent == bl) {
            return;
        }
        this.showWithParent = bl;
        if (bl && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, true);
        }
    }

    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        return this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG);
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
        if (Display.TrimEnabled) {
            this.setItemEnabled(61536, this.isActive());
        } else {
            OS.EnableWindow(this.handle, this.isActive());
        }
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetParent() {
        if (this.handle != 0) {
            return this.handle;
        }
        return this.parent != null ? this.parent.handle : 0;
    }

    int widgetExtStyle() {
        int n = super.widgetExtStyle() & 0xFFFFFFBF;
        if (!OS.IsWinCE && this.parent == null && (this.style & 0x4000) != 0) {
            n |= 0x80;
        }
        if (this.parent != null) {
            if (OS.IsWin95) {
                return n;
            }
            if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
                return n;
            }
        }
        if ((this.style & 0x4000) != 0) {
            n |= 8;
        }
        return n;
    }

    TCHAR windowClass() {
        if (OS.IsSP) {
            return DialogClass;
        }
        return this.parent != null ? DialogClass : super.windowClass();
    }

    int windowProc() {
        if (OS.IsSP) {
            return DialogProc;
        }
        return this.parent != null ? DialogProc : super.windowProc();
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if (this.handle != 0) {
            return n | 0x40000000;
        }
        n &= 0xBFFFFFFF;
        if (OS.IsWinCE) {
            if (OS.IsSP) {
                return n | Integer.MIN_VALUE;
            }
            return this.parent == null ? n : n | Integer.MIN_VALUE;
        }
        return n | OS.WS_OVERLAPPED | 0xC00000;
    }

    LRESULT WM_ACTIVATE(int n, int n2) {
        if (OS.IsPPC) {
            if (this.hooks(33) || this.hooks(34)) {
                int n3 = n & 0xFFFF;
                int n4 = n3 != 0 ? this.handle : 0;
                int n5 = 193;
                while (n5 <= 198) {
                    OS.SHSetAppKeyWndAssoc((byte)n5, n4);
                    ++n5;
                }
            }
            if ((n & 0xFFFF) != 0) {
                OS.SHSipPreference(this.handle, this.psai.fSipUp == 0 ? 1 : 0);
            }
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 327681 && (n & 0xFFFF) == 0 && OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmSetOpenStatus(this.hIMC, false);
        }
        LRESULT lRESULT = super.WM_ACTIVATE(n, n2);
        if (this.parent != null) {
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        int n3;
        if (OS.IsPPC && (n3 = n & 0xFFFF) == 1 && (n2 == 0 || n2 == this.handle)) {
            OS.PostMessage(this.handle, 16, 0, 0);
            return LRESULT.ZERO;
        }
        if ((OS.IsPPC || OS.IsSP) && this.menuBar != null) {
            n3 = this.menuBar.hwndCB;
            if (n2 != 0 && n3 != 0) {
                if (n2 == n3) {
                    return super.WM_COMMAND(n, 0);
                }
                int n4 = OS.GetWindow(n3, 5);
                if (n2 == n4) {
                    return super.WM_COMMAND(n, 0);
                }
            }
        }
        return super.WM_COMMAND(n, n2);
    }

    LRESULT WM_DESTROY(int n, int n2) {
        LRESULT lRESULT = super.WM_DESTROY(n, n2);
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0x40000000) != 0) {
            this.releaseChild();
            this.releaseResources();
        }
        return lRESULT;
    }

    LRESULT WM_ENTERIDLE(int n, int n2) {
        LRESULT lRESULT = super.WM_ENTERIDLE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.display.runAsyncMessages()) {
            this.display.wakeThread();
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEACTIVATE(int n, int n2) {
        int n3;
        Object object;
        LRESULT lRESULT = super.WM_MOUSEACTIVATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s = (short)(n2 & 0xFFFF);
        switch (s) {
            case -2: 
            case -1: 
            case 0: {
                break;
            }
            default: {
                Decorations decorations;
                object = this.display.getFocusControl();
                if (object == null || (decorations = ((Control)object).menuShell()).getShell() != this || decorations == this) break;
                this.display.ignoreRestoreFocus = true;
                this.display.lastHittest = s;
                this.display.lastHittestControl = null;
                if (s == 5 || s == 3) {
                    this.display.lastHittestControl = object;
                    return null;
                }
                if (OS.IsWin95 && s == 2) {
                    this.display.lastHittestControl = object;
                }
                return new LRESULT(3);
            }
        }
        if (s == 5) {
            return null;
        }
        object = new POINT();
        if (!OS.GetCursorPos((POINT)object)) {
            int n4 = OS.GetMessagePos();
            ((POINT)object).x = (short)(n4 & 0xFFFF);
            ((POINT)object).y = (short)(n4 >> 16);
        }
        if ((n3 = OS.WindowFromPoint((POINT)object)) == 0) {
            return null;
        }
        Control control = this.display.findControl(n3);
        this.setActiveControl(control);
        return null;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isEnabled() || !this.isActive()) {
            if (!Display.TrimEnabled) {
                return new LRESULT(0);
            }
            int n3 = this.callWindowProc(132, n, n2);
            if (n3 == 1 || n3 == 5) {
                n3 = 18;
            }
            return new LRESULT(n3);
        }
        if (this.menuBar != null && !this.menuBar.getEnabled()) {
            int n4 = this.callWindowProc(132, n, n2);
            if (n4 == 5) {
                n4 = 18;
            }
            return new LRESULT(n4);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(int n, int n2) {
        Control control;
        boolean bl;
        LRESULT lRESULT = super.WM_NCLBUTTONDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.display.ignoreRestoreFocus) {
            return lRESULT;
        }
        Display display = this.display;
        int n3 = 0;
        boolean bl2 = bl = OS.IsWin95 && display.lastHittest == 2;
        if (bl) {
            n3 = OS.SetActiveWindow(this.handle);
        }
        display.lockActiveWindow = true;
        int n4 = this.callWindowProc(161, n, n2);
        display.lockActiveWindow = false;
        if (bl) {
            OS.SetActiveWindow(n3);
        }
        if ((control = display.lastHittestControl) != null && !control.isDisposed()) {
            control.setFocus();
        }
        display.lastHittestControl = null;
        display.ignoreRestoreFocus = false;
        return new LRESULT(n4);
    }

    LRESULT WM_PALETTECHANGED(int n, int n2) {
        int n3;
        if (n != this.handle && (n3 = this.display.hPalette) != 0) {
            return this.selectPalette(n3);
        }
        return super.WM_PALETTECHANGED(n, n2);
    }

    LRESULT WM_QUERYNEWPALETTE(int n, int n2) {
        int n3 = this.display.hPalette;
        if (n3 != 0) {
            return this.selectPalette(n3);
        }
        return super.WM_QUERYNEWPALETTE(n, n2);
    }

    LRESULT WM_SETCURSOR(int n, int n2) {
        POINT pOINT;
        Control control;
        short s;
        short s2 = (short)(n2 >> 16);
        if (s2 == 513) {
            int n3;
            int n4;
            Shell shell;
            if (!Display.TrimEnabled && (shell = this.display.getModalShell()) != null && !this.isActive() && OS.IsWindowEnabled(n4 = shell.handle)) {
                OS.SetActiveWindow(n4);
            }
            if (!OS.IsWindowEnabled(this.handle) && !OS.IsWinCE && (n3 = OS.GetLastActivePopup(this.handle)) != 0 && n3 != this.handle && this.display.getControl(n3) == null && OS.IsWindowEnabled(n3)) {
                OS.SetActiveWindow(n3);
            }
        }
        if ((s = (short)(n2 & 0xFFFF)) == -2 && !this.getEnabled() && (control = this.display.getControl(n)) == this && this.cursor != null && OS.GetCursorPos(pOINT = new POINT())) {
            OS.ScreenToClient(this.handle, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (OS.PtInRect(rECT, pOINT)) {
                OS.SetCursor(this.cursor.handle);
                switch (s2) {
                    case 513: 
                    case 516: 
                    case 519: {
                        OS.MessageBeep(0);
                    }
                }
                return LRESULT.ONE;
            }
        }
        return super.WM_SETCURSOR(n, n2);
    }

    LRESULT WM_SETTINGCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_SETTINGCHANGE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsPPC && n == 224) {
            if ((this.style & 0x10) != 0) {
                OS.SHHandleWMSettingChange(this.handle, n, n2, this.psai);
                return LRESULT.ZERO;
            }
            SIPINFO sIPINFO = new SIPINFO();
            sIPINFO.cbSize = 48;
            OS.SipGetInfo(sIPINFO);
            this.psai.fSipUp = sIPINFO.fdwFlags & 1;
        }
        return lRESULT;
    }

    LRESULT WM_SHOWWINDOW(int n, int n2) {
        LRESULT lRESULT = super.WM_SHOWWINDOW(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n2 == 3) {
            Composite composite = this;
            while (composite != null) {
                Shell shell = ((Control)composite).getShell();
                if (!shell.showWithParent) {
                    return LRESULT.ZERO;
                }
                composite = composite.parent;
            }
        }
        return lRESULT;
    }
}

