/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Control;

public final class FormData {
    public int height;
    public int width;
    public FormAttachment left;
    public FormAttachment right;
    public FormAttachment top;
    public FormAttachment bottom;
    int cacheHeight;
    int cacheWidth;
    FormAttachment cacheLeft;
    FormAttachment cacheRight;
    FormAttachment cacheTop;
    FormAttachment cacheBottom;
    boolean isVisited;

    public FormData() {
        this(-1, -1);
    }

    public FormData(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    FormAttachment getBottomAttachment(int n) {
        if (this.cacheBottom != null) {
            return this.cacheBottom;
        }
        if (this.isVisited) {
            this.cacheBottom = new FormAttachment(0, this.cacheHeight);
            return this.cacheBottom;
        }
        if (this.bottom == null) {
            if (this.top == null) {
                this.cacheBottom = new FormAttachment(0, this.cacheHeight);
                return this.cacheBottom;
            }
            this.cacheBottom = this.getTopAttachment(n).plus(this.cacheHeight);
            return this.cacheBottom;
        }
        Control control = this.bottom.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.bottom.control = null;
        }
        if (control == null) {
            this.cacheBottom = this.bottom;
            return this.cacheBottom;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment formAttachment = formData.getBottomAttachment(n);
        switch (this.bottom.alignment) {
            case 1024: {
                this.cacheBottom = formAttachment.plus(this.bottom.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment formAttachment2 = formData.getTopAttachment(n);
                FormAttachment formAttachment3 = formAttachment.minus(formAttachment2);
                this.cacheBottom = formAttachment.minus(formAttachment3.minus(this.cacheHeight).divide(2));
                break;
            }
            default: {
                FormAttachment formAttachment4 = formData.getTopAttachment(n);
                this.cacheBottom = formAttachment4.plus(this.bottom.offset - n);
            }
        }
        this.isVisited = false;
        return this.cacheBottom;
    }

    FormAttachment getLeftAttachment(int n) {
        if (this.cacheLeft != null) {
            return this.cacheLeft;
        }
        if (this.isVisited) {
            this.cacheLeft = new FormAttachment(0, 0);
            return this.cacheLeft;
        }
        if (this.left == null) {
            if (this.right == null) {
                this.cacheLeft = new FormAttachment(0, 0);
                return this.cacheLeft;
            }
            this.cacheLeft = this.getRightAttachment(n).minus(this.cacheWidth);
            return this.cacheLeft;
        }
        Control control = this.left.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.left.control = null;
        }
        if (control == null) {
            this.cacheLeft = this.left;
            return this.cacheLeft;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment formAttachment = formData.getLeftAttachment(n);
        switch (this.left.alignment) {
            case 16384: {
                this.cacheLeft = formAttachment.plus(this.left.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment formAttachment2 = formData.getRightAttachment(n);
                FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
                this.cacheLeft = formAttachment.plus(formAttachment3.minus(this.cacheWidth).divide(2));
                break;
            }
            default: {
                FormAttachment formAttachment4 = formData.getRightAttachment(n);
                this.cacheLeft = formAttachment4.plus(this.left.offset + n);
            }
        }
        this.isVisited = false;
        return this.cacheLeft;
    }

    FormAttachment getRightAttachment(int n) {
        if (this.cacheRight != null) {
            return this.cacheRight;
        }
        if (this.isVisited) {
            this.cacheRight = new FormAttachment(0, this.cacheWidth);
            return this.cacheRight;
        }
        if (this.right == null) {
            if (this.left == null) {
                this.cacheRight = new FormAttachment(0, this.cacheWidth);
                return this.cacheRight;
            }
            this.cacheRight = this.getLeftAttachment(n).plus(this.cacheWidth);
            return this.cacheRight;
        }
        Control control = this.right.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.right.control = null;
        }
        if (control == null) {
            this.cacheRight = this.right;
            return this.cacheRight;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment formAttachment = formData.getRightAttachment(n);
        switch (this.right.alignment) {
            case 131072: {
                this.cacheRight = formAttachment.plus(this.right.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment formAttachment2 = formData.getLeftAttachment(n);
                FormAttachment formAttachment3 = formAttachment.minus(formAttachment2);
                this.cacheRight = formAttachment.minus(formAttachment3.minus(this.cacheWidth).divide(2));
                break;
            }
            default: {
                FormAttachment formAttachment4 = formData.getLeftAttachment(n);
                this.cacheRight = formAttachment4.plus(this.right.offset - n);
            }
        }
        this.isVisited = false;
        return this.cacheRight;
    }

    FormAttachment getTopAttachment(int n) {
        if (this.cacheTop != null) {
            return this.cacheTop;
        }
        if (this.isVisited) {
            this.cacheTop = new FormAttachment(0, 0);
            return this.cacheTop;
        }
        if (this.top == null) {
            if (this.bottom == null) {
                this.cacheTop = new FormAttachment(0, 0);
                return this.cacheTop;
            }
            this.cacheTop = this.getBottomAttachment(n).minus(this.cacheHeight);
            return this.cacheTop;
        }
        Control control = this.top.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.top.control = null;
        }
        if (control == null) {
            this.cacheTop = this.top;
            return this.cacheTop;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment formAttachment = formData.getTopAttachment(n);
        switch (this.top.alignment) {
            case 128: {
                this.cacheTop = formAttachment.plus(this.top.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment formAttachment2 = formData.getBottomAttachment(n);
                FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
                this.cacheTop = formAttachment.plus(formAttachment3.minus(this.cacheHeight).divide(2));
                break;
            }
            default: {
                FormAttachment formAttachment4 = formData.getBottomAttachment(n);
                this.cacheTop = formAttachment4.plus(this.top.offset + n);
            }
        }
        this.isVisited = false;
        return this.cacheTop;
    }
}

