/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIhdrChunk;

class PngPlteChunk
extends PngChunk {
    PngPlteChunk(byte[] byArray) {
        super(byArray);
    }

    int getPaletteSize() {
        return this.getLength() / 3;
    }

    PaletteData getPaletteData() {
        RGB[] rGBArray = new RGB[this.getPaletteSize()];
        int n = 0;
        while (n < rGBArray.length) {
            int n2 = 8 + n * 3;
            int n3 = this.reference[n2] & 0xFF;
            int n4 = this.reference[n2 + 1] & 0xFF;
            int n5 = this.reference[n2 + 2] & 0xFF;
            rGBArray[n] = new RGB(n3, n4, n5);
            ++n;
        }
        return new PaletteData(rGBArray);
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        if (!pngFileReadState.readIHDR || pngFileReadState.readPLTE || pngFileReadState.readTRNS || pngFileReadState.readBKGD || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readPLTE = true;
        }
        super.validate(pngFileReadState, pngIhdrChunk);
        if (!pngIhdrChunk.getCanHavePalette()) {
            SWT.error(40);
        }
        if (this.getLength() % 3 != 0) {
            SWT.error(40);
        }
        if (Compatibility.pow2(pngIhdrChunk.getBitDepth()) < this.getPaletteSize()) {
            SWT.error(40);
        }
        if (256 < this.getPaletteSize()) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tPalette size:");
        stringBuffer.append(this.getPaletteSize());
    }
}

