package test.contrib.tabledatefield;

import java.awt.Component;
import java.util.Date;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import org.jvnet.substance.SubstanceDefaultTableCellRenderer;

/**
 * Copyright 2008 Computer Science Software (Pty) Ltd. South Africa.
 * Stripped-down for Substance hover issue demo.
 * 
 * @author JZ
 * @author DP
 * @since 1.00
 * 
 * <BR>
 * 04-Apr-2000 : Created class (JZ) <BR>
 * 10-Jan-2002 : Extended class (DP)
 */

public class DateTextFieldRenderer extends SubstanceDefaultTableCellRenderer {

	private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	private static Border focusBorder = UIManager
			.getBorder("Table.focusCellHighlightBorder");

	private DateTextField dateTextField = new DateTextField();
	private JLabel dateLabel = new JLabel();
	private boolean hasSummaryLine;

	/** Creates new DateTextFieldEditor */
	public DateTextFieldRenderer() {
		dateTextField.setHorizontalAlignment(JTextField.RIGHT); // DP
		// 2002-01-10:
		// This gives us
		// for tables
		// only the
		// nicer right
		// alignment.
		dateTextField.getField().setBorder(null);
		dateLabel.setOpaque(true);
		dateLabel.setBorder(noFocusBorder);
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {

		if (isSelected) {
			dateTextField.setForeground(table.getSelectionForeground());
			dateTextField.setBackground(table.getSelectionBackground());
		} else {
			dateTextField.setForeground(table.getForeground());
			dateTextField.setBackground(table.getBackground());
		}

		if (hasFocus) {
			dateTextField.setBorder(UIManager
					.getBorder("Table.focusCellHighlightBorder"));
		} else {
			dateTextField.setBorder(null);
		}

		dateTextField.setFont(table.getFont());
		dateTextField.setDate((Date) value);
		return dateTextField;
	}

	/**
	 * Getter for property hasSummaryLine.
	 * 
	 * @return Value of property hasSummaryLine.
	 */
	public boolean getHasSummaryLine() {
		return this.hasSummaryLine;
	}

	/**
	 * Setter for property hasSummaryLine.
	 * 
	 * @param newHasSummaryLine
	 *            New value of property hasSummaryLine.
	 */
	public void setHasSummaryLine(boolean newHasSummaryLine) {
		this.hasSummaryLine = newHasSummaryLine;
	}
}