package test.contrib.tabledatefield;

import java.awt.*;
import java.awt.event.*;
import java.awt.im.InputMethodRequests;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.*;
import javax.swing.text.Document;

/**
 * Copyright 2008 Computer Science Software (Pty) Ltd. South Africa.
 * Stripped-down for Substance hover issue demo.
 * 
 * @author DP
 * 
 * 05-Apr-2003 : Created class (DP)
 */

public class DateTextField extends JComponent implements ActionListener,
		Accessible {

	protected Timestamp timestampValue;
	protected Calendar calendarDate = Calendar.getInstance();
	protected JPopupMenu popup = new JPopupMenu();
	protected DateField dateField;
	protected boolean popupIsVisible = false; // Was necessary to implement
	// because popup.isVisible()
	// returnes always false.

	protected JButton calendarButton = new JButton(
			new ImageIcon("calendar.gif")) {
		@Override
		public boolean isFocusTraversable() {
			return false;
		}
	};

	public DateTextField(SimpleDateFormat dateFormat) {
		if (dateFormat == null) {
			this.dateField = new DateField();
		} else {
			this.dateField = new DateField(dateFormat);
		}

		setLayout(new BorderLayout());
		add(BorderLayout.CENTER, dateField);

		calendarButton.setPreferredSize(new Dimension(21, 14));
		calendarButton.addActionListener(this);
		add(BorderLayout.EAST, calendarButton);

	}

	public DateTextField() {
		this(null);
	}

	public Date getDate() {
		return dateField.getValue();
	}

	public void setDate(Date newDate) {
		if (newDate != null) {
			dateField.setValue(newDate);
			calendarDate.setTime(newDate);
		} else {
			dateField.setValue(null);
			calendarDate = Calendar.getInstance();
		}

	}

	public Timestamp getTimestamp() {
		if (dateField.getValue() == null) {
			timestampValue = null;
		} else {
			timestampValue = new Timestamp(dateField.getValue().getTime());
		}

		return timestampValue;
	}

	protected void setFieldValue(Calendar newCalendarDate) {
		this.calendarDate = newCalendarDate;

		if (calendarDate != null) {
			dateField.setValue(calendarDate.getTime());
		} else {
			dateField.setValue(null);
		}
	}

	public String getText() {
		if (dateField.getText() != null) {
			return dateField.getText().trim();
		} else {
			return null;
		}
	}

	/**
	 * Override setText() to throw a RuntimeException, setDate() should be used
	 * instead.
	 */
	public void setText(String text) {
		throw new RuntimeException("Use setDate() instead of setText() ...");
	}

	public DateField getField() {
		return dateField;
	}

	/**
	 * Fetches the model associated with the editor. This is primarily for the
	 * UI to get at the minimal amount of state required to be a text editor.
	 * Subclasses will return the actual type of the model which will typically
	 * be something that extends Document.
	 * 
	 * @return the model
	 */
	public Document getDocument() {
		return dateField.getDocument();
	}

	/**
	 * Associates the editor with a text document. The currently registered
	 * factory is used to build a view for the document, which gets displayed by
	 * the editor after revalidation. A PropertyChange event ("document") is
	 * propagated to each listener.
	 * 
	 * @param doc
	 *            the document to display/edit
	 * @see #getDocument
	 * @beaninfo description: the text document model bound: true expert: true
	 */
	public void setDocument(Document doc) {
		dateField.setDocument(doc);
	}

	@Override
	public void setEnabled(boolean flag) {
		calendarButton.setEnabled(flag);
		dateField.setEnabled(flag);
	}

	public void setHorizontalAlignment(int alignment) {
		dateField.setHorizontalAlignment(alignment);
	}

	@Override
	public void setForeground(Color color) {
		if (dateField != null) {
			dateField.setForeground(color);
		}
	}

	@Override
	public void setBackground(Color color) {
		if (dateField != null) {
			dateField.setBackground(color);
		}
	}

	@Override
	public Color getBackground() {
		if (dateField != null) {
			return dateField.getBackground();
		}
		return null;
	}

	protected Calendar getCurrentCalendarValue() {
		if (dateField.getValue() != null) {
			calendarDate.setTime(dateField.getValue());
		} else {
			calendarDate = Calendar.getInstance();
		}

		return calendarDate;
	}

	public void actionPerformed(ActionEvent event) {
	}

	public boolean getHasChanged() {
		return dateField.getHasChanged();
	}

	public void setHasChanged(boolean newHasChanged) {
		dateField.setHasChanged(newHasChanged);
	}

	@Override
	public void requestFocus() {
		dateField.requestFocus();
	}

	@Override
	public boolean requestFocusInWindow() {
		return dateField.requestFocusInWindow();
	}

	@Override
	public void addFocusListener(FocusListener l) {
		if (dateField == null) {
			super.addFocusListener(l);
		} else {
			dateField.addFocusListener(l);
		}
	}

	@Override
	public void removeFocusListener(FocusListener l) {
		if (dateField == null) {
			super.removeFocusListener(l);
		} else {
			dateField.removeFocusListener(l);
		}
	}

	/**
	 * Returns the boolean indicating whether this <code>DateTextField</code>
	 * is editable or not.
	 * 
	 * @return the boolean value
	 * @see #setEditable
	 */
	public boolean isEditable() {
		return dateField.isEditable();
	}

	/**
	 * Sets the specified boolean to indicate whether or not this
	 * <code>DateTextField</code> should be editable. A PropertyChange event
	 * ("editable") is fired when the state is changed.
	 * 
	 * @param b
	 *            the boolean to be set
	 * @see #isEditable
	 * @beaninfo description: specifies if the text can be edited bound: true
	 */
	public void setEditable(boolean b) {
		dateField.setEditable(b);

		if (b == false) {
			calendarButton.setEnabled(false);
		} else {
			calendarButton.setEnabled(dateField.isEnabled());
		}
	}

	@Override
	public InputMethodRequests getInputMethodRequests() {
		return dateField.getInputMethodRequests();
	}

	/**
	 * Gets the <code>AccessibleContext</code> associated with this
	 * <code>DateTextField</code>. For text components, the
	 * <code>AccessibleContext</code> takes the form of an
	 * <code>AccessibleJTextComponent</code>. A new
	 * <code>AccessibleJTextComponent</code> instance is created if necessary.
	 * 
	 * @return an <code>AccessibleJTextComponent</code> that serves as the
	 *         <code>AccessibleContext</code> of this
	 *         <code>DateTextField</code>
	 */
	@Override
	public AccessibleContext getAccessibleContext() {
		return dateField.getAccessibleContext();

		/*
		 * if(accessibleContext == null){ accessibleContext = new
		 * AccessibleDateComponent(); }
		 * 
		 * return accessibleContext;
		 */
	}

	/**
	 * This class implements accessibility support for the <code>JPanel</code>
	 * class. It provides an implementation of the Java Accessibility API
	 * appropriate to panel user-interface elements.
	 * <p>
	 * <strong>Warning:</strong> Serialized objects of this class will not be
	 * compatible with future Swing releases. The current serialization support
	 * is appropriate for short term storage or RMI between applications running
	 * the same version of Swing. As of 1.4, support for long term storage of
	 * all JavaBeans<sup><font size="-2">TM</font></sup> has been added to
	 * the <code>java.beans</code> package. Please see
	 * {@link java.beans.XMLEncoder}.
	 */
	// protected class AccessibleDateComponent extends AccessibleJComponent {
	//   
	// /** Get the role of this object.
	// * @return an instance of AccessibleRole describing the role of the
	// object. */
	// public AccessibleRole getAccessibleRole(){
	// return AccessibleRole.DATE_EDITOR;
	// }
	// }
}