package test.contrib.bug334;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CustomJLabelTableCellRenderer implements TableCellRenderer {

	// for serialization

	private static JLabel renderer = new JLabel();
	static {
		renderer.setOpaque(true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable,
	 *      java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		if (isSelected) {
			renderer.setBackground(Color.BLUE);
			renderer.setForeground(Color.YELLOW);
		} else {
			renderer.setBackground(Color.WHITE);
			renderer.setForeground(Color.BLACK);
		}
		renderer.setText(String.valueOf(value));
		return renderer;
	}
}
