package test.contrib;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;

import javax.swing.CellEditor;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.MistAquaSkin;

public class TestSubstanceTableModel extends AbstractTableModel {
 
  private static final int s_DESCRIPTION_COLUMN = 0;
  private static final int s_DATA_COLUMN = 1;
  private static final int s_SELECT_COLUMN = 2;
 
  String columnName[] = { "description", "data", "select" };

  Class columnType[] = { String.class, String.class, Boolean.class };

  Object table[][] = { { "this is line", "data", new Boolean(true) },
      { "this is line", "data", new Boolean(false) },
      { "this is line", "data", new Boolean(true) },
      { "this is line", "data", new Boolean(false) },
      { "this is line", "data", new Boolean(true) },
      { "this is line", "data", new Boolean(false) },
      { "this is line", "data", new Boolean(true) },
      { "this is line", "data", new Boolean(false) },
      { "this is line", "data", new Boolean(true) } };

  public int getColumnCount() {
    return table[0].length;
  }

  public int getRowCount() {
    return table.length;
  }

  public Object getValueAt(int r, int c) {
    return table[r][c];
  }

  public String getColumnName(int column) {
    return columnName[column];
  }

  public Class getColumnClass(int c) {
    return columnType[c];
  }

  public boolean isCellEditable(int r, int c) {
    return true;
  }

  public void setValueAt(Object aValue, int r, int c) {
   table[r][c] = aValue;
  }
 
 
  public static void main(String[] arg)throws Exception {
 UIManager.setLookAndFeel(new SubstanceLookAndFeel());
   SubstanceLookAndFeel.setSkin(new MistAquaSkin());
   JTable myTable = new JTable(new TestSubstanceTableModel());
   myTable.setIntercellSpacing(new Dimension(15,5));
   myTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
   myTable.setShowGrid(false);
   myTable.setRowSelectionAllowed(false);
   myTable.setColumnSelectionAllowed(false);
   
   myTable.setRowSelectionAllowed(false);
   myTable.setRowHeight(25);
   setCellRendererEditor(myTable);
   
   
    JFrame f = new JFrame();
    f.getContentPane().add(new JScrollPane(myTable));
    f.setSize(300,300);
    f.show();
    f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
  }
 
  public static void setCellRendererEditor(JTable myTable){
   TextFieldRenderer textRenderer = new TextFieldRenderer();
   TextFieldEditor textEditor = new TextFieldEditor();

   TableColumn descriptionColumn =
    myTable.getColumnModel().getColumn(TestSubstanceTableModel.s_DESCRIPTION_COLUMN);
   descriptionColumn.setCellRenderer(textRenderer);
   descriptionColumn.setCellEditor(textEditor);
   descriptionColumn.setPreferredWidth(50);
  
   TableColumn dataColumn =
    myTable.getColumnModel().getColumn(TestSubstanceTableModel.s_DATA_COLUMN);
   dataColumn.setCellRenderer(textRenderer);
   dataColumn.setCellEditor(textEditor);
   dataColumn.setPreferredWidth(150);
  }
 
  public static class TextFieldRenderer extends JTextField implements TableCellRenderer {

   public TextFieldRenderer() {
     setHorizontalAlignment(JLabel.RIGHT);
   }

   public Component getTableCellRendererComponent(JTable table, Object value,
       boolean isSelected, boolean hasFocus, int row, int column) {
     if (isSelected) {
       setForeground(table.getSelectionForeground());
       //super.setBackground(table.getSelectionBackground());
       setBackground(table.getSelectionBackground());
     } else {
       setForeground(table.getForeground());
       setBackground(table.getBackground());
     }
     setText((String)value);
     return this;
   }
   }
 
  public static class TextFieldEditor extends JTextField implements TableCellEditor, FocusListener {
   protected EventListenerList listenerList = new EventListenerList();
   protected ChangeEvent changeEvent = new ChangeEvent(this);
   //
   public TextFieldEditor() {
   this.addFocusListener(this);
   }

   public void focusGained(FocusEvent e) {
   System.out.println("GOT FOCUS");
   }

   public void focusLost(FocusEvent e) {
   System.out.println("LOST FOCUS");
   }

   public void addCellEditorListener(CellEditorListener listener) {
   listenerList.add(CellEditorListener.class, listener);
   }

   public void removeCellEditorListener(CellEditorListener listener) {
   listenerList.remove(CellEditorListener.class, listener);
   }

   protected void fireEditingStopped() {
   CellEditorListener listener;
   Object[] listeners = listenerList.getListenerList();
   for (int i = 0; i < listeners.length; i++) {
   if (listeners[i] == CellEditor.class) {
   listener = (CellEditorListener) listeners[i + 1];
   listener.editingStopped(changeEvent);
   }
   }
   }

   protected void fireEditingCanceled() {
   CellEditorListener listener;
   Object[] listeners = listenerList.getListenerList();
   for (int i = 0; i < listeners.length; i++) {
   if (listeners[i] == CellEditor.class) {
   listener = (CellEditorListener) listeners[i + 1];
   listener.editingCanceled(changeEvent);
   }
   }
   }

   public void cancelCellEditing() {
   fireEditingCanceled();
   }

   public boolean stopCellEditing() {
   fireEditingStopped();
   return true;
   }

   public boolean isCellEditable(EventObject event) {
   return true;
   }

   public boolean shouldSelectCell(EventObject event) {
   return true;
   }

   public Object getCellEditorValue() {
   System.out.println(this.getText());
   return this.getText();
   }

   public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
    this.setText((String)value);
    return this;
   }
 
  }

 
}