/*
 * SubstanceSplitPaneTest.java
 *
 * Created on 28-Sep-07, PM 04:04
 */

package test.contrib;

import java.awt.BorderLayout;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * @author Prashant Bhat
 */
public class SubstanceSplitPaneTest2 extends JPanel {
	JSplitPane splitPane;

	private void initComponents() {
		splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, new JPanel(),
				new JPanel());
		splitPane.setOneTouchExpandable(true);
		splitPane.setDividerLocation(50);
	}

	private void layoutComponents() {
		setLayout(new BorderLayout());
		add(splitPane);
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				setSubstanceLookAndFeel();
				SubstanceSplitPaneTest2 splitPaneTest = new SubstanceSplitPaneTest2();
				splitPaneTest.initComponents();
				splitPaneTest.layoutComponents();
				JFrame frame = new JFrame("Substance Table with SplitPane");
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				frame.add(splitPaneTest);
				frame.pack();
				frame.setSize(275, 150);
				frame.setVisible(true);
			}
		});
	}

	private static void setSubstanceLookAndFeel() {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
