package test.contrib;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.*;
import javax.swing.text.MaskFormatter;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class MaskedTextField {

	public static void main(String[] args) {
		try {
			UIManager
					.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
			SubstanceLookAndFeel
					.setCurrentWatermark("org.jvnet.substance.watermark.SubstanceStripeWatermark");
			SubstanceLookAndFeel.setToUseConstantThemesOnDialogs(true);
			JFrame.setDefaultLookAndFeelDecorated(true);
			UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, true);
		} catch (UnsupportedLookAndFeelException ex) {
			ex.printStackTrace();
		}

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				FrameMain f = new FrameMain();
				f.setVisible(true);
			}
		});
	}
}

class FrameMain extends JFrame {

	public FrameMain() {
		try {
			getContentPane().setLayout(new java.awt.FlowLayout());
			setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
			int count = 100;
			for (int i = 0; i < count; i++) {
				JFormattedTextField jFormattedTextFieldUser = new JFormattedTextField();
				jFormattedTextFieldUser.setFont(new java.awt.Font(
						"Courier New", 0, 11));
				add(jFormattedTextFieldUser);
				MaskFormatter mask;
				mask = new MaskFormatter("************");
				mask.setPlaceholderCharacter(' ');
				mask.install(jFormattedTextFieldUser);
				jFormattedTextFieldUser.setText("user");
			}
			setSize(200, 300);
		} catch (ParseException ex) {
			Logger.getLogger(FrameMain.class.getName()).log(Level.SEVERE, null,
					ex);
		}
	}
}