package test.contrib;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.swing.*;

import org.jvnet.substance.SubstanceInternalFrameUI;
import org.jvnet.substance.SubstanceLookAndFeel;

public class DesktopRepaintBug {

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					UIManager.setLookAndFeel(new SubstanceLookAndFeel());
					// UIManager.setLookAndFeel(new MetalLookAndFeel());
					// UIManager.setLookAndFeel(new WindowsLookAndFeel());
				} catch (UnsupportedLookAndFeelException e1) {
					e1.printStackTrace();
				}
				// SubstanceLookAndFeel
				// .setCurrentWatermark(new SubstanceMetalWallWatermark());
				JFrame.setDefaultLookAndFeelDecorated(true);
				JDialog.setDefaultLookAndFeelDecorated(true);
				final JFrame frame = new JFrame("JDesktopNoVisibleRepaintBug");
				frame.setSize(600, 400);
				frame.setLocationRelativeTo(null);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				final JDesktopPane desktop = new JDesktopPane();
				// desktop.setUI((DesktopPaneUI) BasicDesktopPaneUI
				// .createUI(desktop));
				frame.setContentPane(desktop);
				frame.setVisible(true);
				final JInternalFrame internal = new JInternalFrame(
						"Internal Non-visible Test", false, true, false, true);
				internal.setOpaque(false);
				internal.setSize(300, 100);
				internal.setVisible(true);
				desktop.add(internal);
				desktop.setSelectedFrame(internal);
				try {
					Field field;
					field = AccessController
							.doPrivileged(new FieldPrivilegedAction(
									SubstanceInternalFrameUI.class, "titlePane"));
					if (field != null) {
						JComponent titlePane = (JComponent) field.get(internal
								.getUI());
						titlePane.addMouseListener(new MouseAdapter() {
							@Override
							public void mousePressed(MouseEvent e) {
								internal.setVisible(false);
							}

							@Override
							public void mouseReleased(MouseEvent e) {
								internal.setVisible(true);
							}
						});
					}
				} catch (IllegalAccessException ex) {
				} catch (IllegalArgumentException ex) {
				}

			}
		});
	}

	/**
	 * Retrieves a Field from the provided class and makes it accessible.
	 */
	public static class FieldPrivilegedAction implements
			PrivilegedAction<Field> {
		private Class<?> clazz;
		private String fieldName;

		public FieldPrivilegedAction(Class<?> clazz, String fieldName) {
			this.clazz = clazz;
			this.fieldName = fieldName;
		}

		public Field run() {
			Field field = null;
			try {
				field = clazz.getDeclaredField(fieldName);
			} catch (NoSuchFieldException ex) {
			}
			if (field != null) {
				field.setAccessible(true);
			}
			return field;
		}
	}

}