package test;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel;

public class ToolbarDisabledButtons extends JFrame {
	
	public ToolbarDisabledButtons() {
		this.setLayout(new BorderLayout());
		JToolBar toolbar = new JToolBar();
		this.add(toolbar, BorderLayout.NORTH);
		
		JButton button1 = new JButton("text1");
		JButton button2 = new JButton("text2");
		button2.setEnabled(false);
		Action action3 = new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
			}
		};
		action3.putValue(Action.NAME, "text3");
		action3.setEnabled(false);
		JButton button3 = new JButton(action3);
		
		toolbar.add(button1);
		toolbar.add(button2);
		toolbar.add(button3);
		
		this.setSize(400, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ToolbarDisabledButtons().setVisible(true);
			}
		});
	}

}
