package test;

import java.awt.*;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.preview.DefaultPreviewPainter;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;

public class ScrollDesktop extends JFrame {
	public ScrollDesktop() {
		JDesktopPane jdp = new JDesktopPane();
		JInternalFrame jif1 = new JInternalFrame();
		jif1.setLayout(new FlowLayout());
		jif1.add(new JButton("button"));
		jif1.setMaximizable(true);
		jif1.setIconifiable(true);
		jif1.setResizable(true);
		jif1.setBounds(20, 20, 500, 500);
		jdp.add(jif1);
		jdp.setPreferredSize(new Dimension(600, 600));
		jif1.setVisible(true);

		JScrollPane jsp = new JScrollPane(jdp);
		jsp.putClientProperty(SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
				new AlphaControlBackgroundComposite(0.4f, 0.6f));
		jsp.putClientProperty(SubstanceLookAndFeel.OVERLAY_PROPERTY, Boolean.TRUE);
		jsp.putClientProperty(LafWidget.COMPONENT_PREVIEW_PAINTER,
				new DefaultPreviewPainter());

		this.setLayout(new BorderLayout());
		this.add(jsp, BorderLayout.CENTER);
		this.setSize(300, 300);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ScrollDesktop().setVisible(true);
			}
		});
	}

}
