/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.*;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.GlassGradientPainter;
import org.jvnet.substance.painter.decoration.Glass3DDecorationPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.watermark.SubstanceBinaryWatermark;

/**
 * <code>Field of Wheat</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class FieldOfWheatSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static final String NAME = "Field of Wheat";

	/**
	 * Creates a new <code>Field of Wheat</code> skin.
	 */
	public FieldOfWheatSkin() {
		SubstanceTheme activeTheme = new SubstanceAquaTheme().saturate(0.1);
		SubstanceTheme defaultTheme = new SubstanceBrownTheme();

		ColorScheme disabledScheme = new SaturatedColorScheme(
				new BlendBiColorScheme(new BrownColorScheme(),
						new SunGlareColorScheme(), 0.3), -0.2) {
			Color foreColor = new Color(181, 122, 26);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		};
		SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme,
				"Disabled Field Of Wheat", ThemeKind.COLD);

		SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.4);
		SubstanceTheme watermarkTheme = new SubstanceSunGlareTheme().tone(0.8);

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, ThemeKind.BRIGHT,
				activeTheme, defaultTheme, disabledTheme, activeTitleTheme,
				watermarkTheme);
		this.theme = theme;

		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceBinaryWatermark();
		this.gradientPainter = new GlassGradientPainter();
		this.decorationPainter = new Glass3DDecorationPainter();
		this.borderPainter = new ClassicBorderPainter();
		this.highlightPainter = new ClassicHighlightPainter();

		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
