/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.painter;

import java.awt.Shape;
import java.awt.image.BufferedImage;

import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.PerlinNoiseGenerator;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/**
 * Gradient painter that uses noise textures. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 */
public class NoiseGradientPainter extends BaseGradientPainter {
	/**
	 * Noise generator.
	 */
	protected static PerlinNoiseGenerator noiseGenerator = new PerlinNoiseGenerator();

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.painter.SubstanceGradientPainter#getDisplayName()
	 */
	public String getDisplayName() {
		return "Noise";
	}

	/* (non-Javadoc)
	 * @see org.jvnet.substance.painter.SubstanceGradientPainter#getContourBackground(int, int, java.awt.Shape, boolean, org.jvnet.substance.color.ColorScheme, org.jvnet.substance.color.ColorScheme, float, boolean, boolean)
	 */
	public BufferedImage getContourBackground(int width, int height,
			Shape contour, boolean isDark, ColorScheme colorScheme1,
			ColorScheme colorScheme2, float cyclePos, boolean hasShine,
			boolean useCyclePosAsInterpolation) {

		// // System.err.println(System.currentTimeMillis() + ":" + width + "*"
		// +
		// // height);
		//
		// BufferedImage mixResult = this.getMixContourBackground(width, height,
		// contour, isDark, colorScheme1, colorScheme2, cyclePos,
		// hasShine, useCyclePosAsInterpolation);
		// if (mixResult != null)
		// return mixResult;
		//
		// // long millis = System.nanoTime();
		//
		BufferedImage image = SubstanceCoreUtilities.getBlankImage(width,
				height);
		// Graphics2D graphics = (Graphics2D) image.getGraphics();
		// graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		// RenderingHints.VALUE_ANTIALIAS_ON);
		//
		// ColorScheme interpolationScheme1 = colorScheme1;
		// ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ?
		// colorScheme2
		// : colorScheme1;
		//
		// double cycleCoef = 1.0 - cyclePos / 10.0;
		//
		// Color topBorderColor = SubstanceColorUtilities.getTopBorderColor(
		// interpolationScheme1, interpolationScheme2, cycleCoef);
		// Color midBorderColor = SubstanceColorUtilities.getMidBorderColor(
		// interpolationScheme1, interpolationScheme2, cycleCoef);
		// Color bottomBorderColor =
		// SubstanceColorUtilities.getBottomBorderColor(
		// interpolationScheme1, interpolationScheme2, cycleCoef);
		//
		// // FabricFilter.FabricFilterLink fabricLink1 =
		// FabricFilterLink.getXLink(
		// // 1.0, 10.0, TrigKind.SINE);
		// // FabricFilter.FabricFilterLink fabricLink2 =
		// FabricFilterLink.getYLink(
		// // 1.0, 10.0, TrigKind.COSINE);
		// // NoiseFilter fabricFilter = new FabricFilter(fabricLink1,
		// fabricLink2);
		// NoiseFilter mazeFilter = new MedianBeakFilter();
		//
		// graphics.setClip(contour);
		// graphics.drawImage(NoiseFactory.getNoiseImage(interpolationScheme1,
		// interpolationScheme2, cycleCoef, width, height, 0.1, 0.1, true,
		// mazeFilter, false), 0, 0, null);
		//
		// graphics.setStroke(new BasicStroke((float) 1.3,
		// BasicStroke.CAP_ROUND,
		// BasicStroke.JOIN_ROUND));
		//
		// // long millis001 = System.nanoTime();
		//
		// // long millis003 = 0, millis004 = 0, millis005 = 0;
		//
		// // Draw border
		// GradientPaint gradientBorderTop = new GradientPaint(0, 0,
		// topBorderColor, 0, height / 2, midBorderColor);
		// graphics.setPaint(gradientBorderTop);
		// graphics.setClip(0, 0, width, height / 2);
		// graphics.draw(contour);
		//
		// GradientPaint gradientBorderBottom = new GradientPaint(0, height / 2,
		// midBorderColor, 0, height - 2, bottomBorderColor);
		// graphics.setPaint(gradientBorderBottom);
		// graphics.setClip(0, height / 2, width, 1 + height / 2);
		// graphics.draw(contour);
		//
		return image;
	}
}
