.TH "TK_GetVar" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_GetVar - Get a tcl/tk variable value

.SH CALLING SEQUENCE
value=TK_SetVar(varname)
.SH PARAMETERS
.TP
o 
varname : string character
Contains the name of the tcl/tk variable.
.TP
o 
value : string character
Contains the value of the tcl/tk variable 'varname'.
.SH Description
When tcl/tk support is enabled in scilab, this routine can be used to retreive
the value of a tcl/tk variable. 
.SH EXAMPLE
.nf
TK_EvalStr('toplevel .tst1');
// creates a toplevel TK window. 
TK_EvalStr('entry .tst1.e -textvariable tvar');
// create an editable entry
TK_EvalStr('set tvar foobar');
// set the entry value
TK_EvalStr('pack .tst1.e');
// pack the entry widget. It appears on the screen.
text=TK_GetVar('tvar')
// retrieve the variable value
// change the entry text and repeat the last command ...
.fi 
.SH SEE ALSO
ScilabEval, TK_EvalFile, TK_EvalStr, TK_SetVar
.SH AUTHOR
Bertrand Guiheneuf
