.TH mlist 1 "September 1995" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
mlist - Scilab object, matrix oriented typed list definition.
.SH CALLING SEQUENCE
.nf
mlist(typ,a1,....an )  
.fi
.SH PARAMETERS
.TP 10
typ
: vector of character strings
.TP 
ai
: any Scilab object (\fVmatrix, list,string...\fR).
.SH DESCRIPTION
mlist object are very similar to tlist objects. But if \fVM\fR is an
mlist, for any index \fVi\fR which is not a field name, \fVM(i)\fR is
not the \fVi\fRth field of the list but is interpreted as the \fVi\fR
th entry of \fVM\fR seen as a vector. This is the only difference
between  \fVmlist\fR and  \fVtlist\fR.
.LP

mlist fields must then be designed by their names. They can also be
handled using the \fVgetfield\fR  and \fVsetfield\fR  functions.

.SH EXAMPLE
.nf
M=mlist(['V','name','value'],['a','b','c'],[1 2 3]);
//define display
deff('%V_p(M)','disp(M.name+'':''+string(M.value))')
//define extraction operation
deff('r=%V_e(i,M)',..
'r=mlist([''V'',''name'',''value''],M.name(i),M.value(i))')
M(2) // the second entry of the vector M
M(2).value 

//define M as a tlist
M=tlist(['V','name','value'],['a','b','c'],[1 2 3]);
M(2)

M('name')

//with two  indices
M=mlist(['V','name','value'],['a','b';'c' 'd'],[1 2;3 4]);
deff('r=%V_e(varargin)',[
    'M=varargin($)';
    'H=[''V'',''name'',''value'']'
    'r=mlist(H,M.name(varargin(1:$-1)),M.value(varargin(1:$-1)))'])

M(:,2)
// multidimensionnal array
str=['a','b','c','d','e','f','g','h'];
n=hypermat([2,2,2],str);
v=hypermat([2,2,2],1:8);
M=mlist(['V','name','value'],n,v);
M(1,1:2,2)
.fi
.SH SEE ALSO
tlist, list, overloading, getfield, setfield
