.TH datafit 1 "Feb 1999" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
datafit - Parameter identification based on measured data
.SH CALLING SEQUENCE
.nf
[p,err]=datafit([imp,] G [,DG],Z [,W],[contr],p0,[algo],[df0,[mem]],
     [work],[stop],['in'])
.fi
.SH PARAMETERS
.TP 6
imp
: scalar argument used to set the trace mode. \fVimp=0\fR nothing
(execpt errors) is reported, \fVimp=1\fR initial and final reports,
\fVimp=2\fR adds a report per iteration, \fVimp>2\fR add reports on
linear search. Warning, most of these reports are written on the
Scilab standard output.
.TP
G
: function descriptor (e=G(p,z), e: ne x 1, p: np x 1, z: nz x 1)
.TP
DG
: partial of G wrt p function descriptor (optional; S=DG(p,z), S: ne x np)
.TP
Z
: matrix [z_1,z_2,...z_n] where z_i (nz x 1) is the ith measurement
.TP
W
: weighting matrix of size ne x ne (optional; defaut no ponderation)
.TP
contr 
: \fV'b',binf,bsup\fR  with \fVbinf\fR and \fVbsup\fR real vectors with same
dimension as \fVp0\fR. \fVbinf\fR and \fVbsup\fR are lower and upper
bounds on \fVp\fR.
.TP
p0
: initial guess (size np x 1)
.TP
algo
: \fV'qn'\fR or \fV'gc'\fR or \fV'nd'\fR . This string stands for quasi-Newton (default), 
conjugate gradient or non-differentiable respectively. 
Note that \fV'nd'\fR does not accept bounds on \fVx\fR ).
.TP
df0 
: real scalar. Guessed decreasing of \fVf\fR at first iteration.
(\fVdf0=1\fR is the default value).
.TP
mem :
 integer, number of variables used to approximate the 
Hessian, (\fValgo='gc' or 'nd'\fR). Default value is around 6.
.TP
stop 
:  sequence of optional parameters controlling the 
convergence of the algorithm.
\fV stop=  'ar',nap, [iter [,epsg [,epsf [,epsx]]]]\fR
.RS
.TP
"ar"
: reserved keyword for stopping rule selection defined as follows:
.TP
nap 
: maximum number of calls to \fVfun\fR allowed.
.TP
iter  
: maximum number of iterations allowed.
.TP
epsg  
: threshold on gradient norm.
.TP
epsf  
: threshold controlling decreasing of \fVf\fR
.TP
epsx 
: threshold controlling variation of \fVx\fR.
This vector (possibly matrix) of same size as \fVx0\fR can be used
to scale \fVx\fR.
.RE
.TP
"in" 
: reserved  keyword for initialization of parameters
used when \fVfun\fR in given as a Fortran routine (see below).
.TP
p
: Column vector, optimal solution found
.TP
err
: scalar, least square error.

.SH DESCRIPTION
\fVdatafit\fR is used for fitting data to a model.
For a given function \fVG(p,z)\fR, this function finds the best vector 
of parameters \fVp\fR for approximating \fVG(p,z_i)=0\fR for a set of measurement
vectors \fVz_i\fR. Vector \fVp\fR is found by minimizing
\fVG(p,z_1)'WG(p,z_1)+G(p,z_2)'WG(p,z_2)+...+G(p,z_n)'WG(p,z_n)\fR
.LP

\fVdatafit\fR is an improved version of \fVfit_dat\fR.
.SH EXAMPLE
.nf
deff('y=FF(x)','y=a*(x-b)+c*x.*x')
X=[];Y=[];
a=34;b=12;c=14;for x=0:.1:3, Y=[Y,FF(x)+100*(rand()-.5)];X=[X,x];end
Z=[Y;X];
deff('e=G(p,z)','a=p(1),b=p(2),c=p(3),y=z(1),x=z(2),e=y-FF(x)')
[p,err]=datafit(G,Z,[3;5;10])

xset('window',0)
xbasc();
plot2d(X',Y',-1) 
plot2d(X',FF(X)',5,'002')
a=p(1),b=p(2),c=p(3);plot2d(X',FF(X)',12,'002')
//same probleme with a known 
deff('e=G(p,z,a)','b=p(1),c=p(2),y=z(1),x=z(2),e=y-FF(x)')
[p,err]=datafit(list(G,a),Z,[5;10])

a=34;b=12;c=14;
deff('s=DG(p,z)','y=z(1),x=z(2),s=-[x-p(2),-p(1),x*x]')
[p,err]=datafit(G,DG,Z,[3;5;10])
xset('window',1)
xbasc();
plot2d(X',Y',-1) 
plot2d(X',FF(X)',5,'002')
a=p(1),b=p(2),c=p(3);plot2d(X',FF(X)',12,'002')
.fi
.SH SEE ALSO
optim, leastsq

