.TH xclick 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xclick - wait for a mouse click
.SH CALLING SEQUENCE
.nf
[c_i,c_x,c_y,c_w,c_m]=xclick([flag])
.fi
.SH PARAMETERS
.TP 9
c_i
: integer, mouse button number.
.TP
c_x,c_y
: real scalars, position of the mouse.
.TP 
c_w
: integer, window number.
.TP 
c_m
: string, menu callback.
.TP
flag
: integer. If present, the click event queue is not cleared when entering 
xclick.
.SH DESCRIPTION
\fVxclick\fR waits for a mouse click in the graphics window.

If it is called with 3 left hand side arguments, it waits for a mouse click 
in the current graphics window.
.LP
If it is called with 4 or 5 left hand side arguments, it waits for a mouse 
click in any graphics window.
.LP
The returned values are described below.
.TP 9
c_i 
: an integer which gives the number of the mouse button that was pressed 
0, 1 or 2 (for left, middle and right) or -1 in case of problems with xclick.
.TP
c_x,c_y
: the coordinates of the position of the mouse click in the current graphics 
scale.
.TP 
c_w
: the window number where the click has occurred.
.TP 
c_m
: string associated with a dynamic menu. If xclick returns
due to a click on a menu, \fVc_i\fR, \fVc_x\fR, \fVc_y,\fR and \fVc_w\fR take
arbitrary values.
.SH KNOWN TROUBLES
\fVxclick\fR can return the message 
"Can't grab the pointer" if the graphics window is iconified when 
calling it.
.SH SEE ALSO
locate, xgetmouse
.SH AUTHOR
J.Ph.C.
