.TH xarcs 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xarcs - draw parts of a set of ellipses
.SH CALLING SEQUENCE
.nf
xarcs(arcs,[style])
.fi
.SH PARAMETERS
.TP 7
arcs
: matrix of size (6,n) describing the ellipses.
.TP 
style
: row vector of size n giving the style to use.
.SH DESCRIPTION
\fVxarcs\fR draws parts of a set of ellipses described by \fVarcs\fR: 
\fVarcs=[x y w h a1 a2;x y w h a1 a2;...]'\fR where each ellipse is defined 
by the 6 parameters \fV(x,y,w,h,a1,a2)\fR (see \fVxarc\fR).
.LP
\fVstyle(i)\fR gives the dash style used to draw ellipse number \fVi\fR.
.SH EXAMPLE 
.nf 
plot2d(0,0,-1,"031"," ",[-1,-1,1,1])
arcs=[-1.0 0.0 0.5; // upper left x
       1.0 0.0 0.5; // upper left y
       0.5 1.0 0.5; // width
       0.5 0.5 1.0; // height
       0.0 0.0 0.0; // angle 1
       180*64 360*64 90*64]; // angle 2
xarcs(arcs,[1,2,3])
.fi
.SH SEE ALSO
xarc, xfarc, xfarcs
.SH AUTHOR
J.Ph.C.

