.TH paramfplot2d 2 "April 1993" "Scilab Group" "Scilab Function" 
.so ../sci.an
.SH NAME
paramfplot2d  - animated 2D plot, curve defined by a function
.SH CALLING SEQUENCE
.nf
paramfplot2d(f,x,theta)
paramfplot2d(f,x,theta,flag)
paramfplot2d(f,x,theta,flagrect)
.fi
.SH PARAMETERS
.TP 15
x
: real vector.
.TP 
f 
: function \fVy=f(x,t)\fR . f is a Scilab function or a
dynamically linked routine (referred to as a string).
.TP
theta
: real vector (set of parameters).
.TP
flag
: string \fV'no'\fR or \fV'yes'\fR: If "yes" screen is cleared 
between two consecutive plots.
.TP
rect
: "rectangle" [xmin, xmax, ymin, ymax] (1 x 4 real vector),
.LP
.SH DESCRIPTION
Animated plot of the function x-->f(x,t) for t=theta(1),theta(2),etc.
f can be a either Scilab function or a dynamically linked routine since
y=f(x,t) is evaluated as y=feval(x(:),t,f). See feval.
f: mapping x,t -> f(x,t) = R^N valued function for x= vector of R^N
and t=real number. x is a N-vector of x-values and for each t in theta, f(x,t)=N-vector of y-values.
.SH EXAMPLE 
.nf
deff('y=f(x,t)','y=t*sin(x)')
x=linspace(0,2*%pi,50);theta=0:0.05:1;
paramfplot2d(f,x,theta);
.fi
.SH SEE ALSO
plot2d, feval, fplot2d, pixmap


