.TH drawaxis  2 "April 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
drawaxis - draw an axis 
.SH CALLING SEQUENCE
.nf
drawaxis([options]) 
// options: x,y,dir,sub_int,fontsize,format_n,seg,textcolor,ticscolor,tics
.fi
.SH PARAMETERS
.TP 8
dir=string
: used to specify the tics direction. \fVstring\fR can be chosen among 
 'u','r','d','l' and 'l' is the default value. the values 'u','r','d','l'
stands respectively for up, right, down, left
.TP
tics=string
: A flag which describes how the tics are given. 
 \fVstring\fR can be chosen among 'v','r', and 'i', and, 'v' is the default value
.TP
x,y
: two vectors which give tics positions.
.TP
val= string matrix
: A string matrix, which, when given, gives the string to be drawn along
the axis at tics positions.
.TP
fontsize=int 
: specifies the fontsize to use for displaying values along the axis.
Default value is \fV-1\fR which stands for current fontsize
.TP 
format_n=string
: format to use for displaying numbers along the axis
.TP
seg= 1 or 0 
: A flag which controls the display of the base segment of the axis
(default value is 1).
.TP
sub_int=integer
: an integer which gives the number of sub-intervals to draw 
between large tics.
.TP
textcolor=integer
: specify the color to use for displaying values along the axis.
Default value is \fV-1\fR which stands for current color.
.TP
ticscolor=integer
: specify the color to use for tics drawing.
Default value is \fV-1\fR which stands for current color.
.SH DESCRIPTION
\fVdrawaxis\fR is used to draw an axis in vertical or horizontal 
direction. the direction of the axis is given by dir 
\fVdir = 'u'\fR or \fV'd'\fR gives a horizontal axis 
with tics going up (\fV'u'\fR) or down (\fV'd'\fR). 
\fVdir = 'r'\fR or \fV'l'\fR give a vertical axis 
with tics going right (\fV'r'\fR) or left (\fV'l'\fR). 

\fVx\fR and \fVy\fR give the axis tics positions. 
If the axis is horizontal then \fVy\fR 
must be a scalar or can be omitted and \fVx\fR 
is a Scilab vector. The meaning of \fVx\fR 
is controlled by \fVtics\fR. 
.RS
.LP
If \fVtics='v'\fR then \fVx\fR gives the tics positions along the x-axis. 
.LP
If \fVtics='r'\fR then \fVx\fR must be of size 3. \fVx=[xmin,xmax,n]\fR and 
\fVn\fR gives the number of intervals.
.LP
If \fVtics='i'\fR then \fVx\fR must be of size 4, \fVx=[k1,k2,a,n]\fR. 
then \fVxmin=k1*10^a\fR, \fVxmax=k2*10^a\fR and \fVn\fR gives the number of intervals
.RE
If \fVy\fR is omitted then the axis will be positioned at 
the top of the frame if \fVdir='u'\fR or at the bottom if  \fVdir='d'\fR

By default, numbers are drawn along the axis. They are drawn using 
a default format which can be changed with \fVformat_n\fR. 
It is also possible to display given strings and not numbers, 
this is done if \fVval\fR is provided. The size of \fVval\fR must 
match the number of tics. 
.fi		       
.SH EXAMPLE 
.nf 
plot2d(1:10,1:10,1,"020")
// horizontal axis 
drawaxis(x=2:7,y=4,dir='u',tics='v')
// horizontal axis on top of the frame
drawaxis(x=2:7,dir='u',tics='v') 
// horizontal axis at the bottom of the frame
drawaxis(x=2:7,dir='d',tics='v') 

// horizontal axis given by a range 
drawaxis(x=[2,7,3],y=4,dir='d',tics='r') 

// vertical axis 
drawaxis(x=4,y=2:7,dir='r',tics='v')
drawaxis(x=2,y=[2,7,3],dir='l',tics='r')
drawaxis(y=2:7,dir='r',tics='v')
drawaxis(y=2:7,dir='l',tics='v')

// horizontal axis with strings displayed at tics positions
drawaxis(x=2:7,y=8,dir='u',tics='v',val='A'+string(1:6));
// vertical axis with strings displayed at tics positions
drawaxis(x=8,y=2:7,dir='r',tics='v',val='B'+string(1:6));

// horizontal axis given with a 'i' range. 
drawaxis(x=[2,5,0,3],y=9,dir='u',tics='i');
drawaxis(x=9,y=[2,5,0,3],dir='r',tics='i',sub_int=5);

// horizontal axis again 
drawaxis(x=2:7,y=4,dir='u',tics='v',fontsize=10,textcolor=9,ticscolor=7,seg=0,sub_int=20) 
.fi 
.SH AUTHOR
J.Ph.C.
