.TH getf 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
getf - defining a function from a file
.SH CALLING SEQUENCE
.nf
getf(file-name [,opt])
.fi
.SH PARAMETERS
.TP 10
filename
: Scilab string.
.TP
opt
: optional character string 
.RS
.TP
 "c"
: loaded functions are "compiled" to be more efficient (default)
.TP
 "n" 
: loaded functions are not "compiled"
.TP
 "p" 
: loaded functions are  "compiled" and prepared for profiling (see profile)
.RE

.SH DESCRIPTION
loads one or several functions (see \fVfunctions\fR) defined in the file \fV'file-name'\fR.
The string \fVopt='n'\fR means that the functions are not  
compiled (pre-interpreted) when loaded. This can be useful for some 
debugging purpose (see \fVcomp\fR). By default, functions are compiled
when loaded (i.e. \fVopt='c'\fR is used).
.LP
In the  file  a function must begin by a "syntax definition" line as follows:
.nf 
function [y1,...,yn]=foo(x1,...,xm)
.fi
followed by a sequence of scilab instructions.
.LP
The "syntax definition" line gives the "full" calling syntax of this
function. The \fVyi\fR are output variables calculated as functions of
input variables \fVxi\fR and variables existing in Scilab when the
function is executed. Shorter input or output argument list may be
used.
.LP
Many functions may be written in the same file. A function is
terminated by an \fVendfunction\fR keyword. For compatibility with
previous versions a function may also be terminated by  the following
\fVfunction\fR keyword or the \fVEOF\fR mark.
.LP
.SH REMARK
\fVgetf\fR is an old way for loading functions into scilab from
a file, If functions in a file are terminated by an \fVendfunction\fR
keyword, the file maybe loaded using the \fVexec\fR function instead
of \fVgetf\fR. In this case default option \fVopt\fR is used.
.SH EXAMPLE
.nf
getf('SCI/macros/xdess/plot.sci')

getf SCI/macros/xdess/plot.sci
.fi
.SH SEE ALSO
functions, function, genlib, getd, exec, edit, comp



