.TH max G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
max - maximum
.SH CALLING SEQUENCE
.nf
[m [,k]]=max(A)
[m [,k]]=max(A,'c') or [m [,k]]=max(A,'r')
[m [,k]]=max(A1,A2,...,An)
[m [,k]]=max(list(A1,A2,...,An))
.fi
.SH PARAMETERS
.TP 10
A
: real vector or matrix.
.TP 10
A1,...,An
: a set of real vectors or matrices, all of the same size or scalar.
.SH DESCRIPTION
For \fVA\fR, a real  vector or matrix, \fVmax(A)\fR 
is the largest element 
\fVA\fR. \fV[m,k]=max(A)\fR gives in addition the index of the maximum.
A second argument of type string \fV'r'\fR or \fV'c'\fR can be used : \fV'r'\fR
is used to get a row vector \fVm\fR such that \fVm(j)\fR contains the 
maximum of the \fVj\fR th column of A (\fVA(:,j)\fR), \fVk(j)\fR gives the row 
indice which contain the maximum for column \fVj\fR. \fV'c'\fR is used for the dual operation on the rows of \fVA\fR.

\fVm=max(A1,A2,...,An)\fR, where all the \fVAj\fR are matrices of the same 
sizes,returns a vector or a matrix \fVm\fR of size \fVsize(m)=size(A1)\fR
such that \fVm(i)= max( Aj(i)), j=1,...,n\fR. \fV[m,k]=max(A1,A2,...,An)\fR 
gives in addition the vector or matrix \fVk\fR. for a fixed \fVi\fR,
\fVk(i)\fR is the number of the first \fVAj(i)\fR achieving the maximum.

\fV[m,k]=max(list(A1,...,An))\fR is an equivalent syntax of 
\fV[m,k]=max(A1,A2,...,An)\fR
.SH EXAMPLE
.nf
[m,n]=max([1,3,1])
[m,n]=max([3,1,1],[1,3,1],[1,1,3])
[m,n]=max([3,-2,1],1)
[m,n]=max(list([3,1,1],[1,3,1],[1,1,3]))
[m,n]=max(list(1,3,1))
.fi
.SH SEE ALSO
sort, find, mini
