/*
 * RTLinux FPU test example
 *
 * Written by Michael Barabanov, 1998
 *  (C) FSMLabs  1999. baraban@fsmlabs.com
 *  Released under the GNU GENERAL PUBLIC LICENSE Version 2, June 1991
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/cons.h>
#include <asm/io.h>

#include <rtl_sched.h>
#include <math.h>

RT_TASK mytask;
RT_TASK task2;
RT_TASK task3;

void fun (int t)
{
	int i = 0;
	double f = 0;
	while (1) {
/* 		conpr(t == 1 ? "1" : "2"); */
		i++;
		f++;
		if (i != f) {
			conpr("Task "); conprn (t);
			conpr(" FP error: i = "); conprn(i);
			conpr("f = "); conprn(f); conpr("\n");
			i = 0;
			f = 0;
		}
		if (i > 200000) {
			i = 0;
			f = 0;
		}
		rt_task_wait();
	}
/* 	conpr("The RT-task has stopped.\n"); */
}


void ifun (int t)
{
	int i=0;
	while (1) {
		if (i++ % 5000 == 0) {
/* 			conpr("i"); */
		}
		rt_task_wait();
	}
}


int init_module (void)
{
	RTIME now = rt_get_time ();

	rt_task_init (&mytask, fun, 1, 4000, 4);
	rt_task_use_fp (&mytask, 1);
	rt_task_make_periodic (&mytask, now + 1000, 3123);

	rt_task_init (&task2, fun, 2, 4000, 5);
	rt_task_use_fp (&task2, 1);
	rt_task_make_periodic (&task2, now + 1000, 4767);

	rt_task_init (&task3, ifun, 3, 4000, 3);
	rt_task_make_periodic (&task3, now + 1000, 300);

	return 0;
}


void cleanup_module (void)
{
	rt_task_delete (&mytask);
	rt_task_delete (&task2);
	rt_task_delete (&task3);
}

