/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		OSMutex.h

	Contains:	Platform - independent mutex header. The implementation of this object
				is platform - specific. Each platform must define an independent
				OSMutex.h & OSMutex.cpp file.
				
				This file is for Mac OS X Server only

	$Log: OSMutex.h,v $
	Revision 1.2  1999/02/19 23:06:14  ds
	Created
	

*/

#ifndef _OSMUTEX_H_
#define _OSMUTEX_H_

#if !__PTHREADS__
#include "mymutex.h"
#else
#include <pthread.h>
#endif

#include "OSHeaders.h"

class OSCond;

class OSMutex
{
	public:

		//Each mutex is identified by a tag for debugging purposes
		OSMutex(UInt32 tag);
		~OSMutex();

		inline void Lock();
		inline void Unlock();

	private:

#if !__PTHREADS__
		mymutex_t fMutex;
#else
		pthread_mutex_t fMutex;
#endif
		UInt32 fTag;

		friend class OSCond;
};

class	OSMutexLocker
{
	public:

		OSMutexLocker(OSMutex *inMutexP) : fMutex(inMutexP) { fMutex->Lock(); }
		~OSMutexLocker() {	fMutex->Unlock(); }
		
		void Lock() 		{ fMutex->Lock(); }
		void Unlock() 		{ fMutex->Unlock(); }
		
	private:

		OSMutex*	fMutex;
};

void OSMutex::Lock()
{
#if !__PTHREADS__
	mymutex_lock(fMutex);
#else
	pthread_mutex_lock(&fMutex);
#endif
}

void OSMutex::Unlock()
{
#if !__PTHREADS__
	mymutex_unlock(fMutex);
#else
	pthread_mutex_unlock(&fMutex);
#endif	
}

#endif //_OSMUTEX_H_