// File:	ShapeProcess.cxx
// Created:	Mon Aug 21 19:03:02 2000
// Author:	Andrey BETENEV
//		<abv@doomox.nnov.matra-dtv.fr>

#include <ShapeProcess.ixx>

#include <Standard_ErrorHandler.hxx>
#include <Standard_Failure.hxx>
#include <TCollection_AsciiString.hxx>
#include <TColStd_SequenceOfAsciiString.hxx>

#include <Message_Msg.hxx>
#include <Message_Printer.hxx>

#include <ShapeProcess_Operator.hxx>
#include <ShapeProcess_DictionaryOfOperator.hxx>

static Handle(ShapeProcess_DictionaryOfOperator) dic;

//=======================================================================
//function : RegisterOperator
//purpose  : 
//=======================================================================

Standard_Boolean ShapeProcess::RegisterOperator (const Standard_CString name,
                                                 const Handle(ShapeProcess_Operator)& op)
{
  if ( dic.IsNull() ) dic = new ShapeProcess_DictionaryOfOperator;
  if ( dic->HasItem ( name, Standard_True ) ) {
#ifdef DEB
    cout << "Warning: operator with name " << name << " is already registered!" << endl;
#endif
    return Standard_False;
  }
  dic->SetItem ( name, op );
  return Standard_True;
}

//=======================================================================
//function : FindOperator
//purpose  : 
//=======================================================================

Standard_Boolean ShapeProcess::FindOperator (const Standard_CString name,
                                             Handle(ShapeProcess_Operator)& op)
{
  if ( dic.IsNull() ) dic = new ShapeProcess_DictionaryOfOperator;
  if ( ! dic->HasItem ( name, Standard_True ) ) {
#ifdef DEB
    cout << "Error: no operator with name " << name << " registered!" << endl;
#endif
    return Standard_False;
  }
  op = dic->Item ( name );
  return !op.IsNull();
}

//=======================================================================
//function : Perform
//purpose  : 
//=======================================================================

Standard_Boolean ShapeProcess::Perform (const Handle(ShapeProcess_Context)& context,
                                        const Standard_CString seq)
{
  context->SetScope ( seq );
  
  // get description of the sequence
  TCollection_AsciiString sequence;
  if ( ! context->GetString ( "exec.op", sequence ) ) {
#ifdef DEB
    cout << "Error: ShapeProcess_Performer::Perform: sequence not defined for " << seq << endl;
#endif
    context->UnSetScope();
    return Standard_False;
  }
  TColStd_SequenceOfAsciiString sequenceOfOperators;
  TCollection_AsciiString oper;
  Standard_Integer i;
  for ( i=1; ; i++ ) {
    oper = sequence.Token ( " \t,;", i );
    if ( oper.Length() <=0 ) break;
    sequenceOfOperators.Append(oper);
  }
  
  // put a message
  if ( context->Printer()->TraceLevel() >=2 ) {
    Message_Msg SMSG0 ("Sequence.MSG0"); //Sequence of operators: %s
    TCollection_AsciiString Seq;
    for ( Standard_Integer i1=1; i1 <= sequenceOfOperators.Length(); i1++ ) {
      if (i1 > 1) Seq += ",";
      Seq += sequenceOfOperators.Value(i1);
    }
    SMSG0.AddString (Seq.ToCString());
    context->Printer()->Send (SMSG0, 2);
  }

  // iterate on operators in the sequence
  for (i=1; i<=sequenceOfOperators.Length(); i++) {
    oper = sequenceOfOperators.Value(i);
    
    if ( context->Printer()->TraceLevel() >=2 ) {
      Message_Msg SMSG5 ("Sequence.MSG5"); //Operator %d/%d: %s
      SMSG5.AddInteger (i);
      SMSG5.AddInteger (sequenceOfOperators.Length());
      SMSG5.AddString (oper.ToCString());
      context->Printer()->Send (SMSG5, 2);
    }
    
    Handle(ShapeProcess_Operator) op;
    if ( ! ShapeProcess::FindOperator ( oper.ToCString(), op ) ) {
      if (context->TraceLevel()>3) 
        cout<<"Opepator "<<oper<<" not found"<<endl;
#ifdef DEB
      cout << "Error: ShapeProcess_Performer::Perform: operator " << oper.ToCString()
           << " is not defined; skipped" << endl;
#endif
      continue;
    }
    
    context->SetScope ( oper.ToCString() );
    try {
      OCC_CATCH_SIGNALS
      op->Perform ( context );
    }
    catch (Standard_Failure) {
      if (context->TraceLevel()>3)
	cout<<"Opepator "<<oper<<" execution failed"<<endl;
#ifdef DEB 
      cout << "Error: Exception in operator " << oper.ToCString() << ": ";
      Standard_Failure::Caught()->Print(cout); cout << endl;
#endif
    }
    context->UnSetScope();
  }
  
  context->UnSetScope();
  return Standard_True;
}
