// File:	BRepMAT2d_Explorer.cxx
// Created:	Tue Oct  4 09:25:21 1994
// Author:	Yves FRICAUD
//		<dub@fuegox>


#include <BRepMAT2d_Explorer.ixx>
#include <MAT2d_SequenceOfSequenceOfCurve.hxx>
#include <TColGeom2d_SequenceOfCurve.hxx>
#include <TopoDS_Wire.hxx>
#include <BRepTools_WireExplorer.hxx>
#include <TopLoc_Location.hxx>
#include <Geom_Curve.hxx>
#include <Geom_TrimmedCurve.hxx>  
#include <Geom2d_TrimmedCurve.hxx>
#include <GeomAPI.hxx>
#include <BRep_Tool.hxx>
#include <gp.hxx>
#include <gp_Pln.hxx>
#include <TopExp_Explorer.hxx>
#include <TopAbs.hxx>
#include <TopoDS.hxx>

#include <Precision.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Geom2dConvert.hxx>

//=======================================================================
//function : BRepMAT2d_Explorer
//purpose  : 
//=======================================================================

BRepMAT2d_Explorer::BRepMAT2d_Explorer()
{
  Clear();
}

//=======================================================================
//function : BRepMAT2d_Explorer
//purpose  : 
//=======================================================================

BRepMAT2d_Explorer::BRepMAT2d_Explorer(const TopoDS_Face& aFace)
{
  Perform (aFace);
}

//=======================================================================
//function : Perform
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Perform(const TopoDS_Face& aFace)
{
  Clear();
  myShape        = aFace;
  TopoDS_Face  F = TopoDS::Face(aFace);
  F.Orientation(TopAbs_FORWARD);
  TopExp_Explorer Exp (F,TopAbs_WIRE);

  while (Exp.More()) {
    Add (TopoDS::Wire (Exp.Current()),F);
    Exp.Next();
  }

  CheckConnection();
}

//=======================================================================
//function : Add
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Add(const TopoDS_Wire& Spine,
			     const TopoDS_Face& aFace )
{  
  NewContour();
//  Modified by Sergey KHROMOV - Wed Mar  6 16:22:13 2002 Begin
  myIsClosed(currentContour) = (Spine.Closed()) ? Standard_True : Standard_False;
//  Modified by Sergey KHROMOV - Wed Mar  6 16:22:14 2002 End

  BRepTools_WireExplorer      TheExp (Spine);
  Standard_Real               UFirst,ULast;
  Handle(Geom2d_Curve)        C2d;
  Handle(Geom2d_TrimmedCurve) CT2d;

  for (; TheExp.More(); TheExp.Next()) {
    TopoDS_Edge  E = TheExp.Current();
    C2d  = BRep_Tool::CurveOnSurface (TheExp.Current(),aFace,UFirst ,ULast);
    CT2d = new Geom2d_TrimmedCurve(C2d,UFirst,ULast);
    if (TheExp.Current().Orientation() == TopAbs_REVERSED) CT2d->Reverse();

    Add(CT2d);
  }
}

//=======================================================================
//function : CheckConnection
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::CheckConnection()
{
  for (Standard_Integer i = 1; i <= theCurves.Length(); i++)
    for (Standard_Integer j = 2; j <= theCurves(i).Length(); j++)
      {
	gp_Pnt2d P1 = theCurves(i)(j-1)->Value( theCurves(i)(j-1)->LastParameter() );
	gp_Pnt2d P2 = theCurves(i)(j)->Value( theCurves(i)(j)->FirstParameter() );
	if (P1.Distance( P2 ) > Precision::Confusion())
	  {
	    Handle( Geom2d_BSplineCurve ) BCurve;
	    if (theCurves(i)(j)->DynamicType() != STANDARD_TYPE(Geom2d_BSplineCurve))
	      BCurve = Geom2dConvert::CurveToBSplineCurve( theCurves(i)(j) );
	    else
	      BCurve = Handle( Geom2d_BSplineCurve )::DownCast( theCurves(i)(j) );
	    BCurve->SetPole( 1, P1 );
	    theCurves(i)(j) = new Geom2d_TrimmedCurve( BCurve, BCurve->FirstParameter(), BCurve->LastParameter() );
	  }
      }
}

//=======================================================================
//function : Clear
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Clear()
{  
  theCurves.Clear() ;
  currentContour = 0;
//  Modified by Sergey KHROMOV - Wed Mar  6 16:07:55 2002 Begin
  myIsClosed.Clear();
//  Modified by Sergey KHROMOV - Wed Mar  6 16:07:55 2002 End
}


//=======================================================================
//function : NewContour
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::NewContour()
{  
  TColGeom2d_SequenceOfCurve Contour;
  theCurves.Append(Contour);
//  Modified by Sergey KHROMOV - Wed Mar  6 16:12:05 2002 Begin
  myIsClosed.Append(Standard_False);
//  Modified by Sergey KHROMOV - Wed Mar  6 16:12:05 2002 End
  currentContour ++ ;
}


//=======================================================================
//function : Add
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Add(const Handle(Geom2d_Curve)& aCurve)
{  
  theCurves.ChangeValue(currentContour).Append(aCurve);
}

//=======================================================================
//function : NumberOfContours
//purpose  : 
//=======================================================================

Standard_Integer BRepMAT2d_Explorer::NumberOfContours() const 
{  
  return theCurves.Length() ;
}


//=======================================================================
//function : NumberOfCurves
//purpose  : 
//=======================================================================

Standard_Integer BRepMAT2d_Explorer::NumberOfCurves
  (const Standard_Integer IndexContour)
const 
{  
  return theCurves.Value(IndexContour).Length();
}


//=======================================================================
//function : Init
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Init(const Standard_Integer IndexContour)
{  
  currentContour = IndexContour;
  current        = 1;
}


//=======================================================================
//function : More
//purpose  : 
//=======================================================================

Standard_Boolean BRepMAT2d_Explorer::More() const 
{  
  return (current <= NumberOfCurves(currentContour));
}


//=======================================================================
//function : Next
//purpose  : 
//=======================================================================

void BRepMAT2d_Explorer::Next()
{ 
  current++;
}


//=======================================================================
//function : Value
//purpose  : 
//=======================================================================

Handle(Geom2d_Curve) BRepMAT2d_Explorer::Value() const 
{  
  return theCurves.Value(currentContour).Value(current);
}

//=======================================================================
//function : Shape
//purpose  : 
//=======================================================================

TopoDS_Shape BRepMAT2d_Explorer::Shape() const
{
  return myShape;
}


//=======================================================================
//function : Contour
//purpose  : 
//=======================================================================

const TColGeom2d_SequenceOfCurve& BRepMAT2d_Explorer::Contour
  (const Standard_Integer IC)
const
{
  return theCurves.Value(IC);
}


//  Modified by Sergey KHROMOV - Wed Mar  6 17:40:07 2002 Begin
//=======================================================================
//function : GetIsClosed
//purpose  : 
//=======================================================================

const MAT2d_SequenceOfBoolean &BRepMAT2d_Explorer::GetIsClosed() const
{
  return myIsClosed;
}
//  Modified by Sergey KHROMOV - Wed Mar  6 17:40:14 2002 End
