// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKNT_Shell_HeaderFile
#define _WOKNT_Shell_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WOKNT_Shell_HeaderFile
#include <Handle_WOKNT_Shell.hxx>
#endif

#ifndef _WOKNT_OutputMode_HeaderFile
#include <WOKNT_OutputMode.hxx>
#endif
#ifndef _WOKNT_ExecutionMode_HeaderFile
#include <WOKNT_ExecutionMode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_WOKNT_Path_HeaderFile
#include <Handle_WOKNT_Path.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
class TCollection_HAsciiString;
class TColStd_HSequenceOfHAsciiString;
class WOKNT_Path;
class WOKNT_ShellManager;


//! creates and manages processes <br>
class WOKNT_Shell : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! creates a class instance <br>
Standard_EXPORT WOKNT_Shell(const WOKNT_ExecutionMode anExecMode = WOKNT_SynchronousMode,const WOKNT_OutputMode anOutMode = WOKNT_OutErrMixed);

//! destrouys all resources attached to the Shell <br>
Standard_EXPORT   void Destroy() ;
~WOKNT_Shell()
{
  Destroy();
}


//! launches a process <br>
Standard_EXPORT   void Launch() ;
//! checks whether a process launched or not <br>
  Standard_Boolean IsLaunched() const;

//! terminates a process <br>
Standard_EXPORT   void Kill() ;


Standard_EXPORT   void Lock() ;


Standard_EXPORT   void UnLock() ;

  Standard_Boolean IsLocked() const;
//! returns process's exit status <br>
  Standard_Integer Status() const;

//! returns process output <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString Errors() ;

//! clears process's output <br>
Standard_EXPORT   void ClearOutput() ;

//! sends a string to the shell <br>
Standard_EXPORT   void Send(const Handle(TCollection_HAsciiString)& aString) ;

//! executes a shell command <br>
Standard_EXPORT   void Execute(const Handle(TCollection_HAsciiString)& aCmdLine) ;

//! waits for process termination and returns its exit status <br>
Standard_EXPORT   Standard_Integer SyncAndStatus() ;

//! adds environment variable to the shell's environment block <br>
Standard_EXPORT   void AddEnvironmentVariable(const Handle(TCollection_HAsciiString)& aName,const Handle(TCollection_HAsciiString)& aValue) ;

//! removes specified variable from the shell's environment block <br>
Standard_EXPORT   void RemoveEnvironmentVariable(const Handle(TCollection_HAsciiString)& aName) ;

//! returns a value for a given environment variable <br>
//!  Warning: returns a null string if specified variable does not exists <br>
Standard_EXPORT   Handle_TCollection_HAsciiString EnvironmentVariable(const Handle(TCollection_HAsciiString)& aName) const;

//! echoes a string <br>
Standard_EXPORT   void Echo(const Handle(TCollection_HAsciiString)& aStr) const;
//! turns echo on <br>
  void SetEcho() ;
//! turns echo off <br>
  void UnsetEcho() ;

//! logs a string to the file <br>
Standard_EXPORT   void Log(const Handle(TCollection_HAsciiString)& aStr) const;

//! creates log file and turns on logging to the file <br>
Standard_EXPORT   void LogInFile(const Handle(WOKNT_Path)& aPath) ;

//! turns off logging to file <br>
Standard_EXPORT   void NoLog() ;


friend class WOKNT_ShellManager;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! checks whether a specified command built-in or not. <br>
//!          Also provides primary parsing of the commend line <br>
//!          ( extraction of the environment variables ). <br>
Standard_EXPORT   Standard_Boolean BuiltInCommand(Handle(TCollection_HAsciiString)& aCmd,const Standard_Boolean doParse = Standard_True) ;

//! builds environment block for sub-process <br>
Standard_EXPORT   Standard_Address BuildEnvironment(const Standard_Boolean aRebuildFlag = Standard_False) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
WOKNT_OutputMode myOutMode;
WOKNT_ExecutionMode myExecMode;
Standard_Integer myStatus;
Standard_Boolean myLocked;
Standard_Boolean myEcho;
Standard_Boolean myExeFlag;
Standard_Boolean myKillFlag;
Standard_Address myOutput;
Standard_Integer myProcess;
Handle_TCollection_HAsciiString myCmdLine;
Handle_TColStd_HSequenceOfHAsciiString myStdOut;
Handle_TColStd_HSequenceOfHAsciiString myStdErr;
Handle_TColStd_HSequenceOfHAsciiString myEnvironment;
Standard_Integer myChannel;
Handle_TCollection_HAsciiString myDirectory;
Handle_WOKNT_Path myLogFile;


};


#include <WOKNT_Shell.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
