// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntRes2d_Intersection_HeaderFile
#define _IntRes2d_Intersection_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntRes2d_SequenceOfIntersectionPoint_HeaderFile
#include <IntRes2d_SequenceOfIntersectionPoint.hxx>
#endif
#ifndef _IntRes2d_SequenceOfIntersectionSegment_HeaderFile
#include <IntRes2d_SequenceOfIntersectionSegment.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class IntRes2d_IntersectionPoint;
class IntRes2d_IntersectionSegment;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines  the root   class  of  all  the  Intersections <br>
//!          between  two 2D-Curves, and  provides all  the methods <br>
//!          about the results of the Intersections Algorithms. <br>
class IntRes2d_Intersection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! returns TRUE when the computation was successful. <br>
  Standard_Boolean IsDone() const;
//! Returns TRUE if there is no intersection between the <br>
//!          given arguments. <br>
//!          The exception NotDone is raised if IsDone returns FALSE. <br>
  Standard_Boolean IsEmpty() const;
//! This function returns the number of intersection <br>
//!          points between the 2 curves. <br>
//!          The exception NotDone is raised if IsDone returns FALSE. <br>
  Standard_Integer NbPoints() const;
//! This function returns the intersection point <br>
//!          of range N; <br>
//!          The exception NotDone is raised if IsDone returns FALSE. <br>
//!          The exception OutOfRange is raised if (N <= 0) <br>
//!          or (N > NbPoints). <br>
 const IntRes2d_IntersectionPoint& Point(const Standard_Integer N) const;
//! This function returns the number of intersection <br>
//!          segments between the two curves. <br>
//!          The exception NotDone is raised if IsDone returns FALSE. <br>
  Standard_Integer NbSegments() const;
//! This function returns the intersection segment <br>
//!          of range N; <br>
//!          The exception NotDone is raised if IsDone returns FALSE. <br>
//!          The exception OutOfRange is raised if (N <= 0) <br>
//!          or (N > NbPoints). <br>
 const IntRes2d_IntersectionSegment& Segment(const Standard_Integer N) const;

  void SetReversedParameters(const Standard_Boolean Reverseflag) ;





protected:

 // Methods PROTECTED
 // 
//! Empty constructor. <br>
IntRes2d_Intersection();

IntRes2d_Intersection(const IntRes2d_Intersection& Other);


Standard_EXPORT   void SetValues(const IntRes2d_Intersection& Inter) ;


Standard_EXPORT   void Append(const IntRes2d_Intersection& Inter,const Standard_Real FirstParam1,const Standard_Real LastParam1,const Standard_Real FirstParam2,const Standard_Real LastParam2) ;

  void Append(const IntRes2d_IntersectionSegment& Seg) ;

  void Append(const IntRes2d_IntersectionPoint& Pnt) ;


Standard_EXPORT   void Insert(const IntRes2d_IntersectionPoint& Pnt) ;

  void ResetFields() ;

  Standard_Boolean ReversedParameters() const;


 // Fields PROTECTED
 //
Standard_Boolean done;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean reverse;
IntRes2d_SequenceOfIntersectionPoint lpnt;
IntRes2d_SequenceOfIntersectionSegment lseg;


};


#include <IntRes2d_Intersection.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
