// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_Axis2Placement_HeaderFile
#define _Geom_Axis2Placement_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_Axis2Placement_HeaderFile
#include <Handle_Geom_Axis2Placement.hxx>
#endif

#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _Geom_AxisPlacement_HeaderFile
#include <Geom_AxisPlacement.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax2;
class gp_Pnt;
class gp_Dir;
class gp_Trsf;
class Geom_Geometry;


//!  Describes a right-handed coordinate system in 3D space. <br>
//! A coordinate system is defined by: <br>
//! - its origin, also termed the "Location point" of the coordinate system, <br>
//! - three orthogonal unit vectors, termed respectively <br>
//!   the "X Direction", "Y Direction" and "Direction" (or <br>
//!   "main Direction") of the coordinate system. <br>
//! As a Geom_Axis2Placement coordinate system is <br>
//! right-handed, its "Direction" is always equal to the <br>
//! cross product of its "X Direction" and "Y Direction". <br>
//! The "Direction" of a coordinate system is called the <br>
//! "main Direction" because when this unit vector is <br>
//! modified, the "X Direction" and "Y Direction" are <br>
//! recomputed, whereas when the "X Direction" or "Y <br>
//! Direction" is changed, the "main Direction" is <br>
//! retained. The "main Direction" is also the "Z Direction". <br>
//! Note: Geom_Axis2Placement coordinate systems <br>
//! provide the same kind of "geometric" services as <br>
//! gp_Ax2 coordinate systems but have more complex <br>
//! data structures. The geometric objects provided by <br>
//! the Geom package use gp_Ax2 objects to include <br>
//! coordinate systems in their data structures, or to <br>
//! define the geometric transformations, which are applied to them. <br>
//! Geom_Axis2Placement coordinate systems are <br>
//! used in a context where they can be shared by <br>
//! several objects contained inside a common data structure. <br>
class Geom_Axis2Placement : public Geom_AxisPlacement {

public:
 // Methods PUBLIC
 // 

//! Returns a transient copy of A2. <br>
Standard_EXPORT Geom_Axis2Placement(const gp_Ax2& A2);


//!  P is the origin of the axis placement, N is the main <br>
//!  direction of the axis placement and Vx is the "XDirection". <br>
//!  If the two directions N and Vx are not orthogonal the <br>
//!  "XDirection" is computed as follow : <br>
//!  XDirection = N ^ (Vx ^ N). <br>//! Raised if N and Vx are parallel. <br>
Standard_EXPORT Geom_Axis2Placement(const gp_Pnt& P,const gp_Dir& N,const gp_Dir& Vx);

//! Assigns the origin and the three unit vectors of A2 to <br>
//! this coordinate system. <br>
Standard_EXPORT   void SetAx2(const gp_Ax2& A2) ;


//!  Changes the main direction of the axis placement. <br>
//!  The "Xdirection" is modified : <br>
//!  New XDirection = V ^ (Previous_Xdirection ^ V). <br>
//!  Raised if V and the previous "XDirection" are parallel <br>
//!  because it is impossible to calculate the new "XDirection" <br>
//!  and the new "YDirection". <br>
Standard_EXPORT   void SetDirection(const gp_Dir& V) ;


//!  Changes the "XDirection" of the axis placement, Vx is the <br>
//!  new "XDirection". If Vx is not normal to the main direction <br>
//!  then "XDirection" is computed as follow : <br>
//!  XDirection = Direction ^ ( Vx ^ Direction). <br>
//!  The main direction is not modified. <br>//!  Raised if Vx and "Direction"  are parallel. <br>
Standard_EXPORT   void SetXDirection(const gp_Dir& Vx) ;


//!  Changes the "YDirection" of the axis placement, Vy is the <br>
//!  new "YDirection". If Vy is not normal to the main direction <br>
//!  then "YDirection" is computed as follow : <br>
//!  YDirection = Direction ^ ( Vy ^ Direction). <br>
//!  The main direction is not modified. The "XDirection" is <br>
//!  modified. <br>//! Raised if Vy and the main direction are parallel. <br>
Standard_EXPORT   void SetYDirection(const gp_Dir& Vy) ;

//! Returns a non transient copy of <me>. <br>
Standard_EXPORT   gp_Ax2 Ax2() const;

//! Returns the "XDirection". This is a unit vector. <br>
Standard_EXPORT  const gp_Dir& XDirection() const;

//! Returns the "YDirection". This is a unit vector. <br>
Standard_EXPORT  const gp_Dir& YDirection() const;


//!  Transforms an axis placement with a Trsf. <br>
//!  The "Location" point, the "XDirection" and the <br>
//!  "YDirection" are transformed with T.  The resulting <br>
//!  main "Direction" of <me> is the cross product between <br>
//!  the "XDirection" and the "YDirection" after transformation. <br>
Standard_EXPORT   void Transform(const gp_Trsf& T) ;

//! Creates a new object which is a copy of this coordinate system. <br>
Standard_EXPORT   Handle_Geom_Geometry Copy() const;
//Standard_EXPORT ~Geom_Axis2Placement();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT Geom_Axis2Placement(const gp_Pnt& P,const gp_Dir& Vz,const gp_Dir& Vx,const gp_Dir& Vy);


 // Fields PRIVATE
 //
gp_Dir vxdir;
gp_Dir vydir;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
