// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _EDL_Interpretor_HeaderFile
#define _EDL_Interpretor_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_EDL_Interpretor_HeaderFile
#include <Handle_EDL_Interpretor.hxx>
#endif

#ifndef _EDL_MapOfVariable_HeaderFile
#include <EDL_MapOfVariable.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfAsciiString.hxx>
#endif
#ifndef _EDL_MapOfTemplate_HeaderFile
#include <EDL_MapOfTemplate.hxx>
#endif
#ifndef _EDL_MapOfFile_HeaderFile
#include <EDL_MapOfFile.hxx>
#endif
#ifndef _EDL_MapOfLibrary_HeaderFile
#include <EDL_MapOfLibrary.hxx>
#endif
#ifndef _EDL_StackOfBoolean_HeaderFile
#include <EDL_StackOfBoolean.hxx>
#endif
#ifndef _EDL_ParameterMode_HeaderFile
#include <EDL_ParameterMode.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_EDL_HSequenceOfVariable_HeaderFile
#include <Handle_EDL_HSequenceOfVariable.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _EDL_Error_HeaderFile
#include <EDL_Error.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HSequenceOfAsciiString;
class EDL_HSequenceOfVariable;
class EDL_File;
class EDL_Variable;
class EDL_Template;
class EDL_Library;
class TCollection_AsciiString;
class EDL_DataMapIteratorOfMapOfTemplate;
class EDL_DataMapIteratorOfMapOfVariable;



class EDL_Interpretor : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT EDL_Interpretor();


Standard_EXPORT   void ClearAll() ;
~EDL_Interpretor()
{
  ClearAll();
}



Standard_EXPORT   void ClearSymbolTable() ;


Standard_EXPORT   void ClearTemplateTable() ;


Standard_EXPORT   void ClearVariableList() ;


Standard_EXPORT   void ClearArgList() ;


Standard_EXPORT   void ClearRetList() ;


Standard_EXPORT   EDL_Error Parse(const Standard_CString aFile) ;


Standard_EXPORT   EDL_Error AddIncludeDirectory(const Standard_CString aDirectory) ;


Standard_EXPORT   Handle_TColStd_HSequenceOfAsciiString GetIncludeDirectory() const;


Standard_EXPORT   EDL_Error AddFile(const Standard_CString aVariable,const Standard_CString aFilename) ;


Standard_EXPORT   EDL_File& GetFile(const Standard_CString aVariable) ;


Standard_EXPORT   void RemoveFile(const Standard_CString aVariable) ;


Standard_EXPORT   EDL_Error AddVariable(const Standard_CString aVariable,const Standard_CString aValue) ;


Standard_EXPORT   EDL_Variable& GetVariable(const Standard_CString aVariable) ;


Standard_EXPORT   Standard_Boolean IsDefined(const Standard_CString aVariable) const;


Standard_EXPORT   Standard_Boolean IsFile(const Standard_CString aVariable) const;


Standard_EXPORT   void RemoveVariable(const Standard_CString aVariable) ;


Standard_EXPORT   EDL_Error AddTemplate(const Standard_CString aTemplate) ;


Standard_EXPORT   EDL_Error AddToTemplate(const Standard_CString aTemplate) ;


Standard_EXPORT   EDL_Error ClearTemplate(const Standard_CString aTemplate) ;


Standard_EXPORT   EDL_Template& GetTemplate(const Standard_CString aTemplate) ;


Standard_EXPORT   void EvalTemplate(const Standard_CString aTemplate,const Standard_CString aResult) ;


Standard_EXPORT   void RemoveTemplate(const Standard_CString aTemplate) ;


Standard_EXPORT   EDL_Error AddLibrary(const Standard_CString aLibrary) ;


Standard_EXPORT   EDL_Library& GetLibrary(const Standard_CString aLibrary) ;


Standard_EXPORT   EDL_Error CallFunction(const Standard_CString aLibname,const Standard_CString aFunction,const Standard_CString aRetuenName) ;


Standard_EXPORT   void RemoveLibrary(const Standard_CString aLibrary) ;


Standard_EXPORT   void AddExecutionStatus(const Standard_Boolean aValue) ;


Standard_EXPORT   Standard_Boolean GetExecutionStatus() ;


Standard_EXPORT   Standard_Boolean RemoveExecutionStatus() ;


Standard_EXPORT   void SetParameterType(const EDL_ParameterMode aMode) ;


Standard_EXPORT   EDL_ParameterMode GetParameterType() const;


Standard_EXPORT   void AddExpressionMember(const Standard_Boolean aValue) ;


Standard_EXPORT   Standard_Boolean GetExpressionMember() ;


Standard_EXPORT   void SetPrintList(const Standard_CString aValue) ;


Standard_EXPORT   TCollection_AsciiString& GetPrintList() ;


Standard_EXPORT   void SetCurrentTemplate(const Standard_CString aValue) ;


Standard_EXPORT   TCollection_AsciiString& GetCurrentTemplate() ;


Standard_EXPORT   void AddToVariableList(const Standard_CString aVariable) ;


Standard_EXPORT   Handle_EDL_HSequenceOfVariable GetVariableList() const;


Standard_EXPORT   void AddToArgList(const Standard_CString aVariable) ;


Standard_EXPORT   void AddToArgList(const Standard_CString aVariable,const Standard_CString aValue) ;


Standard_EXPORT   EDL_DataMapIteratorOfMapOfTemplate GetTemplateIterator() const;


Standard_EXPORT   EDL_DataMapIteratorOfMapOfVariable GetVariableIterator() const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
EDL_MapOfVariable mySymbolTable;
Handle_TColStd_HSequenceOfAsciiString myIncludeTable;
EDL_MapOfTemplate myTemplateTable;
EDL_MapOfFile myFileTable;
EDL_MapOfLibrary myLibraryTable;
EDL_StackOfBoolean myExecutionStatus;
EDL_ParameterMode myParameterType;
EDL_StackOfBoolean myExpressionMember;
TCollection_AsciiString myPrintList;
TCollection_AsciiString myCurrentTemplate;
Handle_EDL_HSequenceOfVariable myVariableList;
Handle_EDL_HSequenceOfVariable myArgList;
Handle_EDL_HSequenceOfVariable myRetList;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
