// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ChFi3d_FilBuilder_HeaderFile
#define _ChFi3d_FilBuilder_HeaderFile

#ifndef _BlendFunc_SectionShape_HeaderFile
#include <BlendFunc_SectionShape.hxx>
#endif
#ifndef _ChFi3d_Builder_HeaderFile
#include <ChFi3d_Builder.hxx>
#endif
#ifndef _ChFi3d_FilletShape_HeaderFile
#include <ChFi3d_FilletShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Law_Function_HeaderFile
#include <Handle_Law_Function.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_ChFiDS_SecHArray1_HeaderFile
#include <Handle_ChFiDS_SecHArray1.hxx>
#endif
#ifndef _Handle_ChFiDS_SurfData_HeaderFile
#include <Handle_ChFiDS_SurfData.hxx>
#endif
#ifndef _Handle_ChFiDS_HElSpine_HeaderFile
#include <Handle_ChFiDS_HElSpine.hxx>
#endif
#ifndef _Handle_ChFiDS_Spine_HeaderFile
#include <Handle_ChFiDS_Spine.hxx>
#endif
#ifndef _Handle_BRepAdaptor_HSurface_HeaderFile
#include <Handle_BRepAdaptor_HSurface.hxx>
#endif
#ifndef _Handle_Adaptor3d_TopolTool_HeaderFile
#include <Handle_Adaptor3d_TopolTool.hxx>
#endif
#ifndef _Handle_BRepAdaptor_HCurve2d_HeaderFile
#include <Handle_BRepAdaptor_HCurve2d.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Handle_BRepBlend_Line_HeaderFile
#include <Handle_BRepBlend_Line.hxx>
#endif
#ifndef _Handle_ChFiDS_Stripe_HeaderFile
#include <Handle_ChFiDS_Stripe.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Edge;
class Law_Function;
class TopoDS_Vertex;
class gp_XY;
class ChFiDS_SecHArray1;
class ChFiDS_SurfData;
class ChFiDS_HElSpine;
class ChFiDS_Spine;
class BRepAdaptor_HSurface;
class Adaptor3d_TopolTool;
class math_Vector;
class BRepAdaptor_HCurve2d;
class ChFiDS_SequenceOfSurfData;
class BRepBlend_Line;
class ChFiDS_Stripe;
class ChFiDS_ListOfStripe;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Tool  of  construction of  fillets 3d on  edges. <br>
class ChFi3d_FilBuilder  : public ChFi3d_Builder {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ChFi3d_FilBuilder(const TopoDS_Shape& S,const ChFi3d_FilletShape FShape = ChFi3d_Rational,const Standard_Real Ta = 1.0e-2);

//! Sets the type of fillet surface. <br>
Standard_EXPORT   void SetFilletShape(const ChFi3d_FilletShape FShape) ;

//! Returns the type of fillet surface. <br>
Standard_EXPORT   ChFi3d_FilletShape GetFilletShape() const;

//! initialisation of  a contour with the first edge <br>
//!          (the following are found  by propagation). <br>
//!          Attention, you  need  to start  with  SetRadius. <br>
//! <br>
Standard_EXPORT   void Add(const TopoDS_Edge& E) ;

//! initialisation of the constant vector the corresponding  1st  edge. <br>
//! <br>
Standard_EXPORT   void Add(const Standard_Real Radius,const TopoDS_Edge& E) ;

//! Set the radius of the contour of index IC. <br>
Standard_EXPORT   void SetRadius(const Handle(Law_Function)& C,const Standard_Integer IC,const Standard_Integer IinC) ;

//! Returns true the contour is flaged as edge constant. <br>
Standard_EXPORT   Standard_Boolean IsConstant(const Standard_Integer IC) ;

//! Returns the vector if the contour is flagged as edge <br>
//!          constant. <br>
Standard_EXPORT   Standard_Real Radius(const Standard_Integer IC) ;

//! Reset all vectors of contour IC. <br>
Standard_EXPORT   void ResetContour(const Standard_Integer IC) ;

//! Set a constant on edge E of  the contour of <br>
//!          index IC. Since  then  E is flagged as constant. <br>
Standard_EXPORT   void SetRadius(const Standard_Real Radius,const Standard_Integer IC,const TopoDS_Edge& E) ;

//! Extracts the flag constant and the vector of edge E. <br>
Standard_EXPORT   void UnSet(const Standard_Integer IC,const TopoDS_Edge& E) ;

//! Set a vector on vertex  V of  the contour of index IC. <br>
Standard_EXPORT   void SetRadius(const Standard_Real Radius,const Standard_Integer IC,const TopoDS_Vertex& V) ;

//! Extracts the vector of  the vertex V. <br>
Standard_EXPORT   void UnSet(const Standard_Integer IC,const TopoDS_Vertex& V) ;

//! Set  a vertex on the point of parametre U in the edge IinC <br>
//!          of  the contour of index IC <br>
Standard_EXPORT   void SetRadius(const gp_XY& UandR,const Standard_Integer IC,const Standard_Integer IinC) ;

//! Returns true E is flagged as edge constant. <br>
Standard_EXPORT   Standard_Boolean IsConstant(const Standard_Integer IC,const TopoDS_Edge& E) ;

//! Returns the vector if E is flagged as edge constant. <br>
Standard_EXPORT   Standard_Real Radius(const Standard_Integer IC,const TopoDS_Edge& E) ;

//! Returns in First and Last  les extremities of  the <br>
//!          part of variable  vector framing E, returns <br>
//!          False  if  E is flagged as edge constant. <br>
Standard_EXPORT   Standard_Boolean GetBounds(const Standard_Integer IC,const TopoDS_Edge& E,Standard_Real& First,Standard_Real& Last) ;

//! Returns the rule of  elementary  evolution of  the <br>
//!          part to  variable vector framing E, returns a <br>
//!          rule zero if E is flagged as edge constant. <br>
Standard_EXPORT   Handle_Law_Function GetLaw(const Standard_Integer IC,const TopoDS_Edge& E) ;

//! Sets the rule of elementary evolution of  the <br>
//!          part to variable  vector framing E. <br>
Standard_EXPORT   void SetLaw(const Standard_Integer IC,const TopoDS_Edge& E,const Handle(Law_Function)& L) ;


Standard_EXPORT   void Simulate(const Standard_Integer IC) ;


Standard_EXPORT   Standard_Integer NbSurf(const Standard_Integer IC) const;


Standard_EXPORT   Handle_ChFiDS_SecHArray1 Sect(const Standard_Integer IC,const Standard_Integer IS) const;





protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void SimulKPart(const Handle(ChFiDS_SurfData)& SD) const;


Standard_EXPORT   Standard_Boolean SimulSurf(Handle(ChFiDS_SurfData)& Data,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecOnS1,const Standard_Boolean RecOnS2,const math_Vector& Soldep,Standard_Boolean& Intf,Standard_Boolean& Intl) ;


Standard_EXPORT virtual  void SimulSurf(Handle(ChFiDS_SurfData)& Data,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HCurve2d)& PC1,const Handle(BRepAdaptor_HSurface)& Sref1,const Handle(BRepAdaptor_HCurve2d)& PCref1,Standard_Boolean& Decroch1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const TopAbs_Orientation Or2,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP,const Standard_Boolean RecS,const Standard_Boolean RecRst,const math_Vector& Soldep) ;


Standard_EXPORT virtual  void SimulSurf(Handle(ChFiDS_SurfData)& Data,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const TopAbs_Orientation Or1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Handle(BRepAdaptor_HCurve2d)& PC2,const Handle(BRepAdaptor_HSurface)& Sref2,const Handle(BRepAdaptor_HCurve2d)& PCref2,Standard_Boolean& Decroch2,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP,const Standard_Boolean RecS,const Standard_Boolean RecRst,const math_Vector& Soldep) ;


Standard_EXPORT virtual  void SimulSurf(Handle(ChFiDS_SurfData)& Data,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HCurve2d)& PC1,const Handle(BRepAdaptor_HSurface)& Sref1,const Handle(BRepAdaptor_HCurve2d)& PCref1,Standard_Boolean& Decroch1,const TopAbs_Orientation Or1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Handle(BRepAdaptor_HCurve2d)& PC2,const Handle(BRepAdaptor_HSurface)& Sref2,const Handle(BRepAdaptor_HCurve2d)& PCref2,Standard_Boolean& Decroch2,const TopAbs_Orientation Or2,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP1,const Standard_Boolean RecRst1,const Standard_Boolean RecP2,const Standard_Boolean RecRst2,const math_Vector& Soldep) ;


Standard_EXPORT   Standard_Boolean PerformFirstSection(const Handle(ChFiDS_Spine)& S,const Handle(ChFiDS_HElSpine)& HGuide,const Standard_Integer Choix,Handle(BRepAdaptor_HSurface)& S1,Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I1,const Handle(Adaptor3d_TopolTool)& I2,const Standard_Real Par,math_Vector& SolDep,TopAbs_State& Pos1,TopAbs_State& Pos2) const;

//! Method calculates the elements of construction of  the <br>
//!          fillet (constant or evolutive). <br>
Standard_EXPORT   Standard_Boolean PerformSurf(ChFiDS_SequenceOfSurfData& SeqData,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Standard_Real MaxStep,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecOnS1,const Standard_Boolean RecOnS2,const math_Vector& Soldep,Standard_Boolean& Intf,Standard_Boolean& Intl) ;


Standard_EXPORT virtual  void PerformSurf(ChFiDS_SequenceOfSurfData& SeqData,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HCurve2d)& PC1,const Handle(BRepAdaptor_HSurface)& Sref1,const Handle(BRepAdaptor_HCurve2d)& PCref1,Standard_Boolean& Decroch1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const TopAbs_Orientation Or2,const Standard_Real MaxStep,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP,const Standard_Boolean RecS,const Standard_Boolean RecRst,const math_Vector& Soldep) ;


Standard_EXPORT virtual  void PerformSurf(ChFiDS_SequenceOfSurfData& SeqData,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const TopAbs_Orientation Or1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Handle(BRepAdaptor_HCurve2d)& PC2,const Handle(BRepAdaptor_HSurface)& Sref2,const Handle(BRepAdaptor_HCurve2d)& PCref2,Standard_Boolean& Decroch2,const Standard_Real MaxStep,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP,const Standard_Boolean RecS,const Standard_Boolean RecRst,const math_Vector& Soldep) ;


Standard_EXPORT virtual  void PerformSurf(ChFiDS_SequenceOfSurfData& Data,const Handle(ChFiDS_HElSpine)& Guide,const Handle(ChFiDS_Spine)& Spine,const Standard_Integer Choix,const Handle(BRepAdaptor_HSurface)& S1,const Handle(Adaptor3d_TopolTool)& I1,const Handle(BRepAdaptor_HCurve2d)& PC1,const Handle(BRepAdaptor_HSurface)& Sref1,const Handle(BRepAdaptor_HCurve2d)& PCref1,Standard_Boolean& Decroch1,const TopAbs_Orientation Or1,const Handle(BRepAdaptor_HSurface)& S2,const Handle(Adaptor3d_TopolTool)& I2,const Handle(BRepAdaptor_HCurve2d)& PC2,const Handle(BRepAdaptor_HSurface)& Sref2,const Handle(BRepAdaptor_HCurve2d)& PCref2,Standard_Boolean& Decroch2,const TopAbs_Orientation Or2,const Standard_Real MaxStep,const Standard_Real Fleche,const Standard_Real TolGuide,Standard_Real& First,Standard_Real& Last,const Standard_Boolean Inside,const Standard_Boolean Appro,const Standard_Boolean Forward,const Standard_Boolean RecP1,const Standard_Boolean RecRst1,const Standard_Boolean RecP2,const Standard_Boolean RecRst2,const math_Vector& Soldep) ;

//! Method to split an singular SurfData  in  several  non <br>
//!          singular  SurfData.. <br>
Standard_EXPORT   void SplitSurf(ChFiDS_SequenceOfSurfData& SeqData,const Handle(BRepBlend_Line)& line) ;


Standard_EXPORT   void PerformTwoCorner(const Standard_Integer Index) ;


Standard_EXPORT   void PerformThreeCorner(const Standard_Integer Index) ;


Standard_EXPORT   void ExtentOneCorner(const TopoDS_Vertex& V,const Handle(ChFiDS_Stripe)& S) ;


Standard_EXPORT   void ExtentTwoCorner(const TopoDS_Vertex& V,const ChFiDS_ListOfStripe& LS) ;


Standard_EXPORT   void ExtentThreeCorner(const TopoDS_Vertex& V,const ChFiDS_ListOfStripe& LS) ;


Standard_EXPORT   void SetRegul() ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BlendFunc_SectionShape myShape;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
