// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_CommonBlockAPI_HeaderFile
#define _BOPTools_CommonBlockAPI_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _BOPTools_ListOfPaveBlock_HeaderFile
#include <BOPTools_ListOfPaveBlock.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOPTools_ListOfCommonBlock;
class BOPTools_ListOfPaveBlock;
class BOPTools_PaveBlock;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! class that provide some  useful tools <br>
//! to manage with a List Of Common Block-s <br>
class BOPTools_CommonBlockAPI  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Constructor <br>
Standard_EXPORT BOPTools_CommonBlockAPI(const BOPTools_ListOfCommonBlock& aList);


//! Selector <br>
Standard_EXPORT  const BOPTools_ListOfCommonBlock& List() const;


//! Returns all PaveBlock-s (from the list) that are <br>
//! common for the given edge with  DS-index <anE> <br>
Standard_EXPORT  const BOPTools_ListOfPaveBlock& CommonPaveBlocks(const Standard_Integer anE) const;


//! Returns TRUE if given PaveBlock <aPB> is <br>
//! common for the Blocks from the list <br>
Standard_EXPORT   Standard_Boolean IsCommonBlock(const BOPTools_PaveBlock& aPB) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Address myListOfCommonBlock;
BOPTools_ListOfPaveBlock myListOfPaveBlock;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
