open Graphics;;

open_graph "";;

let round x =
  if x >= 0.0
  then int_of_float (x +. 0.5)
  else - (int_of_float (-. x +. 0.5));;

type tat =
   { mutable x : float; mutable y : float;
     mutable vise : float; mutable lev : bool };;

let crayon = { x = 0.0; y = 0.0; vise = 0.0; lev = false };;

let fixe_crayon b = crayon.lev <- b;;

let pi_sur_180 =
    let pi = 4.0 *. (atan 1.0) in pi /. 180.0;;

let tourne angle =
    crayon.vise <- (crayon.vise +. angle *. pi_sur_180);;

let avance d =
    let dx = d *. cos (crayon.vise)
    and dy = d *. sin (crayon.vise) in
    crayon.x <- crayon.x +. dx;
    crayon.y <- crayon.y +. dy;
    if crayon.lev
    then moveto (round crayon.x) (round crayon.y)
    else lineto (round crayon.x) (round crayon.y);;

let couleur_du_trac = foreground;;
let couleur_du_fond = background;;

let zro_x = float_of_int ((size_x ()) / 2);;
let zro_y = float_of_int ((size_y ()) / 2);;

let vide_cran () =
    clear_graph ();
    set_color couleur_du_trac;
    crayon.x <- zro_x;
    crayon.y <- zro_y;
    crayon.vise <- 0.0;
    crayon.lev <- false;
    moveto (round crayon.x) (round crayon.y);;
