/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemBaseAction
extends Action
implements ISystemAction {
    protected Shell shell;
    protected boolean allowOnMultipleSelection = false;
    protected IStructuredSelection sSelection = null;
    private Iterator selectionIterator = null;
    private String contextMenuGroup = null;
    protected boolean selectionSensitive = true;
    protected boolean traceSelections = false;
    protected String traceTarget;
    protected Viewer viewer = null;
    protected String helpId;
    protected Cursor waitCursor;
    protected Cursor arrowCursor;
    private ISelectionProvider fSelectionProvider;
    private Vector previousShells = new Vector();
    private Vector previousViewers = new Vector();
    private boolean isAvailableOffline;
    private IHost conn;

    public SystemBaseAction(String text, ImageDescriptor image, Shell shell) {
        this(text, null, null, image, shell);
    }

    public SystemBaseAction(String text, String tooltip, ImageDescriptor image, Shell parent) {
        this(text, tooltip, null, image, parent);
    }

    public SystemBaseAction(String text, String tooltip, String description, ImageDescriptor image, Shell shell) {
        super(text, image);
        this.shell = shell;
        if (tooltip != null) {
            this.setToolTipText(tooltip);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public SystemBaseAction(String text, String tooltip, String description, ImageDescriptor image, int style, Shell shell) {
        super(text, style);
        this.shell = shell;
        if (image != null) {
            this.setImageDescriptor(image);
        }
        if (tooltip != null) {
            this.setToolTipText(tooltip);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public SystemBaseAction(String text, Shell shell) {
        this(text, null, null, null, shell);
    }

    public SystemBaseAction(String text, String tooltip, Shell shell) {
        this(text, tooltip, null, null, shell);
    }

    public SystemBaseAction(String text, String tooltip, String description, Shell shell) {
        this(text, tooltip, description, null, shell);
    }

    public void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
        } else {
            this.setDisplayCursor(null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }

    protected void setDisplayCursor(Cursor c) {
        SystemBaseAction.setDisplayCursor(this.getShell(), c);
    }

    public static void setDisplayCursor(Shell shell, Cursor c) {
        if (c == null) {
            shell.forceActive();
            shell.forceFocus();
        }
        Shell[] shells = shell.getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    protected void setTracing(boolean tracing) {
        this.traceSelections = tracing;
    }

    protected void setTracing(String tracingClassTarget) {
        this.traceSelections = true;
        this.traceTarget = tracingClassTarget;
    }

    protected void issueTraceMessage(String msg) {
        if (this.traceSelections) {
            String className = this.getClass().getName();
            if (this.traceTarget == null || className.indexOf(this.traceTarget) >= 0) {
                SystemBasePlugin.logInfo(String.valueOf(this.getClass().getName()) + ": " + this.getText() + ": " + msg);
            }
        }
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter(o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public void setInputs(Shell shell, Viewer v, ISelection selection) {
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETINPUTS IN BASE ACTION CLASS");
        }
        this.setShell(shell);
        this.setViewer(v);
        this.setSelection(selection);
    }

    public void setShell(Shell shell) {
        this.previousShells.add(this.shell);
        this.shell = shell;
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETSHELL. shell = " + shell);
        }
    }

    public void setViewer(Viewer v) {
        this.previousViewers.add(this.viewer);
        this.viewer = v;
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETVIEWER. viewer = " + this.viewer);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.traceSelections) {
            this.issueTraceMessage("INSIDE SELECTIONCHANGED. Selection null? " + (selection == null));
        }
        this.setSelection(selection);
    }

    public void setSelection(ISelection selection) {
        boolean multiSelect;
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETSELECTION. Selection null? " + (selection == null));
        }
        if (!(selection instanceof IStructuredSelection)) {
            if (this.selectionSensitive) {
                this.setEnabled(false);
            }
            if (this.traceSelections) {
                System.out.println(String.valueOf(this.getClass().getName()) + ". Returning false in setSelection. selection= " + selection);
            }
            return;
        }
        this.sSelection = (IStructuredSelection)selection;
        if (!this.selectionSensitive) {
            if (this.traceSelections) {
                System.out.println(String.valueOf(this.getClass().getName()) + ". Returning. selectionSensitive = " + this.selectionSensitive);
            }
            return;
        }
        boolean bl = multiSelect = this.sSelection.size() > 1;
        if (!this.allowOnMultipleSelection && multiSelect) {
            this.setEnabled(false);
            if (this.traceSelections) {
                System.out.println(String.valueOf(this.getClass().getName()) + ". Returning false in setSelection. #selected = " + this.sSelection.size());
            }
        } else {
            boolean enable = false;
            enable = this.updateSelection(this.sSelection);
            this.setEnabled(enable);
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fSelectionProvider = provider;
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETSELECTIONPROVIDER. fSelectionProvider = " + this.fSelectionProvider);
        }
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setHelp(String id) {
        SystemWidgetHelpers.setHelp(this, id);
        this.helpId = id;
    }

    public void setContextMenuGroup(String group) {
        this.contextMenuGroup = group;
    }

    public void allowOnMultipleSelection(boolean allow) {
        this.allowOnMultipleSelection = allow;
    }

    public void setSelectionSensitive(boolean sensitive) {
        this.selectionSensitive = sensitive;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            enable = this.checkObjectType(e.next());
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        return true;
    }

    public void run() {
    }

    public boolean isDummy() {
        String label = this.getText();
        if (label == null) {
            return false;
        }
        return label.equals("dummy");
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public Shell getShell() {
        return this.internalGetShell(true);
    }

    protected Shell getShell(boolean doTest) {
        return this.internalGetShell(doTest);
    }

    private Shell internalGetShell(boolean doTest) {
        if (this.shell != null && this.shell.isDisposed()) {
            boolean found = false;
            Vector<Shell> disposedShells = new Vector<Shell>();
            int idx = this.previousShells.size() - 1;
            while (!found && idx >= 0) {
                this.shell = (Shell)this.previousShells.elementAt(idx);
                if (this.shell.isDisposed()) {
                    disposedShells.add(this.shell);
                } else {
                    found = true;
                }
                --idx;
            }
            if (!found) {
                this.shell = null;
            }
            idx = 0;
            while (idx < disposedShells.size()) {
                this.previousShells.remove(disposedShells.elementAt(idx));
                ++idx;
            }
        }
        if (doTest && this.shell == null) {
            System.out.println("Inside getShell for " + this.getClass().getName() + " and the shell is null! This needs to be investigated");
            SystemBasePlugin.logDebugMessage("SystemBaseAction", "Inside getShell for " + this.getClass().getName() + " and the shell is null! This needs to be investigated");
        }
        return this.shell;
    }

    public Viewer getViewer() {
        if (this.viewer != null && this.viewer.getControl().isDisposed()) {
            boolean found = false;
            Vector<Viewer> disposedViewers = new Vector<Viewer>();
            int idx = disposedViewers.size() - 1;
            while (!found && idx >= 0) {
                this.viewer = (Viewer)this.previousViewers.elementAt(idx);
                if (this.viewer.getControl().isDisposed()) {
                    disposedViewers.add(this.viewer);
                } else {
                    found = true;
                }
                --idx;
            }
            if (!found) {
                this.viewer = null;
            }
            idx = 0;
            while (idx < disposedViewers.size()) {
                this.previousViewers.remove(disposedViewers.elementAt(idx));
                ++idx;
            }
        }
        return this.viewer;
    }

    protected ISystemTree getCurrentTreeView() {
        Viewer v = this.getViewer();
        if (v instanceof ISystemTree) {
            return (ISystemTree)v;
        }
        return null;
    }

    public String getContextMenuGroup() {
        return this.contextMenuGroup;
    }

    public boolean isSelectionSensitive() {
        return this.selectionSensitive;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public IStructuredSelection getSelection() {
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE GETSELECTION. sSelection null? " + (this.sSelection == null));
        }
        return this.sSelection;
    }

    protected Object getFirstSelection() {
        if (this.sSelection != null) {
            this.selectionIterator = this.sSelection.iterator();
            if (this.selectionIterator.hasNext()) {
                return this.selectionIterator.next();
            }
            return null;
        }
        this.selectionIterator = null;
        return null;
    }

    protected Object getNextSelection() {
        if (this.sSelection != null && this.selectionIterator != null) {
            if (this.selectionIterator.hasNext()) {
                return this.selectionIterator.next();
            }
            return null;
        }
        this.selectionIterator = null;
        return null;
    }

    public boolean isEnabled() {
        if (!this.isAvailableOffline) {
            if (this.conn != null && this.conn.isOffline()) {
                return false;
            }
            Object selection = this.getFirstSelection();
            while (selection != null) {
                if (selection instanceof ISubSystem && ((ISubSystem)selection).isOffline()) {
                    return false;
                }
                selection = this.getNextSelection();
            }
        }
        return super.isEnabled();
    }

    public void setAvailableOffline(boolean availableOffline) {
        this.isAvailableOffline = availableOffline;
    }

    public void setHost(IHost connection) {
        this.conn = connection;
    }

    public IHost getSystemConnection() {
        return this.conn;
    }
}

