/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.ui.ColorLegendControl;
import com.nvidia.viper.ui.PreciseTimeFormatter;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class UVMColorLegendControl
extends ColorLegendControl {
    public UVMColorLegendControl(Composite parent, int style) {
        super(parent, style);
    }

    public void updateLegend(TimelineIntervalUVM interval) {
        if (interval == null) {
            return;
        }
        this.labelLegend.setText(interval.getLegendTitle());
        long max = interval.getDuration();
        if (interval.getKind().equals((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
            max = TimelineIntervalUVM.MAX_CPU_FAULTS_PER_SECOND;
        }
        int count = 0;
        String start = "0";
        for (Map.Entry entry : this.mapValueLabel.entrySet()) {
            double value = (double)(max * (long)((Integer)entry.getKey()).intValue()) / 100.0;
            String end = new PreciseTimeFormatter((long)value).getScaled();
            if (interval.getKind().equals((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
                end = String.valueOf((int)value);
            }
            String text = " [" + start + " - " + end + "]";
            if (++count == this.mapValueLabel.size()) {
                text = " [ > " + start + "]";
            }
            ((Label)entry.getValue()).setText(text);
            start = end;
        }
        this.layout();
    }
}

