/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_EXCEPTION = 4;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private volatile WorkbenchLabelProvider fWorkbenchLabelProvider;
    protected CElementImageProvider fImageLabelProvider;
    private CUILabelProvider fCElementLabelProvider;
    private int fFlags;
    private int fImageFlags;
    private int fTextFlags;

    public CElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public CElementLabelProvider(int flags) {
        if (Display.getCurrent() != null) {
            this.fWorkbenchLabelProvider = new WorkbenchLabelProvider();
        } else {
            CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CElementLabelProvider.this.fCElementLabelProvider != null) {
                        CElementLabelProvider.this.fWorkbenchLabelProvider = new WorkbenchLabelProvider();
                    }
                }
            });
        }
        this.fImageLabelProvider = new CElementImageProvider();
        this.fFlags = flags;
        this.fCElementLabelProvider = new CUILabelProvider((long)this.getTextFlags() | 0x80L, this.getImageFlags());
    }

    public String getText(Object element) {
        if (element instanceof ICElement) {
            return this.fCElementLabelProvider.getText(element);
        }
        if (this.fWorkbenchLabelProvider != null) {
            return this.fWorkbenchLabelProvider.getText(element);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        return this.fImageLabelProvider.getImageLabel(element, this.getImageFlags());
    }

    public void dispose() {
        if (this.fCElementLabelProvider != null) {
            this.fCElementLabelProvider.dispose();
            this.fCElementLabelProvider = null;
        }
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
            this.fWorkbenchLabelProvider = null;
        }
        if (this.fImageLabelProvider != null) {
            this.fImageLabelProvider.dispose();
        }
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public int getImageFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
        return this.fImageFlags;
    }

    public int getTextFlags() {
        this.fTextFlags = 0;
        if (this.getFlag(1)) {
            this.fTextFlags = (int)((long)this.fTextFlags | 8L);
        }
        if (this.getFlag(2)) {
            this.fTextFlags = (int)((long)this.fTextFlags | 1L);
        }
        if (this.getFlag(4)) {
            this.fTextFlags = (int)((long)this.fTextFlags | 4L);
        }
        if (this.getFlag(2048)) {
            this.fTextFlags = (int)((long)this.fTextFlags | 0x40L);
        }
        return this.fTextFlags;
    }
}

