/*
 *   mwmnotify.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef __MWNOTIFY_H__
#define __MWNOTIFY_H__

#include "mwagent.h"

typedef struct clientobj
{
   HMCONV        hConv;
   unsigned long EventFlags;
   char          Name[32];
   HDSP          hDsp;
   unsigned long SuppressRequest;
} CLIENTOBJ;

typedef struct logentry
{
   long           TimeStamp;        /* time stamp for message*/
   unsigned short wMessage;         /* type of message being processed*/
   unsigned long  lParam1;          /* additional info*/
   char           Name[32];         /* name of receiver of message*/
} LOGENTRY;

#if defined(NS_LOCALFUNCTIONS)
extern LOGENTRY FAR  *LogBuffer;
extern unsigned char  LogStartIdx;
extern unsigned char  LogEndIdx;
extern unsigned short LogNumEntries;
extern HANDLE hNS_Instance;

extern short NS_SuspendStarted;

unsigned long ServerSetup(void);
unsigned long ServerPowerEvent(unsigned short wMessage,
                               unsigned long lParam1,
                               HDSP hDsp);
unsigned long ServerLogMessage(unsigned long lParam1,unsigned long lParam2);
void PutLog(unsigned short wMessage, unsigned long lParam1, char FAR *Name);

#define NS_LOG_MESSAGE  DRV_USER+1
#endif

#define NS_REQNOTIFICATION     SRV_USERBASE
#define NS_MANAGEREVENT        SRV_USERBASE+1
#define NS_REQLOGMESSAGE       SRV_USERBASE+2       /* V$IGARYA*/
#define NS_SUPPRESSSUSPEND     SRV_USERBASE+3       /* STUDWELL*/
#define NS_PCMCIAEVENT         SRV_USERBASE+4       /* STUDWELL*/
#define NS_DSPHANDLES          SRV_USERBASE+5       /* STUDWELL*/
#define NS_REQCLIENTLIST       SRV_USERBASE+6       /* MORRELL*/


#define SUPPRESSSUSPEND       1
#define ENABLESUSPEND         0

#define NS_INSUFFICIENT_BUFFER SRV_USERBASE+15

#define NS_EVENTNOTIFICATION   CLI_USERBASE
#define NS_EVENTLOG            CLI_USERBASE+1       /* V$IGARYA*/
#define NS_CLIENTLIST          CLI_USERBASE+2       /* MORRELL*/

#define NS_MAX_CLIENTS  64     /* maximum number of clients supported by NS*/
                               /* this is fixed for now for simplicity, could*/
                               /* dynamically allocate later on.*/

#define NS_PWRSUSPEND        0x0001    /* event flag for power suspend*/
#define NS_PWRRESUME         0x0002    /* event flag for power resume*/
#define NS_PWRCRITICALRESUME 0x0004    /* event flag for power critical resume*/
#define NS_PWRMGMT  (NS_PWRSUSPEND |       \
                     NS_PWRRESUME  |       \
                     NS_PWRCRITICALRESUME)

#define NS_STARTSUSPEND          0x0020  /* prenotification of suspend*/
#define NS_RESUMECOMPLETED       0x0040  /* postnotification of resume*/

#define NS_PCMCIA_CARDUNPLUGGED  0x0008  /* event flag for card unplugged*/
#define NS_PCMCIA_CARDREPLUGGED  0x0010  /* event flag for card replugged*/
#define NS_PCMCIA_CARDEVENT      0x0018  /* event flag for card services*/

#define NS_DSPINIT           0x0100    /* event flag for DSP INIT*/
#define NS_DSPMIPO           0x0200    /* event flag for DSP MIPO*/
#define NS_DSPICC            0x0400    /* event flag for DSP ICC*/
#define NS_DSPFAIL   (NS_DSPMIPO | NS_DSPICC)
#define NS_DSP       (NS_DSPINIT | NS_DSPFAIL)

/*---------------------------------------------------------------------*/
/**/
/*   Define names of special clients for Notification Server*/
/**/
/*---------------------------------------------------------------------*/
#define NS_MWPCMCIA_NAME  "MWAVE_PCMCIA"
#define NS_MWMANAGER_NAME "MWAVE_MANAGER"
#define NS_MWMEIO_NAME    "MWAVE_MEIO"

#endif

