/*------------ Telecommunications & Signal Processing Lab -------------
                         McGill University

Routine:
  int FLseekable (FILE *fp)

Purpose:
  Determine if an I/O stream is random access.

Description:
  This routine determines if an I/O stream associated with a given file pointer
  is random access.

Parameters:
  <-  int FLseekable
      Return value, 1 if the file is random access, 0 otherwise
   -> FILE *fp
      File pointer

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.4 $  $Date: 1997/10/10 16:42:10 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLseekable.c 1.4 1997/10/10 libtsp-v3r0 $";

#include <libtsp/nucleus.h>


int
FLseekable (fp)

     FILE *fp;

{
/*
  Consider ftell and fseek on pipes, terminals and regular files.  Only
  regular files are random access.
                             pipe   terminal   reg. file
    ftell (fp)               error   value     value
    fseek (fp,0L,SEEK_CUR)   error   success   success
  We are not able to distinguish terminals from reg. files this way.  One
  possible test is to change the position and then to restore it.  But one
  cannot change the position of a zero-sized file.  The test implemented here
  uses a test for a terminal to disqualify terminals and ftell to disqualify
  pipes.
*/
  return (! FLterm (fp) && ftell (fp) != -1L);
}
