/*
   Test AFsetRead

   $Id: tAFsetRead.c 1.6 1998/06/13 libtsp-v3r0 $
*/

#include <stdio.h>
#include <string.h>

#include <libtsp.h>
#include <libtsp/AFheader.h>
#define AF_DATA_LENGTHS
#include <libtsp/AFpar.h>

int
main (argc, argv)

     int argc;
     const char *argv[];

{
  AFILE *AFp;
  FILE *fp;
  long int Nbytes, Dstart, Ldata, Nsamp;
  int i, Format, Fix;
  const char *Fname;

/* Get the data */
  Fname = argv[1];
  sscanf (argv[2], "%ld", &Nbytes);
  sscanf (argv[3], "%d",  &Format);
  sscanf (argv[4], "%ld", &Dstart);
  sscanf (argv[5], "%ld", &Ldata);
  sscanf (argv[6], "%ld", &Nsamp);
  sscanf (argv[7], "%d",  &Fix);

/* Create a file */
  if (strcmp (Fname, "-") != 0) {
    fp = fopen (Fname, "wb");
    for (i = 0; i < Nbytes; ++i)
      fwrite ("\0", 1, 1, fp);
  }
  else
    fp = stdin;

  fseek (fp, Dstart, 0);
  AFp = AFsetRead (fp, FT_SPPACK, Format, DS_EB, 8000.0, 1.0, 1L,
		   Ldata, Nsamp, NULL, Fix);
  if (AFp == NULL)
    printf ("AFsetRead: Error return\n");
  else
    printf ("AFsetRead: Ldata: %ld ==> %ld, Nsamp: %ld ==> %ld\n",
	    Ldata, AF_DL[AFp->Format] * AFp->Nsamp, Nsamp, AFp->Nsamp);

/* Close the file */
  fclose (fp);

  return 0;
}
