/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFprAFpar (AFILE *AFp, const char Fname[], FILE *fpinfo)

Purpose:
  Print information about an audio file

Description:
  This routine optionally prints header information for an audio file.

Parameters:
   -> AFILE *AFp
      Audio file pointer for the audio file.  If AFp is NULL, this routine
      is a no-op.
   -> const char Fname[]
      File name.  If the file is stdin or stdout, this string is not used.
   -> FILE *fpinfo
      File pointer for printing the audio file identification information.  If
      fpinfo is NULL, no information is printed.

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.39 $  $Date: 1998/06/19 14:29:26 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFprAFpar.c 1.39 1998/06/19 libtsp-v3r0 $";

#include <assert.h>

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFheader.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */
#include <libtsp/AFmsg.h>
#define AF_DATA_TYPE_NAMES
#define AF_FILE_TYPE_NAMES
#include <libtsp/AFpar.h>

static char *
AF_findRec p_((const char *Id[], const struct AF_info *Hinfo));


void
AFprAFpar (AFp, Fname, fpinfo)

     AFILE *AFp;
     const char Fname[];
     FILE *fpinfo;

{
  const char *ft;
  char *Datetime, *Title;
  char FullName[FILENAME_MAX];
  static const char *IDtitle[] = {"title:", "name:", "user_comment:", NULL};
  static const char *IDdate[] = {"date:", "recording_date:", "creation_date:",
				 NULL};

  if (AFp == NULL)
    return;

  assert (AFp->Op == FO_RO || AFp->Op == FO_WO);
  assert (AFp->Format > 0 && AFp->Format < NFD);
  assert (AFp->Ftype > 0 && AFp->Ftype < NFT);

/* Print the header information */
  if (fpinfo != NULL) {

    /* Type of file and name */
    if (AFp->Ftype == FT_NH && AFopt_NHpar.Start == 0L)
      ft = AFM_Headerless;
    else
      ft = AF_FTN[AFp->Ftype];

    if (AFp->fp == stdin)
      fprintf (fpinfo, AFMF_stdin, ft);
    else if (AFp->fp == stdout)
      fprintf (fpinfo, AFMF_stdout, ft);
    else {
      FLfullName (Fname, FullName);
      fprintf (fpinfo, AFMF_File, ft, FullName);
    }

    /* Title */
    Title = AF_findRec (IDtitle, &AFp->Hinfo);
    if (Title != NULL)
      fprintf (fpinfo, AFMF_Desc, STstrDots (Title, 56));

    /* Date and number of samples*/
    if (AFp->Op == FO_RO) {
      Datetime = AF_findRec (IDdate, &AFp->Hinfo);
      if (Datetime == NULL) {
	Datetime = "";
	if (AFp->fp != stdin)
	  Datetime = FLfileDate (AFp->fp, 3);
      }

      if (AFp->Nsamp == AF_NSAMP_UNDEF)
	fprintf (fpinfo, AFMF_NumSampUnk, Datetime);
      else
	fprintf (fpinfo, AFMF_NumSamp, AFp->Nsamp, Datetime);
    }

    /* Sampling frequency */
    fprintf (fpinfo, AFMF_SFreq, AFp->Sfreq);

    /* Number of channels and data format */
    fprintf (fpinfo, AFMF_NumChan, AFp->Nchan, AF_DTN[AFp->Format]);
  }

  return;
}

/* Search for named records in an AFsp information structure */


static char *AF_findRec (Id, Hinfo)

     const char *Id[];
     const struct AF_info *Hinfo;

{
  int i;
  char *p;

  p = NULL;
  for (i = 0; Id[i] != NULL; ++i) {
    p = AFgetHrec (Id[i], Hinfo);
    if (p != NULL)
      break;
  }

  if (p != NULL)
    p = STtrimIws (p);

  return p;
}
