/****************************************************************************
 **
 ** $Id: DirBase.h,v 1.4 2005/01/06 13:40:36 frank Exp $
 **
 ** Copyright (C) 1999-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/
#ifndef DIRBASE_H
#define DIRBASE_H

#include <qlistview.h>

#include "CommandInterface.h"
#include "FileListViewItem.h"

//----------------------------------------------------------------------------
enum EntryStates_E {
   ES_invalid                                    = -1,
   ES_unknown                                    =  0,
   ES_probably_up_to_date                        =  1,
   ES_probably_up_to_date_and_timezone_incorrect =  2,
   ES_up_to_date                                 =  3,
   ES_noncvs                                     =  4,
   ES_modified                                   =  5,
   ES_added                                      =  6,
   ES_removed                                    =  7,
   ES_needs_patch                                =  8,
   ES_needs_merge                                =  9,
   ES_needs_checkout                             = 10,
   ES_missing                                    = 11,
   ES_missing_dir                                = 12, 
   ES_conflict                                   = 13
};
typedef enum EntryStates_E EntryStates;

//----------------------------------------------------------------------------

class CvsBuffer;

class DirBase : public QListViewItem, public QObject, CommandInterface {

 public:
   DirBase(QListView * item) : QListViewItem(item) {}
   DirBase(QListViewItem * item) : QListViewItem(item) {}
   ~DirBase() {}

   enum Type { Plain = 0, Cvs = 1, Svn = 2 };
   enum Tab { Cached = 0, Controled = 1, NonControled = 2, Ignored = 4, Force = 8, Tree = 16 };
   enum Mode { Create = 1, Overwrite = 2, Replace = 4 };

   DirBase * parent() const {return static_cast<DirBase *>(QListViewItem::parent());}
   DirBase * firstChild() {return static_cast<DirBase *>(QListViewItem::firstChild());}
   DirBase * nextSibling() {return static_cast<DirBase *>(QListViewItem::nextSibling());}

   virtual void activateItem(bool=false,int=Controled|NonControled|Ignored) = 0;

   // open/close dirs
   virtual void setOpen(bool) = 0;
   virtual void setOpen(bool,QString &) = 0;
   virtual void setAllOpen() = 0;
   virtual void expandAllDir() = 0;
   virtual void collapsAllDir() = 0;
   virtual void analyzeAll() = 0;
   virtual void saveViewPort() = 0;

   // readonly methods
   virtual QString fullName() = 0;
   virtual QString shortName() = 0;
   virtual QString relativeName() = 0;
   virtual QListView * topView() = 0;
   virtual DirBase * topDir() = 0;
   virtual DirBase * topControlledDir() = 0;
   virtual QString rootDir() = 0;
   virtual bool isControlled() = 0;
   virtual bool isAnalyzed() = 0;
   virtual bool isDisabled() = 0;
   virtual bool isVirtual() = 0;
   virtual QString getLastError() = 0;
   virtual QStringList getSelectedFiles() = 0;
   virtual QString getFirstSelectedFile() = 0;
   virtual QListViewItem * firstControlledFile() = 0;
   virtual QListViewItem * firstNonFile() = 0;
   virtual QListViewItem * firstIgnoredFile() = 0;
   
   //repository
   virtual QString repository() = 0;
   virtual QString userName() = 0;
   virtual QString host() = 0;
   virtual int port() = 0;
   virtual QString connectMethod() = 0;
   virtual QString getDirTag() = 0;
   virtual QString getRoot() = 0;
   
   // rw methods
   virtual DirBase * addDir(QString newDir,bool addVirtual=false) = 0;
   virtual DirBase * reloadChild(QString) = 0; //remove and reinsert Dir with all its subdirs without rereading the whole project
   virtual void removeChild( DirBase *) = 0;

   virtual DirBase * searchDirOfPath(QString path, bool findVirtual = false) = 0;
   virtual DirBase * searchLastValidDirOfPath(QString path) = 0;
   
   virtual bool setEntryState(QString&, EntryStates) = 0;
   virtual EntryStates getEntryState(QString) = 0;
   
   virtual bool recCopyControlledFiles(QString,int=Create) = 0;
   virtual bool copyFile(QString,QString,int,bool deleteSource=FALSE) = 0;
   virtual bool recRemoveNonControlledFiles(QString &) = 0;
   virtual bool removeNonControlled(QString&) = 0;
   
   // virtual methods
   virtual int getType() = 0;
   virtual bool isModified() = 0;
   virtual bool isControlledTree() = 0;
   virtual bool checkDirForControl() = 0;
   virtual void recCheckForModifications(bool) = 0;
   virtual bool postCallCheck(int=Controled|NonControled|Ignored) = 0;
   virtual void validateControlledFilesStatus(bool=false, bool=false, bool=false) = 0;
   virtual void checkAndShowStatus(FileListViewItem * =0, bool=false, int=Controled|NonControled|Ignored, bool=false) = 0;
   virtual void removeTmpEntries(QString name=QString::null) = 0;
   virtual void recRemoveTmpEntries(bool) = 0;
   virtual bool recCopyTree(QString,QString,bool=FALSE) = 0;
   virtual bool parseCallResult(CvsBuffer*, int, QStringList * =0) = 0;
   virtual bool backupFiles(QStringList) = 0;
   virtual bool restoreFiles(QStringList) = 0;
   
   //functions telling about cvs file state
   virtual bool isControlled(QString) = 0;
   virtual bool isBinary(QString) = 0;
   virtual void getNameAndRevOfFirstSelectedFile(QString *, QString *) = 0;
   virtual QString getRev(QString *) = 0;
};
#endif
