/**********************************************************************
 * Jhove - JSTOR/Harvard Object Validation Environment
 * Copyright 2003 by JSTOR and the President and Fellows of Harvard College
 **********************************************************************/

package edu.harvard.hul.ois.jhove;

//import java.io.*;
import java.util.*;

/**
 *  The application class for JHOVE. One instance of this class is
 *  generated by the application.  Various utility and informational
 *  methods are contained here.
 */
public class App
{
    /******************************************************************
     * PRIVATE INSTANCE FIELDS.
     ******************************************************************/

    /** Application build date. */
    private Date _date;

    /** Application name. */
    private String _name;

    /** Application release identifier. */
    private String _release;

    /** Application rights statement. */
    private String _rights;

    /** Application invocation syntax. */
    private String _usage;

    /******************************************************************
     * CLASS CONSTRUCTOR.
     ******************************************************************/

    /**
     *   Creates an App object.
     *   @param name            Name of the application.
     *   @param release         Release identifier.
     *   @param date            Last modification date of the application code,
     *                          in the form of an array of three numbers.
     *                          <code>date[0]</code> is the year, 
     *                          <code>date[1]</code> the month, and
     *                          <code>date[2]</code> the day.
     *   @param usage           String summarizing command line usage, to
     *                          output when app name is typed with no
     *                          arguments or flags.
     *   @param args            Array of command line arguments. 
     */
    public App (String name, String release, int [] date, String usage,
                String rights)
    {
        Calendar calendar = new GregorianCalendar ();
        calendar.set (date[0], date[1]-1, date[2]);

        _name    = name;
        _release = release;
        _date    = calendar.getTime ();
        _usage   = usage;
        _rights  = rights;
    }

    /******************************************************************
     * PUBLIC INSTANCE METHODS.
     *
     * Accessor methods.
     ******************************************************************/

    /**
     *  Returns application code creation date
     */
    public Date getDate ()
    {
        return _date;
    }

    /**
     *  Returns the name of this application
     */
    public String getName ()
    {
        return _name;
    }

    /**
     *  Returns the release identifier for this application.
     */
    public String getRelease ()
    {
        return _release;
    }

    /**
     *  Returns the rights string.
     */
    public String getRights ()
    {
        return _rights;    
    }
    
    /**
     *  Returns the usage string, which should be output when the user
     *  enters a command line with only the application name.
     */
    public String getUsage ()
    {
        return _usage;
    }

    /******************************************************************
     * Serialization methods.
     ******************************************************************/

    /**
     *  Outputs detailed information about the application,
     *  including configuration, available modules and handlers,
     *  etc.
     */
    public void show (OutputHandler handler)
    {
        handler.show (this);
    }
}
