package org.broad.tribble.index;

import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.util.LittleEndianInputStream;

import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * Interface for all index implementations.  
 */
public interface Index {
    /**
     * 
     * @param chr the chromosome
     * @param start the start position
     * @param end the end position
     * @return a list of blocks that contain the specified interval
     */
    List<Block> getBlocks(String chr, int start, int end);

    /**
     * returns the sequence dictionary, if available, for this index file
     * @return a sequence dictionary, or NULL if not available.
     */
    SAMSequenceDictionary getSequenceDictionary();

    /**
     * sets the sequence dictionary for this index file (prior to writing the file)
     */
    void setSequenceDictionary(SAMSequenceDictionary dictionary);

    /**
     * does this index represent an up-to-date version
     * @return true if the index is up to date, false otherwise
     */
    public boolean isCurrentVersion();

    Set<String> getSequenceNames();

    public void read(LittleEndianInputStream stream)  throws IOException;
}
