static char rcs_id[] = "$Id: http-analyze.c,v 2.4.1.3 1999/11/04 12:15:19 stefan Stab $";

/*
*************************************************************************
**
** http-analyze - A fast log analyzer for web servers
**
**	http-analyze is a fast log analyzer for web servers. It analyzes
**	the logfile of a web server and creates a detailed summary of the
**	server's access load in tabular and in graphical form.
**
** Copyright  1996-1999 by Stefan Stapelberg/RENT-A-GURU, <stefan@rent-a-guru.de>
** All rights reserved.
**
** RENT-A-GURU is a registered trademark of Martin Weitzel, Stefan
** Stapelberg, and Walter Mecky. Netstore and the Netstore logo is
** a registered trademark of Stefan Stapelberg.
**
*************************************************************************
**
** HTTP-ANALYZE PERSONAL LICENSE
**
** Use of http-analyze indicates your acceptance of this license agreement.
** Please read the following paragraphs carefully and use this software only
** if you agree to the terms contained herein. For commercial licensing
** please visit our web site or contact RENT-A-GURU by email at
** <office@rent-a-guru.de>.  RENT-A-GURU has exclusive licensing rights
** for use of http-analyze for commercial purposes.
**
** This license applies to the computer program(s) known as http-analyze.
** The term program used in this license agreement refers to such program
** including all output files (HTML files, VRML files, image files) it
** generates, and the term work based on the program means either the
** program or any derivative work of the program including it's output files,
** such as a translation into another language, extending the program's
** functionality, use of parts of the program or it's output files or any
** modification of the program or it's output files. The program is a
** copyrigthed work whose copyright is held by Stefan Stapelberg of
**  RENT-A-GURU (the licensor).
**
** 1. License terms
** ----------------
**
** Licensor hereby grants you the following rights, provided that you comply
** with all of the restrictions set forth in this license and provided further,
** ** that you distribute an unmodified copy of this license with the program:
**
** (a) You may copy and distribute the program's unaltered source code
**     worldwide via any medium. Any distribution of the program or any
**     programs containing source code of http-analyze as well as any output
**     created with the program must contain an appropriate credit and all
**     additional materials included with the original distribution, including
**     the unaltered license agreement.
**
** (b) You may use the program for non-commercial purposes only, meaning that
**     the program must not be sold commercially as a separate product, as part
**     of another product (bundled software) or project, or used by service
**     providers to provide statistics services to their webspace customers, or
**     otherwise used for financial gain without a separate Commercial Service
**     License. Please see section 2, Restrictions, for details.
**
** (c) You may build derived versions of this software under the restrictions
**     stated in section 2 (Restrictions) of this license. The derived versions
**     must be clearly marked as such and must be called by a name other than
**     http-analyze.
**
**   i)	All derived versions of the program must be made freely available under
**	the terms of this license. RENT-A-GURU must be given the right to use
**	the modified source code in their products without any compensation
**	and without being required to separately name the parties whose
**	modifications are being used.
**
**  ii)	Credit for http-analyze must be given to RENT-A-GURU in all derived
** 	works and in all HTML and/or VRML output files created by the derived
** 	work. This does not affect your ownership of the derived work or the
** 	statistics reports itself, and the intent is to assure proper credit
** 	for RENT-A-GURU, not to interfere with your use of this derived work.
**
** 2. Restrictions
** ---------------
**
** (a) Distribution of the program or any work based on the program by a
**     commercial organization to any third party is prohibited if any payment
**     is made in connection with such distribution, whether directly (as in
**     payment for a copy of the program) or indirectly (as in payment for some
**     service related to the program, or payment for some product or service
**     that includes a copy of the program without charge, or payment for some
**     product or service the delivery of which requires for the recipient to
**     retrieve/download or otherwise obtain a copy of the program; these are
**     only examples, not an exhaustive enumeration of prohibited activities).
**
**     As an exception to the above rule, putting this program on CD-ROMs
**     containing other free software is explicitly permitted even when a
**     modest distribution fee is charged for the CD, as long as this software
**     is not a primary selling argument for the CD. Two CDs must be sent to
**     RENT-A-GURU without having RENT-A-GURU requesting it.
**
** (b) You may not change the essential layout of the HTML and/or VRML output
**     files the program generates, except for those parts which can be changed
**     by using the appropriate settings in the configuration file or via
**     command line options. The Copyright notice and the link to the homepage
**     of http-analyze as produced by the program must remain intact in all
**     HTML and/or VRML output files created by the program and must be
**     included in all HTML and/or VRML output files created by work based
**     on the program.
**
** (c) Activities other than copying, distribution and modification of the
**     program are not subject to this license and they are outside it's
**     scope. Functional use (running) of the program is not restricted.
**
** (d) You must meet all of the following conditions with respect to the
**     distribution of any work based on the program:
**
**   i)	All modified versions of the program, must carry prominent notice
** 	stating that the program has been modified. The notice must indicate
** 	who made the modifications and how the program's files were modified
** 	and the date of any change;
**  ii)	You must cause any work that you distribute or publish, that in whole
** 	or in part contains or is derived from the program or any part thereof,
** 	to be licensed as a whole and at no charge to all third parties under
** 	the terms of this license;
** iii) You must cause the program, at each time it commences operation, to
** 	print or display an announcement including an appropriate copyright
** 	notice and a notice that there is no warranty. The notice must also
** 	tell the user how to view the copy of the license included with the
** 	program, and state that users may redistribute the program only under
** 	the terms of this License;
**  iv)	You must accompany any such work based on the program with the complete
** 	corresponding machine-readable source code, delivered on a medium
** 	customarily used for software interchange. The source code for a work
** 	means the preferred form of the work for making modifications to it;
**   v)	If you distribute any written or printed material at all with the
** 	program or any work based on the program, such material must include
** 	either a written copy of this license, or a prominent written
** 	indication that the program or the work based on the program is
** 	covered by this license and written instructions for printing and/or
** 	displaying the copy of the License on the distribution medium;
**  vi)	You may not change the terms in this License or impose any further
** 	restrictions on the recipient's exercise of the rights granted herein.
**
**
** 3. Reservation of Rights
** ------------------------
**
** No rights are granted except as expressly set forth herein. You may not
** copy, modify, sublicense, or distribute the program or any parts of the
** HTML output files the program generates, except as expressly provided
** under this license. Any attempt otherwise to copy, modify, sublicense
** or distribute the program or the HTML output files as a whole or in parts
** is void, and will automatically terminate your rights under this license.
** However, parties who have received copies, or rights, from you under this
** license will not have their licenses terminated as long as such parties
** remain in full compliance with the license.
**
** RENT-A-GURU has the right to terminate this license immediately by written
** notice upon Licensee's breach of, or non-compliance with any of its terms
** or upon any other reason. Licensee may be held legally responsible for any
** copyright infringement that is caused or encouraged by licensee's failure
** to abide by the terms of this license.
**
**
** 4. Limitations
** --------------
**
** The program is provided "as is" without warranty of any kind, either
** expressed or implied, including, but not limited to, the implied
** warranties of merchantability and fitness for a particular purpose.
**
** Use at your own risk. In no event unless required by applicable law or
** agreed to in writing will any copyright holder, or any other party who
** may use, modify and/or redistribute the program as permitted above, be
** liable to you for damages, including any general, special, incidental
** or consequential damages arising out of the use or inability to use the
** program (including but not limited to loss of data or data being rendered
** inaccurate or losses sustained by you or third parties or a failure of
** the program to operate with any other programs), even if such holder or
** other party has been advised of the possibility of such damages.
**
**
**				IMPORTANT NOTE
**
**   Because under this Personal License the program is free of charge,
**	 RENT-A-GURU does not support it nor assist in it's usage.
**
**
**
** 5. General
** ----------
**
** Some of the source code aggregated with this distribution is licensed by
** third parties under different terms, so the restrictions above may not
** apply to such components. As far as we know, all included source code
** is used in accordance with the relevant license agreements and can be
** used and distributed freely for any purpose; see below for details.
**
** Some functions in the file utils.c are owned by the Regents of the
** University of California, and can be freely used and distributed.
** License terms are included in the file utils.c.
**
** The program uses the GD graphics library for fast image creation by
** Thomas Boutell available at http://www.boutell.com/gd/, which is not
** included in the distribution of http-analyze, but which is required
** to compile the. software. The following copyrights and credits apply
** for gd1.7.3, which has been used for http-analyze2.4:
**
**    Portions copyright 1994, 1995, 1996, 1997, 1998, 1999, by Cold Spring
**    Harbor Laboratory. Funded under Grant P41-RR02188 by the National
**    Institutes of Health.
**
**    Portions copyright 1996, 1997, 1998, 1999, by Boutell.Com, Inc.
**
**    Portions relating to GD2 format copyright 1999 Philip Warner.
**
**    Portions relating to PNG copyright 1999, Greg Roelofs.
**
**    Portions relating to libttf copyright 1999, John Ellson
**    (ellson@lucent.com).
**
**    Permission has been granted to copy and distribute gd in any context
**    without fee, including a commercial application, provided that this
**    notice is present in user-accessible supporting documentation.
**
**    This does not affect your ownership of the derived work itself, and
**    the intent is to assure proper credit for the authors of gd, not to
**    interfere with your productive use of gd. If you have questions, ask.
**    "Derived works" includes all programs that utilize the library.
**    Credit must be given in user-accessible documentation.
**
**    This software is provided "AS IS." The copyright holders disclaim all
**    warranties, either express or implied, including but not limited to
**    implied warranties of merchantability and fitness for a particular
**    purpose, with respect to this code and accompanying documentation.
**
**    Although their code does not appear in gd 1.7.3, the authors wish
**    to thank David Koblas, David Rowley, and Hutchison Avenue Software
**    Corporation for their prior contributions.
**
*************************************************************************
*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#if defined(unix)
# include <unistd.h>
# define ISFULLPATH(cp)	(*(cp) == '/')
# define ISANYPATH(cp)	(strchr((cp), '/') != NULL)

#else
# if defined(WIN32)
#  include <winsock.h>		/* for the u_int, etc. types */
#  include <direct.h>		/* for other windows/watcom stuff */
#  include <io.h>		/* for the F_OK, etc. symbolic constants */
# define ISFULLPATH(cp)	(*(cp) == '/' || *(cp) == '\\' || *(cp+1) == ':')
# define ISANYPATH(cp)	(strchr((cp), '/') != NULL || \
			 strchr((cp), '\\') != NULL || *(cp+1) == ':')
#elif defined(NETWARE)
#  include <direct.h>		/* for other windows/watcom stuff */
#  include <io.h>		/* for the F_OK, etc. symbolic constants */
# define ISFULLPATH(cp)	(*(cp) == '\\' || strchr((cp), ':') != NULL)
# define ISANYPATH(cp)	(strchr((cp), '/') != NULL || strchr((cp), '\\') != NULL)
# endif
#endif

#include "config.h"			/* common configuration definitions */
#include "defs.h"			/* common data structures, prototypes */
#include "patchlevel.h"

#if defined(TIME_STATS)			/* generate time statistics */
# include <sys/time.h>			/* for gettimeofday() */
# define TICKS_PMSEC	1000L
#endif

#if defined(USE_FAST_MALLOC)		/* fast malloc functions */
# include <malloc.h>
#endif

#if !defined(NO_SETLOCALE)
# include <locale.h>			/* for localization */
#endif

#define VERSION	"2.4"			/* version number */

/* Global variables */
char *progname = NULL;			/* name of program */
char *creator = NULL;			/* creator of 3D model */
char *daynam[7], *monnam[12];		/* day and month names */
int verbose=0;				/* 0=silent, 1=verbose, >1=debugging */
int btn_missing = 0;			/* set if buttons are missing */
long best_iosize = 0L;			/* best I/O buffer size specified on cmd-line */

#if defined(USE_XPGCAT)
nl_catd catFD = (nl_catd) -1;		/* XPG/4 msg catalog descriptor */
#endif

/* Global variables with module-scope */
static char *language = NULL;		/* use this language everywhere */
static char *htmlcset = NULL;		/* use this charset in the report */
static char *last_update = NULL;	/* time of last update */
static char *srv_name = NULL;		/* name of this server */
static char *srv_url = NULL;		/* prefix to use for hot URLs */
static char *log_file = NULL;		/* name of the logfile */
static char *log_format = NULL;		/* logfile format */
static char *out_dir = NULL;		/* directory for HTML output files */
static char *priv_dir = NULL;		/* private HTML directory */
static char *btn_dir = NULL;		/* localized buttons subdirectory */
static char *tld_file = NULL;		/* name of TLD file */
static char *time_win = NULL;		/* time-window for session accounting */
static char *cur_tim = NULL;		/* fake current time (for debugging) */
static char *ign_date = NULL;		/* ignore date */
static char *end_date = NULL;		/* end date */
static char *doc_title = NULL;		/* document title */
static char *virt_root = NULL;		/* document root of virtual server */
static char *virt_host = NULL;		/* virtual hostname */
static char *vrml_prlg = NULL;		/* VRML 3D prolog file */
static char *html_str[HTML_STRSIZE];	/* user-defined HTML strings */
static char copyright[MAX_FNAMELEN];	/* copyright note */
static int list_dir = 0;		/* set if separate list directory */

/* Name of private directory */
#define PRIV_DIR	(priv_dir ? priv_dir : ".")

/* User-defineable table formats */
#define FMT_MON			0
#define FMT_DAY			1
#define FMT_LOAD		2
#define FMT_CNTRY		3
#define FMT_TOPTEN		4
#define FMT_OVIEW		5
#define FMT_LISTS		6
#define FMT_NFOUND		7

static char *tblfmt[8] = {
	"n h f c p s k",		/* hits by month (main page) */
	"n H F C P S k",		/* hits by day (monthly report) */
	"N H F P S k L",		/* hits by week, weekday, hour, min, sec */
	"N H F P S k L",		/* hits by country */
	"N H F P S k L",		/* top ten (URLs/sites/agents/referrer) */
	"H f p B",			/* overviews (URLs/sites/agents/referrer) */
	"H f p B",			/* detailed lists (URLs/sites/agents/referrer) */
	"h s b"				/* Not Found list */
};

static size_t ipnum = 0;		/* total # of index filenames */
static size_t ptnum = 0;		/* total # of pageview suffixes */
static size_t vrlen = 0;		/* length of document root for virtual server */
static int maxbtn = 0;			/* max # of buttons */
static int drneg = 0;			/* set if doc root should be ignored */
static int btn_symlink = 0;		/* set if buttons are to be symlinked */
static u_long lnum = 0LU;		/* line number in logfile */
static u_long ndays = 0LU;		/* number of days processed */
static PERIOD t;			/* times: first/last entry, current time, time limit */
static LIC_INFO *lic = NULL;		/* registration info */
static HSTRING indexpg[MAX_HPNAMES];	/* names of additional index files */
static HSTRING pvtab[MAX_PGTYPE];	/* pageview suffixes for page rating */
static enum { EXT_WIN, INT_WIN } vrml_win = EXT_WIN; /* VRML 3D window */
static FONTDEF font[FONT_MAX];

/*
** Counters
*/
static COUNTER total;			/* hits/files/304s/sites total */
static COUNTER cksum;			/* totals for history checksum */
static COUNTER monly[12];		/* hits per month */
static COUNTER weekly[7];		/* hits per weekday */
static COUNTER grmon[13];		/* hit cnt for img drawing functions */
COUNTER daily[31];			/* total hits per day */
COUNTER max_day, avg_day;		/* max/average hits per day */

u_long wh_hits[7][24];			/* hits per weekday & hour */
u_long avg_wday[7];			/* avg hits per weekday */
u_long avg_whour[24];			/* avg hits per weekhour */

static u_long avg_hour[24];		/* average hits per hour */
static u_long max_avhits = 0L;		/* max avg hits per hour */
static u_long max_hits = 0L;		/* max hits per year */

u_long max_avdhits = 0L;		/* max average hits per weekday */
u_long max_avhhits = 0L;		/* max average hits per weekhour */
u_long max_whhits = 0L;			/* max hits per weekday & hour */
size_t wdtab[31];			/* list of weekdays for this month */

static u_long corrupt = 0L;		/* total # of corrupt lines */
static u_long ignored = 0L;		/* total # of lines skipped or ignored */
static u_long reqempty = 0L;		/* total # of empty requests */
static u_long reqinval = 0L;		/* total # of invalid request methods */
static u_long reqauth = 0L;		/* total # of requests which required authentication */
static u_long this_hits = 0L;		/* total # of hits per run */
static u_long total_kbsaved = 0L;	/* total kbytes saved by cache */
static u_long total_agents = 0L;	/* total # of user agents */
static u_long total_refer = 0L;		/* total # of referrer URLs */
static u_long uniq_urls = 0L;		/* total # of unique URLs */
static u_long uniq_sites = 0L;		/* total # of unique sites */
static u_long uniq_stime = 0L;		/* duration before new session */
static size_t num_cntry = 0L;		/* total # of countries */
static char *grlabel[13];		/* labels for img drawing functions */
static u_short wh_cnt[7];		/* # of days accounted for */
static int noiselevel = -1;		/* skip entries with hits below this level */

/*
** Dynamic lists of hidden sites, items, agents and referrers.
*/
#if !defined(HASHSIZE)
# define HASHSIZE	7001
#endif
#if !defined(HIDELIST_SIZE)
# define HIDELIST_SIZE	4001
#endif

/* Hidden/ignore tables for items/sites/agents/referrers */
static HIDE_TAB hidden[6] = {
	{ NULL, NULL, 0, 0, 0, 0 },	/* HIDDEN_SITES */
	{ NULL, NULL, 0, 0, 0, 0 },	/* HIDDEN_ITEMS */
	{ NULL, NULL, 0, 0, 0, 0 },	/* HIDDEN_REFERS */
	{ NULL, NULL, 0, 0, 0, 0 },	/* HIDDEN_AGENTS */
	{ NULL, NULL, 0, 0, 0, 0 },	/* IGNORED_SITES */
	{ NULL, NULL, 0, 0, 0, 0 }	/* IGNORED_ITEMS */
};

/* Unknown items/sites/agents/referrers */
static COUNTER unknown[6] = {
	{ 0, 0, 0, 0, 0, 0.0 },		/* HIDDEN_SITES */
	{ 0, 0, 0, 0, 0, 0.0 },		/* HIDDEN_ITEMS */
	{ 0, 0, 0, 0, 0, 0.0 },		/* HIDDEN_REFERS */
	{ 0, 0, 0, 0, 0, 0.0 },		/* HIDDEN_AGENTS */
	{ 0, 0, 0, 0, 0, 0.0 },		/* SELF_REF */
					/* unused */
};

static u_short mdays[2][12] = {
    { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
    { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
};

/* Hash tables for hidden items, sites, agents, referrers */
static NLIST *hlist[4][HIDELIST_SIZE];

/* The lists for items/sites/agents/referrers/errors */
static NLIST *sitetab[HASHSIZE];	/* table for sitenames */
static NLIST *urltab[HASHSIZE];		/* table for URLs */
static NLIST *uatab[HASHSIZE];		/* table for user agents */
static NLIST *reftab[HASHSIZE];		/* table for referrer URLs */
static NLIST *errtab[HASHSIZE];		/* table for Code 404 errors */

/* Dimensions of all top N lists. */
static int topn_urls = -1, lstn_urls = -1;
static int topn_sites = -1, topn_agent = -1, topn_refer = -1;
static int topn_day = -1, topn_hrs = -1, topn_min = -1, topn_sec = -1;

/* The Top N sites/urls/agents/referrers lists. */
static NLIST **top_urls  = NULL, **lst_urls = NULL;
static NLIST **top_sites = NULL, **top_agent = NULL, **top_refer = NULL;

/* The Top N secs/mins/hours/days */
static TOP_COUNTER *top_sec = NULL, *top_min = NULL;
static TOP_COUNTER *top_hrs = NULL, *top_day = NULL;
static TOP_COUNTER csec, cmin, chrs, cday;

/* Self referrer */
static HSTRING *ref_urls = NULL;

/* Common used strings. */
static char enoent[]  = "Can't open file `%s' (%s)\n";			/* 83 */
static char enoacc[]  = "Can't access `%s' (%s)\n";			/* 84 */
static char enomem[]  = "Not enough memory -- need %u more bytes\n";	/* 337 */
static char deffont[] = "Helvetica,Arial,Geneva,sans-serif";
static char ha_home[] = "http://www.netstore.de/Supply/http-analyze/";
static char ha_reg[]  = "http://www.netstore.de/Supply/http-analyze/register.html";
static char ha_bug[]  = "http://support.netstore.de/support/ha-call.cgi";
static char hrule1[]  =	"-------------------------------------------------"
			"-------------------------------------------------";
static char hrule2[]  = "================================================="
			"=================================================";

/* Common variables, mostly options. */
static int bugrep = 0;			/* print URL for bug report */
static int regonly = 0;			/* save registration ID */
static int btnonly = 0;			/* make buttons only */
static int versonly = 0;		/* print version only */
static int logfmt = LOGF_UNKNOWN;	/* defines the logfile format */
static int timestats = 0;		/* if set print elapsed time */
static int use_vrml = 0;		/* create a VRML model */
static int use_frames = 0;		/* if set create frames interface */
static int use_hist = 0;		/* if set use values from history for expired period */
static int noautohide = 0;		/* if set don't automatically add base URLs as hidden items */
static int nohist = 0;			/* if set ignore history file */
static int nodefhid = 0;		/* if set don't collect image filenames */
static int nocgistrip = 0;		/* if set don't strip arguments from CGI URLs */
static int nonavpanel = 0;		/* if set don't create separate navigation window */
static int msiis_mode = 0;		/* if set use case-insensitive URLs */
static int show_domain = -1;		/* number of subdomains to show */
static int nav_frame = -1;		/* size of navigation frame in frames UI */
static int navwid = -1, navht = -1;	/* size of navigation window */
static int w3wid = -1, w3ht = -1;	/* size of 3D window */
static int monthly = -1;		/* if set create monthly summary */

/*
** HTTP/1.1 (RFC2616) request methods and response codes.
*/
static RESPONSE ReqMethod[] = {
    { "Extension-method",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "GET",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "POST",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "HEAD",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "PUT",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "OPTIONS",			{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "CONNECT",			{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "DELETE",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "TRACE",				{ 0L, 0L, 0L, 0L, 0L, 0.0 } }
};

static RESPONSE RespCode[] = {
    { "Unknown response",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Continue (Code 100)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Switching Protocols (Code 101)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "OK (Code 200)",			{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Created (Code 201)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Accepted (Code 202)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Non-Authoritative Information (Code 203)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "No Content (Code 204)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Reset Content (Code 205)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Partial Content (Code 206)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Multiple Choices (Code 300)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Moved Permanently (Code 301)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Moved Temporarily (Code 302)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "See Other (Code 303)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Not Modified (Code 304)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Use Proxy (Code 305)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Temporary Redirect (Code 307)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Bad Request (Code 400)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Unauthorized (Code 401)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Payment Required (Code 402)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Forbidden (Code 403)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Not Found (Code 404)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Method Not Allowed (Code 405)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Not Acceptable (Code 406)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Proxy Authentication Required (Code 407)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Request Timeout (Code 408)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Conflict (Code 409)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Gone (Code 410)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Length Required (Code 411)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Precondition Failed (Code 412)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Request Entity Too Large (Code 413)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Request-URI Too Long (Code 414)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Unsupported Media Type (Code 415)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Requested Range Not Satisfiable (Code 416)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Expectation Failed (Code 417)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Internal Server Error (Code 500)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Not Implemented (Code 501)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Bad Gateway (Code 502)",		{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Service Unavailable (Code 503)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "Gateway Timeout (Code 504)",	{ 0L, 0L, 0L, 0L, 0L, 0.0 } },
    { "HTTP Version Not Supported (Code 505)",{ 0L, 0L, 0L, 0L, 0L, 0.0 } }
};

/*
** Suppress suboptions and report control flags.
*/
static SUPPRESS sptab [] = {
	{ 1, "URLs" },		/* SP_URLS */
	{ 1, "URLList" },	/* SP_URLLIST */
	{ 1, "Code404" },	/* SP_CODE404 */
	{ 1, "Sites" },		/* SP_SITES */
	{ 1, "RSites" },	/* SP_RSITES */
	{ 1, "SiteList" },	/* SP_SITELIST */
	{ 1, "Agents" },	/* SP_AGENTS */
	{ 1, "Referrer" },	/* SP_REFERRER */
	{ 1, "AVLoad" },	/* SP_AVLOAD */
	{ 1, "Country" },	/* SP_COUNTRY */
	{ 1, "Pageviews" },	/* SP_PAGEVIEWS */
	{ 1, "AuthReq" },	/* SP_AUTHREQ */
	{ 1, "Graphics" },	/* SP_GRAPHICS */
	{ 1, "Hotlinks" },	/* SP_HOTLINKS */
	{ 1, "Interpol" }	/* SP_INTERPOL */
};

/*local functions */
static LOGENT *readLog(FILE *const, LOGTIME *const, LOGTIME *const);
static NLIST *lookupItem(NLIST **const, HSTRING *const, u_int const);
static HSTRING *hashedString(u_int const, char *);
static HSTRING *validURL(char *const, char *const);
static char *mkSubdir(char *const, u_short const);
static char *readHTML(char *const, char *const);

static void insertTop(TOP_COUNTER *const, TOP_COUNTER [], int const);
static void saveHiddenItem(int const, HSTRING *const);
static void addIgnoredItem(int const, char *const);
static void addHiddenName(size_t const, char *, char *const, HSTRING *const);
static void addSelfRefer(char *const, size_t const);
static void initHiddenItems(int const);
static void defHiddenImages(void), defHiddenRefers(void);
static void prIndex(void), prMonStats(char *const);
static void prMonIndex(char *const, int const, int const);
static void prFrameHeader(char *const);
static void prSiteStats(char *const, char *const);
static void prURLStats(char *const, char *const);
static void prAgentStats(char *const, char *const);
static void prReferStats(char *const, char *const);
static void prFileURL(FILE *const, NLIST *const);
static void prRefURL(FILE *const, NLIST *const);
static void prURLencoded(FILE *const, char *const, char const *);
static void prEscHTML(FILE *const, char const *);
static void prCGI(FILE *const, size_t const, int, int, char *, char const *);
static void prDayStats(char *const);
static void prTopList(FILE *const, TOP_COUNTER *const, size_t const, int const);
static void prIdxTab(FILE *const, FILE *const, COUNTER *const, int const, COUNTER *const, COUNTER *const);
static void prHidden(FILE *const, NLIST **const, size_t const, size_t const, COUNTER *const, int const);
static void prItem(FILE *const, NLIST **const, size_t const, size_t const, COUNTER *const);
static void prString(FILE *const, FILE *const, int, char *const, char *const, char *const, ...);
static void openTable(FILE *const, FILE *const, int const, char const *, char const *, ...);
static void closeTable(FILE *const, FILE *const);
static void prTblHead(FILE *const, FILE *const, char const *, char *const, char *const);
static void prTblRow(FILE *const, FILE *const, char const *, int const, char *const,
		     COUNTER *const, COUNTER *const, COUNTER *const);
static void revDomain(char *, size_t const, char *, size_t);
static void mkdtab(LOGTIME *const);
static void hideArgs(int const, char *const, char *);
static void clearItems(NLIST **const, int const);
static void clearCounter(int const);
static void writeHistory(int const);
static int mkPrivdir(char *const, char *const);
static int sort_by_hits(const void *, const void *);
static int sort_by_item(const void *, const void *);
static int sort_by_agent(const void *, const void *);
static int sort_by_refer(const void *, const void *);
static int sort_by_cntry(const void *, const void *);
static int sort_by_casestr(const void *, const void *);
static int sort_by_string(const void *, const void *);
static int isSelfRefer(char *const, size_t const);
static int isHiddenItem(NLIST *const), isHiddenSite(NLIST *const);
static int isHiddenAgent(NLIST *const), isHiddenRefer(NLIST *const);
static int isIgnoredItem(int const, HSTRING *const);
static int readHistory(int const, LOGTIME *const);
static int readConfigFile(char *const, char *const);
static int writeConfigFile(char *const, char *const);
static int setLogFmt(char *const);
static int parseDate(LOGTIME *const, u_short const, char *const);


#if defined(VRML)
static void prVRMLModel(char *const, char *const, char *const);
extern int prVRMLStats(FILE *const, char *const, char *const, LOGTIME *const);
extern int prVRMLYear(FILE *const, char *const, char *const, LOGTIME *const);
#endif

#if !defined(USE_FGETS)
int readLine(char *, size_t, FILE *const);
#endif

#if defined(USE_XPGCAT)
# define MNLS_TYPE	"XPG4 MNLS"
#elif defined(USE_SVR4CAT)
# define MNLS_TYPE	"SVR4 MNLS"
#elif defined(USE_MYCAT)
# define MNLS_TYPE	"native MNLS"
#else
# define MNLS_TYPE	"no MNLS"
#endif

#if defined(OLD_GDLIB)
# define GD_IMGTYPE	"GIF"		/* compatibility kludge (GD version < 1.6) */
#else
# define GD_IMGTYPE	"PNG"		/* preferred format now is PNG (GD version > 1.5) */
# define PNG_SITE	"http://www.cdrom.com/pub/png/"	/* where to find out more about PNG */
#endif

/*
** Print program version.
*/
static void prVersion(SRVINFO *const sysinfo, char *const rcsinfo, LIC_INFO *const lic) {
	char lbuf[MEDIUMSIZE];
	char vbuf[SMALLSIZE];

	if (rcsinfo) {
		if (lic)
			(void) snprintf(lbuf, sizeof lbuf, "%s %s (%s)\n",
				GETMSG(1, "Registered for"), lic->company, lic->regID);
		else	(void) snprintf(lbuf, sizeof lbuf,
				GETMSG(2, "Evaluation copy - see %s\n"), ha_reg);
	}
	(void) snprintf(vbuf, sizeof vbuf, VERSION "pl%d", PATCHLEVEL);

	prmsg(0, "%s %s (%s; %s %s; " MNLS_TYPE "; " GD_IMGTYPE ")\n"
		 "Copyright %hu by RENT-A-GURU(TM)\n%s%s%s",
		progname, vbuf,
		sysinfo->machine ? sysinfo->machine : "-",
		sysinfo->sysname ? sysinfo->sysname : "-",
		sysinfo->release ? sysinfo->release : "",
		t.current.year,
		rcsinfo ? rcsinfo : "", rcsinfo ? "\n" : "", rcsinfo ? lbuf : "");
	return;
}

/*
** Initialize strings.
*/
static void initStrings(void) {
	/* Week starts at Monday for calculations */
	daynam[0] = GETMSG(338, "Mon");
	daynam[1] = GETMSG(339, "Tue");
	daynam[2] = GETMSG(340, "Wed");
	daynam[3] = GETMSG(341, "Thu");
	daynam[4] = GETMSG(342, "Fri");
	daynam[5] = GETMSG(343, "Sat");
	daynam[6] = GETMSG(344, "Sun");

	monnam[0] = GETMSG(345, "January");
	monnam[1] = GETMSG(346, "February");
	monnam[2] = GETMSG(347, "March");
	monnam[3] = GETMSG(348, "April");
	monnam[4] = GETMSG(349, "May");
	monnam[5] = GETMSG(350, "June");
	monnam[6] = GETMSG(351, "July");
	monnam[7] = GETMSG(352, "August");
	monnam[8] = GETMSG(353, "September");
	monnam[9] = GETMSG(354, "October");
	monnam[10] = GETMSG(355, "November");
	monnam[11] = GETMSG(356, "December");

	hidden[HIDDEN_SITES].what  = GETMSG(453, "sitename");
	hidden[HIDDEN_ITEMS].what  = GETMSG(454, "URL");
	hidden[HIDDEN_REFERS].what = GETMSG(455, "referrer URL");
	hidden[HIDDEN_AGENTS].what = GETMSG(456, "user agent");

	ReqMethod[0].msg = GETMSG(457, "Unknown request method");
	RespCode[0].msg  = GETMSG(458, "Unknown response");

	return;
}

/*
** Print an usage message.
*/
#define OPTSTRING ":hdmrBVX3aefgknqvxyMb:c:i:l:o:p:s:t:u:w:C:D:E:F:G:H:I:L:O:P:R:S:T:U:W:Z:"

static char usage[] =
	"    %s [-{hdmBVX}] [-3aefgnqvxyM] [-b bufsize] [-c cfgfile]\n"
	"\t[-i newcfg] [-l libdir] [-o outdir] [-p prvdir] [-s subopt,...]\n"
	"\t[-t num,...]  [-u time] [-w hits] [-F logfmt] [-L lang] [-C chrset]\n"
	"\t[-I date] [-E date] [-G suffix,...]  [-H idxfile,...]  [-O vname,...]\n"
	"\t[-P prolog] [-R docroot] [-S srvname] [-T TLDfile] [-U srvurl]\n"
	"\t[-W 3Dwin] [-Z showdom] [logfile ...]\n\n";

static void pusage(int const help, SRVINFO *const sinfo) {
	if (versonly)
		prVersion(sinfo, NULL, NULL);

	(void) fputs(GETMSG(3, "Usage:\n"), stderr);
	(void) fprintf(stderr, usage, progname);

	if (!help) {
		(void) fprintf(stderr, GETMSG(4, "Use `%s -h' for a help list.\n\n"), progname);
		return;
	}
	(void) fputs(GETMSG(5, "\t-h\t\tprint this help list\n"), stderr);
	(void) fputs(GETMSG(6, "\t-d\t\tgenerate short statistics (\"daily\" mode)\n"), stderr);
	(void) fputs(GETMSG(7, "\t-m\t\tgenerate full statistics (\"monthly\" mode, default)\n"), stderr);
	(void) fputs(GETMSG(176,"\t-B\t\tcreate buttons and files only and exit\n"), stderr);
	(void) fputs(GETMSG(8, "\t-V\t\tprint program version and exit\n"), stderr);
	(void) fputs(GETMSG(184,"\t-X\t\tprint URL to file a bug report and exit\n"), stderr);
	(void) fputs(GETMSG(9, "\t-3\t\tcreate a VRML 2.0 compliant 3D model\n"), stderr);
	(void) fputs(GETMSG(10, "\t-a\t\tignore requests which required authentication\n"), stderr);
	(void) fputs(GETMSG(11, "\t-e\t\tuse history data even in full statistics mode\n"), stderr);
	(void) fputs(GETMSG(12, "\t-f\t\tcreate an additional frames-based interface\n"), stderr);
	(void) fputs(GETMSG(13, "\t-g\t\t\"generic\" interface: no navigation panel\n"), stderr);
	(void) fputs(GETMSG(14, "\t-n\t\tcompletely ignore the history data\n"), stderr);
	(void) fputs(GETMSG(15, "\t-q\t\tinclude arguments in CGI URLs\n"), stderr);
	(void) fputs(GETMSG(16, "\t-v\t\tincrement the verbosity level\n"), stderr);
	(void) fputs(GETMSG(17, "\t-x\t\tdon't collect images under \"All images\"\n"), stderr);
	(void) fputs(GETMSG(18, "\t-y\t\tprint timing stats (if timing code is compiled in)\n"), stderr);
	(void) fputs(GETMSG(177,"\t-M\t\tMS IIS mode: URLs are case-insensitive\n"), stderr);
	(void) fputs(GETMSG(180,"\t-b bufsize\tdefines the size of the I/O buffer (default: 64KB)\n"), stderr);
	(void) fputs(GETMSG(19, "\t-c cfgfile\tpathname of the configuration file\n"), stderr);
	(void) fputs(GETMSG(73, "\t-i newcfg\tcreate a new config file and exit\n"), stderr);
	(void) fputs(GETMSG(20, "\t-l libdir\tdirectory with buttons and support files\n"), stderr);
	(void) fputs(GETMSG(21, "\t-o outdir\tdirectory to use for the statistics report\n"), stderr);
	(void) fputs(GETMSG(22, "\t-p prvdir\tsubdirectory (private area) for detailed lists\n"), stderr);
	if (help < 2) {
		(void) fputs(GETMSG(24, "\t-s opt,...\tsuppress parts of the report"), stderr);
		(void) fprintf(stderr, " %s",
			GETMSG(23, "(`-hh' for more help)\n"));
		(void) fputs(GETMSG(25, "\t-t num,...\tsize of top N lists"), stderr);
		(void) fprintf(stderr, " %s",
			GETMSG(23, "(`-hh' for more help)\n"));
	}
	(void) fputs(GETMSG(26, "\t-u time\t\ttime-window for unique sessions (default: one day)\n"), stderr);
	(void) fputs(GETMSG(27, "\t-w hits\t\tset the noise-level (hits skipped in overview lists)\n"), stderr);
	(void) fputs(GETMSG(31, "\t-I date\t\tskip entries until this date (DD/MM/YYYY or MM/YYYY)\n"), stderr);
	(void) fputs(GETMSG(32, "\t-E date\t\tskip entries after this date (DD/MM/YYYY or MM/YYYY)\n"), stderr);
	(void) fputs(GETMSG(28, "\t-F logfmt\tlogfile format, may be one of auto, clf, dlf, elf\n"), stderr);
	(void) fputs(GETMSG(78, "\t-L lang\t\tLanguage to use for messages\n"), stderr);
	(void) fputs(GETMSG(79, "\t-C chrset\tCharacter set to use in reports\n"), stderr);
	(void) fputs(GETMSG(29, "\t-G suffix,...\tpageview suffixes (in addition to `.html')\n"), stderr);
	(void) fputs(GETMSG(30, "\t-H idxfile,...\tdirectory index filenames (in addition to `index.html')\n"), stderr);
	(void) fputs(GETMSG(33, "\t-O virtname,...\tadditional virtual names for this server\n"), stderr);
	(void) fputs(GETMSG(34, "\t-P prolog\tpathname of the prolog file for yearly 3D models\n"), stderr);
	(void) fputs(GETMSG(35, "\t-R docroot\tname of the document root to restrict analysis to\n"), stderr);

	(void) fprintf(stderr, "%s %s\n", GETMSG(36, "\t-S srvname\tthe official server name:"), sinfo->hostname);
	(void) fputs(GETMSG(37, "\t-T tldfile\tfile containing a list of all top-level domains\n"), stderr);
	(void) fprintf(stderr, "%s http://%s/\n", GETMSG(38, "\t-U srvurl\tthe server's URL:"), sinfo->hostname);
	(void) fputs(GETMSG(39, "\t-W 3Dwin\t3D window (extern/intern, default: extern)\n"), stderr);
	(void) fputs(GETMSG(185, "\t-Z showdom\tthe no. of subdomains to display in domain lists\n"), stderr);

	if (help > 1) {
		(void) fputs(GETMSG(40, "\t-s subopt,...\tdefine `subopt' to suppress ...\n"), stderr);
		(void) fputs(GETMSG(41, "\t   AVLoad\tthe average load (top hour/min/sec)\n"), stderr);
		(void) fputs(GETMSG(42, "\t   URLs\t\tthe overview of URLs/items\n"), stderr);
		(void) fputs(GETMSG(43, "\t   URLList\tthe list of all URLs grouped by item\n"), stderr);
		(void) fputs(GETMSG(44, "\t   Code404\tthe list of Code 404 (NotFound) responses\n"), stderr);
		(void) fputs(GETMSG(45, "\t   Sites\tthe overview of client domains\n"), stderr);
		(void) fputs(GETMSG(46, "\t   RSites\tthe overview of reverse client domains\n"), stderr);
		(void) fputs(GETMSG(47, "\t   SiteList\tthe list of all hostnames\n"), stderr);
		(void) fputs(GETMSG(48, "\t   Agents\tthe overview/list of browser types\n"), stderr);
		(void) fputs(GETMSG(49, "\t   Referrer\tthe overview/list of referrer URLs\n"), stderr);
		(void) fputs(GETMSG(50, "\t   Country\tthe list of countries\n"), stderr);
		(void) fputs(GETMSG(51, "\t   Pageviews\tPageview rating\n"), stderr);
		(void) fputs(GETMSG(52, "\t   AuthReq\trequests which required authentication\n"), stderr);
		(void) fputs(GETMSG(53, "\t   Graphics\timages such as graphs and pie charts\n"), stderr);
		(void) fputs(GETMSG(54, "\t   Hotlinks\thotlinks in the list of all URLs\n"), stderr);
		(void) fputs(GETMSG(55, "\t   Interpol\tinterpolation of values in graphs\n"), stderr);
		(void) fputs(GETMSG(56, "\t-t num,...\tdefine size of Top N lists:\n"), stderr);
		(void) fputs(GETMSG(57, "\t   #U\t\tnumber of entries in Top N URL list (30)\n"), stderr);
		(void) fputs(GETMSG(58, "\t   #L\t\tnumber of entries in Least N URL list (10)\n"), stderr);
		(void) fputs(GETMSG(59, "\t   #S\t\tnumber of entries in Top N domain list (30)\n"), stderr);
		(void) fputs(GETMSG(60, "\t   #A\t\tnumber of entries in Top N browser list (30)\n"), stderr);
		(void) fputs(GETMSG(61, "\t   #R\t\tnumber of entries in Top N referrer URL list (30)\n"), stderr);
		(void) fputs(GETMSG(62, "\t   #d\t\tnumber of entries in Top N days list (7)\n"), stderr);
		(void) fputs(GETMSG(63, "\t   #h\t\tnumber of entries in Top N hours list (24)\n"), stderr);
		(void) fputs(GETMSG(64, "\t   #m\t\tnumber of entries in Top N minutes list (5)\n"), stderr);
		(void) fputs(GETMSG(65, "\t   #s\t\tnumber of entries in Top N seconds list (5)\n"), stderr);
		(void) fputs(GETMSG(66, "\t   #N\t\tsize of navigation frame in pixels (120)\n\n"), stderr);
	}
	(void) fputs(GETMSG(67, "\tlogfile ...\tname(s) of the logfile(s) or `-' for stdin\n\n"), stderr);
	return;
}


/*
** m a i n function
*/
int main(int const argc, char **const argv) {
	extern char *optarg;		/* option processing */
	extern int optind;
	char *cp, *ep;			/* temp */
	char tbuf[MAX_FNAMELEN];	/* filename templates */
	char *cfg_file = NULL;		/* name of cfg file */
	char *init_cfg = NULL;		/* initialize config file */
	char *lib_dir = NULL;		/* directory for configuration files */
	char *cur_dir = NULL;		/* initial directory */
	char *sub_dir = NULL;		/* subdir (per year) for output files */
	char *locale = NULL;		/* current locale */
	size_t wday = 0;		/* current weekday */
	int cc, errflg = 0;		/* set if invalid option */
	int hflg=0;			/* controls verbosity of usage message */
	int cur_p = 0;			/* set if period is current month */
	int nlogf = 0;			/* number of logfiles */
	int disorder = 0;		/* set if disorder has been detected */
	long lval;			/* temp values */
	u_long cur_tick = 0LU;		/* tick counter for days, hours, minutes, seconds */
	u_long max_tick = 0LU;		/* maximum tick detected in order */
	u_long last_tick[4] = { 0LU, 0LU, 0LU, 0LU };
	struct tm *tp;			/* current (local) time */
	COUNTER	delta;			/* counter values per entry */
	HSTRING *sref;			/* for self referrers */
	LOGENT *entry;			/* current logfile entry */
	NLIST *np = NULL;		/* namelist */
	FILE *lfp = NULL;		/* logfile */
	SRVINFO *srvinfo;
	time_t now = time(NULL);	/* get current time */
#if defined(WIN32)
	HKEY	rHandle;
	char	lbuf[LBUFSIZE];
	DWORD	kType, bSize = LBUFSIZE;
#endif

#if defined(TIME_STATS)
	struct timeval tvs, tve;
	long asec = 0L, rsec = 0L;

	(void) gettimeofday(&tvs, NULL);	/* measure execution time */
#endif
#if defined(WIN32)
	if ((progname = strrchr(argv[0], '\\')) != NULL)
		progname++;			/* save program name */
	else	progname = argv[0];

	if ((cc = strlen(progname)) > 4) {
		cc -= 4;
		if (streq(progname+cc, ".exe"))
			progname[cc] = '\0';
	}

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Rent-A-Guru\\HttpAnalyze",
			 NULL, KEY_QUERY_VALUE, &rHandle) == ERROR_SUCCESS) {
		bSize= LBUFSIZE;
		if (RegQueryValueEx(rHandle, "InstallLocation", NULL, &kType, lbuf, &bSize) == ERROR_SUCCESS) {
			strcat(lbuf, "\\files");
			lib_dir = strsave(lbuf);
		}
		RegCloseKey(rHandle);
	}
#else
	/*
	** Save program name and set reasonable default for libdir.
	** The latter one may be overwritten using the option -l
	** or the environment variable HA_LIBDIR.
	*/
	if ((progname = strrchr(argv[0], '/')) != NULL)
		progname++;			/* save program name */
	else	progname = argv[0];
	lib_dir = HA_LIBDIR;
#endif

	/*
	** Use hardcoded version number
	*/
	(void) snprintf(tbuf, sizeof tbuf, "%s %s", progname, VERSION);
	if ((creator=strsave(tbuf)) == NULL)	/* the "can't happen" case */
		creator = "http-analyze " VERSION;

	/*
	** Overwrite the default settings from the environment.
	*/
	if ((cp = getenv("HA_CONFIG")) != NULL)
		cfg_file = cp;
	if ((cp = getenv("HA_LIBDIR")) != NULL)
		lib_dir = cp;

	/*
	** Get language setting and open msg catalog
	*/
#if defined(USE_MYCAT)
	if ((cp = getenv("HA_LANG")) != NULL && cp[0] == 'C' && cp[1] == '\0')
		cp = NULL;
	if (cp && (locale = mycatopen(lib_dir, cp)) == NULL)
		prmsg(1, "Couldn't set message catalog from the environment\n");

#elif defined(USE_XPGCAT) || defined(USE_SVR4CAT)
	if ((locale = setlocale(LC_MESSAGES, "")) != NULL && locale[0] == 'C' && locale[1] == '\0')
		locale = NULL;

	if (locale && !MSGCAT_OPEN("http-analyze"))
		prmsg(1, "Couldn't set locale from the environment\n");
#endif

	/*
	** Get current time, set the date
	*/
	tp = localtime(&now);			/* define time-dependend strings */
	(void) strftime(tbuf, sizeof tbuf, "%d/%b/%Y:%T", tp);
	if (!setDate(&t.current, tbuf)) {	/* set the current date */
		prmsg(2, "%s `%s'\n", GETMSG(68, "Can't parse the current date:"), tbuf);
		exit(1);
	}
	(void) snprintf(copyright, sizeof copyright,
			"Copyright &#169; %hu by RENT-A-GURU&#174;", t.current.year);
	(void) strftime(tbuf, sizeof tbuf, "%d/%b/%Y %H:%M", tp);
	last_update = strsave(tbuf);		/* save string for display in HTML pages */

	srvinfo = myHostName();			/* initialize server name */
	indexpg[ipnum++].str = "/index.html";	/* name of default index file */
	pvtab[ptnum++].str = ".html";		/* suffixes for text pages */

	/* initialize font list */
	(void) memset((void *)font, 0, sizeof font);
	font[FONT_HEAD].face = font[FONT_TEXT].face = font[FONT_SMALL].face = deffont;

	/* process options */
	while ((cc = getopt(argc, argv, OPTSTRING)) != EOF) {
		switch (cc) {
		  default:	errflg++;
				(void) fprintf(stderr, "%s %c\n",
						GETMSG(406, "illegal option --"), optopt);
				break;

		  case ':':	errflg++;
				(void) fprintf(stderr, "%s %c\n",
						GETMSG(407, "option requires an argument --"), optopt);
				break;

		  case 'h':	errflg++; hflg++; break; /* print help only */
		  case 'r':	regonly++;	 break;	/* save registration ID */
		  case 'B':	btnonly++;	 break;	/* create buttons only */
		  case 'V':	versonly++;	 break; /* print version only */
		  case 'X':	bugrep++;	 break;	/* print URL for bugreport only */

		  case 'd':	/*FALLTHROUGH*/		/* operation mode */
		  case 'm':	if (monthly >= 0) {
					prmsg(2, GETMSG(69, "Options -d and -m are mutually exclusive\n"));
					exit(1);
				}
				monthly = (cc == 'd' ? 0 : 1);
				break;

		  case '3':	use_vrml++;	 break;	/* generate 3D model */
		  case 'a':	sptab[SP_AUTHREQ].ison = 0; break; /* ignore auth req URLs */
		  case 'e':	use_hist++;	 break;	/* use values from history */
		  case 'f':	use_frames++;	 break;	/* generate also HTML frames */
		  case 'g':	nonavpanel++;	 break;	/* don't create navigation panel */
		  case 'k':	noautohide++;	 break;	/* don't automatically add base URLs as hidden items */
		  case 'n':	nohist++;	 break;	/* don't use history */
		  case 'q':	nocgistrip++;	 break;	/* don't strip CGI arguments */
		  case 'v':	verbose++;	 break;	/* be verbose */
		  case 'x':	nodefhid++;	 break;	/* don't hide default items */
		  case 'y':	timestats++;	 break;	/* print elapsed time */
		  case 'M':	msiis_mode++;	 break;	/* IIS: URLs are case-insensitive */

		  case 'c':	cfg_file=optarg; break;	/* configuration file */
		  case 'i':	init_cfg=optarg; break;	/* initialize config file */
		  case 'l':	lib_dir=optarg;  break;	/* directory for configuration files */
		  case 'o':	out_dir=optarg;  break;	/* directory for output files */
		  case 'p':	priv_dir=optarg; break; /* private dir for site/URL lists */
		  case 'u':	time_win=optarg; break; /* time-window for session */
		  case 'D':	cur_tim=optarg;  break; /* fake current time (debugging only) */
		  case 'I':	ign_date=optarg; break; /* ignore entries until this date */
		  case 'E':	end_date=optarg; break; /* ignore entries from this date on */
		  case 'F':	log_format=optarg;break;/* logfile format */
		  case 'L':	language=optarg; break; /* language to use */
		  case 'C':	htmlcset=optarg; break; /* HTML character set */
		  case 'P':	vrml_prlg=optarg;break; /* VRML prolog file */
		  case 'R':	virt_root=optarg;break; /* virtual DocRoot */
		  case 'S':	srv_name=optarg; break; /* server name */
		  case 'T':	tld_file=optarg; break;	/* Top Level Domains */
		  case 'U':	srv_url=optarg;  break; /* prefix for hot links */
		  case 'W':	if (*optarg == 'i' || *optarg == 'I')
					vrml_win = INT_WIN;	/* VRML window type */
				break;

		  case 'G':	cp = strtok(optarg, ", ");
				do {	/* parse additional pageview suffixes */
					if (ptnum < TABSIZE(pvtab))
						pvtab[ptnum++].str = cp;
					else	prmsg(1, "%s `%s'\n", GETMSG(70,
							"Too many pageview definitions, ignore"), cp);
				} while ((cp=strtok(NULL, ", ")) != NULL);
				break;

		  case 'H':	cp = strtok(optarg, ", ");
				do {	/* parse additional index filenames */
					if (ipnum < TABSIZE(indexpg))
						indexpg[ipnum++].str = cp;
					else	prmsg(1, "%s `%s'\n", GETMSG(71,
							"Too many index filenames, ignore"), cp);
				} while ((cp=strtok(NULL, ", ")) != NULL);
				break;

		  case 'O':	cp = strtok(optarg, ", ");
				do {	/* additional virtual server names */
					if ((sref = validURL(cp, NULL)) == NULL) {
						if ((sref = validURL(cp, "https://")) != NULL)
							addSelfRefer(sref->str, sref->len);
						sref = validURL(cp, "http://");
					}
					if (sref)
						addSelfRefer(sref->str, sref->len);
				} while ((cp=strtok(NULL, ", ")) != NULL);
				break;

		  case 'b':	if ((lval = strtol(optarg, &ep, 10)) <= 0 || ep == cp) {
					prmsg(1, "%s %c: `%s'\n",
						GETMSG(72, "Illegal value for"), cc, optarg);
					++errflg;
				} else {
					switch (*ep) {
					  default:	best_iosize = lval;		break;
					  case 'b':	/*FALLTHROUGH*/
					  case 'B':	best_iosize = lval * 512L;	break;
					  case 'k':	/*FALLTHROUGH*/
					  case 'K':	best_iosize = lval * 1024L;	break;
					  case 'm':	/*FALLTHROUGH*/
					  case 'M':	best_iosize = lval * 1048576L;	break;
					}
				}
				break;

		  case 'w':	if ((lval = strtol(optarg, &ep, 10)) < 0 || ep == cp) {
					prmsg(1, "%s %c: `%s'\n",
						GETMSG(72, "Illegal value for"), cc, optarg);
					++errflg;
				} else
					noiselevel = (int)lval;
				break;

		  case 'Z':	if ((lval = strtol(optarg, &ep, 10)) < 0 || ep == cp) {
					prmsg(1, "%s %c: `%s'\n",
						GETMSG(72, "Illegal value for"), cc, optarg);
					++errflg;
				} else
					show_domain = (int)lval;
				break;

		  case 's':	cp = strtok(optarg, ", ");
				do {
					size_t idx;
					for (idx=0; idx < SP_MAX; idx++)
						if (streq(cp, sptab[idx].subopt)) {
							sptab[idx].ison = 0;
							break;
						}

					if (idx == SP_MAX) {
						prmsg(2, "%s %c: `%s'\n",
							GETMSG(72, "Illegal value for"), cc, cp);
						++errflg;
						break;
					}
				} while ((cp=strtok(NULL, ", ")) != NULL);
				break;

		  case 't':	cp = strtok(optarg, ", ");
				do {
					if ((lval = strtol(cp, &ep, 10)) < 0)
						ep = cp;
					else if (ep > cp) {
						switch(*ep) {
						  case 'U':	topn_urls  = (int)lval;	break;
						  case 'L':	lstn_urls  = (int)lval;	break;
						  case 'S':	topn_sites = (int)lval;	break;
						  case 'A':	topn_agent = (int)lval;	break;
						  case 'R':	topn_refer = (int)lval;	break;
						  case 'N':	nav_frame  = (int)lval;	break;
						  case 'd':	topn_day   = (int)lval;	break;
						  case 'h':	topn_hrs   = (int)lval;	break;
						  case 'm':	topn_min   = (int)lval;	break;
						  case 's':	topn_sec   = (int)lval;	break;
						  default:	ep = cp;		break;
						}
					}
					if (ep == cp) {
						prmsg(2, "%s -%c: `%s'\n", GETMSG(72, "Illegal value for"), cc, cp);
						++errflg;
					}
				} while ((cp=strtok(NULL, ", ")) != NULL);
				break;
		}
	}
	if (errflg) {				/* print usage and exit */
		pusage(hflg, srvinfo);
		exit(!hflg);
	}

	if (regonly) {				/* save registration ID */
		if ((cc = argc-optind) < 2 || cc > 3) {
			prmsg(0, "%s", GETMSG(75,
				"Use the command:\n\n\thttp-analyze -r \"company name\" registration_ID [free|comm]\n\n"
				"to install the registration ID and optionally the registration images.\n"
				"If specified, 'free' installs the images for the freeware (personal)\n"
				"version, while 'comm' installs the images for the commercial version\n"
				"if they have been unpacked in the current directory according to the\n"
				"instructions in the email.\n"));
			exit(1);
		}
		if (cc == 3) {
			if (!mkRegBtn(lib_dir, argv[optind+2], BTN_NETSTORESW) ||
			    !mkRegBtn(lib_dir, argv[optind+2], BTN_NETSTORESB))
				exit(1);

			prmsg(0, GETMSG(183, "Installed registration images in `%s'\n"), lib_dir);
		}
		if (!saveRegID(lib_dir, argv[optind], argv[optind+1])) {
			prmsg(0, "%s `%s'\n", GETMSG(76,
				"Couldn't write registration information into file"), REGID_FILE);
			exit(1);
		}
		prmsg(0, "%s `%s'\n", GETMSG(77,
			"Registration information saved in file"), REGID_FILE);
		exit(0);
	}
	lic = getRegID(lib_dir, NULL, NULL);
	if (versonly) {			/* print version and exit */
		prVersion(srvinfo, rcs_id, lic);
		exit(0);
	}
	if (verbose)
		prVersion(srvinfo, NULL, NULL);

#if !defined(TIME_STATS)
	if (timestats) {
		prmsg(0, GETMSG(80, "Timing code not compiled in, -y ignored\n"));
		timestats = 0;
	}
#endif
#if !defined(VRML)
	if (use_vrml) {
		prmsg(0, GETMSG(81, "VRML code not compiled in, -3 ignored\n"));
		use_vrml = 0;
		vrml_prlg = NULL;
	}
#endif
	if ((cur_dir=getcwd(NULL, 256)) == NULL) {
		prmsg(2, "%s (%s)?\n",
			GETMSG(82, "Couldn't determine current directory"), strerror(errno));
		exit(1);
	}
	/* read config file, process option directives */
	if (cfg_file && !readConfigFile(cfg_file, init_cfg)) {
		prmsg(2, GETMSG(83, enoent), cfg_file, strerror(errno));
		exit(1);
	}

	/* print URL to file a bugreport only, assume complete registration */
	if (bugrep) {
		(void) snprintf(tbuf, sizeof tbuf, "%s; %s %s; " MNLS_TYPE,
			srvinfo->machine ? srvinfo->machine : "-",
			srvinfo->sysname ? srvinfo->sysname : "-",
			srvinfo->release ? srvinfo->release : "");

		if (lic) {		/* only fill in data if available */
			(void) fputs(ha_bug, stdout);
			prURLencoded(stdout, "customer", lic->company);
			prURLencoded(stdout, "regID", lic->regID);
			prURLencoded(stdout, "version", creator);
			prURLencoded(stdout, "platform", tbuf);
			(void) fputc('\n', stdout);
		} else
			(void) fprintf(stdout, "file:%s/bugreport.html\n", lib_dir);
		exit(0);
	}

	/*
	** Overwrite language set in the environment
	** with value from cmd line or config file.
	*/
	if (language && language[0] == 'C' && language[1] == '\0')
		language = NULL;

#if defined(USE_XPGCAT) || defined(USE_SVR4CAT) || defined(USE_MYCAT)
	if (language) {
#  if defined(MSGCAT_CLOSE)
		if (locale) MSGCAT_CLOSE;
#  endif
# if defined(USE_MYCAT)
		if ((locale = mycatopen(lib_dir, language)) == NULL)
			prmsg(1, GETMSG(135,
				"Couldn't install message catalog for language `%s'\n"), language);
# else
		locale = setlocale(LC_MESSAGES, language);
		if (locale && !MSGCAT_OPEN("http-analyze"))
			prmsg(1, GETMSG(135,
				"Couldn't install message catalog for language `%s'\n"), language);
# endif
	}
#endif
	initStrings();		/* initialize all localized static strings */

	/* conditionally create a localized buttons directory */
	if (locale) {
		(void) snprintf(tbuf, sizeof tbuf, "btn-%s", locale);
		if ((btn_dir = strsave(tbuf)) != NULL) {
			(void) snprintf(tbuf, sizeof tbuf, "%s/%s", lib_dir, btn_dir);
			if (access(tbuf, F_OK) < 0)
				btn_dir = NULL;
		}
	}

	/* check for accessibility of all logfiles before reading data */
	if ((nlogf = argc-optind) > 0) {
		errflg = 0;
		for (cc=optind; cc < argc; cc++) {
			if (argv[cc][0] == '-' && argv[cc][1] == '\0')
				continue;

			cp = argv[cc];
			if (!ISFULLPATH(cp)) { /* *cp != '/' */
				(void) snprintf(tbuf, sizeof tbuf, "%s/%s", cur_dir, argv[cc]);
				cp = tbuf;
			}
			errno = 0;
			if (access(cp, F_OK) < 0) {
				prmsg(2, GETMSG(84, enoacc), argv[cc], strerror(errno));
				errflg++;
			}
		}
		if (errflg)
			exit(1);

		log_file = (argv[optind][0] == '-' && !argv[optind][1]) ? NULL : argv[optind];

	} else if ((cp = log_file) != NULL) {
		if (!ISFULLPATH(cp)) { /* *cp != '/' */
			(void) snprintf(tbuf, sizeof tbuf, "%s/%s", cur_dir, log_file);
			cp = tbuf;
		}
		errno = 0;
		if (access(cp, F_OK) < 0) {
			prmsg(2, GETMSG(84, enoacc), log_file, strerror(errno));
			exit(1);
		}
	}
	if (log_format && (logfmt=setLogFmt(log_format)) < 0) {
		prmsg(2, "%s `%s'\n", GETMSG(85, "Unknown logfile format:"), log_format);
		exit(1);
	}

	/* make sure private directory is a subdirectory of OutputDir */
	if (priv_dir && ISANYPATH(priv_dir)) {
		prmsg(2, GETMSG(86, "The name of the private directory (%s)"
				    " may not contain slashes.\n"), priv_dir);
		exit(1);
	}

	/* set defaults for some parameters not specified */
	if (!srv_name)				/* set default server name */
		srv_name = srvinfo->hostname;
	else if (validURL(srv_name, NULL) != NULL) {
		prmsg(2, GETMSG(87, "The server name (%s) must be a"
				    " domain name, not an URL.\n"), srv_name);
		exit(1);
	}

	/* try to construct selfref URL from srv_url or srv_name */
	if (srv_url) {				/* also massage server URL if given */
		if ((sref = validURL(srv_url, NULL)) == NULL)
			sref = validURL(srv_url, "http://");
		if (sref) {
			addSelfRefer(sref->str, sref->len);
			srv_url = sref->str;	/* set as selref, overwrite srv_url */
		}
	} else if (srv_name) {
		if ((sref = validURL(srv_name, NULL)) == NULL)
			sref = validURL(srv_name, "http://");
		if (sref)		/* set as selref, don't change srv_name */
			addSelfRefer(sref->str, sref->len);
	}

	/* install default hidden items unless we are creating a config file */
	if (!nodefhid && !init_cfg)
		defHiddenImages();

	/* install default hidden referrers unless we are creating a config file */
	if (sptab[SP_REFERRER].ison && !init_cfg)
		defHiddenRefers();

	/* save number of pre-defined hidden items */
	hidden[HIDDEN_ITEMS].t_start = hidden[HIDDEN_ITEMS].t_count;
	hidden[HIDDEN_SITES].t_start = hidden[HIDDEN_SITES].t_count;
	hidden[HIDDEN_AGENTS].t_start = hidden[HIDDEN_AGENTS].t_count;
	hidden[HIDDEN_REFERS].t_start = hidden[HIDDEN_REFERS].t_count;

	if (!doc_title) {
		(void) snprintf(tbuf, sizeof tbuf, "%s %s",
				GETMSG(88, "Access Statistics for"), srv_name);
		if ((doc_title = strsave(tbuf)) == NULL)
			doc_title = "Access Statistics";
	}

	if (monthly < 0)		/* set default mode of operation */
		monthly = 1;

	if (noiselevel < 0)
		noiselevel = 0;

	uniq_stime = TICKS_PHOUR(24);	/* default: 24 hours */
	if (time_win) {			/* set time window for user sessions */
		if ((lval = strtol(time_win, &ep, 10)) >= 0 && ep > time_win) {
			while (*ep == ' ') ep++;
			switch (*ep) {
			  case '\0':	/*FALLTHROUGH*/
			  case 't':	/*FALLTHROUGH*/
			  case 'T':	/*FALLTHROUGH*/
			  case 's':	/*FALLTHROUGH*/
			  case 'S':	uniq_stime = TICKS_PSEC(lval);	break;
			  case 'm':	/*FALLTHROUGH*/
			  case 'M':	uniq_stime = TICKS_PMIN(lval);	break;
			  case 'h':	/*FALLTHROUGH*/
			  case 'H':	uniq_stime = TICKS_PHOUR(lval);	break;
			  case 'd':	/*FALLTHROUGH*/
			  case 'D':	uniq_stime = TICKS_PDAY(lval);	break;
			  default:	ep = time_win;	break;
			}
		}
		if (ep == time_win || uniq_stime > TICKS_PMON(1)) {
			prmsg(1, GETMSG(89,
				"Invalid time-window for sessions: %s (using 24h)\n"), time_win);
			uniq_stime = TICKS_PHOUR(24);
		}
	}

	/* set default font and sizes */
	if (!font[FONT_LISTS].fsize)
		font[FONT_LISTS].fsize = 2;
	if (!font[FONT_TEXT].fsize)
		font[FONT_TEXT].fsize = 2;
	if (!font[FONT_SMALL].fsize)
		font[FONT_SMALL].fsize = 1;

	if (show_domain < 0)		/* levels of subdomains to show */
		show_domain = 2;
	else if (show_domain < 1 || show_domain > 5) {
		prmsg(1, GETMSG(74,
			"Invalid level of subdomains to show: %d ([1-5], using 2)\n"), show_domain);
		show_domain = 2;
	}

	if (nav_frame < 0)		/* frame navigation column size in pixels */
		nav_frame = 124;
	else if (nav_frame < 80 || nav_frame > 160) {
		prmsg(1, GETMSG(90,
			"Invalid navigation frame size: %d ([80-160], using 124)\n"), nav_frame);
		nav_frame = 124;
	}

	if (navwid < 0 && navht < 0) {	/* size of navigation window */
		navwid = 420;
		navht = 190;
	} else if (navwid < 100 || navwid > 1280) {
		prmsg(1, GETMSG(91,
			"Invalid navigation window size: %dx%d (using 420x190)\n"), navwid, navht);
		navwid = 420;
		navht = 190;
	} else if (navht < 50 || navht > 1024) {
		prmsg(1, GETMSG(91,
			"Invalid navigation window size: %dx%d (using 420x190)\n"), navwid, navht);
		navwid = 420;
		navht = 190;
	}

	if (w3wid < 0 && w3ht < 0) {	/* size of 3D window */
		w3wid = 520;
		w3ht = 420;
	} else if (w3wid < 420 || w3wid > 1280) {
		prmsg(1, GETMSG(92,
			"Invalid 3D window size: %dx%d (using 520x420)\n"), w3wid, w3ht);
		w3wid = 520;
		w3ht = 420;
	} else if (w3ht < 220 || w3ht > 1024) {
		prmsg(1, GETMSG(92,
			"Invalid 3D window size: %dx%d (using 520x420)\n"), w3wid, w3ht);
		w3wid = 520;
		w3ht = 420;
	}

	initTLD(tld_file);	/* initialize list of top-level domains */

	/* Add default dimensions for top lists, allocate space */
	if (topn_sites < 0)	topn_sites = 30;
	if (topn_urls < 0)	topn_urls = 30;
	if (lstn_urls < 0)	lstn_urls = 10;
	if (topn_agent < 0)	topn_agent = 30;
	if (topn_refer < 0)	topn_refer = 30;

	if (topn_day < 0)	topn_day = 7;
	if (topn_hrs < 0)	topn_hrs = 24;
	if (topn_min < 0)	topn_min = 5;
	if (topn_sec < 0)	topn_sec = 5;

	if (topn_sites > 0)
		top_sites = (NLIST **)calloc((size_t)topn_sites, sizeof(NLIST *));
	if (topn_urls > 0)
		top_urls = (NLIST **)calloc((size_t)topn_urls, sizeof(NLIST *));
	if (lstn_urls > 0)
		lst_urls = (NLIST **)calloc((size_t)lstn_urls, sizeof(NLIST *));
	if (topn_agent > 0)
		top_agent = (NLIST **)calloc((size_t)topn_agent, sizeof(NLIST *));
	if (topn_refer > 0)
		top_refer = (NLIST **)calloc((size_t)topn_refer, sizeof(NLIST *));
	if (topn_day > 0)
		top_day = (TOP_COUNTER *)calloc((size_t)topn_day, sizeof(TOP_COUNTER));
	if (topn_hrs > 0)
		top_hrs = (TOP_COUNTER *)calloc((size_t)topn_hrs, sizeof(TOP_COUNTER));
	if (topn_min > 0)
		top_min = (TOP_COUNTER *)calloc((size_t)topn_min, sizeof(TOP_COUNTER));
	if (topn_sec > 0)
		top_sec = (TOP_COUNTER *)calloc((size_t)topn_sec, sizeof(TOP_COUNTER));

	if ((topn_sites && !top_sites) || (topn_urls && !top_urls) ||
	    (topn_agent && !top_agent) || (topn_refer && !top_refer) ||
	    (lstn_urls && !lst_urls) ||
	    (topn_day && !top_day) || (topn_hrs && !top_hrs) ||
	    (topn_min && !top_min) || (topn_sec && !top_sec)) {
		prmsg(2, GETMSG(337, enomem),
			topn_sites+topn_urls+topn_agent+topn_refer+lstn_urls);
		exit(1);
	}

	for (cc=0; cc < (int)ipnum; cc++) {
		if (*indexpg[cc].str == '\0') {
			prmsg(2, GETMSG(93,
				"Invalid zero length name for index file.\n"));
			exit(1);
		}
		if (*indexpg[cc].str != '/') {	/* add slash if filename fits into tbuf */
			if (strlen(indexpg[cc].str) >= sizeof(tbuf)-1) {
				prmsg(2, GETMSG(94,
				"Additional index filenames must begin with a slash.\n"));
				exit(1);
			}
			(void) snprintf(tbuf, sizeof tbuf, "/%s", indexpg[cc].str);
			indexpg[cc].str = strsave(tbuf);
		}
		indexpg[cc].len = indexpg[cc].str ? strlen(indexpg[cc].str) : 0;
	}

	if (!sptab[SP_PAGEVIEWS].ison)
		ptnum = 0;
	else for (cc=0; cc < (int)ptnum; cc++) {
		size_t tlen = strlen(pvtab[cc].str);

		/* check for valid item, correct if necessary */
		if ((pvtab[cc].len = tlen) < 2) {
			prmsg(2, GETMSG(95, "Invalid pageview prefix/suffix.\n"));
			exit(1);
		}
		if (*pvtab[cc].str != '/' && *pvtab[cc].str != '.') {
			if (tlen >= sizeof(tbuf)-2) {	/* try to prepend a dot */
				prmsg(2, GETMSG(96,
					"Pageview items must start with a dot ('.') or a slash ('/').\n"));
				exit(1);
			}
			(void) snprintf(tbuf, sizeof tbuf, ".%s", pvtab[cc].str);
			pvtab[cc].str = strsave(tbuf);
			pvtab[cc].len++;
		}
	}

	/*
	** Check for DocumentRoot of virtual server or virtual hostname.
	*/
	if (virt_root != NULL) {
		if (*virt_root == '!') {
			drneg++;
			virt_root++;
		}
		if ((vrlen = strlen(virt_root)) == 0) {
			prmsg(2, GETMSG(97,
				"Invalid zero length name for virtual document root/hostname.\n"));
			exit(1);
		}
		if (*virt_root != '/') {	/* set virtual host */
			virt_host = virt_root;
			virt_root = NULL;
		}
	}

	/*
	** Create configuration file if requested.
	** Must be last action of cmd line processing.
	*/
	if (init_cfg != NULL)
		exit(writeConfigFile(init_cfg, locale));

	/*
	** Start analyzing data.
	** Clear all counters, set the dates.
	*/
	clearCounter(1);

	if (cur_tim && !parseDate(&t.current, t.current.year, cur_tim)) {
		prmsg(2, GETMSG(98, "Can't parse the current date: `%s'"
				    " (use [DD/]MM/YYYY)\n"), cur_tim);
		exit(1);
	}
	if (ign_date && !parseDate(&t.ignore, t.current.year, ign_date)) {
		prmsg(2, GETMSG(99, "Can't parse the start date: `%s'"
				    " (use [DD/]MM/YYYY)\n"), ign_date);
		exit(1);
	}
	if (end_date && !parseDate(&t.brk, t.current.year, end_date)) {
		prmsg(2, GETMSG(100, "Can't parse the end date: `%s'"
				     " (use [DD/]MM/YYYY)\n"), end_date);
		exit(1);
	}

	/* change into the HTML directory if given */
	if (out_dir && chdir(out_dir) != 0) {
		prmsg(2, GETMSG(101,
			"Can't change into output directory `%s'\n"), out_dir);
		exit(1);
	}

	/*
	** Create button directories. We have a standard
	** directory and probably a localized version.
	*/
	if (!mkBtnDir(lib_dir, "btn", btn_symlink))
		exit(1);

	if (!btn_dir)
		btn_dir = "btn";
	else if (!mkBtnDir(lib_dir, btn_dir, btn_symlink))
		exit(1);

	/*
	** Check for buttons and files, create them if missing.
	*/
	maxbtn = checkForFiles(lib_dir, btn_dir, ha_home,
				btn_symlink, (use_frames || btnonly));
	if (maxbtn != BTN_CUSTOMW && maxbtn != BTN_CUSTOMB)
		lic = NULL;

	if (btnonly) {
		if (btn_missing) {
			prmsg(2, GETMSG(178, "Could not find all buttons in %s/%s\n"),
				lib_dir, btn_dir);
			exit(1);
		}
		if (verbose)
			prmsg(0, GETMSG(179, "All buttons and files have been installed\n"));
		exit(0);
	}

	if (use_frames && btn_missing) {
		prmsg(1, GETMSG(109,
			"Frames creation disabled due to missing buttons\n"));
		use_frames = 0;
	}
	if (use_vrml && vrml_prlg) {
		errno = 0;
		if (access(vrml_prlg, R_OK) < 0) {
			if (verbose)
				prmsg(0, GETMSG(110,
					"Can't find VRML prolog file `%s' (%s)\n"),
					vrml_prlg, strerror(errno));
			vrml_prlg = NULL;	/* disable yearly model */
		}
	}

	if (verbose) {
		if (vrlen && out_dir)
			(void) snprintf(tbuf, sizeof tbuf, GETMSG(102,
				"for virthost `%s' in output directory `%s'"),
				virt_root ? virt_root : virt_host, out_dir);
		else if (out_dir)
			(void) snprintf(tbuf, sizeof tbuf, GETMSG(103,
				"in output directory `%s'"), out_dir);
		else if (vrlen)
			(void) snprintf(tbuf, sizeof tbuf, GETMSG(104,
				"for virthost `%s'"), virt_root ? virt_root : virt_host);
		else	(void) strcpy(tbuf, GETMSG(105, "in current directory"));

		if (!monthly)
			prmsg(0, GETMSG(106, "Generating short statistics %s\n"), tbuf);
		else
			prmsg(0, GETMSG(107, "Generating full statistics %s\n"), tbuf);
	}

	/*
	** Now read the history to speed up processing.
	** If doing a monthly summary, delay reading of
	** the history file until we could determine the
	** start time unless user requested to not do so.
	*/
	if (!monthly) {
		if (!t.ignore.mday) {
			t.ignore = t.current;
			t.ignore.mday = 1;	/* tick back to first day of month */
		}
		t.end = t.ignore;
		if (!nohist)			/* adjust ignore time from history */
			(void) readHistory(0, &t.end);
		if (!ign_date)
			t.ignore = t.end;
	} else if (use_hist) {
		t.end = t.current;
		t.end.mday = 1;			/* tick back to first day of month */
		(void) readHistory(2, &t.end);
		t.ignore = t.end;
	}

	/*
	** Read the logfiles. Remember the last day done in t.end.
	** For monthly stats, get summary period from first logfile
	** entry read. Save start time of period in t.start.
	*/
	if (verbose) {
		if (t.ignore.mday)
			prmsg(0, GETMSG(111,
				"Skip all entries until %02hu/%3.3s/%04hu\n"),
				t.ignore.mday, monnam[t.ignore.mon], t.ignore.year);
		if (t.brk.mday)
			prmsg(0, GETMSG(112,
				"Stop processing at %02hu/%3.3s/%04hu\n"),
				t.brk.mday, monnam[t.brk.mon], t.brk.year);
		prmsg(0, GETMSG(113, "Reading data from `%s'\n"),
			(log_file ? log_file : "stdin"));
	}

	errflg = 0;
	do {
		if (nlogf > 0) {
			--nlogf;
			lnum = 0L;			/* reset line number */
			log_file = argv[optind++];
			if (*log_file == '-' && *(log_file+1) == '\0')
				log_file = NULL;
		}
		if (log_file) {
			if (!ISFULLPATH(log_file) && cur_dir) {
				(void) snprintf(tbuf, sizeof tbuf, "%s/%s", cur_dir, log_file);
				errno = 0;
				lfp = fopen(tbuf, "r");
			} else {
				errno = 0;
				lfp = fopen(log_file, "r");
			}
			if (lfp == NULL) {
				prmsg(2, GETMSG(83, enoent), log_file, strerror(errno));
				break;
			}
		}

		while ((entry=readLog(lfp ? lfp : stdin, &t.ignore, &t.brk)) != NULL) {
			if (t.ignore.mday)
				t.ignore.mday = 0;

			if (t.start.mday == 0) {		/* we have no history so we use the */
				t.start = t.end = entry->tm;	/* first entry to determine the month */
				if (verbose)
					prmsg(0, GETMSG(114,
						"Start new period at %02hu/%3.3s/%04hu\n"),
						t.start.mday, monnam[t.start.mon], t.start.year);
				if (monthly) {
					(void) readHistory(1, &t.start);
					t.start.mday = 1;	/* tick back to beginning of month */
				}
				mkdtab(&t.start);
			} else if (entry->tm.year > t.start.year || entry->tm.mon > t.start.mon) {
				assert(monthly != 0);

				insertTop(&cday, top_day, topn_day);
				insertTop(&chrs, top_hrs, topn_hrs);
				insertTop(&cmin, top_min, topn_min);
				insertTop(&csec, top_sec, topn_sec);
				last_tick[0] = last_tick[1] = last_tick[2] = last_tick[3] = 0LU;
				if (verbose == 2)
					(void) fputc('\n', stderr);
#if defined(TIME_STATS)
				if (timestats) {
					(void) gettimeofday(&tve, NULL);
					rsec += (tve.tv_sec-tvs.tv_sec) * TICKS_PMSEC;
					rsec -= tvs.tv_usec/TICKS_PMSEC;
					rsec += tve.tv_usec/TICKS_PMSEC;
				}
#endif
				sub_dir = mkSubdir("www", t.end.year);
				if (priv_dir && !mkPrivdir(sub_dir, priv_dir)) {
					sptab[SP_URLS].ison = sptab[SP_SITES].ison = 0;
					sptab[SP_AGENTS].ison = sptab[SP_REFERRER].ison = 0;
					prmsg(1, GETMSG(334,
						"Can't create private lists directory `%s'.\n"
						"The detailed lists will be omitted "
						"from the report.\n"), priv_dir);
					priv_dir = NULL;	/* suppress lists & msg */
				}
				cur_p = (t.end.year == t.current.year && t.end.mon == t.current.mon);
				prMonStats(sub_dir);		/* year or month wrap */
				prMonIndex(sub_dir, cur_p, 0);
				if (!nohist)
					writeHistory(1);

				if (verbose) {
					u_long skipped = corrupt + ignored + reqempty + reqinval;

					if (!sptab[SP_AUTHREQ].ison)
						skipped += reqauth;

					prmsg(0, GETMSG(115, "Total entries read: %lu, processed: %lu\n"),
						total.hits + skipped, total.hits);

					if (skipped)
						prmsg(0, GETMSG(116,
							"Skipped: %lu corrupt, %lu ignored, %lu empty,"
							" %lu invalid, %lu auth\n"), corrupt, ignored,
							reqempty, reqinval,
							!sptab[SP_AUTHREQ].ison ? reqauth : 0L);
				}

				/* prepare for new period */
				clearCounter(0);
				clearItems(sitetab, TABSIZE(sitetab));
				clearItems(urltab, TABSIZE(urltab));
				clearItems(uatab, TABSIZE(uatab));
				clearItems(reftab, TABSIZE(reftab));
				clearItems(errtab, TABSIZE(errtab));
				initHiddenItems(HIDDEN_SITES);
				initHiddenItems(HIDDEN_ITEMS);
				initHiddenItems(HIDDEN_AGENTS);
				initHiddenItems(HIDDEN_REFERS);
				clearCountry();

				t.start = entry->tm;
				t.start.mday = 1; /* tick back to beginning of month */
				if (verbose) {
					prmsg(0, GETMSG(117,
						"Clear almost all counters at %02hu/%3.3s/%04hu\n"
						"Start new period at %02hu/%3.3s/%04hu\n"),
						t.end.mday, monnam[t.end.mon], t.end.year,
						t.start.mday, monnam[t.start.mon], t.start.year);
				}
				if (errflg) {
					errflg = 0;
					if (verbose)
						prmsg(0, GETMSG(118, "Now reading data from `%s'\n"),
							(log_file ? log_file : "stdin"));
				}
				t.end = entry->tm;
				mkdtab(&t.start);

#if defined(TIME_STATS)
				if (timestats) {
					(void) gettimeofday(&tvs, NULL);
					asec += (tvs.tv_sec-tve.tv_sec) * TICKS_PMSEC;
					asec -= tve.tv_usec/TICKS_PMSEC;
					asec += tvs.tv_usec/TICKS_PMSEC;
				}
#endif
			} else if (entry->tm.year < t.start.year ||
				   entry->tm.mon < t.end.mon || entry->tm.mday < t.end.mday) {
				if (monthly && verbose == 2)
					(void) fputc('\n', stderr);
				prmsg(1, GETMSG(119, "Disorder detected, skip entries from"
					" %02hu/%3.3s/%04hu to %02hu/%3.3s/%04hu (%s)\n"),
					entry->tm.mday, monnam[entry->tm.mon], entry->tm.year,
					t.end.mday, monnam[t.end.mon], t.end.year,
					log_file ? log_file : "stdin");
				t.ignore = t.end;
				ignored++;
				continue;
			} else {
				if (errflg) {
					errflg = 0;
					if (verbose)
						prmsg(0, GETMSG(118, "Now reading data from `%s'\n"),
							(log_file ? log_file : "stdin"));
				}
				if (t.end.mday != entry->tm.mday) {	/* remember last day done */
					t.end.mday = entry->tm.mday;
					ndays++;
					if (verbose == 2)
						(void) fputc('.', stderr);
				}
			}

			/*
			** Classify the entry, update counters later
			*/
			delta.hits = 1L;
			delta.files = delta.nomod = delta.views = delta.sessions = 0L;
			delta.bytes = (float)entry->reqsize;

			if (IS_METHOD(entry->ftype, METHOD_GET) ||
			    IS_METHOD(entry->ftype, METHOD_POST)) {
				if (entry->respidx == IDX_OK) {
					delta.files++;
					if (IS_TYPE(entry->ftype, TYPE_PGVIEW))
						delta.views++;
				} else if (entry->respidx == IDX_NOT_MODIFIED) {
					delta.nomod++;
					if (IS_TYPE(entry->ftype, TYPE_PGVIEW))
						delta.views++;
				}
			}

			/*
			** Check for known sitename, determine new session.
			*/
			np = lookupItem(sitetab, &entry->sitename, entry->sitename.len-entry->tldomain.len);
			if (np == NULL) {		/* no more memory, count as new & unique */
				uniq_sites++;
				delta.sessions++;
			} else {
				if (!np->cnt.hits) {			/* brand new */
					uniq_sites++;			/* sum of unique sites */
					if (entry->tldomain.len)	/* skips also TYPE_NODNS */
						saveHiddenItem(HIDDEN_SITES, &entry->tldomain);
				}

				if (IS_METHOD(entry->ftype, METHOD_GET) ||
				    IS_METHOD(entry->ftype, METHOD_POST)) {
					if (np->ltick < entry->ltick-uniq_stime) {	/* new session */
						if (verbose > 3 && np->ltick) {
							u_short day, hour, min, sec;
							u_long delta_t = entry->ltick - np->ltick;

							day = (u_short)(delta_t / (24LU * 60LU * 62LU));
							delta_t %= 24LU * 60LU * 62LU;
							hour = (u_short)(delta_t / (60LU * 62LU));
							delta_t %= 60LU * 62LU;
							min = (u_short)(delta_t / 62L);
							sec = (u_short)(delta_t % 62L);
							prmsg(0, GETMSG(120,
								"\tnew session after %hu.%02hu:%02hu:%02hu\n"),
								day, hour, min, sec);
						}
						np->ltick = entry->ltick;	/* stamp it */
						delta.sessions++;
					}
				}
				UPDATE_CNT(np->cnt, delta);			/* update counters */
				np->ftype = entry->ftype;			/* save type */
			}

			/*
			** Check for method and response type.
			*/
			if (!IS_METHOD(entry->ftype, METHOD_GET) &&
			    !IS_METHOD(entry->ftype, METHOD_POST)) {
				size_t idx = (size_t)(entry->ftype&METHOD_MASK);
				if (idx >= TABSIZE(ReqMethod))
					idx = 0;
				UPDATE_CNT(ReqMethod[idx].cnt, delta);
			} else if (entry->respidx != IDX_OK && entry->respidx != IDX_NOT_MODIFIED) {
				UPDATE_CNT(RespCode[entry->respidx].cnt, delta);
				if (monthly && entry->respidx == IDX_NOT_FOUND) {
					np = lookupItem(errtab, &entry->request, 0);
					if (np != NULL)			/* update Code 404 counters */
						UPDATE_CNT(np->cnt, delta);
				}
			} else if (monthly) {	/* GET or POST and IDX_OK or IDX_NOT_MODIFIED */
				/*
				** Check for known URL, save it.
				*/
				np = lookupItem(urltab, &entry->request, entry->reqbase.len);
				if (np == NULL || !np->cnt.hits) {	/* no mem or brand new */
					uniq_urls++;
					if (!noautohide && entry->reqbase.len)
						saveHiddenItem(HIDDEN_ITEMS, &entry->reqbase);
				}

				if (np != NULL) {			/* update counters */
					UPDATE_CNT(np->cnt, delta);
					if (entry->respidx == IDX_OK && entry->reqsize > np->size)
						np->size = entry->reqsize; /* adjust doc size */
				}
			}

			/*
			** Update the counters
			*/
			wday = wdtab[entry->tm.mday-1];		/* compute weekday */

			UPDATE_CNT(total, delta);
			UPDATE_CNT(daily[entry->tm.mday-1], delta);
			UPDATE_CNT(weekly[wday], delta);

			wh_hits[wday][entry->tm.hour]++;	/* account for hour & weekday */
			avg_hour[entry->tm.hour]++;

			if (!monthly)
				continue;			/* done already for short statistics */

			/*
			** Check for known user agent and referrer URL, save them.
			*/
			if (logfmt == LOGF_ELF || logfmt == LOGF_NCSA) {
				if (!entry->uagent.str || *entry->uagent.str == '\0') {
					UPDATE_CNT(unknown[HIDDEN_AGENTS], delta);
				} else {
					np = lookupItem(uatab, &entry->uagent, entry->uatype.len);
					if (np != NULL) {
						if (!np->cnt.hits) {
							total_agents++;	/* brand new */
							if (entry->uatype.len)	/* skips also agents w/o version  */
								saveHiddenItem(HIDDEN_AGENTS, &entry->uatype);
						}
						UPDATE_CNT(np->cnt, delta);	/* update counters */
						np->ftype = entry->ftype;	/* save type */
					}
				}
				if (!entry->refer.str || *entry->refer.str == '\0') {
					UPDATE_CNT(unknown[HIDDEN_REFERS], delta);
				} else {
					np = lookupItem(reftab, &entry->refer, entry->refhost.len);
					if (np != NULL) {
						if (!np->cnt.hits) {	/* brand new */
							total_refer++;
							if (entry->refhost.len)
								saveHiddenItem(HIDDEN_REFERS, &entry->refhost);
						}
						UPDATE_CNT(np->cnt, delta);	/* update counters */
						np->ftype = entry->ftype;	/* save type */
					}
				}
			}

			/*
			** Now the top counters.
			** Compute "ticks" to count top seconds, minutes, and hours.
			*/
			if (entry->ltick < max_tick) {		/* disorder detected */
				if (!disorder && verbose) {
					if (monthly && verbose == 2)
						(void) fputc('\n', stderr);
					prmsg(1, GETMSG(186, "Disorder detected: the Top "
						"Hours/Minutes/Seconds may be inaccurate\n"));
					disorder = 1;
				}
			} else {
				max_tick = entry->ltick;
				cur_tick = entry->ltick % TICKS_PMON(1);
				if (cur_tick-last_tick[0] >= TICKS_PDAY(1)) {	/* day changed */
					insertTop(&cday, top_day, topn_day);
					last_tick[0] = cur_tick - cur_tick % TICKS_PDAY(1);
				}
				if (cur_tick-last_tick[1] >= TICKS_PHOUR(1)) {	/* hour changed */
					insertTop(&chrs, top_hrs, topn_hrs);
					last_tick[1] = cur_tick - cur_tick % TICKS_PHOUR(1);
				}
				if (cur_tick-last_tick[2] >= TICKS_PMIN(1)) {	/* minute changed */
					insertTop(&cmin, top_min, topn_min);
					last_tick[2] = cur_tick - cur_tick % TICKS_PMIN(1);
				}
				if (cur_tick != last_tick[3]) {		/* second has changed */
					insertTop(&csec, top_sec, topn_sec);
					last_tick[3] = cur_tick;
				}
				UPDATE_CNT(cday.cnt, delta);
				UPDATE_CNT(chrs.cnt, delta);
				UPDATE_CNT(cmin.cnt, delta);
				UPDATE_CNT(csec.cnt, delta);
				cday.tm = chrs.tm = cmin.tm = csec.tm = entry->tm;
			}
		}
		if (lfp != NULL) {
			(void) fclose(lfp);
			lfp = NULL;
		}
		errflg = 1;
		if (monthly && verbose == 2)
			(void) fputc('\n', stderr);
	} while (nlogf > 0);

	if (monthly) {
		insertTop(&cday, top_day, topn_day);
		insertTop(&chrs, top_hrs, topn_hrs);
		insertTop(&cmin, top_min, topn_min);
		insertTop(&csec, top_sec, topn_sec);
		last_tick[0] = last_tick[1] = last_tick[2] = last_tick[3] = 0L;
	}

	if (this_hits == 0L && total.hits == 0L) {
		if (verbose) {
			u_long skipped = corrupt + ignored + reqempty + reqinval;
			if (!sptab[SP_AUTHREQ].ison)
				skipped += reqauth;

			if (skipped)
				prmsg(1, GETMSG(121, "Ignored all %lu logfile entries?!?\n"), skipped);
			else	prmsg(1, GETMSG(122, "No hits at all?!?\n"));
		}
		exit(0);
	}

#if defined(TIME_STATS)
	if (timestats) {
		(void) gettimeofday(&tve, NULL);
		rsec += (tve.tv_sec-tvs.tv_sec) * TICKS_PMSEC;
		rsec -= tvs.tv_usec/TICKS_PMSEC;
		rsec += tve.tv_usec/TICKS_PMSEC;
	}
#endif

	if (t.start.mday == t.end.mday && total.hits < 30 && this_hits > (total.hits*10)) {
		if (verbose)
			prmsg(0, GETMSG(123,
				"Let the dust settle down: ignore %lu hits since %02hu/%3.3s/%04hu\n"),
				total.hits, t.end.mday, monnam[t.end.mon], t.end.year);
	} else {
		sub_dir = mkSubdir("www", t.end.year);
		if (priv_dir && !mkPrivdir(sub_dir, priv_dir)) {
			sptab[SP_URLS].ison = sptab[SP_SITES].ison = 0;
			sptab[SP_AGENTS].ison = sptab[SP_REFERRER].ison = 0;
			prmsg(1, GETMSG(334,
				"Can't create private lists directory `%s'.\n"
				"The detailed lists will be omitted from the report.\n"), priv_dir);
			priv_dir = NULL;	/* suppress lists & msg */
		}

		cur_p = (t.end.year == t.current.year && t.end.mon == t.current.mon);
		if (cur_p) {			/* summary period is current month */
			if (t.end.mday < t.current.mday || t.end.mday == t.ignore.mday) {
				if (verbose)
					prmsg(0, GETMSG(124, "No more hits since %02hu/%3.3s/%04hu\n"),
						t.end.mday, monnam[t.end.mon], t.end.year);
				t.end.mday = t.current.mday;	 /* in case there were no hits since then */
			}
			if (monthly && t.current.mday > 1)
				prMonStats(sub_dir);	/* full summary */
			prDayStats(sub_dir);		/* short summary */
			prMonIndex(sub_dir, cur_p, 0);
			if (!nohist)
				writeHistory(0);
		} else if (monthly) {			/* previous periods */
			int leap = t.end.year%4 == 0 && (t.end.year%100 != 0 || t.end.year%400 == 0);
			if (t.end.mday != mdays[leap][t.end.mon]) {
				if (verbose)
					prmsg(0, GETMSG(124, "No more hits since %02hu/%3.3s/%04hu\n"),
						t.end.mday, monnam[t.end.mon], t.end.year);
				t.end.mday = mdays[leap][t.end.mon];
			}
			prMonStats(sub_dir);		/* full summary */
			prMonIndex(sub_dir, cur_p, 1);
			if (!nohist)
				writeHistory(1);
		}
		if (verbose) {
			u_long skipped = corrupt + reqempty + reqinval;

			if (monthly)
				skipped += ignored;	/* already accountet for in daily mode */

			if (!sptab[SP_AUTHREQ].ison)
				skipped += reqauth;

			prmsg(0, GETMSG(115, "Total entries read: %lu, processed: %lu\n"),
				total.hits + skipped, total.hits);

			if (skipped)
				prmsg(0, GETMSG(116,
					"Skipped: %lu corrupt, %lu ignored, %lu empty,"
					" %lu invalid, %lu auth\n"), corrupt, ignored,
					reqempty, reqinval,
					!sptab[SP_AUTHREQ].ison ? reqauth : 0L);
		}
		if (verbose && t.end.mday)
			prmsg(0, GETMSG(125, "Statistics complete until %02hu/%3.3s/%04hu\n"),
				t.end.mday, monnam[t.end.mon], t.end.year);
	}
	prIndex();					/* update the (new) main index file */

#if defined(TIME_STATS)
	if (timestats) {
		(void) gettimeofday(&tvs, NULL);	/* measure execution time */
		asec += (tvs.tv_sec-tve.tv_sec) * TICKS_PMSEC;
		asec -= tve.tv_usec/TICKS_PMSEC;
		asec += tvs.tv_usec/TICKS_PMSEC;
		this_hits += total.hits;		/* sum up this month' hits */

		prmsg(0, GETMSG(126, "\n"
			"Time to process %lu entries: %ld.%03ld sec (%lu hits/sec)\n"
			"Time to create the summary: %ld.%03ld sec\n"),
			this_hits, rsec/TICKS_PMSEC, rsec%TICKS_PMSEC,
			(u_long)((float)this_hits/(((float)rsec/(float)TICKS_PMSEC))),
			asec/TICKS_PMSEC, asec%TICKS_PMSEC);

		rsec += asec;
		prmsg(0, GETMSG(127, "Total time elapsed: %ld.%03ld sec (%lu hits/sec)\n\n"),
			rsec/TICKS_PMSEC, rsec%TICKS_PMSEC,
			(u_long)((float)this_hits/(((float)rsec/(float)TICKS_PMSEC))));
	}
#endif
	/*
	** Clean up. Although technically not necessary here,
	** freeing allocated memory enables us to detect memory
	** leaks elsewhere.
	*/
	clearItems(sitetab, TABSIZE(sitetab));
	clearItems(urltab, TABSIZE(urltab));
	clearItems(uatab, TABSIZE(uatab));
	clearItems(reftab, TABSIZE(reftab));
	clearItems(errtab, TABSIZE(errtab));

	clearItems(hlist[HIDDEN_ITEMS], HIDELIST_SIZE);
	clearItems(hlist[HIDDEN_SITES], HIDELIST_SIZE);
	clearItems(hlist[HIDDEN_AGENTS], HIDELIST_SIZE);
	clearItems(hlist[HIDDEN_REFERS], HIDELIST_SIZE);

	if (top_sites != NULL)
		free(top_sites);
	if (top_refer != NULL)
		free(top_refer);
	if (top_agent != NULL)
		free(top_agent);
	if (top_urls != NULL)
		free(top_urls);
	if (lst_urls != NULL)
		free(lst_urls);
	if (last_update != NULL)
		free(last_update);

#if defined(MSGCAT_CLOSE)
	if (locale) MSGCAT_CLOSE;
#endif
	return 0;
}

/*
** Find month by name.
*/
static u_short findMonth(char *const str) {
	size_t idx;

	for (idx=0; idx < 12; idx++) {
		if (strneq(monnam[idx], str, 3))
			break;
	}
	return (u_short)(idx < 12 ? idx+1 : 0);
}

/*
** Parse the date.
**
** date-spec [- [date-spec]]	range from date-spec1 to date-spec2 (default: today)
** -date-spec			range from start of first logfile entry until date-spec
**
** date-spec:
**	Full specification:	01/Oct/[19]97, 01/10/[19]97
**	Day defaults to 1st:	Oct/97, 10/97, Oct, 10
**	Year defaults to tcur:	01/Oct, 01/10
*/
static int parseDate(LOGTIME *const tp, u_short const cyear, char *const str) {
	u_short tmday=0, tmon=0, tyear=0;
	int leap, rc = 0;
	char smon[5];

	tp->year = tp->mon = tp->mday = 0;

	if ((rc = sscanf(str, "%2hu/%2hu/%4hu", &tmday, &tmon, &tyear)) == 3) {
		tp->mday = tmday;
		tp->mon = tmon;
		tp->year = tyear;
	} else if ((rc = sscanf(str, "%2hu/%3s/%4hu", &tmday, smon, &tyear)) == 3) {
		tp->mday = tmday;
		tp->mon = findMonth(smon);
		tp->year = tyear;
	} else if ((rc = sscanf(str, "%2hu/%4hu", &tmon, &tyear)) == 2) {
		tp->mday = 1;
		tp->mon = tmon;
		tp->year = tyear;
	} else if ((rc = sscanf(str, "%2hu/%3s", &tmday, smon)) == 2) {
		tp->mday = tmday;
		tp->mon = findMonth(smon);
		tp->year = cyear;
	} else if ((rc = sscanf(str, "%3s/%4hu", smon, &tyear)) == 2) {
		tp->mday = 1;
		tp->mon = findMonth(smon);
		tp->year = tyear;
	} else if ((rc = sscanf(str, "%2hu", &tmon)) == 1) {
		tp->mday = 1;
		tp->mon = tmon;
		tp->year = cyear;
	} else if ((rc = sscanf(str, "%3s", smon)) == 1) {
		tp->mday = 1;
		tp->mon = findMonth(smon);
		tp->year = cyear;
	}
	if (rc < 0 || !tp->mon || tp->mon > 12)
		return 0;

	tp->mon--;			/* adjust month [0,11], set defaults */
	if (tp->year < 100)
		tp->year += (tp->year < 69) ? 2000 : 1900;

	leap = tp->year%4 == 0 && (tp->year%100 != 0 || tp->year%400 == 0);
	return tp->mday && tp->mday <= mdays[leap][tp->mon];
}

/*
** Check for output subdirectory
*/
static char *mkSubdir(char *const templ, u_short const year) {
	static char dirnam[MAX_FNAMELEN];

	(void) snprintf(dirnam, sizeof dirnam, "%s%hu", templ, year);
	if (access(dirnam, W_OK) != 0) {
		errno = 0;
		if (mkdir(dirnam, 0777) < 0) {
			prmsg(2, GETMSG(128, "Couldn't create subdirectory `%s' (%s)\n"),
				dirnam, strerror(errno));
			exit(1);
		}
		if (verbose)
			prmsg(0, GETMSG(129, "NOTE: output files will be "
				 "created in subdirectory `%s'\n"), dirnam);
	}
	return (char *)dirnam;
}

/*
** Check for private directory
*/
static int mkPrivdir(char *const subd, char *const privd) {
	char dirnam[MAX_FNAMELEN];

	(void) snprintf(dirnam, sizeof dirnam, "%s/%s", subd, privd);
	errno = 0;
	return mkdir(dirnam, 0777) == 0 || errno == EEXIST;
}

/*
** Insert item into top counter.
*/
static void insertTop(TOP_COUNTER *const cp, TOP_COUNTER tp[], int const max) {
	int idx, minidx = 0;
	u_long mincnt = ~0UL;
	float minbyt = 0.0;

	if (max <= 0 || tp == NULL) {
		CLEAR_CNT(cp->cnt);
		return;
	}

	if (!cp->cnt.hits && cp->cnt.bytes < 1.0)
		return;

	for (idx=0; idx < max; idx++) {		/* find lowest value */
		if (tp[idx].cnt.hits < mincnt || tp[idx].cnt.hits == mincnt &&
		    (minbyt < 1.0 || tp[idx].cnt.bytes < minbyt)) {
			minidx = idx;
			mincnt = tp[idx].cnt.hits;
			minbyt = tp[idx].cnt.bytes;
		}
	}
	if (cp->cnt.hits > tp[minidx].cnt.hits ||
	    cp->cnt.hits == tp[minidx].cnt.hits && cp->cnt.bytes > tp[minidx].cnt.bytes) {
		tp[minidx].cnt = cp->cnt;
		tp[minidx].tm = cp->tm;
	}
	CLEAR_CNT(cp->cnt);
	return;
}

#define PERCENT(val, max)	((val&&max) ? ((float)(val)*100.0)/(float)(max) : 0.0)
#define KBYTES(val)		((u_long)(((val)/1024.0)+0.9))
#define MBYTES(val)		((u_long)(((val)/(1024.0*1024.0))+0.9))

#define FMT_SPACE(ht)	"<TR><TD HEIGHT=\"" #ht "\"></TD></TR>\n"


/* File flags (indicate existance) */
#define	FNAME_FILES	0
#define	FNAME_LFILES	1
#define	FNAME_RFILES	2
#define	FNAME_SITES	3
#define	FNAME_LSITES	4
#define	FNAME_RSITES	5
#define	FNAME_AGENTS	6
#define	FNAME_LAGENTS	7
#define	FNAME_REFERS	8
#define	FNAME_LREFERS	9
#define	FNAME_TOPFILES	10
#define	FNAME_TOPLFILES	11
#define	FNAME_TOPSITES	12
#define	FNAME_TOPAGENTS	13
#define	FNAME_TOPREFERS	14
#define	FNAME_SIZE	15

static size_t lntab[FNAME_SIZE];

/*
** Open a file for writing, exit on failure.
*/
/*PRINTFLIKE1*/
static FILE *efopen(char *const fmt, ...) {
	static char fname[MAX_FNAMELEN];
	FILE *ofp;
	va_list ap;

	va_start(ap, fmt);
	(void) vsnprintf(fname, sizeof fname, fmt, ap);
	va_end(ap);

	errno = 0;
	if ((ofp=fopen(fname, "w")) == NULL)
		prmsg(2, GETMSG(83, enoent), fname, strerror(errno));
	return ofp;
}

/*
** Dual fprintf: writes into two files simultanously.
*/
/*PRINTFLIKE3*/
static void dfpr(FILE *const ofp, FILE *const ffp, char *const fmt, ...) {
	va_list ap;

	if (ofp != NULL) {
		va_start(ap, fmt);
		(void) vfprintf(ofp, fmt, ap);
		va_end(ap);
	}
	if (ffp != NULL) {
		va_start(ap, fmt);
		(void) vfprintf(ffp, fmt, ap);
		va_end(ap);
	}
	return;
}

/*
** Print a HTML header.
*/
/*PRINTFLIKE3*/
static void html_header(FILE *const ofp,
	char *const title, char *const period, char *const jscript, ...) {
	va_list ap;

	(void) fprintf(ofp,
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
		"<HTML>\n<HEAD>\n  <META NAME=\"ROBOTS\" CONTENT=\"NONE\">\n"
		"  <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;"
		" charset=%s\">\n", htmlcset ? htmlcset : "iso-8859-1");

	if (title && period)
		(void) fprintf(ofp, "<TITLE>%s (%s)</TITLE>\n", title, period);
	else if (title)
		(void) fprintf(ofp, "<TITLE>%s</TITLE>\n", title);

	if (jscript) {
		va_start(ap, jscript);
		(void) vfprintf(ofp, jscript, ap);
		va_end(ap);
	}
	if (!title && !period) {
		(void) fprintf(ofp, "</HEAD>\n<BODY BGCOLOR=\"#EFEFEF\">\n");
		return;
	}
	(void) fprintf(ofp, "<BASE TARGET=\"_top\">\n</HEAD>\n");

	if (html_str[HTML_HEADPFX])
		(void) fprintf(ofp, "%s\n", html_str[HTML_HEADPFX]);
	else	(void) fprintf(ofp, "<BODY BGCOLOR=\"#EFEFEF\">\n");
	if (html_str[HTML_HEADSFX])
		(void) fprintf(ofp, "\n%s\n", html_str[HTML_HEADSFX]);
	return;
}

/*
** Print an HTML trailer.
*/
static void html_trailer(FILE *const ofp) {
	if (html_str[HTML_TRAILER])
		(void) fprintf(ofp, "%s\n", html_str[HTML_TRAILER]);
	prString(ofp, NULL, FONT_HEAD1, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE BORDER=\"4\" WIDTH=\"100%\" CELLPADDING=\"0\" CELLSPACING=\"0\">\n"
		"<TR><TD><TABLE WIDTH=\"100%\" CELLPADDING=\"0\" CELLSPACING=\"0\">\n"
		"<TR><TD NOWRAP ALIGN=\"LEFT\">", "</TD>\n",
		"<A TARGET=\"_blank\" HREF=\"%s\">%s</A>", ha_home, creator);
	if (maxbtn != BTN_CUSTOMW)
		prString(ofp, NULL, FONT_HEAD1,
			"<TD NOWRAP ALIGN=\"CENTER\">", "</TD>\n", "%s", copyright);
	prString(ofp, NULL, FONT_HEAD1, "<TD NOWRAP ALIGN=\"RIGHT\">",
		"</TD></TR>\n</TABLE></TD></TR>\n</TABLE></P>\n"
		"</CENTER>\n</BODY>\n</HTML>\n", "%s", last_update);
	return;
}

/*
** Print a HTML string with FONT information.
*/
/*PRINTFLIKE6*/
static void prString(FILE *const ofp, FILE *const ffp,
	    int type, char *const pfx, char *const sfx, char *const fmt, ...) {
	va_list ap;
	int fntype = (type & 0xFF);
	char *tcol = (type & FONT_INVERSE) ? " COLOR=\"#FFFFFF\"" : "";

	switch (fntype) {	/* special cases: variable size header font */
	  case FONT_HEAD1:	fntype = FONT_VAR; font[fntype].fsize = 1;
				font[fntype].face = font[FONT_TEXT].face;
				break;
	  case FONT_HEAD2:	fntype = FONT_VAR; font[fntype].fsize = 2;
				font[fntype].face = font[FONT_TEXT].face;
				break;
	  case FONT_HEAD3:	fntype = FONT_VAR; font[fntype].fsize = 3;
				font[fntype].face = font[FONT_HEAD].face;
				break;
	  case FONT_HEAD4:	fntype = FONT_VAR; font[fntype].fsize = 4;
				font[fntype].face = font[FONT_HEAD].face;
				break;
	}

	if (pfx)
		dfpr(ofp, ffp, "%s", pfx);

	if (font[fntype].fsize && font[fntype].face)
		dfpr(ofp, ffp, "<FONT SIZE=\"%hu\"%s FACE=\"%s\">",
				font[fntype].fsize, tcol, font[fntype].face);
	else if (font[fntype].fsize)
		dfpr(ofp, ffp, "<FONT SIZE=\"%hu\"%s>", font[fntype].fsize, tcol);
	else if (font[fntype].face)
		dfpr(ofp, ffp, "<FONT FACE=\"%s\"%s>", font[fntype].face, tcol);

	if (fmt && ofp) {
		va_start(ap, fmt);
		(void) vfprintf(ofp, fmt, ap);
		va_end(ap);
	}
	if (fmt && ffp) {
		va_start(ap, fmt);
		(void) vfprintf(ffp, fmt, ap);
		va_end(ap);
	}
	if (fmt && (font[fntype].face || font[fntype].fsize))
		dfpr(ofp, ffp, "</FONT>");
	if (sfx)
		dfpr(ofp, ffp, "%s", sfx);
	return;
}

#define FONT_END(which)	((font[which].face || font[which].fsize) ? "</FONT>" : "")

/*
** Print daily table entries.
*/
static void prIdxTab(FILE *const ofp, FILE *const ffp,
	     COUNTER *const base, int const stop, COUNTER *const max, COUNTER *const avg) {
	int idx;

	openTable(ofp, ffp, 498, tblfmt[FMT_DAY], NULL);
	prTblHead(ofp, ffp, tblfmt[FMT_DAY], GETMSG(130, "Day"), NULL);

	for (idx=0; idx < stop; idx++)
		prTblRow(ofp, ffp, tblfmt[FMT_DAY], idx, NULL, &base[idx], &total, max);

	dfpr(ofp, ffp, FMT_SPACE(4));
	prTblRow(ofp, ffp, tblfmt[FMT_DAY], 0, GETMSG(131, "Total"), &total, &total, NULL);

	if (avg) {
		dfpr(ofp, ffp, FMT_SPACE(4));
		prTblRow(ofp, ffp, tblfmt[FMT_DAY], 0, GETMSG(132, "Average"), avg, &total, NULL);
	}
	closeTable(ofp, ffp);
	return;
}

/*
** Print header in table.
*/
static void prHeader(FILE *const ofp, FILE *const ffp, char *const str1, char *const str2) {
	prString(ofp, ffp, FONT_HEAD, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE WIDTH=\"100%\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n"
		"<TR><TH HEIGHT=\"24\" BGCOLOR=\"#AFAFAF\">", "</TH></TR>\n</TABLE></P>\n"
		"</CENTER>\n", !str2 ? "%s" : "%s %s", str1, str2);
	return;
}

/*
** Print daily statistics.
*/
static void prDayStats(char *const stdir) {
	char fname[MAX_FNAMELEN], period[SMALLSIZE];
	int curday;
	FILE *ofp;

	(void) snprintf(period, sizeof period, "%s %hu", monnam[t.end.mon], t.end.year);
	if (verbose)
		prmsg(0, GETMSG(133, "Creating short statistics for %s\n"), period);

	/* Compute max hits */
	for (curday=0; curday < (int)t.end.mday; curday++) {
		if (daily[curday].hits > max_day.hits)
			max_day.hits = daily[curday].hits;
		if (daily[curday].files > max_day.files)
			max_day.files = daily[curday].files;
		if (daily[curday].nomod > max_day.nomod)
			max_day.nomod = daily[curday].nomod;
		if (daily[curday].views > max_day.views)
			max_day.views = daily[curday].views;
		if (daily[curday].sessions > max_day.sessions)
			max_day.sessions = daily[curday].sessions;
		if (daily[curday].bytes > max_day.bytes)
			max_day.bytes = daily[curday].bytes;
	}
	if (max_day.bytes < 1024.0)
		max_day.bytes = 1024.0;

	if ((ofp=efopen("%s/stats.html", stdir)) == NULL)
		exit(1);

	html_header(ofp, "WWW", period, NULL);
	prHeader(ofp, NULL, GETMSG(134, "Short statistics for"), period);

	if (sptab[SP_GRAPHICS].ison) {
		(void) fprintf(ofp, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<IMG SRC=\"stats" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"317\"></P>\n</CENTER>\n",
				GETMSG(251, "Hits by Day"));

		(void) snprintf(fname, sizeof fname, "%s/stats" IMG_SFX, stdir);
		(void) mn_bars(492, 317, 28, daily, t.end.mday, 31, fname, sptab[SP_PAGEVIEWS].ison);
	}

	/* print the daily values */
	prIdxTab(ofp, NULL, daily, (int)t.current.mday, &max_day, NULL);

	prString(ofp, NULL, FONT_HEAD1, "<CENTER><P ALIGN=\"CENTER\">\n", NULL, NULL);
	if (lic) {
		prEscHTML(ofp, lic->company);
		(void) fprintf(ofp, " &#183; %s", lic->regID);
	} else {
		(void) fputs(GETMSG(136, "Evaluation version -"), ofp);
		(void) fprintf(ofp, " <A HREF=\"%s\">%s</A>", ha_reg,
				GETMSG(137, "please register your copy"));
	}
	(void) fprintf(ofp, "%s</P>\n</CENTER>\n", FONT_END(FONT_VAR));

	html_trailer(ofp);
	(void) fclose(ofp);
	return;
}

/*
** Create a table, print header.
*/
/*PRINTFLIKE5*/
static void openTable(FILE *const ofp, FILE *const ffp,
		      int const width, char const *tblfmt, char const *msg, ...) {
	char tbuf[MEDIUMSIZE];
	va_list ap;
	int cspan = 0;

	while (*tblfmt != '\0')
		switch (*tblfmt++) {
		  case 'H': case 'F': case 'C': case 'P': case 'S': case 'K':
			cspan += 2;	break;

		  case 'h': case 'f': case 'c': case 'p': case 's': case 'k':
		  case 'L': case 'l': case 'N': case 'n':
			cspan++;	break;
		}

	dfpr(ofp, ffp, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE WIDTH=\"%d\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n", width);

	if (!msg)
		return;

	dfpr(ofp, ffp, FMT_SPACE(4));
	if (cspan)
		dfpr(ofp, ffp, "<TR><TH COLSPAN=\"%d\" BGCOLOR=\"#CCCCCC\">", cspan);
	else
		dfpr(ofp, ffp, "<TR><TH BGCOLOR=\"#CCCCCC\">");

	va_start(ap, msg);
	(void) vsnprintf(tbuf, sizeof tbuf, msg, ap);
	va_end(ap);

	prString(ofp, ffp, FONT_TEXT, NULL, "</TH></TR>\n", "%s", tbuf);
	return;
}

/*
** Terminate table.
*/
static void closeTable(FILE *const ofp, FILE *const ffp) {
	dfpr(ofp, ffp, FMT_SPACE(4) "</TABLE></P>\n</CENTER>\n");
}


/*
** Print table header.
*/
static void prTblHead(FILE *const ofp, FILE *const ffp,
		      char const *tblfmt, char *const label1, char *const label2) {
	char tbuf[MEDIUMSIZE];
	u_int cspan, invtxt;
	char *chead, *bgcol;

	dfpr(ofp, ffp, FMT_SPACE(4) "<TR>");

	for ( ; *tblfmt != '\0'; tblfmt++) {
		cspan = invtxt = 0;
		chead = bgcol = NULL;

		switch (*tblfmt) {
		  case 'N':	/*FALLTHROUGH*/
		  case 'n':	bgcol = "#999999";
				chead = label1 ? label1 : GETMSG(138, "No.");
				break;

		  case 'H':	cspan = 2;	/*FALLTHROUGH*/
		  case 'h':	bgcol = "#00CC00";
				chead = GETMSG(139, "Hits");
				break;

		  case 'F':	cspan = 2;	/*FALLTHROUGH*/
		  case 'f':	bgcol = "#0000FF"; invtxt++;
				chead = GETMSG(140, "Files");
				break;

		  case 'C':	cspan = 2;	/*FALLTHROUGH*/
		  case 'c':	bgcol = "#FFFF00";
				chead  = GETMSG(141, "Cached");
				break;

		  case 'P':	cspan = 2;	/*FALLTHROUGH*/
		  case 'p':	bgcol = "#9900FF"; invtxt++;
				chead = GETMSG(142, "Pageviews");
				break;

		  case 'S':	cspan = 2;	/*FALLTHROUGH*/
		  case 's':	bgcol = "#FF0000";
				chead = GETMSG(143, "Sessions");
				break;

		  case 'K':	cspan = 2;	/*FALLTHROUGH*/
		  case 'k':	bgcol = "#FF6600";
				chead = GETMSG(144, "KB&nbsp;sent");
				break;

		  case 'L':	/*FALLTHROUGH*/
		  case 'l':	bgcol = "#999999"; chead  = label2;
				break;
		}
		if (!chead)
			continue;

		if (cspan && bgcol)
			(void) snprintf(tbuf, sizeof tbuf, "<TH COLSPAN=%u BGCOLOR=\"%s\">", cspan, bgcol);
		else if (bgcol)
			(void) snprintf(tbuf, sizeof tbuf, "<TH BGCOLOR=\"%s\">", bgcol);
		else
			(void) strcpy(tbuf, "<TH>");
		prString(ofp, ffp, invtxt ? (FONT_TEXT|FONT_INVERSE) : FONT_TEXT,
			tbuf, "</TH>\n", chead);
	}
	dfpr(ofp, ffp, "</TR>\n");
	return;
}

static void prTblRow(FILE *const ofp, FILE *const ffp,
		     char const *tblfmt, int const idx, char *const label,
		     COUNTER *const cntp, COUNTER *const sump, COUNTER *const maxp) {
	size_t align;
	int term = 1;
	u_long count;
	float pct;
	static char *tblalign[] = {
		"<TD ALIGN=\"RIGHT\">",
		"<TD ALIGN=\"RIGHT\" BGCOLOR=\"#FF0000\">",
		"<TR><TD ALIGN=\"CENTER\">",
		"<TD ALIGN=\"RIGHT\" BGCOLOR=\"#CCCCCC\">",
		"<TR><TD BGCOLOR=\"#CCCCCC\" ALIGN=\"CENTER\">"
	};

	if (!tblfmt || !cntp)
		return;

	for ( ; *tblfmt != '\0'; tblfmt++) {
		if (label && (*tblfmt == 'N' || *tblfmt == 'n')) {
			prString(ofp, ffp, FONT_TEXT,
				tblalign[4], "</TD>\n", "<B>%s</B>", label);
			continue;
		}
		if (*tblfmt == 'L' || *tblfmt == 'l') {
			term = 0;
			continue;
		}

		count = 0L;
		align = label ? 3 : 0;
		pct = -1.0;

		switch (*tblfmt) {
		  default:	continue;	/*NOTREACHED*/

		  case 'N':	/*FALLTHROUGH*/
		  case 'n':	count = idx+1L; align = 2; break;

		  case 'H':	pct = !sump ? 0.0 : PERCENT(cntp->hits, sump->hits); /*FALLTHROUGH*/
		  case 'h':	count = cntp->hits;
				if (maxp && maxp->hits && maxp->hits == count)
					align = 1;
				break;

		  case 'F':	pct = !sump ? 0.0 : PERCENT(cntp->files, sump->files); /*FALLTHROUGH*/
		  case 'f':	count = cntp->files;
				if (maxp && maxp->files && maxp->files == count)
					align = 1;
				break;

		  case 'C':	pct = !sump ? 0.0 : PERCENT(cntp->nomod, sump->nomod); /*FALLTHROUGH*/
		  case 'c':	count = cntp->nomod;
				if (maxp && maxp->nomod && maxp->nomod == count)
					align = 1;
				break;

		  case 'P':	pct = !sump ? 0.0 : PERCENT(cntp->views, sump->views); /*FALLTHROUGH*/
		  case 'p':	count = cntp->views;
				if (maxp && maxp->views && maxp->views == count)
					align = 1;
				break;

		  case 'S':	pct = !sump ? 0.0 : PERCENT(cntp->sessions, sump->sessions); /*FALLTHROUGH*/
		  case 's':	count = cntp->sessions;
				if (maxp && maxp->sessions && maxp->sessions == count)
					align = 1;
				break;

		  case 'K':	pct = !sump ? 0.0 : PERCENT(cntp->bytes, sump->bytes);	/*FALLTHROUGH*/
		  case 'k':	count = KBYTES(cntp->bytes);
				if (maxp && maxp->bytes > 0.0 && maxp->bytes == cntp->bytes)
					align = 1;
				break;

		}
		prString(ofp, ffp, FONT_TEXT,
			tblalign[align], "</TD>\n", "<B>%lu</B>", count);
		if (pct >= 0.0)
			prString(ofp, ffp, FONT_SMALL,
				tblalign[align], "</TD>\n", "%6.2f%%", pct);
	}
	if (term)
		dfpr(ofp, ffp, "</TR>\n");
	return;
}

/*
** Print items from a Top N list.
*/
static void prTopList(FILE *const ofp, TOP_COUNTER *const base, size_t const num, int const which) {
	char *label;
	size_t idx;

	switch (which) {
	   default:	assert(which != which);		break;
	   case 0:	label = GETMSG(145, "days");    break;
	   case 1:	label = GETMSG(146, "hours");   break;
	   case 2:	label = GETMSG(147, "minutes"); break;
	   case 3:	label = GETMSG(148, "seconds"); break;
	}

	openTable(ofp, NULL, 498, tblfmt[FMT_LOAD],
		GETMSG(151, "The Top %d %s of the period"), num, label);
	prTblHead(ofp, NULL, tblfmt[FMT_LOAD], NULL,
		!which ? GETMSG(149, "Date") : GETMSG(150, "Date/Time"));

	for (idx=0; idx < num; idx++)
		if (base[idx].cnt.hits > 0L) {
			prTblRow(ofp, NULL, tblfmt[FMT_LOAD], idx, NULL, &base[idx].cnt, &total, NULL);

			prString(ofp, NULL, FONT_TEXT, "<TD ALIGN=\"LEFT\">", NULL, NULL);
			dfpr(ofp, NULL, "%02d/%3.3s/%d",
				base[idx].tm.mday, monnam[base[idx].tm.mon], base[idx].tm.year);
			if (which == 1)
				dfpr(ofp, NULL, ":%02d:XX:XX", base[idx].tm.hour);
			else if (which == 2)
				dfpr(ofp, NULL, ":%02d:%02d:XX", base[idx].tm.hour, base[idx].tm.min);
			else if (which == 3)
				dfpr(ofp, NULL, ":%02d:%02d:%02d",
					base[idx].tm.hour, base[idx].tm.min, base[idx].tm.sec);
			dfpr(ofp, NULL, "%s</TD></TR>\n", FONT_END(FONT_TEXT));
		}
	closeTable(ofp, NULL);
	return;
}

/*
** Print navigation bar for month.
*/
static void prNavMon(FILE *const ofp, FILE *const efp) {
	dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE WIDTH=\"498\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n");
	if (efp)
		prString(efp, NULL, FONT_HEAD2, "<CENTER><P ALIGN=\"CENTER\">\n"
			"<TABLE WIDTH=\"100%\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n"
			FMT_SPACE(4) "<TR><TH NOWRAP COLSPAN=\"2\" BGCOLOR=\"#CCCCCC\">",
			"</TH></TR>\n", "%s <A HREF=\"javascript:loadPage('totals%02d%02d.html');\">%s %d</A>",
			GETMSG(152, "Full Statistics for"),
			t.start.mon+1, EPOCH(t.start.year), monnam[t.end.mon], t.start.year);

	prString(ofp, efp, FONT_HEAD2, FMT_SPACE(4)
		"<TR><TD BGCOLOR=\"#CCCCCC\">", "</TD>\n", "%s", GETMSG(153, "Hits:"));
	prString(ofp, efp, FONT_HEAD2, "<TD NOWRAP BGCOLOR=\"#CCCCCC\">", NULL, NULL);

	if (efp)
		dfpr(NULL, efp, "<A HREF=\"javascript:loadPage('days%02d%02d.html');\">",
			t.start.mon+1, EPOCH(t.start.year));
	dfpr(ofp, NULL, "<A HREF=\"days%02d%02d.html\">", t.start.mon+1, EPOCH(t.start.year));
	dfpr(ofp, efp, "%s</A> /\n", GETMSG(154, "by Day"));

	if (sptab[SP_AVLOAD].ison) {
		if (efp)
			dfpr(NULL, efp, "<A HREF=\"javascript:loadPage('avload%02d%02d.html');\">",
				t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, NULL, "<A HREF=\"avload%02d%02d.html\">",
			t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, efp, "%s</A> /\n", GETMSG(155, "by Weekday &amp; Hour"));
	}
	if (sptab[SP_COUNTRY].ison) {
		if (efp)
			dfpr(NULL, efp, "<A HREF=\"javascript:loadPage('country%02d%02d.html');\">",
				t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, NULL, "<A HREF=\"country%02d%02d.html\">",
			t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, efp, "%s</A> /\n", GETMSG(156, "by Country"));
	}

#if defined(VRML)
	if (use_vrml) {
		if (efp)
			dfpr(NULL, efp,
				"<A HREF=\"javascript:createVRMLWin('3Dstats%02d%02d.html');\">",
				t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, NULL, "<A TARGET=\"vrml_win\" HREF=\"3Dstats%02d%02d.html\">",
			t.start.mon+1, EPOCH(t.start.year));
		dfpr(ofp, efp, "%s</A>\n", GETMSG(157, "3D model"));
	}
#endif
	dfpr(ofp, efp, "%s</TD></TR>\n", FONT_END(FONT_VAR));

	if (lntab[FNAME_FILES] || lntab[FNAME_RFILES] || lntab[FNAME_LFILES] || lntab[FNAME_TOPFILES]) {
		prString(ofp, efp, FONT_HEAD2,
			"<TR><TD BGCOLOR=\"#CCCCCC\">", "</TD>\n", "%s", GETMSG(158, "Items/URLs:"));
		prString(ofp, efp, FONT_HEAD2, "<TD NOWRAP BGCOLOR=\"#CCCCCC\">", NULL, NULL);
		if (lntab[FNAME_TOPFILES] || lntab[FNAME_TOPLFILES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('topurl%02d%02d.html');\">",
					t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"topurl%02d%02d.html\">",
				t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(159, "Top Ten"));
		}
		if (lntab[FNAME_FILES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/files%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/files%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(160, "Overview"));
		}
		if (lntab[FNAME_RFILES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/rfiles%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/rfiles%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(162, "Not&nbsp;Found"));
		}
		if (lntab[FNAME_LFILES] && !list_dir)
			dfpr(ofp, efp, "<A TARGET=\"lists\" HREF=\"%s/lfiles%02d%02d.html\">%s</A>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year), GETMSG(161, "List"));
		dfpr(ofp, efp, "%s</TD></TR>\n", FONT_END(FONT_VAR));
	}
	if (lntab[FNAME_SITES] || lntab[FNAME_RSITES] || lntab[FNAME_LSITES] || lntab[FNAME_TOPSITES]) {
		prString(ofp, efp, FONT_HEAD2,
			"<TR><TD NOWRAP BGCOLOR=\"#CCCCCC\">", "</TD>\n", "%s", GETMSG(163, "Client Domain:"));
		prString(ofp, efp, FONT_HEAD2, "<TD NOWRAP BGCOLOR=\"#CCCCCC\">", NULL, NULL);
		if (lntab[FNAME_TOPSITES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('topdom%02d%02d.html');\">",
					t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"topdom%02d%02d.html\">",
				t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(159, "Top Ten"));
		}
		if (lntab[FNAME_SITES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/sites%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/sites%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(160, "Overview"));
		}
		if (lntab[FNAME_RSITES]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/rsites%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/rsites%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(164, "Reverse Domain"));
		}
		if (lntab[FNAME_LSITES])
			dfpr(ofp, efp, "<A TARGET=\"lists\" HREF=\"%s/lsites%02d%02d.html\">%s</A>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year), GETMSG(161, "List"));
		dfpr(ofp, efp, "%s</TD></TR>\n", FONT_END(FONT_VAR));
	}
	if (lntab[FNAME_AGENTS] || lntab[FNAME_LAGENTS] || lntab[FNAME_TOPAGENTS]) {
		prString(ofp, efp, FONT_HEAD2,
			"<TR><TD NOWRAP BGCOLOR=\"#CCCCCC\">", "</TD>\n", "%s", GETMSG(165, "Browser Type:"));
		prString(ofp, efp, FONT_HEAD2, "<TD NOWRAP BGCOLOR=\"#CCCCCC\">", NULL, NULL);
		if (lntab[FNAME_TOPAGENTS]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('topuag%02d%02d.html');\">",
					t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"topuag%02d%02d.html\">",
				t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(159, "Top Ten"));
		}
		if (lntab[FNAME_AGENTS]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/agents%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/agents%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(160, "Overview"));
		}
		if (lntab[FNAME_LAGENTS])
			dfpr(ofp, efp, "<A TARGET=\"lists\" HREF=\"%s/lagents%02d%02d.html\">%s</A>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year), GETMSG(161, "List"));
		dfpr(ofp, efp, "%s</TD></TR>\n", FONT_END(FONT_VAR));
	}
	if (lntab[FNAME_REFERS] || lntab[FNAME_LREFERS] || lntab[FNAME_TOPREFERS]) {
		prString(ofp, efp, FONT_HEAD2,
			"<TR><TD NOWRAP BGCOLOR=\"#CCCCCC\">", "</TD>\n", "%s", GETMSG(166, "Referrer URL:"));
		prString(ofp, efp, FONT_HEAD2, "<TD NOWRAP BGCOLOR=\"#CCCCCC\">", NULL, NULL);
		if (lntab[FNAME_TOPREFERS]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('topref%02d%02d.html');\">",
					t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"topref%02d%02d.html\">",
				t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(159, "Top Ten"));
		}
		if (lntab[FNAME_REFERS]) {
			if (efp)
				dfpr(NULL, efp,
					"<A HREF=\"javascript:loadPage('%s/refers%02d%02d.html');\">",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, NULL, "<A HREF=\"%s/refers%02d%02d.html\">",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));
			dfpr(ofp, efp, "%s</A> /\n", GETMSG(160, "Overview"));
		}
		if (lntab[FNAME_LREFERS])
			dfpr(ofp, efp, "<A TARGET=\"lists\" HREF=\"%s/lrefers%02d%02d.html\">%s</A>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year), GETMSG(161, "List"));
		dfpr(ofp, efp, "%s</TD></TR>\n", FONT_END(FONT_VAR));
	}
	prString(ofp, efp, FONT_HEAD2, FMT_SPACE(4)
		"<TR><TD NOWRAP COLSPAN=\"2\" ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">", NULL, NULL);

	dfpr(ofp, NULL, "<A HREF=\"index.html\"><B>%s %d</B></A>", GETMSG(167, "Summary for"), t.start.year);
	if (efp) {
		dfpr(NULL, efp, "<A HREF=\"jsnav.html\" onClick=\"loadPage('index.html');"
			"return true;\">%s %d</A> / ", GETMSG(167, "Summary for"), t.start.year);
		dfpr(NULL, efp, "<A HREF=\"javascript:closeWin();\">%s</A>",
			GETMSG(168, "Close navigation window"));
	}
	dfpr(ofp, efp, "%s</TD></TR>\n" FMT_SPACE(4) "</TABLE></P>\n</CENTER>\n",
		FONT_END(FONT_VAR));
	return;
}

/*
** Print navigation bar for year.
*/
static void prNavYear(FILE *const ofp, char *const period, int const curlink) {
	int idx, ndx = 0;

	prString(ofp, NULL, FONT_HEAD2, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE WIDTH=\"100%\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n"
		FMT_SPACE(4) "<TR><TH COLSPAN=\"3\" BGCOLOR=\"#CCCCCC\">", "</TH></TR>\n"
		FMT_SPACE(4) "<TR><TD NOWRAP ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">\n",
		"%s %s", GETMSG(169, "WWW Access Statistics for"), period);

	if (curlink)
		prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
			"<A HREF=\"nav%02d%02d.html\""
			" onClick=\"loadPage('totals%02d%02d.html');\">%s %d</A>",
			t.end.mon+1, EPOCH(t.end.year),
			t.end.mon+1, EPOCH(t.end.year),
			monnam[t.end.mon], t.end.year);
	else
		prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
			"%s %d", monnam[t.end.mon], t.end.year);

	for (idx=(int)t.end.mon; --idx >= 0; ) {
		(void) fprintf(ofp, "%s<TD NOWRAP ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">\n",
				(++ndx%3) == 0 ? "</TR>\n<TR>" : "\n");
		if (monly[idx].hits)
			prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
				"<A HREF=\"nav%02d%02d.html\""
				" onClick=\"loadPage('totals%02d%02d.html');\">%s %d</A>",
				idx+1, EPOCH(t.end.year),
				idx+1, EPOCH(t.end.year),
				monnam[idx], t.end.year);
		else
			prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
				"%s %d", monnam[idx], t.end.year);
	}

	for (idx=11; idx > (int)t.end.mon; idx--) {
		(void) fprintf(ofp, "%s<TD NOWRAP ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">\n",
			(++ndx%3) == 0 ? "</TR>\n<TR>" : "\n");
		if (monly[idx].hits)
			prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
				"<A HREF=\"../www%d/nav%02d%02d.html\""
				" onClick=\"loadPage('../www%d/totals%02d%02d.html');\">%s %d</A>",
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U),
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U),
				monnam[idx], t.end.year-1U);
		else
			prString(ofp, NULL, FONT_HEAD2, NULL, "</TD>\n",
				"%s %d", monnam[idx], t.end.year-1U);
	}
	dfpr(ofp, NULL, "</TR>\n" FMT_SPACE(4)
		"<TR><TD COLSPAN=\"3\" ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">");
	prString(ofp, NULL, FONT_HEAD2, NULL, NULL, NULL);
	dfpr(ofp, NULL, "<A HREF=\"javascript:loadPage('../index.html');\">%s</A> / ",
		GETMSG(170, "Main Page"));
	dfpr(ofp, NULL, "<A HREF=\"javascript:closeWin();\">%s</A>",
		GETMSG(168, "Close navigation window"));
	dfpr(ofp, NULL, "%s</TD></TR>\n" FMT_SPACE(4) "</TABLE></P>\n</CENTER>\n",
		FONT_END(FONT_VAR));
	return;
}

/*
** Print frameset and navigation subframe.
*/
static void prFrameHeader(char *const stdir) {
	char tbuf[MAX_FNAMELEN];
	char *temp;
	FILE *ofp;
	int idx;

	/* create the frames layout file */
	if ((ofp=efopen("%s/frames.html", stdir)) == NULL)
		exit(1);

	(void) fprintf(ofp,
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
		"<HTML>\n<HEAD>\n<META NAME=\"ROBOTS\" CONTENT=\"NONE\">\n"
		"<TITLE>%s</TITLE>\n</HEAD>\n"
		"<FRAMESET COLS=\"%d,*\" BORDER=\"2\">\n"
		" <FRAME NAME=\"header\" SRC=\"header.html\" MARGINWIDTH=\"2\">\n"
		" <FRAME NAME=\"main_win\" SRC=\"fstats%hu.html\">\n"
		"</FRAMESET>\n<NOFRAMES>\n<BODY>\n<P>\n%s</P>\n"
		"</BODY>\n</NOFRAMES>\n</HTML>\n", doc_title, nav_frame, t.start.year,
		GETMSG(172, "Please use the <A HREF=\"index.html\">non-frames version</A> "
			    "of the summary report."));
	(void) fclose(ofp);

	/* create a blank page to avoid "about:blank" */
	if ((ofp=efopen("%s/blank.html", stdir)) == NULL)
		exit(1);

	(void) fprintf(ofp,
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
		"<HTML>\n<HEAD>\n<TITLE>blank page</TITLE>\n</HEAD>\n"
		"<BODY>\n</BODY>\n</HTML>\n");
	(void) fclose(ofp);

	/* create navigation frame */
	if ((ofp=efopen("%s/header.html", stdir)) == NULL)
		exit(1);

	(void) fprintf(ofp,
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
		"<HTML>\n<HEAD>\n"
		"<META NAME=\"ROBOTS\" CONTENT=\"NONE\">\n"
		"<BASE TARGET=\"header\">\n"
		"<TITLE>Table of Content</TITLE>\n\n"
		"<SCRIPT LANGUAGE=\"JavaScript\">\n"
		"<!-- // hide script\n"
		"var vrmlWin = null;\n"
		"var switchImages=0;\n"
		"var totalMonth=0;\n"
		"var totalGraphics=0;\n"
		"var selectedModel=0;\n"
		"var active=1;\n"
		"var curmon=1;\n\n"
		"// Build array of extensions\n"
		"function monTab(sdir, sfx, text) {\n"
		"\tthis.sdir = sdir;\n"
		"\tthis.sfx = sfx;\n"
		"\tthis.text = text;\n}\n\n");

	(void) fprintf(ofp, "// Create new month description\n"
		"// First entry is top summary period\n"
		"function createMonTab(sdir, sfx, text) {\n"
		"\tmonTab[totalMonth] = new monTab(sdir, sfx, text);\n"
		"\ttotalMonth++;\n}\n\n");

	(void) fprintf(ofp, "// Change graphic appearance as mouse moves over it\n"
		"function tocMouseOver(tocNumber, thismon) {\n"
		"\tif (switchImages && tocNumber != active)\n"
		"\t\tdocument.images[tocNumber-1].src = tocGraphic[tocNumber].on.src;\n"
		"\tself.status = %s+monTab[thismon].text;\n}\n\n",
		GETMSG(173, "tocGraphic[tocNumber].text+' for '"));

	(void) fprintf(ofp, "// Change graphic back to 'off' state when mouse moves past it\n"
		"function tocMouseOut(tocNumber) {\n"
		"\tif (switchImages && tocNumber != active)\n"
		"\t\tdocument.images[tocNumber-1].src = tocGraphic[tocNumber].off.src;\n"
		"\tself.status = '';\t\t// Clear status line for broken browsers\n}\n\n");

	(void) fprintf(ofp, "// Display no report error message\n"
		"function noReport(tocNumber, thismon) {\n"
		"\talert(%s+monTab[thismon].text);\n}\n\n",
		GETMSG(174, "tocGraphic[tocNumber].text+' not available for '"));

	(void) fprintf(ofp, "// Show no report status\n"
		"function tocNoReport(thismon) {\n"
		"\tself.status = '%s '+monTab[thismon].text;\n}\n\n",
		GETMSG(175, "No report available for"));

	(void) fprintf(ofp, "// Build array of graphic objects\n"
		"function tocGraphic(name, file, text) {\n"
		"\tthis.name = name;\n"
		"\tthis.file = file;\n"
		"\tthis.text = text;\n"
		"\tif (switchImages) {\n"
		"\t\tthis.off = new Image(%d,%d);\n"
		"\t\tthis.off.src = name + \"_off" IMG_SFX "\";\n"
		"\t\tthis.on = new Image(%d,%d);\n"
		"\t\tthis.on.src = name + \"_on" IMG_SFX "\";\n\t}\n}\n\n",
		buttons[BTN_YEAR].wid, buttons[BTN_YEAR].ht,
		buttons[BTN_YEAR].wid, buttons[BTN_YEAR].ht);

	(void) fprintf(ofp, "// Create new array object\n"
		"function createTocGraphic(name, file, text) {\n"
		"\ttotalGraphics++;\n"
		"\ttocGraphic[totalGraphics] = new tocGraphic(name, file, text);\n}\n\n");

#if defined(VRML)
	if (use_vrml) {
		if (vrml_win == EXT_WIN) {
			(void) fprintf(ofp, "// Create the VRML window\n"
				"function createVRMLWin(loc) {\n"
				"\tvrmlWin = window.open(loc, 'vrml_win',"
				"'toolbar=no,location=no,directories=no,status=yrd,"
				"menubar=no,scrollbars=no,resizable=yes,"
				"width=%d,height=%d');\n\tvrmlWin.creator = self;\n"
				"}\n\n", w3wid, w3ht);
		}
		(void) fprintf(ofp, "// Select the VRML model\n"
			"function selectModel(button) {\n"
			"\t// Choose a model depending on the value of the select button\n"
			"\tif (button.value != \"year\")\n"
			"\t\tselectedModel = 0;\n"
			"\telse\tselectedModel = 1;\n"
			"\ttocClick(active);\n}\n\n");

		(void) fprintf(ofp, "// Load the VRML scene\n"
			"function loadVRML(checkbox) {\n"
			"\t// Load the VRML 3D model. It is triggered by the user\n"
			"\t// clicking the ShowVRML checkbox in the control pane.\n"
			"\tif (checkbox.checked) {\n");

		if (vrml_win == EXT_WIN) {
			(void) fprintf(ofp,
				"\t\tcreateVRMLWin(\"blank.html\");\n"
				"\t} else {\t\t// Close the VRML window.\n"
				"\t\tvrmlWin.close();\n"
				"\t\tvrmlWin = null;\n");
		} else {
			(void) fprintf(ofp,
				"\t\ttop.main_win.document.open();\t// Create new frameset\n"
				"\t\ttop.main_win.document.write('<FRAMESET ROWS=\"*,360\">');\n"
				"\t\ttop.main_win.document.write('<FRAME SRC=\"blank.html\" NAME=\"Text\">');\n"
				"\t\ttop.main_win.document.write('<FRAME SRC=\"blank.html\" NAME=\"VRML\""
				" SCROLLING=\"no\" MARGINWIDTH=0 MARGINHEIGHT=0>');\n"
				"\t\ttop.main_win.document.write('</FRAMESET>');\n"
				"\t\ttop.main_win.document.close();\n");
		}
		(void) fprintf(ofp, "\t}\n\tsetTimeout(\"tocClick(active)\", 1000);\n}\n\n");
	}
#endif
	(void) fprintf(ofp, "// Load given month\n"
		"function loadMonth() {\n"
		"\tcurmon = document.ControlForm.period.selectedIndex+1;\n"
		"\ttocClick(2);\n}\n\n");

	(void) fprintf(ofp, "// Change graphic to 'on' state when mouse is clicked\n"
		"function tocClick(tocNumber) {\n"
		"\tvar currentURL;\n"
		"\tvar currentModel;\n"
		"\tif (switchImages && (active > 0) && (active != tocNumber))\n"
		"\t\tdocument.images[active-1].src = tocGraphic[active].off.src;\n\n"
		"\tif (tocNumber > 0) {\n"
		"\t\tif (switchImages)\n"
		"\t\t\tdocument.images[tocNumber-1].src = tocGraphic[tocNumber].on.src;\n"
		"\t\tif (tocNumber > 1) {\n"
		"\t\t\tcurrentURL = parentURL+monTab[curmon].sdir+tocGraphic[tocNumber].file+monTab[curmon].sfx+'.html';\n");

#if defined(VRML)
	if (use_vrml) {
		if (vrml_win == EXT_WIN)
			temp = ".html";
		else	temp = ".wrl.gz";
		if (vrml_prlg) {
			(void) fprintf(ofp, "\t\t\tif (selectedModel)\t// model for year\n"
				"\t\t\t\tcurrentModel = parentURL+monTab[curmon].sdir+"
				"\"3Dstats\"+monTab[0].sfx+\"%s\";\n"
				"\t\t\telse\t\t// model for month\n\t", temp);
		}
		(void) fprintf(ofp, "\t\t\tcurrentModel = parentURL+monTab[curmon].sdir+"
				"\"3Dstats\"+monTab[curmon].sfx+\"%s\";\n", temp);
	}
#endif
	(void) fprintf(ofp,
		"\t\t} else {\n"
		"\t\t\tcurrentURL = baseURL+tocGraphic[tocNumber].file+monTab[0].sfx+'.html';\n");

#if defined(VRML)
	if (use_vrml) {
		if (vrml_prlg) {
			(void) fprintf(ofp, "\t\t\tif (selectedModel)\t// model for year\n"
				"\t\t\t\tcurrentModel = baseURL+\"3Dstats\"+"
				"monTab[0].sfx+\"%s\";\n"
				"\t\t\telse\t\t// model for month\n\t", temp);
		}
		(void) fprintf(ofp, "\t\t\tcurrentModel = parentURL+\"3Dlogo%s\";\n", temp);
	}
#endif
	(void) fprintf(ofp, "\t\t}\n");

#if defined(VRML)
	if (use_vrml) {
		(void) fprintf(ofp, "\t\tif (document.ControlForm.ShowVRML.checked) {\n");
		if (vrml_win == EXT_WIN)
			(void) fprintf(ofp,
				"\t\t\tif ((top.window.frames['main_win'].location.href != currentURL))\n"
				"\t\t\t\ttop.window.frames['main_win'].location = currentURL;\n\n"
				"\t\t\tif (vrmlWin == null)\t// in case page has been reloaded\n"
				"\t\t\t\tcreateVRMLWin(currentModel);\n"
				"\t\t\telse if (vrmlWin.location.href != currentModel)\n"
				"\t\t\t\tvrmlWin.location = currentModel;\n");
		else
			(void) fprintf(ofp,
				"\t\t\tif (top.window.frames['main_win'].Text.location.href != currentURL)\n"
				"\t\t\t\ttop.window.frames['main_win'].Text.location = currentURL;\n"
				"\t\t\tif (top.window.frames['main_win'].VRML.location.href != currentModel)\n"
				"\t\t\t\ttop.window.frames['main_win'].VRML.location = currentModel;\n");
		(void) fprintf(ofp, "\t\t} else\n");
	}
#endif
	(void) fprintf(ofp,
		"\t\tif ((top.window.frames['main_win'].location.href != currentURL))\n"
		"\t\t    top.window.frames['main_win'].location = currentURL;\n"
		"\t}\n\tactive = tocNumber;\n}\n\n");

	(void) fprintf(ofp, "// Set home document\nfunction setHome() {\n"
		"\tvar mn, curPage = top.window.frames['main_win'].location.href;\n\n");

	if (use_vrml && vrml_win != EXT_WIN)
		(void) fprintf(ofp,
			"\tif (document.ControlForm.ShowVRML.checked)\n"
			"\t\tcurPage = top.window.frames['main_win'].Text.location.href;\n");

	(void) fprintf(ofp, "\t// Strip off prefix and suffix from URL\n"
		"\tcurPage = curPage.substring(curPage.lastIndexOf(\"/\")+1,curPage.length);\n"
		"\tcurPage = curPage.substring(0,curPage.lastIndexOf(\".html\"));\n\n"
		"\tif (curPage.length > 4) {\n"
		"\t\tmn = curPage.substring(curPage.length-4, curPage.length);\n"
		"\t\tcurPage = curPage.substring(0, curPage.length-4);\n"
		"\t} else {                // Set default values\n"
		"\t\tcurPage = tocGraphic[1].file;\n"
		"\t\tmn = monTab[0].sfx;\n\t}\n\n"
		"\t// Find out which page is currently loaded\n"
		"\tvar idx = 0;\n\tvar count = 1;\n"
		"\twhile ((idx < 13) && (monTab[idx].sfx != mn))\n"
		"\t\tidx++;\n\n"
		"\tif (curmon < 13)\n"
		"\t\twhile ((count <= totalGraphics) && (tocGraphic[count].file != curPage))\n"
		"\t\t\tcount++;\n\n"
		"\t// Adjust menu to current page\n"
		"\tif (idx < 13 && count <= totalGraphics) {\n"
		"\t\tcurmon = idx;\n"
		"\t\tif (curmon == 0)\n"
		"\t\t\tcurmon++;\n"
		"\t\ttocClick(count);\n"
		"\t}\n}\n\n");

	(void) fprintf(ofp, "// Determine base URL\n"
		"baseURL = location.href.substring(0,location.href.lastIndexOf(\"/\")+1);\n"
		"parentURL = baseURL.substring(0,baseURL.lastIndexOf(\"%s/\"));\n", stdir);

	(void) fprintf(ofp,
		"// Check if navigator is Netscape 3.0 or MSIE 4.0.\n"
		"if ((navigator.appName == \"Netscape\" && "
		"parseInt(navigator.appVersion) >= 3) ||\n"
		"    (navigator.appName == \"Microsoft Internet Explorer\" && "
		"parseInt(navigator.appVersion) >= 4))\n"
		"\tswitchImages=1;\n\n");

	(void) fprintf(ofp, "// Build menu graphic array\n"
		"createTocGraphic(\"../%s/%s\",  \"fstats\",\"%s\");\n",
		btn_dir, buttons[BTN_YEAR].name, buttons[BTN_YEAR].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"totals\",\"%s\");\n",
		btn_dir, buttons[BTN_TOTALS].name, buttons[BTN_TOTALS].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",  \"days\",  \"%s\");\n",
		btn_dir, buttons[BTN_DAYS].name, buttons[BTN_DAYS].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"avload\",\"%s\");\n",
		btn_dir, buttons[BTN_AVLOAD].name, buttons[BTN_AVLOAD].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"topurl\",\"%s\");\n",
		btn_dir, buttons[BTN_TOPURL].name, buttons[BTN_TOPURL].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"topdom\",\"%s\");\n",
		btn_dir, buttons[BTN_TOPDOM].name, buttons[BTN_TOPDOM].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"topuag\",\"%s\");\n",
		btn_dir, buttons[BTN_TOPUAG].name, buttons[BTN_TOPUAG].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"topref\",\"%s\");\n",
		btn_dir, buttons[BTN_TOPREF].name, buttons[BTN_TOPREF].text);
	(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\", \"country\",\"%s\");\n",
		btn_dir, buttons[BTN_COUNTRY].name, buttons[BTN_COUNTRY].text);

	if (!priv_dir) {
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\", \"files\", \"%s\");\n",
			btn_dir, buttons[BTN_FILES].name, buttons[BTN_FILES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"rfiles\",\"%s\");\n",
			btn_dir, buttons[BTN_RFILES].name, buttons[BTN_RFILES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\", \"sites\", \"%s\");\n",
			btn_dir, buttons[BTN_SITES].name, buttons[BTN_SITES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"rsites\",\"%s\");\n",
			btn_dir, buttons[BTN_RSITES].name, buttons[BTN_RSITES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"agents\",\"%s\");\n",
			btn_dir, buttons[BTN_AGENTS].name, buttons[BTN_AGENTS].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"refers\",\"%s\");\n\n",
			btn_dir, buttons[BTN_REFER].name, buttons[BTN_REFER].text);
	} else {
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\", \"%s/files\", \"%s\");\n",
			btn_dir, buttons[BTN_FILES].name, priv_dir, buttons[BTN_FILES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"%s/rfiles\",\"%s\");\n",
			btn_dir, buttons[BTN_RFILES].name, priv_dir, buttons[BTN_RFILES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\", \"%s/sites\", \"%s\");\n",
			btn_dir, buttons[BTN_SITES].name, priv_dir, buttons[BTN_SITES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"%s/rsites\",\"%s\");\n",
			btn_dir, buttons[BTN_RSITES].name, priv_dir, buttons[BTN_RSITES].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"%s/agents\",\"%s\");\n",
			btn_dir, buttons[BTN_AGENTS].name, priv_dir, buttons[BTN_AGENTS].text);
		(void) fprintf(ofp, "createTocGraphic(\"../%s/%s\",\"%s/refers\",\"%s\");\n\n",
			btn_dir, buttons[BTN_REFER].name, priv_dir, buttons[BTN_REFER].text);
	}

	(void) fprintf(ofp, "createMonTab(\"%s/\", \"%d\", \"%s\");\n",
			stdir, (int)t.end.year, GETMSG(191, "the last 12 months"));
	for (idx=(int)t.end.mon; idx >= 0; idx--)
		(void) fprintf(ofp, "createMonTab(\"%s/\", \"%02d%02d\", \"%s %04d\");\n",
			stdir, idx+1, EPOCH(t.end.year), monnam[idx], t.end.year);
	for (idx=11; idx > (int)t.end.mon; idx--)
		(void) fprintf(ofp, "createMonTab(\"www%04d/\", \"%02d%02d\", \"%s %04d\");\n",
			t.end.year-1U, idx+1, EPOCH(t.end.year-1U), monnam[idx], t.end.year-1U);

	(void) fprintf(ofp, "\n// -->\n</SCRIPT>\n</HEAD>\n"
		"<BODY BGCOLOR=\"#000000\" TEXT=\"#FF6600\" LINK=\"#00FF00\"\n"
		" ALINK=\"#FF0000\" VLINK=\"#FF3300\" onLoad=\"setHome()\">\n\n"
		"<SPACER TYPE=\"vertical\" SIZE=\"4\">\n"
		"<FORM NAME=\"ControlForm\" METHOD=\"GET\">\n"
		"<CENTER>\n<P ALIGN=\"CENTER\">\n");

#define MAKE_BUTTON(number, which, cond)						\
	if (cond)									\
	     (void) fprintf(ofp,							\
		"<A HREF=\"javascript:top.frames[0].tocClick(" #number ")\"\n"		\
			" onMouseOver=\"tocMouseOver(" #number ",curmon);return true;\""\
			" onMouseOut=\"tocMouseOut(" #number ");\">\n");		\
	else (void) fprintf(ofp,							\
		"<A HREF=\"javascript:top.frames[0].noReport(" #number ",curmon)\"\n"	\
			" onMouseOver=\"tocNoReport(curmon);return true;\">\n");	\
	(void) fprintf(ofp, "<IMG SRC=\"../%s/%s_off" IMG_SFX "\" ALT=\"%s\""		\
		" WIDTH=\"%d\" HEIGHT=\"%d\" BORDER=\"0\"></A><BR>\n", btn_dir,		\
		    buttons[(which)].name, buttons[(which)].text,			\
		    buttons[(which)].wid, buttons[(which)].ht)

	/*CONSTCOND*/
	MAKE_BUTTON(1, BTN_YEAR, 1);	/* controlling expression is intentionally constant */
	prString(ofp, NULL, FONT_HEAD2, NULL, NULL, NULL);
	(void) fprintf(ofp, "<SELECT NAME=\"period\" onChange=\"loadMonth();\">\n"
		"<OPTION SELECTED>%.3s %4d\n", monnam[idx], t.end.year);

	for (idx=(int)t.end.mon-1; idx >= 0; idx--) {
		(void) snprintf(tbuf, sizeof tbuf, "%s/stats%02d%02d.html",
				stdir, idx+1, EPOCH(t.end.year));
		(void) fprintf(ofp, "<OPTION>%.3s %4d\n", monnam[idx], t.end.year);
	}
	for (idx=11; idx > (int)t.end.mon; idx--) {
		(void) snprintf(tbuf, sizeof tbuf, "../www%d/stats%02d%02d.html",
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U));
		(void) fprintf(ofp, "<OPTION>%.3s %4d\n", monnam[idx], t.end.year-1U);
	}
	(void) fprintf(ofp, "</SELECT>%s<BR>\n", FONT_END(FONT_VAR));

	/*CONSTCOND*/
	MAKE_BUTTON(2,  BTN_TOTALS, 1);	/* controlling expression is intentionally constant */
	/*CONSTCOND*/
	MAKE_BUTTON(3,  BTN_DAYS,   1);	/* controlling expression is intentionally constant */
	MAKE_BUTTON(4,  BTN_AVLOAD, sptab[SP_AVLOAD].ison);
	MAKE_BUTTON(5,  BTN_TOPURL, lntab[FNAME_TOPFILES] != 0);
	MAKE_BUTTON(6,  BTN_TOPDOM, lntab[FNAME_TOPSITES] != 0);
	MAKE_BUTTON(7,  BTN_TOPUAG, lntab[FNAME_TOPAGENTS] != 0);
	MAKE_BUTTON(8,  BTN_TOPREF, lntab[FNAME_TOPREFERS] != 0);
	MAKE_BUTTON(9,  BTN_COUNTRY,sptab[SP_COUNTRY].ison);
	MAKE_BUTTON(10, BTN_FILES,  lntab[FNAME_FILES] != 0);
	MAKE_BUTTON(11, BTN_RFILES, lntab[FNAME_RFILES] != 0);
	MAKE_BUTTON(12, BTN_SITES,  lntab[FNAME_SITES] != 0);
	MAKE_BUTTON(13, BTN_RSITES, lntab[FNAME_RSITES] != 0);
	MAKE_BUTTON(14, BTN_AGENTS, lntab[FNAME_AGENTS] != 0);
	MAKE_BUTTON(15, BTN_REFER,  lntab[FNAME_REFERS] != 0);
#undef MAKE_BUTTON

#if defined(VRML)
	if (use_vrml) {
		prString(ofp, NULL, FONT_HEAD2, NULL, "<BR>\n",
			"<INPUT TYPE=\"checkbox\" NAME=\"ShowVRML\""
			" onClick=\"loadVRML(this);\"><B>&nbsp;VRML</B>");
		if (vrml_prlg)
			prString(ofp, NULL, FONT_HEAD1, NULL, "<BR>\n",
				"<INPUT TYPE=\"radio\" NAME=\"WhichModel\" VALUE=\"month\""
				" CHECKED onClick=\"selectModel(this);\">&nbsp;PC&nbsp;\n"
				"<INPUT TYPE=\"radio\" NAME=\"WhichModel\" VALUE=\"year\""
				" onClick=\"selectModel(this);\">&nbsp;SGI");
	}
#endif
	prString(ofp, NULL, FONT_HEAD2, "<SPACER TYPE=\"vertical\" SIZE=\"4\">\n"
		"<HR SIZE=\"2\">\n<A HREF=\"../index.html\" TARGET=\"_top\">",
		"</A><BR>\n", "<B>%s</B>", GETMSG(192, "Main&nbsp;Page"));

	if (lic && access("docs.html", F_OK) == 0)
		(void) fprintf(ofp, "<A HREF=\"../docs.html\" TARGET=\"manual\">");
	else	(void) fprintf(ofp, "<A HREF=\"%sdocs.html\" TARGET=\"manual\">", ha_home);
	prString(ofp, NULL, FONT_HEAD1,
		NULL, "</A>\n<HR SIZE=\"2\">\n", "%s", GETMSG(193, "Online&nbsp;Documentation"));

	if (buttons[BTN_CUSTOMB].name)
		(void) fprintf(ofp, "<A HREF=\"%s\" TARGET=\"_blank\">"
			"<IMG SRC=\"../%s\" ALT=\"\" WIDTH=\"%d\" HEIGHT=\"%d\""
			" BORDER=\"0\"></A><BR>\n<HR SIZE=\"2\">\n",
			buttons[BTN_CUSTOMB].text, buttons[BTN_CUSTOMB].name,
			buttons[BTN_CUSTOMB].wid, buttons[BTN_CUSTOMB].ht);

	(void) fprintf(ofp, "<A HREF=\"%s\" TARGET=\"_blank\">"
		"<IMG SRC=\"../%s\" ALT=\"\" WIDTH=\"%d\" HEIGHT=\"%d\""
		" VSPACE=\"4\" BORDER=\"0\"></A><BR>\n",
		!lic ? ha_reg : ha_home, buttons[BTN_NETSTORESB].name,
		buttons[BTN_NETSTORESB].wid, buttons[BTN_NETSTORESB].ht);
	prString(ofp, NULL, FONT_HEAD1, NULL, "</P>\n</CENTER>\n</FORM>\n\n"
		"</BODY>\n</HTML>\n", "%s<BR>\n%s", creator, copyright);

	(void) fclose(ofp);
	return;
}

#if defined(VRML)
/*
** Create a VRML model
*/
static void prVRMLModel(char *const stdir, char *const srvname, char *const period) {
	char model[MEDIUMSIZE], templ[MEDIUMSIZE];
	FILE *ofp;
	int rc;

	if (period)
		(void) snprintf(templ, sizeof templ, "3Dstats%02d%02d",
				t.start.mon+1, EPOCH(t.start.year));
	else
		(void) snprintf(templ, sizeof templ, "3Dstats%04hu", t.start.year);

	(void) snprintf(model, sizeof model, "%s/%s.wrl", stdir ? stdir : ".", templ);
	if ((ofp=efopen(model)) == NULL)
		exit(1);

	if (period) {			/* create VRML model */
		if (verbose)
			prmsg(0, "%s %s\n", GETMSG(194, "Creating VRML model for"), period);
		rc = prVRMLStats(ofp, srvname, period, &t.end);
	} else {
		if (verbose)
			prmsg(0, "%s %04d\n", GETMSG(195, "Updating VRML model for"), t.end.year);
		rc = prVRMLYear(ofp, srvname, vrml_prlg, &t.end);
	}
	(void) fclose(ofp);

	if (!rc)	/* something went wrong */
		return;

	if (!compress(model)) {
		prmsg(1, GETMSG(336, "Couldn't compress the VRML model `%s' using gzip?!?\n"), model);
		(void) snprintf(model, sizeof model, "%s.wrl", templ);
	} else
		(void) snprintf(model, sizeof model, "%s.wrl.gz", templ);

	/* create HTML file with VRML inline object */
	if ((ofp=efopen("%s/%s.html", stdir ? stdir : ".", templ)) == NULL)
		exit(1);

	(void) fprintf(ofp,
		"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
		"<HTML>\n<HEAD>\n<META NAME=\"ROBOTS\" CONTENT=\"NONE\">\n"
		"<TITLE>3D %s", doc_title);
	if (period) (void) fprintf(ofp, " (%s)", period);
	(void) fprintf(ofp,
		"</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#000000\" TEXT=\"#FFFFFF\"\n"
		" LINK=\"#00FF00\" ALINK=\"#FF0000\" VLINK=\"#CCCCCC\">\n<CENTER><P ALIGN=\"CENTER\">\n"
		"<EMBED SRC=\"%s\" WIDTH=\"480\" HEIGHT=\"360\">\n<NOEMBED>%s", model, GETMSG(196,
			"The VRML model requires a VRML 2.0 plug-in such as CosmoPlayer from\n"
			"Cosmo Software. If you have another viewer which is fully VRML 2.0 compliant,\n"));
	(void) fprintf(ofp, "<A HREF=\"%s\">%s</A>.</NOEMBED><BR>\n",
			model, GETMSG(197, "download the compressed model here"));

	prString(ofp, NULL, FONT_SMALL, NULL, NULL, "%s %s. %s",
			GETMSG(198, "Created by"), creator, copyright);
	(void) fputs("</P>\n</CENTER>\n</BODY>\n</HTML>\n", ofp);

	(void) fclose(ofp);
	return;
}
#endif

static void prLinks(FILE *const ofp, char *const title, char *const dpfx) {
	char fname[MAX_FNAMELEN], gname[MAX_FNAMELEN];
	char period[SMALLSIZE];
	int idx = (int)t.current.year;
	int rc = 0;

	prHeader(ofp, NULL, title, GETMSG(199, "Access Statistics"));

	(void) fputs("<CENTER><P ALIGN=\"CENTER\">\n"
		     "<TABLE WIDTH=\"70%\" BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"4\">\n", ofp);
	for (rc=0; idx > 1995; idx--) {	/* create links for previous summary periods */
		(void) snprintf(fname, sizeof fname, "%s%04d", dpfx, idx);
		if (access(fname, F_OK) == 0) {
			rc++;
			(void) snprintf(gname, sizeof gname, "%s/gr-icon" IMG_SFX, fname);
#if !defined(OLD_GDLIB)
			if (access(gname, F_OK) != 0)
				(void) snprintf(gname, sizeof gname, "%s/gr-icon.gif", fname);
#endif
			if (idx == (int)t.current.year)
				(void) snprintf(period, sizeof period, "%s",
					GETMSG(191, "the last 12 months"));
			else	(void) snprintf(period, sizeof period, "%04d", idx);

			(void) fprintf(ofp,
				"<TR><TD BGCOLOR=\"#CCCCCC\" ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">"
				"<A HREF=\"%s/index.html\"><IMG SRC=\"%s\""
				" WIDTH=\"59\" HEIGHT=\"41\" ALT=\"\" BORDER=\"0\"></A></TD>\n"
				"<TD BGCOLOR=\"#CCCCCC\" ALIGN=\"LEFT\" VALIGN=\"MIDDLE\">\n"
				"<A HREF=\"%s/index.html\"", fname, gname, fname);
			if (!nonavpanel)
				(void) fprintf(ofp,
					" onClick=\"createWin('%s/jsnav.html',"
					"'%s/index.html');return false;\"", fname, fname);
			prString(ofp, NULL, FONT_HEAD4, ">", "</A>", "%s %s",
					GETMSG(200, "Statistics for"), period);

			(void) snprintf(fname, sizeof fname, "%s%04d/frames.html", dpfx, idx);
			if (access(fname, F_OK) == 0) {
				prString(ofp, NULL, FONT_HEAD3, "<BR>\n", NULL,
					"<B><A HREF=\"%s\">%s</A></B>",
					fname, GETMSG(201, "Frames version"));
				prString(ofp, NULL, FONT_HEAD3, " ", NULL,
					"%s", GETMSG(202, "(requires JavaScript)"));
			}
			(void) fprintf(ofp, "</TD></TR>\n");
		}
	}
	if (!rc && idx == 1995)
		prString(ofp, NULL, FONT_HEAD2,
			"<TR><TD ALIGN=\"CENTER\">", "</TD></TR>\n", "%s",
			GETMSG(203, "Not available (yet)"));
	(void) fputs("</TABLE></P>\n</CENTER>\n", ofp);
	return;
}

/*
** JavaScript functions.
*/
static char *jscreate =
	"<SCRIPT LANGUAGE=\"JavaScript\">\n"
	"<!-- // begin hide script\n"
	"var newWin = null;\n"
	"var vrmlWin = null;\n\n"
	"// Create the navigation window\n"
	"function createWin(loc,pg) {\n"
	"\tnewWin = window.open(loc,'nav_win','toolbar=no,location=no,directories=no,"
	"status=yrd,menubar=no,scrollbars=no,resizable=yes,width=%d,height=%d');\n"
	"\tnewWin.creator = self;\n\tself.location = pg;\n}\n"
	"// Create the VRML window\n"
	"function createVRMLWin(loc) {\n"
	"\tvrmlWin = window.open(loc, 'vrml_win','toolbar=no,location=no,directories=no,"
	"status=yrd,menubar=no,scrollbars=no,resizable=yes,width=%d,height=%d');\n"
	"\tvrmlWin.creator = self;\n}\n\n"
	"// end hide script -->\n</SCRIPT>\n";

static char *jsloadpg =
	"<TITLE>Navigation Window</TITLE>\n"
	"<SCRIPT LANGUAGE=\"JavaScript\">\n"
	"<!-- // begin hide script\n\n"
	"// Load a new page into the creator's window\n"
	"function loadPage(loc) {\n"
	"\tif (!opener)\n\t\tcreator.location = loc;\n"
	"\telse\topener.location = loc;\n}\n\n"
	"// Close the navigation window\n"
	"function closeWin() {\n"
	"\tloadPage('../index.html');\n"
	"\twindow.close(self);\n}\n"
	"// Create the VRML window\n"
	"function createVRMLWin(loc) {\n"
	"\tvrmlWin = window.open(loc, 'vrml_win','toolbar=no,location=no,directories=no,"
	"status=yrd,menubar=no,scrollbars=no,resizable=yes,width=%d,height=%d');\n"
	"\tvrmlWin.creator = self;\n}\n\n"
	"// end hide script -->\n</SCRIPT>\n";

/*
** Print an index file.
*/
static void prIndex(void) {
	int wid = 0;
	FILE *ofp;

	errno = 0;
	if ((ofp=fopen("index.html", "w")) == NULL) {
		prmsg(2, "%s (%s)\n",
			GETMSG(204, "Couldn't create file `index.html'"), strerror(errno));
		return;
	}

	html_header(ofp, doc_title, NULL,
		nonavpanel ? NULL : jscreate, navwid, navht, w3wid, w3ht);
	prLinks(ofp, "WWW", "www");
#if 0
	if (lic) {
		prLinks(ofp, "FTP", "ftp");
		prLinks(ofp, "RealAudio", "ra");
	}
#endif

#if !defined(OLD_GDLIB)
	prString(ofp, NULL, FONT_HEAD1,
		"<CENTER><P ALIGN=\"CENTER\">\n", "</P>\n</CENTER>\n",
		GETMSG(187,
	"Note: If the images on this and the following pages appear to\n"
	"be broken, your browser probably can't display PNG images.<BR>\n"
	"Please use a PNG-capable browser to view the statistics report.\n"
	"<A HREF=\"%s\">Follow this link</A> to learn more about the PNG "
	"image format."), PNG_SITE);
#endif
	if (html_str[HTML_TRAILER])
		(void) fprintf(ofp, "%s\n", html_str[HTML_TRAILER]);

	if ((wid = buttons[BTN_CUSTOMW].name ?
		   buttons[BTN_CUSTOMW].wid : buttons[BTN_RAGSW].wid) < buttons[BTN_NETSTORESW].wid)
		wid = buttons[BTN_NETSTORESW].wid;
	wid += 8;

	(void) fprintf(ofp, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<HR NOSHADE SIZE=\"2\" WIDTH=\"100%%\">\n"
		"<TABLE WIDTH=\"100%%\" BORDER=0 CELLSPACING=0 CELLPADDING=0>\n"
		"<TR><TD WIDTH=\"%d\" ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">\n"
		"<A HREF=\"%s\"><IMG SRC=\"%s\" ALT=\"\""
		" WIDTH=\"%d\" HEIGHT=\"%d\" BORDER=\"0\"></A></TD>\n"
		"<TD NOWRAP VALIGN=\"MIDDLE\" ALIGN=\"CENTER\">\n",
		wid, !lic ? ha_reg : ha_home, buttons[BTN_NETSTORESW].name,
		buttons[BTN_NETSTORESW].wid, buttons[BTN_NETSTORESW].ht);
	if (lic && access("docs.html", F_OK) == 0)
		(void) fprintf(ofp, "<A HREF=\"docs.html\" TARGET=\"manual\">");
	else	(void) fprintf(ofp, "<A HREF=\"%sdocs.html\" TARGET=\"manual\">", ha_home);
	prString(ofp, NULL, FONT_HEAD2, NULL, "</A><BR>\n", GETMSG(193, "Online&nbsp;Documentation"));
	prString(ofp, NULL, FONT_HEAD1, NULL, "<BR>\n",
		"%s <A HREF=\"%s\">%s</A>, %s",
		GETMSG(205, "Statistics by"), ha_home, creator, copyright);

	prString(ofp, NULL, FONT_HEAD1, NULL, NULL, NULL);
	if (lic) {
		prEscHTML(ofp, lic->company);
		(void) fprintf(ofp, "  &#183; %s", lic->regID);
	} else {
		(void) fputs(GETMSG(136, "Evaluation version -"), ofp);
		(void) fprintf(ofp, " <A HREF=\"%s\">%s</A>", ha_reg,
				GETMSG(137, "please register your copy"));
	}
	(void) fprintf(ofp, "%s</TD>\n<TD WIDTH=\"%d\""
		" ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">\n", FONT_END(FONT_VAR), wid);

	if (buttons[BTN_CUSTOMW].name)
		(void) fprintf(ofp, "<A HREF=\"%s\">"
			"<IMG SRC=\"%s\" ALT=\"\" WIDTH=\"%d\" HEIGHT=\"%d\" BORDER=\"0\"></A>",
			buttons[BTN_CUSTOMW].text, buttons[BTN_CUSTOMW].name,
			buttons[BTN_CUSTOMW].wid, buttons[BTN_CUSTOMW].ht);
	else
		(void) fprintf(ofp, "<A HREF=\"%s\">"
			"<IMG SRC=\"%s\" ALT=\"\" WIDTH=\"%d\" HEIGHT=\"%d\" BORDER=\"0\"></A>",
			buttons[BTN_RAGSW].text, buttons[BTN_RAGSW].name,
			buttons[BTN_RAGSW].wid, buttons[BTN_RAGSW].ht);
	(void) fputs("</TD></TR>\n</TABLE></P>\n</CENTER>\n\n</BODY>\n</HTML>\n", ofp);
	(void) fclose(ofp);
	return;
}

/*
** Print a monthly index file.
*/
static void prMonIndex(char *const stdir, int const current, int const last) {
	char fname[MAX_FNAMELEN];
	char period[SMALLSIZE];
	int idx, dst = TABSIZE(grmon)-1;
	int curlink = 0;	/* link to the full stats of currrent month */
	COUNTER *mp;		/* ptr to monthly COUNTER structure */
	FILE *ofp, *ffp;

	/*
	** Create an index file.
	*/
	if (current)
		(void) snprintf(period, sizeof period, "%s", GETMSG(191, "the last 12 months"));
	else	(void) snprintf(period, sizeof period, "%hu", t.end.year);

	(void) snprintf(fname, sizeof fname, "%s/index.html", stdir);
	if (access(fname, F_OK) == 0) {
		if (!monthly)		/* suppress summary in short stats mode */
			return;		/* ... unless file does not exist */
		if (verbose && !current && last)
			prmsg(0, GETMSG(206, "... updating `%s': last report is for %s %hu\n"),
				fname, monnam[t.end.mon], t.end.year);
	}

	(void) snprintf(fname, sizeof fname, "%s/stats%02d%02d.html",
			stdir, t.end.mon+1, EPOCH(t.end.year));
	curlink = monthly ? (!current || t.end.mday > 1) : (access(fname, F_OK) == 0);

	if (!nonavpanel) {
		ffp = NULL;
		if ((ffp=efopen("%s/jsnav.html", stdir)) == NULL)
			exit(1);
		html_header(ffp, NULL, NULL, jsloadpg, w3wid, w3ht);
		prNavYear(ffp, period, curlink);
		(void) fprintf(ffp, "</BODY>\n</HTML>\n");
		(void) fclose(ffp);
	}
	if ((ofp=efopen("%s/index.html", stdir)) == NULL)
		exit(1);

	html_header(ofp, doc_title, period,
		nonavpanel ? NULL : jscreate, navwid, navht, w3wid, w3ht);

	ffp = NULL;
	if (use_frames) {
		if ((ffp=efopen("%s/fstats%hu.html", stdir, t.end.year)) == NULL)
			exit(1);
		html_header(ffp, doc_title, period, NULL);
	}
	prHeader(ofp, ffp, GETMSG(169, "WWW Access Statistics for"), period);

	if (sptab[SP_GRAPHICS].ison)
		dfpr(ofp, ffp, "<CENTER><P ALIGN=\"CENTER\">\n<IMG SRC=\"graph%hu" IMG_SFX
			"\" ALT=\"%s\" WIDTH=\"490\" HEIGHT=\"316\"></P>\n</CENTER>\n",
			t.end.year, GETMSG(207, "Hits by Month"));

	(void) snprintf(fname, sizeof fname, "%s/stats.html", stdir);
	if (current && access(fname, F_OK) == 0)
		openTable(ofp, ffp, 498, tblfmt[FMT_MON],
			GETMSG(208, "<A HREF=\"stats.html\" TARGET=\"_self\">"
				    "Short statistics for %s %d</A> (updated more frequently)"),
			monnam[t.end.mon], t.end.year);
	else
		openTable(ofp, ffp, 498, tblfmt[FMT_MON], NULL);

	prTblHead(ofp, ffp, tblfmt[FMT_MON], GETMSG(209, "Month"), NULL);

	dfpr(ofp, ffp, FMT_SPACE(4) "<TR><TD NOWRAP ALIGN=\"LEFT\"><B>");
	prString(ofp, ffp, FONT_TEXT, NULL, NULL, NULL);

	if (curlink) {
		dfpr(ofp, NULL, "<A HREF=\"stats%02d%02d.html\"", t.end.mon+1, EPOCH(t.end.year));
		if (!nonavpanel)
			dfpr(ofp, NULL,
				" onClick=\"createWin('nav%02d%02d.html',"
				"'totals%02d%02d.html');return false;\"",
				t.end.mon+1, EPOCH(t.end.year), t.end.mon+1, EPOCH(t.end.year));
		dfpr(ofp, NULL, ">%s %d</A>\n", monnam[t.end.mon], t.end.year);
	} else
		dfpr(ofp, NULL, "%s %d", monnam[t.end.mon], t.end.year);

	dfpr(NULL, ffp, "%s %d", monnam[t.end.mon], t.end.year);
	dfpr(ofp, ffp, "%s</B></TD>\n", FONT_END(FONT_TEXT));

	prTblRow(ofp, ffp, tblfmt[FMT_MON]+1, 0, NULL, &total, NULL, NULL);

	cksum = grmon[dst] = total;

	if (current && sptab[SP_INTERPOL].ison) {	/* interpolate values based on average values */
		int leap = t.end.year%4 == 0 && (t.end.year%100 != 0 || t.end.year%400 == 0);
		int ddiff = (int)(mdays[leap][t.end.mon] - t.end.mday);

		if (ddiff > 0) {
			grmon[dst].hits  += (grmon[dst].hits * (u_long)ddiff) / (u_long)t.current.mday;
			grmon[dst].files += (grmon[dst].files * (u_long)ddiff) / (u_long)t.current.mday;
			grmon[dst].nomod += (grmon[dst].nomod * (u_long)ddiff) / (u_long)t.current.mday;
			grmon[dst].views += (grmon[dst].views * (u_long)ddiff) / (u_long)t.current.mday;
			grmon[dst].sessions += (grmon[dst].sessions * (u_long)ddiff) / (u_long)t.current.mday;
			grmon[dst].bytes += (grmon[dst].bytes * (float)ddiff) / (float)t.current.mday;
		}
	}
	grlabel[dst--] = monnam[t.end.mon];

	for (idx=(int)t.end.mon; --idx >= 0; ) {
		mp = &monly[idx];
		dfpr(ofp, ffp, "<TR><TD NOWRAP ALIGN=\"LEFT\"><B>");
		prString(ofp, ffp, FONT_TEXT, NULL, NULL, NULL);

		if (mp->hits > 0L) {
			dfpr(ofp, NULL, "<A HREF=\"stats%02d%02d.html\"", idx+1, EPOCH(t.end.year));
			if (!nonavpanel)
				dfpr(ofp, NULL,
				" onClick=\"createWin('nav%02d%02d.html',"
				"'totals%02d%02d.html');return false;\"",
				idx+1, EPOCH(t.end.year), idx+1, EPOCH(t.end.year));
			dfpr(ofp, NULL, ">%s %d</A>\n", monnam[idx], t.end.year);
		} else
			dfpr(ofp, NULL, "%s %d", monnam[idx], t.end.year);
		dfpr(NULL, ffp, "%s %d", monnam[idx], t.end.year);
		dfpr(ofp, ffp, "%s</B></TD>\n", FONT_END(FONT_TEXT));

		prTblRow(ofp, ffp, tblfmt[FMT_MON]+1, 0, NULL, &monly[idx], NULL, NULL);

		grmon[dst] = *mp;
		UPDATE_CNT(cksum, *mp);

		grlabel[dst--] = monnam[idx];
	}
	for (idx=11; idx > (int)t.end.mon; idx--) {
		mp = &monly[idx];
		dfpr(ofp, ffp, "<TR><TD NOWRAP ALIGN=\"LEFT\"><B>");
		prString(ofp, ffp, FONT_TEXT, NULL, NULL, NULL);

		if (mp->hits > 0L) {
			dfpr(ofp, NULL, "<A HREF=\"../www%d/stats%02d%02d.html\"",
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U));
			if (!nonavpanel)
				dfpr(ofp, NULL,
				" onClick=\"createWin('../www%d/nav%02d%02d.html',"
				"'../www%d/totals%02d%02d.html');return false;\"",
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U),
				t.end.year-1U, idx+1, EPOCH(t.end.year-1U));
			dfpr(ofp, NULL, ">%s %d</A>\n", monnam[idx], t.end.year-1U);
		} else
			dfpr(ofp, NULL, "%s %d", monnam[idx], t.end.year-1U);

		dfpr(NULL, ffp, "%s %d", monnam[idx], t.end.year-1U);
		dfpr(ofp, ffp, "%s</B></TD>\n", FONT_END(FONT_TEXT));

		prTblRow(ofp, ffp, tblfmt[FMT_MON]+1, 0, NULL, &monly[idx], NULL, NULL);

		grmon[dst] = *mp;
		UPDATE_CNT(cksum, *mp);

		grlabel[dst--] = monnam[idx];
	}

	grmon[dst] = monly[idx];	/* previous year */
	grlabel[dst] = monnam[idx];

	dfpr(ofp, ffp, FMT_SPACE(4));
	prTblRow(ofp, ffp, tblfmt[FMT_MON], 0, GETMSG(131, "Total"), &cksum, NULL, NULL);

	cksum.hits  /= 12L;
	cksum.files /= 12L;
	cksum.nomod /= 12L;
	cksum.views /= 12L;
	cksum.sessions /= 12L;
	cksum.bytes /= 12.0;

	dfpr(ofp, ffp, FMT_SPACE(4));
	prTblRow(ofp, ffp, tblfmt[FMT_MON], 0, GETMSG(132, "Average"), &cksum, NULL, NULL);

	closeTable(ofp, ffp);

	dfpr(ofp, ffp, "<CENTER><P ALIGN=\"CENTER\">\n");
	dfpr(ofp, NULL, "<TABLE WIDTH=\"498\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n<TR>");

	(void) snprintf(fname, sizeof fname, "%s/frames.html", stdir);
	if (use_frames && access(fname, F_OK) == 0) {
		prString(ofp, NULL, FONT_HEAD2,
			"<TD NOWRAP ALIGN=\"LEFT\" WIDTH=\"24%\">\n"
			"<A HREF=\"frames.html\">", "</A><BR>\n",
			"<B>%s</B>", GETMSG(201, "Frames version"));
		prString(ofp, NULL, FONT_HEAD1, NULL, "</TD>\n",
			"%s", GETMSG(202, "(requires JavaScript)"));
	} else
		(void) fputs("<TD WIDTH=\"24%\"></TD>\n", ofp);

	prString(ofp, NULL, FONT_HEAD2,
		"<TD NOWRAP ALIGN=\"CENTER\"><A HREF=\"../index.html\">", "</A><BR>\n",
		"<B>%s</B>", GETMSG(210, "Back to the Main Page"));

	prString(ofp, ffp, FONT_HEAD1, NULL, NULL, NULL);
	if (lic) {
		if (ofp)
			prEscHTML(ofp, lic->company);
		if (ffp)
			prEscHTML(ffp, lic->company);
		dfpr(ofp, ffp, " &#183; %s", lic->regID);
	} else {
		dfpr(ofp, ffp, "%s", GETMSG(136, "Evaluation version -"));
		dfpr(ofp, ffp, " <A HREF=\"%s\">%s</A>", ha_reg,
			GETMSG(137, "please register your copy"));
	}
	dfpr(ofp, ffp, "%s", FONT_END(FONT_VAR));
	(void) fputs("</TD>\n", ofp);
	if (ffp != NULL)
		(void) fputs("</P>\n</CENTER>\n", ffp);

	if (use_vrml) {
		(void) fputs("<TD NOWRAP ALIGN=\"RIGHT\" WIDTH=\"24%\">\n"
			"<A TARGET=\"vrml_win\" HREF=\"../3Dlogo.html\"", ofp);
		if (!nonavpanel)
			(void) fprintf(ofp,
				" onClick=\"createVRMLWin('../3Dlogo.html');return false;\"");
		prString(ofp, NULL, FONT_HEAD2, ">", "</A><BR>\n",
			"<B>%s</B>", GETMSG(157, "3D model"));
		prString(ofp, NULL, FONT_HEAD1, NULL, "</TD>\n",
			"%s", GETMSG(211, "(requires VRML)"));
	} else
		(void) fputs("<TD WIDTH=\"24%\"></TD>", ofp);
	dfpr(ofp, NULL, "</TR>\n</TABLE></P>\n</CENTER>\n");

	if (ffp) {
		html_trailer(ffp);
		(void) fclose(ffp);
	}
	html_trailer(ofp);
	(void) fclose(ofp);

	if (sptab[SP_GRAPHICS].ison) {
		(void) snprintf(fname, sizeof fname, "%s/graph%hu" IMG_SFX, stdir, t.end.year);
		(void) graph(&grmon[0], grlabel, 490, 317, 28, t.end.year,
				fname, sptab[SP_PAGEVIEWS].ison);

		(void) snprintf(fname, sizeof fname, "%s/gr-icon" IMG_SFX, stdir);
		(void) graph(&grmon[0], NULL, 50, 32, 0, t.end.year,
				fname, sptab[SP_PAGEVIEWS].ison);
	}
#if defined(VRML)
	if (use_vrml) {
		errno = 0;
		if ((ffp=fopen("3Dlogo.html", "w")) == NULL) {
			prmsg(2, GETMSG(83, enoent), "3Dlogo.html", strerror(errno));
			exit(1);
		}
		(void) fprintf(ffp,		/* create 3D logo file */
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
			"<HTML>\n<HEAD>\n<META NAME=\"ROBOTS\" CONTENT=\"NONE\">\n"
			"<TITLE>3D %s</TITLE>\n</HEAD>\n"
			"<BODY BGCOLOR=\"#000000\" TEXT=\"#FFFFFF\"\n"
			" LINK=\"#00FF00\" ALINK=\"#FF0000\" VLINK=\"#CCCCCC\">\n"
			"<CENTER><P ALIGN=\"CENTER\">\n"
			"<EMBED SRC=\"3Dlogo.wrl.gz\" WIDTH=\"480\" HEIGHT=\"360\">\n", doc_title);

		(void) fprintf(ofp, "<NOEMBED>%s", GETMSG(196,
				"The VRML model requires a VRML 2.0 plug-in such as CosmoPlayer from\n"
				"Cosmo Software. If you have another viewer which is fully VRML 2.0 compliant,\n"));
		(void) fprintf(ofp, "<A HREF=\"3Dlogo.wrl.gz\">%s</A>.</NOEMBED><BR>\n",
				GETMSG(197, "download the compressed model here"));

		prString(ffp, NULL, FONT_TEXT, NULL, NULL, NULL);
		for (idx=0; idx < 12; idx++) {
			(void) snprintf(fname, sizeof fname, "%s/3Dstats%02d%02d.html",
					stdir, idx+1, EPOCH(t.end.year));
			if (access(fname, F_OK) == 0) {
				(void) fprintf(ffp, "<A HREF=\"%s\">%.3s</A>%s\n",
					fname, monnam[idx], idx < 11 ? " |" : "");
				continue;
			}
			(void) fprintf(ffp, "%.3s%s\n",
				monnam[idx], idx < 11 ? " |" : "");
		}
		(void) fprintf(ffp,
			"%s</P>\n</CENTER>\n</BODY>\n</HTML>\n", FONT_END(FONT_TEXT));
		(void) fclose(ffp);
	}
#endif
	return;
}

/*
** Sort list by hits.
*/
static int sort_by_hits(const void *e1, const void *e2) {
	if ((*(NLIST **)e2)->cnt.hits == (*(NLIST **)e1)->cnt.hits)
		return 0;
	return ((*(NLIST **)e2)->cnt.hits < (*(NLIST **)e1)->cnt.hits) ? -1 : 1;
}

/*
** Sort list by hidden item.
*/
static int sort_by_item(const void *e1, const void *e2) {
	register size_t stamp1 = (size_t)(*(NLIST **)e1)->ishidden;	/* already checked for -1 */
	register size_t stamp2 = (size_t)(*(NLIST **)e2)->ishidden;
	register ITEM_LIST *ip = hidden[HIDDEN_ITEMS].tab;

	if (stamp1 == stamp2 || ip[stamp1].col == ip[stamp2].col) {
		if ((*(NLIST **)e2)->cnt.hits == (*(NLIST **)e1)->cnt.hits)
			return 0;
		return ((*(NLIST **)e2)->cnt.hits < (*(NLIST **)e1)->cnt.hits) ? -1 : 1;
	}
	if (ip[stamp1].col->cnt.hits == ip[stamp2].col->cnt.hits)
		return (stamp2 < stamp1) ? -1 : 1;
	return (ip[stamp2].col->cnt.hits < ip[stamp1].col->cnt.hits) ? -1 : 1;
}

/*
** Sort list by hidden client domain.
*/
static int sort_by_domain(const void *e1, const void *e2) {
	register size_t stamp1 = (size_t)(*(NLIST **)e1)->ishidden;
	register size_t stamp2 = (size_t)(*(NLIST **)e2)->ishidden;
	register ITEM_LIST *ip = hidden[HIDDEN_SITES].tab;

	if (stamp1 == stamp2 || ip[stamp2].col == ip[stamp1].col) {
		if ((*(NLIST **)e2)->cnt.hits == (*(NLIST **)e1)->cnt.hits)
			return 0;
		return ((*(NLIST **)e2)->cnt.hits < (*(NLIST **)e1)->cnt.hits) ? -1 : 1;
	}
	if (ip[stamp1].col->cnt.hits == ip[stamp2].col->cnt.hits)
		return (stamp2 < stamp1) ? -1 : 1;
	return (ip[stamp2].col->cnt.hits < ip[stamp1].col->cnt.hits) ? -1 : 1;
}

/*
** Sort list by reverse domain.
*/
static int sort_by_revdom(const void *e1, const void *e2) {
	static char nbuf1[MEDIUMSIZE], nbuf2[MEDIUMSIZE];

	revDomain((*(NLIST **)e1)->str, (*(NLIST **)e1)->len, nbuf1, sizeof(nbuf1));
	revDomain((*(NLIST **)e2)->str, (*(NLIST **)e2)->len, nbuf2, sizeof(nbuf2));
	return strcasecmp(nbuf1, nbuf2);
}

/*
** Sort list by hidden browser type.
*/
static int sort_by_agent(const void *e1, const void *e2) {
	register size_t stamp1 = (size_t)(*(NLIST **)e1)->ishidden;
	register size_t stamp2 = (size_t)(*(NLIST **)e2)->ishidden;
	register ITEM_LIST *ip = hidden[HIDDEN_AGENTS].tab;

	if (stamp1 == stamp2 || ip[stamp2].col == ip[stamp1].col) {
		if ((*(NLIST **)e2)->cnt.hits == (*(NLIST **)e1)->cnt.hits)
			return 0;
		return ((*(NLIST **)e2)->cnt.hits < (*(NLIST **)e1)->cnt.hits) ? -1 : 1;
	}
	if (ip[stamp1].col->cnt.hits == ip[stamp2].col->cnt.hits)
		return (stamp2 < stamp1) ? -1 : 1;
	return (ip[stamp2].col->cnt.hits < ip[stamp1].col->cnt.hits) ? -1 : 1;
}

/*
** Sort list by hidden referrer URL.
*/
static int sort_by_refer(const void *e1, const void *e2) {
	register size_t stamp1 = (size_t)(*(NLIST **)e1)->ishidden;
	register size_t stamp2 = (size_t)(*(NLIST **)e2)->ishidden;
	register ITEM_LIST *ip = hidden[HIDDEN_REFERS].tab;

	if (stamp1 == stamp2 || ip[stamp1].col == ip[stamp2].col) {
		if ((*(NLIST **)e2)->cnt.hits == (*(NLIST **)e1)->cnt.hits)
			return 0;
		return ((*(NLIST **)e2)->cnt.hits < (*(NLIST **)e1)->cnt.hits) ? -1 : 1;
	}
	if (ip[stamp1].col->cnt.hits == ip[stamp2].col->cnt.hits)
		return (stamp2 < stamp1) ? -1 : 1;
	return (ip[stamp2].col->cnt.hits < ip[stamp1].col->cnt.hits) ? -1 : 1;
}

/*
** Sort country list by number of hits.
*/
static int sort_by_cntry(const void *e1, const void *e2) {
	if ((*(COUNTRY **)e2)->cnt.hits == (*(COUNTRY **)e1)->cnt.hits)
		return 0;

	return ((*(COUNTRY **)e2)->cnt.hits < (*(COUNTRY **)e1)->cnt.hits) ? -1 : 1;
}

/*
** Sort list by string lexicographically (case-insensitive).
*/
static int sort_by_casestr(const void *e1, const void *e2) {
	return strcasecmp(((ITEM_LIST *)e1)->pfx, ((ITEM_LIST *)e2)->pfx);
}

/*
** Sort list by string lexicographically (case-sensitive).
*/
static int sort_by_string(const void *e1, const void *e2) {
	return strcmp(((ITEM_LIST *)e1)->pfx, ((ITEM_LIST *)e2)->pfx);
}

/*
** Sort list by ascending string length, then lexicographically.
*/
static int sort_by_slen(const void *e1, const void *e2) {
	if (((ITEM_LIST *)e1)->len != ((ITEM_LIST *)e2)->len)
		return (((ITEM_LIST *)e1)->len < ((ITEM_LIST *)e2)->len) ? -1 : 1;

	return msiis_mode ?
		strcasecmp(((ITEM_LIST *)e1)->pfx, ((ITEM_LIST *)e2)->pfx) :
		strcmp(((ITEM_LIST *)e1)->pfx, ((ITEM_LIST *)e2)->pfx);
}

/*
** Sort top list by hits and data sent.
*/
static int sort_top(const void *e1, const void *e2) {
	if (((TOP_COUNTER *)e2)->cnt.hits == ((TOP_COUNTER *)e1)->cnt.hits) {
		if (((TOP_COUNTER *)e2)->cnt.bytes > ((TOP_COUNTER *)e1)->cnt.bytes)
			return 1;
		else if (((TOP_COUNTER *)e2)->cnt.bytes < ((TOP_COUNTER *)e1)->cnt.bytes)
			return -1;
		else
			return 0;
	}
	return (((TOP_COUNTER *)e2)->cnt.hits < ((TOP_COUNTER *)e1)->cnt.hits) ? -1 : 1;
}

/*
** Print monthly summary.
*/
#define SQ_WID(max, val) (!(val) || !(max) ? 1L : (u_long)(((val)*100.0)/(max))+1L)
#define ISHIDDEN(listp, which)	\
	((listp)->ishidden >= 0 && (size_t)((listp)->ishidden) < hidden[which].t_count)


static void prMonStats(char *const stdir) {
	char tbuf[MAX_FNAMELEN];	/* name of output file */
	char period[SMALLSIZE];		/* statistics period */
	int idx, curday, prhead;	/* temp, current day, flag */
	u_long total_lines = 0L;	/* total # of lines read */
	u_long kbytes;			/* total KB sent */
	COUNTER hsum;			/* correction for totals */
	COUNTRY *ccp, **clist = NULL;	/* ptr into (sorted) country list */
	FILE *ofp, *ffp;

	(void) snprintf(period, sizeof period, "%s %hu", monnam[t.end.mon], t.end.year);
	(void) memset((void *)lntab, 0, sizeof lntab);

	/* Compute average and max hits */
	for (curday=0; curday < (int)t.end.mday; curday++) {
		int cc = wdtab[curday];
		wh_cnt[cc]++;

		UPDATE_CNT(avg_day, daily[curday]);
		if (daily[curday].hits > max_day.hits)
			max_day.hits = daily[curday].hits;
		if (daily[curday].files > max_day.files)
			max_day.files = daily[curday].files;
		if (daily[curday].nomod > max_day.nomod)
			max_day.nomod = daily[curday].nomod;
		if (daily[curday].views > max_day.views)
			max_day.views = daily[curday].views;
		if (daily[curday].sessions > max_day.sessions)
			max_day.sessions = daily[curday].sessions;
		if (daily[curday].bytes > max_day.bytes)
			max_day.bytes = daily[curday].bytes;
	}
	avg_day.hits  /= ndays;
	avg_day.files /= ndays;
	avg_day.nomod /= ndays;
	avg_day.views /= ndays;
	avg_day.sessions /= ndays;
	avg_day.bytes /= (float)ndays;

	if (max_day.bytes < 1024.0)
		max_day.bytes = 1024.0;

#if defined(VRML)
	if (use_vrml) {
		for (curday=0; curday < 7; curday++) {
			for (idx=0; idx < 24; idx++) {
				if (wh_hits[curday][idx] && wh_cnt[curday])
					wh_hits[curday][idx] /= (u_long)wh_cnt[curday];
				if (max_whhits < wh_hits[curday][idx])
					max_whhits = wh_hits[curday][idx];

				avg_wday[curday] += wh_hits[curday][idx];
				avg_whour[idx] += wh_hits[curday][idx];
			}
			if (wh_cnt[curday]) {
				if (weekly[curday].hits)
					weekly[curday].hits /= (u_long)wh_cnt[curday];
				if (weekly[curday].files)
					weekly[curday].files /= (u_long)wh_cnt[curday];
				if (weekly[curday].nomod)
					weekly[curday].nomod /= (u_long)wh_cnt[curday];
				if (weekly[curday].views)
					weekly[curday].views /= (u_long)wh_cnt[curday];
				if (weekly[curday].sessions)
					weekly[curday].sessions /= (u_long)wh_cnt[curday];
			}
			avg_wday[curday] /= 24L;
			if (max_avdhits < avg_wday[curday])
				max_avdhits = avg_wday[curday];
		}
		for (idx=0; idx < 24; idx++) {
			avg_hour[idx] /= ndays;
			if (max_avhits < avg_hour[idx])
				max_avhits = avg_hour[idx];

			avg_whour[idx] /= 7L;
			if (max_avhhits < avg_whour[idx])
				max_avhhits = avg_whour[idx];
		}

		if (max_avhits < 1L)
			max_avhits = 1L;
		if (max_avdhits < 1L)
			max_avdhits = 1L;
		if (max_avhhits < 1L)
			max_avhhits = 1L;
		if (max_whhits < 1L)
			max_whhits = 1L;
	} else
#endif
	   if (sptab[SP_GRAPHICS].ison) {
		for (idx=0; idx < 24; idx++) {
			avg_hour[idx] /= ndays;
			if (max_avhits < avg_hour[idx])
				max_avhits = avg_hour[idx];
		}
		if (max_avhits < 1L)
			max_avhits = 1L;
	   }

#if defined(VRML)
	if (use_vrml) {
		prVRMLModel(stdir, srv_name, period);
		if (vrml_prlg)
			prVRMLModel(stdir, srv_name, NULL);
	}
#endif
	if (verbose)
		prmsg(0, "%s %s\n", GETMSG(212, "Creating full statistics for"), period);

	if (uniq_urls)
		prURLStats(stdir, period);
	else if (verbose)
		prmsg(0, GETMSG(213, "... no URLs found\n"));

	if (uniq_sites)
		prSiteStats(stdir, period);
	else if (verbose)
		prmsg(0, GETMSG(214, "... no hostnames found\n"));

	if (total_agents)
		prAgentStats(stdir, period);
	else if (verbose && logfmt != LOGF_CLF)
		prmsg(0, GETMSG(215, "... no user agents found\n"));

	if (total_refer)
		prReferStats(stdir, period);
	else if (verbose && logfmt != LOGF_CLF)
		prmsg(0, GETMSG(216, "... no referrer URLs found\n"));

	/* Now sort the top N lists by accesses */
	if (top_day) {
		qsort((void *)top_day, topn_day, sizeof(TOP_COUNTER), sort_top);
		while (topn_day > 0 && !top_day[topn_day-1].cnt.hits)
			topn_day--;
	}
	if (top_hrs) {
		qsort((void *)top_hrs, topn_hrs, sizeof(TOP_COUNTER), sort_top);
		while (topn_hrs > 0 && !top_hrs[topn_hrs-1].cnt.hits)
			topn_hrs--;
	}
	if (top_min) {
		qsort((void *)top_min, topn_min, sizeof(TOP_COUNTER), sort_top);
		while (topn_min > 0 && !top_min[topn_min-1].cnt.hits)
			topn_min--;
	}
	if (top_sec) {
		qsort((void *)top_sec, topn_sec, sizeof(TOP_COUNTER), sort_top);
		while (topn_sec > 0 && !top_min[topn_sec-1].cnt.hits)
			topn_sec--;
	}

	if (use_frames)			/* create a frames interface */
		prFrameHeader(stdir);

	if ((ofp=efopen("%s/stats%02d%02d.html",
		stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
		exit(1);

	html_header(ofp, doc_title, period, NULL);

	if ((ffp=efopen("%s/totals%02d%02d.html",
	    stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
		exit(1);

	html_header(ffp, doc_title, period, NULL);
	prHeader(ofp, ffp, GETMSG(152, "Full Statistics for"), period);

	dfpr(ofp, ffp, "<CENTER><P ALIGN=\"CENTER\">\n"
		"<TABLE WIDTH=\"498\" BORDER=\"2\" CELLSPACING=\"1\" CELLPADDING=\"1\">\n");

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TR><TH COLSPAN=\"4\" BGCOLOR=\"#CCCCCC\">", "</TH></TR>\n",
		"%s", GETMSG(217, "Monthly Summary"));

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">\n", NULL,
		"%s", GETMSG(218, "Total hits (any request)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_GREEN);

	prString(ofp, ffp, FONT_TEXT, NULL, NULL,
		"%s", GETMSG(219, "Total files sent (Code 200)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_BLUE);

	prString(ofp, ffp, FONT_TEXT, NULL, NULL,
		"%s", GETMSG(220, "Total files saved by cache (Code 304)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_YELLOW);

	prString(ofp, ffp, FONT_TEXT, NULL, NULL,
		"%s", GETMSG(221, "Other response codes (see below)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"></TD>\n", SQICON_RED);

	dfpr(ofp, ffp, "<TD VALIGN=\"MIDDLE\">"
		"<IMG SRC=\"../%s\" ALT=\"\" VSPACE=\"2\" HEIGHT=\"8\" WIDTH=\"102\"><BR>\n"
		"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\">"
		"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\">"
		"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\"></TD>\n",
		SQICON_GREEN, SQICON_BLUE, SQ_WID(total.hits, total.files),
		SQICON_YELLOW, SQ_WID(total.hits, total.nomod),
		SQICON_RED, SQ_WID(total.hits, total.hits-(total.files+total.nomod)));

	prString(ofp, ffp, FONT_TEXT, "<TD ALIGN=\"RIGHT\">", NULL, "100.00%%");
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%6.2f%%", PERCENT(total.files, total.hits));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%6.2f%%", PERCENT(total.nomod, total.hits));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD>\n", "%6.2f%%",
		 PERCENT(total.hits-(total.files+total.nomod), total.hits));

	prString(ofp, ffp, FONT_TEXT,
		"<TD WIDTH=\"20%\" ALIGN=\"RIGHT\">", "<BR>\n", "<B>%lu</B>", total.hits);
	prString(ofp, ffp, FONT_TEXT, NULL, "<BR>\n", "<B>%lu</B>", total.files);
	prString(ofp, ffp, FONT_TEXT, NULL, "<BR>\n", "<B>%lu</B>", total.nomod);
	prString(ofp, ffp, FONT_TEXT, NULL, "</TD></TR>\n", "<B>%lu</B>",
		 total.hits-(total.files+total.nomod));

	if (sptab[SP_PAGEVIEWS].ison) {
		prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
			"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">\n", NULL,
			"%s", GETMSG(222, "Total pageviews"));
		dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_MAGENTA);

		prString(ofp, ffp, FONT_TEXT, NULL, NULL, "%s", GETMSG(223, "Remaining responses"));
		dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"></TD>\n", SQICON_GREY);

		dfpr(ofp, ffp, "<TD VALIGN=\"MIDDLE\">"
			"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\">"
			"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\"></TD>\n",
			SQICON_MAGENTA, SQ_WID(total.hits, total.views),
			SQICON_GREY, SQ_WID(total.hits, total.hits-total.views)+1);

		prString(ofp, ffp, FONT_TEXT, "<TD ALIGN=\"RIGHT\">", NULL,
			"%6.2f%%", PERCENT(total.views, total.hits));
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD>\n",
			"%6.2f%%", PERCENT(total.hits-total.views, total.hits));

		prString(ofp, ffp, FONT_TEXT,
			"<TD ALIGN=\"RIGHT\">", "<BR>\n", "<B>%lu</B>", total.views);
		prString(ofp, ffp, FONT_TEXT, NULL, "</TD></TR>\n", "<B>%lu</B>", total.hits-total.views);
	}

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">", NULL,
		"%s", GETMSG(224, "Total KB requested"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_GREEN);
	prString(ofp, ffp, FONT_TEXT, NULL, NULL,
		"%s", GETMSG(225, "Total KB transferred (Code 200)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"><BR>\n", SQICON_ORANGE);
	prString(ofp, ffp, FONT_TEXT, NULL, NULL,
		"%s", GETMSG(226, "Total KB saved by cache (Code 304)"));
	dfpr(ofp, ffp, " <IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"4\"></TD>\n", SQICON_YELLOW);

	kbytes = KBYTES(total.bytes);
	dfpr(ofp, ffp, "<TD VALIGN=\"MIDDLE\">\n"
		"<IMG SRC=\"../%s\" ALT=\"\" VSPACE=\"2\" HEIGHT=\"8\" WIDTH=\"%d\"><BR>\n"
		"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\">"
		"<IMG SRC=\"../%s\" ALT=\"\" HEIGHT=\"8\" WIDTH=\"%lu\"></TD>\n",
		SQICON_GREEN, 102,
		SQICON_ORANGE, SQ_WID(kbytes+total_kbsaved, kbytes),
		SQICON_YELLOW, SQ_WID(kbytes+total_kbsaved, total_kbsaved));

	prString(ofp, ffp, FONT_TEXT, "<TD ALIGN=\"RIGHT\">", NULL, "100.00%%");
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%6.2f%%",
		PERCENT(kbytes, kbytes+total_kbsaved));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD>\n", "%6.2f%%",
		PERCENT(total_kbsaved, kbytes+total_kbsaved));

	prString(ofp, ffp, FONT_TEXT,
		"<TD ALIGN=\"RIGHT\">", NULL, "<B>%lu</B>", kbytes+total_kbsaved);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", kbytes);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD></TR>\n", "<B>%lu</B>", total_kbsaved);

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">", NULL,
		"%s", GETMSG(227, "Total unique URLs"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, GETMSG(228, "Total unique sites"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
		"%s", GETMSG(229, "Total user sessions"));

	if (total_agents)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(231, "Total unique agents"));
	if (total_refer)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(232, "Total unique referrer URLs"));

	prString(ofp, ffp, FONT_TEXT,
		"</TD><TD COLSPAN=\"3\" ALIGN=\"RIGHT\">", NULL, "<B>%lu</B>", uniq_urls);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", uniq_sites);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", total.sessions);

	if (total_agents)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", total_agents);

	if (total_refer)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", total_refer);
	dfpr(ofp, ffp, "</TD></TR>\n");

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TD>&nbsp;</TD>\n<TD COLSPAN=\"2\" ALIGN=\"RIGHT\">", "</TD>\n",
		"%s", GETMSG(233, "Maximum"));
	prString(ofp, ffp, FONT_TEXT, "<TD ALIGN=\"RIGHT\">", "</TD></TR>\n",
		"%s", GETMSG(234, "Average"));
	prString(ofp, ffp, FONT_TEXT,
		"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">\n", NULL,
		"%s", GETMSG(235, "Hits per day"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%s", GETMSG(236, "Files sent per day"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%s", GETMSG(237, "Files cached per day"));

	if (sptab[SP_PAGEVIEWS].ison)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(238, "Pageviews per day"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%s", GETMSG(239, "Sessions per day"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD>\n", "%s", GETMSG(240, "KB sent per day"));

	prString(ofp, ffp, FONT_TEXT,
		"<TD COLSPAN=\"2\" ALIGN=\"RIGHT\">", NULL, "<B>%lu</B>", max_day.hits);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", max_day.files);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", max_day.nomod);
	if (sptab[SP_PAGEVIEWS].ison)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", max_day.views);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", max_day.sessions);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD>\n", "<B>%lu</B>", KBYTES(max_day.bytes));

	prString(ofp, ffp, FONT_TEXT, "<TD ALIGN=\"RIGHT\">", NULL, "<B>%lu</B>", avg_day.hits);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", avg_day.files);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", avg_day.nomod);
	if (sptab[SP_PAGEVIEWS].ison)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", avg_day.views);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", avg_day.sessions);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", "</TD></TR>\n", "<B>%lu</B>", KBYTES(avg_day.bytes));

	prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
		"<TR><TH COLSPAN=\"4\" ALIGN=\"CENTER\" BGCOLOR=\"#CCCCCC\">",
		"</TH></TR>\n" FMT_SPACE(4), "%s", GETMSG(241, "Logfile statistics"));
	prString(ofp, ffp, FONT_TEXT, "<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">",
		NULL, "%s", GETMSG(242, "Total logfile entries read"));
	prString(ofp, ffp, FONT_TEXT, "<BR>\n",
		NULL, "%s", GETMSG(243, "Total logfile entries processed"));

	total_lines = total.hits;

	if (reqauth) {
		if (!sptab[SP_AUTHREQ].ison) {
			total_lines += reqauth;
			prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
				"%s", GETMSG(244, "Total authenticated requests (skipped)"));
		} else	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
				"%s", GETMSG(245, "Total authenticated requests (inclusive)"));
	}
	if (corrupt) {
		total_lines += corrupt;
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(246, "Corrupt logfile entries"));
	}
	if (reqempty) {
		total_lines += reqempty;
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(247, "Empty Request Method"));
	}
	if (reqinval) {
		total_lines += reqinval;
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL,
			"%s", GETMSG(248, "Unknown Request Method"));
	}

	prString(ofp, ffp, FONT_TEXT, "</TD>\n"
		"<TD COLSPAN=\"3\" ALIGN=\"RIGHT\">", NULL, "<B>%lu</B>", total_lines);
	prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", total.hits);

	if (reqauth)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", reqauth);
	if (corrupt)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", corrupt);
	if (reqempty)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", reqempty);
	if (reqinval)
		prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "<B>%lu</B>", reqinval);

	dfpr(ofp, ffp, "</TD></TR>\n");

	prhead = 1;		/* flag to print header */
	for (idx=0; idx < (int)TABSIZE(RespCode); idx++) {
		if (idx == IDX_OK || idx == IDX_NOT_MODIFIED || !RespCode[idx].cnt.hits)
			continue;

		if (prhead) {
			prString(ofp, ffp, FONT_TEXT, FMT_SPACE(4)
				"<TR><TH COLSPAN=\"4\" BGCOLOR=\"#CCCCCC\">",
				"</TH></TR>\n" FMT_SPACE(4), "%s", GETMSG(249, "Other Response Codes"));
			prString(ofp, ffp, FONT_TEXT,
				"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">", NULL,
				"%s", RespCode[idx].msg);
			prhead = 0;
		} else
			prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%s", RespCode[idx].msg);
	}
	if (!prhead) {
		prhead = 1;
		dfpr(ofp, ffp, "</TD><TD COLSPAN=\"3\" ALIGN=\"RIGHT\">\n");
		for (idx=0; idx < (int)TABSIZE(RespCode); idx++) {
			if (idx == IDX_OK || idx == IDX_NOT_MODIFIED || !RespCode[idx].cnt.hits)
				continue;

			prString(ofp, ffp, FONT_TEXT,
				prhead ? NULL : "<BR>\n", NULL, "<B>%lu</B>", RespCode[idx].cnt.hits);
			prhead = 0;
		}
		dfpr(ofp, ffp, "</TD></TR>\n");
	}

	prhead = 1;		/* flag to print header */
	for (idx=0; idx < (int)TABSIZE(ReqMethod); idx++) {
		if (!ReqMethod[idx].cnt.hits)
			continue;

		if (prhead) {
			prString(ofp, ffp, FONT_TEXT,
				FMT_SPACE(4) "<TR><TH COLSPAN=\"4\" BGCOLOR=\"#CCCCCC\">",
				"</TH></TR>\n" FMT_SPACE(4),
				"%s", GETMSG(250, "Request Methods other than GET/POST"));
			prString(ofp, ffp, FONT_TEXT,
				"<TR><TD WIDTH=\"60%\" NOWRAP ALIGN=\"RIGHT\">", NULL,
				"%s", ReqMethod[idx].msg);
			prhead = 0;
		} else
			prString(ofp, ffp, FONT_TEXT, "<BR>\n", NULL, "%s", ReqMethod[idx].msg);
	}	
	if (!prhead) {
		prhead = 1;
		dfpr(ofp, ffp, "</TD><TD COLSPAN=\"3\" ALIGN=\"RIGHT\">\n");
		for (idx=0; idx < (int)TABSIZE(ReqMethod); idx++) {
			if (!ReqMethod[idx].cnt.hits)
				continue;

			prString(ofp, ffp, FONT_TEXT,
				prhead ? NULL : "<BR>\n", NULL, "<B>%lu</B>", ReqMethod[idx].cnt.hits);
			prhead = 0;
		}
		dfpr(ofp, ffp, "</TD></TR>\n");
	}

	dfpr(ofp, ffp, FMT_SPACE(4) "</TABLE></P>\n</CENTER>\n");
	html_trailer(ffp);
	(void) fclose(ffp);

	if (!nonavpanel) {
		if ((ffp = efopen("%s/nav%02d%02d.html",
			stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ffp, NULL, NULL, jsloadpg, w3wid, w3ht);
		prNavMon(ofp, ffp);
		(void) fprintf(ffp, "</BODY>\n</HTML>\n");
		(void) fclose(ffp);
	} else
		prNavMon(ofp, NULL);

	html_trailer(ofp);
	(void) fclose(ofp);

	/* hits by day */
	if ((ofp=efopen("%s/days%02d%02d.html",
		stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
		exit(1);

	html_header(ofp, doc_title, period, NULL);
	prHeader(ofp, NULL, GETMSG(251, "Hits by Day"), NULL);

	if (sptab[SP_GRAPHICS].ison) {
		dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">"
			"<IMG SRC=\"stats%02d%02d" IMG_SFX "\" ALT=\"%s\""
			" WIDTH=\"492\" HEIGHT=\"317\"></P>\n</CENTER>\n",
			t.start.mon+1, EPOCH(t.start.year), GETMSG(251, "Hits by Day"));

		(void) snprintf(tbuf, sizeof tbuf, "%s/stats%02d%02d" IMG_SFX,
				stdir, t.start.mon+1, EPOCH(t.start.year));
		(void) mn_bars(492, 317, 28, daily, t.end.mday, 31, tbuf, sptab[SP_PAGEVIEWS].ison);
	}

	/* print the daily values */
	prIdxTab(ofp, NULL, daily, (int)t.end.mday, &max_day, &avg_day);

	html_trailer(ofp);
	(void) fclose(ofp);

	if (sptab[SP_AVLOAD].ison &&
	    (topn_day > 0 || topn_hrs > 0 || topn_min > 0 || topn_sec > 0)) {
		if ((ofp=efopen("%s/avload%02d%02d.html",
			stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ofp, doc_title, period, NULL);
		prHeader(ofp, NULL, GETMSG(253, "Average load"), NULL);

		if (sptab[SP_GRAPHICS].ison) {
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<IMG SRC=\"avday%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"160\"></P>\n</CENTER>\n",
				t.start.mon+1, EPOCH(t.start.year), GETMSG(254, "Load by weekday"));

			(void) snprintf(tbuf, sizeof tbuf, "%s/avday%02d%02d" IMG_SFX,
					stdir, t.start.mon+1, EPOCH(t.start.year));
			(void) wd_bars(492, 160, 28, weekly, daily, t.end.mday,
					tbuf, sptab[SP_PAGEVIEWS].ison);
		}

		if (topn_day > 0)
			prTopList(ofp, top_day, topn_day, 0);

		if (sptab[SP_GRAPHICS].ison) {
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<IMG SRC=\"avload%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"160\"></P>\n</CENTER>\n",
				t.start.mon+1, EPOCH(t.start.year), GETMSG(255, "Load by hour"));
			(void) snprintf(tbuf, sizeof tbuf, "%s/avload%02d%02d" IMG_SFX,
					stdir, t.start.mon+1, EPOCH(t.start.year));
			(void) hr_bars(492, 160, 28, avg_hour, avg_day.hits, tbuf);
		}

		if (topn_hrs > 0)
			prTopList(ofp, top_hrs, topn_hrs, 1);
		if (topn_min > 0)
			prTopList(ofp, top_min, topn_min, 2);
		if (topn_sec > 0)
			prTopList(ofp, top_sec, topn_sec, 3);
	}

	html_trailer(ofp);
	(void) fclose(ofp);

	/* the top files/sites lists */
	if (lntab[FNAME_TOPFILES] || lntab[FNAME_TOPLFILES]) {
		if ((ofp=efopen("%s/topurl%02d%02d.html",
				stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ofp, doc_title, period, NULL);
	}
	if (lntab[FNAME_TOPFILES]) {			/* the top N files */
		(void) snprintf(tbuf, sizeof tbuf,
			GETMSG(256, "The Top %u items/URLs"), lntab[FNAME_TOPFILES]);

		prHeader(ofp, NULL, tbuf, NULL);

		if (sptab[SP_GRAPHICS].ison)
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<A HREF=\"%s/files%02d%02d.html\" TARGET=\"_self\">"
				"<IMG SRC=\"files%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"320\" BORDER=\"0\"></A>"
				"</P>\n</CENTER>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
				t.start.mon+1, EPOCH(t.start.year), GETMSG(257, "Files chart"));

		openTable(ofp, NULL, 498, tblfmt[FMT_TOPTEN],
			"<A HREF=\"%s/files%02d%02d.html\" TARGET=\"_self\">%s</A>",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			GETMSG(258, "More details"));

		prTblHead(ofp, NULL, tblfmt[FMT_TOPTEN], NULL, GETMSG(259, "URL"));

		for (idx=0; idx < topn_urls; idx++) {
			if (top_urls[idx] == NULL)
				break;

			prTblRow(ofp, NULL, tblfmt[FMT_TOPTEN],
				idx, NULL, &top_urls[idx]->cnt, &total, NULL);
			prFileURL(ofp, top_urls[idx]);
		}
		closeTable(ofp, NULL);
	}
	if (lntab[FNAME_TOPLFILES]) {			/* the least N files */
		(void) snprintf(tbuf, sizeof tbuf,
			GETMSG(260, "The %u least frequently accessed items/URLs"), lntab[FNAME_TOPLFILES]);
		prHeader(ofp, NULL, tbuf, NULL);
		openTable(ofp, NULL, 498, tblfmt[FMT_TOPTEN],
			"<A HREF=\"%s/files%02d%02d.html\" TARGET=\"_self\">%s</A>",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			GETMSG(258, "More details"));

		prTblHead(ofp, NULL, tblfmt[FMT_TOPTEN], NULL, GETMSG(259, "URL"));

		for (idx=lstn_urls-1; idx >= 0; idx--) {
			if (lst_urls[idx] == NULL)
				continue;

			prTblRow(ofp, NULL, tblfmt[FMT_TOPTEN],
				idx, NULL, &lst_urls[idx]->cnt, &total, NULL);
			prFileURL(ofp, lst_urls[idx]);
		}
		closeTable(ofp, NULL);
	}
	if (lntab[FNAME_TOPFILES] || lntab[FNAME_TOPLFILES]) {
		dfpr(ofp, NULL, "</P>\n</CENTER>\n");
		html_trailer(ofp);
		(void) fclose(ofp);
	}
	if (lntab[FNAME_TOPSITES]) {				/* the top N domains */
		if ((ofp=efopen("%s/topdom%02d%02d.html",
				stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ofp, doc_title, period, NULL);
		(void) snprintf(tbuf, sizeof tbuf,
			GETMSG(261, "The Top %u client domains"), lntab[FNAME_TOPSITES]);

		prHeader(ofp, NULL, tbuf, NULL);

		if (sptab[SP_GRAPHICS].ison)
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<A HREF=\"%s/sites%02d%02d.html\" TARGET=\"_self\">"
				"<IMG SRC=\"domains%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"320\" BORDER=\"0\"></A>"
				"</P>\n</CENTER>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
				t.start.mon+1, EPOCH(t.start.year), GETMSG(262, "Domain chart"));

		openTable(ofp, NULL, 498, tblfmt[FMT_TOPTEN],
			"<A HREF=\"%s/sites%02d%02d.html\" TARGET=\"_self\">%s</A>",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			GETMSG(258, "More details"));

		prTblHead(ofp, NULL, tblfmt[FMT_TOPTEN], NULL, GETMSG(263, "Domain"));

		hsum.hits  = total.hits-unknown[HIDDEN_SITES].hits;
		hsum.files = total.files-unknown[HIDDEN_SITES].files;
		hsum.nomod = total.nomod-unknown[HIDDEN_SITES].nomod;
		hsum.views = total.views-unknown[HIDDEN_SITES].views;
		hsum.sessions = total.sessions-unknown[HIDDEN_SITES].sessions;
		hsum.bytes = total.bytes-unknown[HIDDEN_SITES].bytes;

		dfpr(ofp, NULL, FMT_SPACE(4));
		for (idx=0; idx < topn_sites; idx++) {
			if (top_sites[idx] == NULL)
				break;

			prTblRow(ofp, NULL, tblfmt[FMT_TOPTEN],
				idx, NULL, &top_sites[idx]->cnt, &hsum, NULL);
			if (sptab[SP_HOTLINKS].ison && sptab[SP_SITELIST].ison &&
			    ISHIDDEN(top_sites[idx], HIDDEN_SITES)) {
				prString(ofp, NULL, FONT_TEXT,
					"<TD NOWRAP ALIGN=\"LEFT\">", "</TD></TR>\n",
					"<A TARGET=\"lists\" HREF=\"%s/lsites%02d%02d.html#Domain%d\">%s</A>\n",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year), top_sites[idx]->ishidden,
					*top_sites[idx]->str == '.' ? top_sites[idx]->str+1 : top_sites[idx]->str);
			} else
				prString(ofp, NULL, FONT_TEXT,
					"<TD NOWRAP ALIGN=\"LEFT\">", "</TD></TR>\n", "%s",
					*top_sites[idx]->str == '.' ? top_sites[idx]->str+1 : top_sites[idx]->str);
		}
		closeTable(ofp, NULL);
		html_trailer(ofp);
		(void) fclose(ofp);
	}
	if (lntab[FNAME_TOPAGENTS]) {				/* the top N user agents */
		if ((ofp=efopen("%s/topuag%02d%02d.html",
				stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ofp, doc_title, period, NULL);

		(void) snprintf(tbuf, sizeof tbuf,
			GETMSG(264, "The Top %u browser types"), lntab[FNAME_TOPAGENTS]);
		prHeader(ofp, NULL, tbuf, NULL);

		if (sptab[SP_GRAPHICS].ison)
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<A HREF=\"%s/agents%02d%02d.html\" TARGET=\"_self\">"
				"<IMG SRC=\"agents%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"320\" BORDER=\"0\"></A>"
				"</P>\n</CENTER>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
				t.start.mon+1, EPOCH(t.start.year), GETMSG(265, "Browser chart"));

		openTable(ofp, NULL, 498, tblfmt[FMT_TOPTEN], NULL,
			"<A HREF=\"%s/agents%02d%02d.html\" TARGET=\"_self\">%s</A>",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			GETMSG(258, "More details"));

		prTblHead(ofp, NULL, tblfmt[FMT_TOPTEN], NULL, GETMSG(266, "Browser"));

		hsum.hits  = total.hits-unknown[HIDDEN_AGENTS].hits;
		hsum.files = total.files-unknown[HIDDEN_AGENTS].files;
		hsum.nomod = total.nomod-unknown[HIDDEN_AGENTS].nomod;
		hsum.views = total.views-unknown[HIDDEN_AGENTS].views;
		hsum.sessions = total.sessions-unknown[HIDDEN_AGENTS].sessions;
		hsum.bytes = total.bytes-unknown[HIDDEN_AGENTS].bytes;

		dfpr(ofp, NULL, FMT_SPACE(4));
		for (idx=0; idx < topn_agent; idx++) {
			if (top_agent[idx] == NULL)
				break;

			prTblRow(ofp, NULL, tblfmt[FMT_TOPTEN],
				idx, NULL, &top_agent[idx]->cnt, &hsum, NULL);
			if (sptab[SP_HOTLINKS].ison && sptab[SP_AGENTS].ison &&
			    ISHIDDEN(top_agent[idx], HIDDEN_AGENTS)) {
				prString(ofp, NULL, FONT_TEXT,
					"<TD NOWRAP ALIGN=\"LEFT\">", "</TD></TR>\n",
					"<A TARGET=\"lists\" HREF=\"%s/lagents%02d%02d.html#Agent%d\">%s%s</A>\n",
					PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
					top_agent[idx]->ishidden, top_agent[idx]->str,
					top_agent[idx]->str[top_agent[idx]->len-1] == '.' ? "*" : "");
			} else
				prString(ofp, NULL, FONT_TEXT,
					"<TD NOWRAP ALIGN=\"LEFT\">", "</TD></TR>\n", "%s%s",
					top_agent[idx]->str, top_agent[idx]->str[top_agent[idx]->len-1] == '.' ? "*" : "");
		}
		closeTable(ofp, NULL);
		html_trailer(ofp);
		(void) fclose(ofp);
	}
	if (lntab[FNAME_TOPREFERS]) {			/* the top N referrers */
		if ((ofp=efopen("%s/topref%02d%02d.html",
				stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
			exit(1);

		html_header(ofp, doc_title, period, NULL);

		(void) snprintf(tbuf, sizeof tbuf,
			GETMSG(267, "The Top %u referrer URLs"), lntab[FNAME_TOPREFERS]);
		prHeader(ofp, NULL, tbuf, NULL);

		if (sptab[SP_GRAPHICS].ison)
			dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
				"<A HREF=\"%s/refers%02d%02d.html\" TARGET=\"_self\">"
				"<IMG SRC=\"refers%02d%02d" IMG_SFX "\" ALT=\"%s\""
				" WIDTH=\"492\" HEIGHT=\"320\" BORDER=\"0\"></A>"
				"</P>\n</CENTER>\n",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
				t.start.mon+1, EPOCH(t.start.year), GETMSG(268, "Referrer chart"));

		openTable(ofp, NULL, 498, tblfmt[FMT_TOPTEN], NULL,
			"<A HREF=\"%s/refers%02d%02d.html\" TARGET=\"_self\">%s</A>",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			GETMSG(258, "More details"));

		prTblHead(ofp, NULL, tblfmt[FMT_TOPTEN], NULL, GETMSG(269, "Referrer Host"));

		hsum.hits  = total.hits-(unknown[HIDDEN_REFERS].hits+unknown[SELF_REF].hits);
		hsum.files = total.files-(unknown[HIDDEN_REFERS].files+unknown[SELF_REF].files);
		hsum.nomod = total.nomod-(unknown[HIDDEN_REFERS].nomod+unknown[SELF_REF].nomod);
		hsum.views = total.views-(unknown[HIDDEN_REFERS].views+unknown[SELF_REF].views);
		hsum.sessions = total.sessions-(unknown[HIDDEN_REFERS].sessions+unknown[SELF_REF].sessions);
		hsum.bytes = total.bytes-(unknown[HIDDEN_REFERS].bytes+unknown[SELF_REF].bytes);

		dfpr(ofp, NULL, FMT_SPACE(4));
		for (idx=0; idx < topn_refer; idx++) {
			if (top_refer[idx] == NULL)
				break;

			prTblRow(ofp, NULL, tblfmt[FMT_TOPTEN],
				idx, NULL, &top_refer[idx]->cnt, &hsum, NULL);
			prRefURL(ofp, top_refer[idx]);
		}
		closeTable(ofp, NULL);
		html_trailer(ofp);
		(void) fclose(ofp);
	}
	if (sptab[SP_COUNTRY].ison) {		/* generate country list */
		if ((clist = (COUNTRY **)calloc(num_cntry, sizeof(COUNTRY *))) == NULL) {
			prmsg(1, GETMSG(337, enomem), num_cntry*sizeof(NLIST *));
			num_cntry = 0;
		} else {		/* create a linear list */
			for (idx=0; ccp = nextCountry(0); idx++)
				clist[idx] = ccp;

			/*
			** Save countries, sort the list by hits/cntry
			*/
			if ((num_cntry = (size_t)idx) != 0) {
				if (num_cntry > 1)
					qsort((void *)clist, num_cntry, sizeof(COUNTRY *), sort_by_cntry);

				if ((ofp=efopen("%s/country%02d%02d.html",
					stdir, t.start.mon+1, EPOCH(t.start.year))) == NULL)
					exit(1);

				html_header(ofp, doc_title, period, NULL);
				prHeader(ofp, NULL, GETMSG(270, "Hits by Country"), NULL);

				if (sptab[SP_GRAPHICS].ison)
					dfpr(ofp, NULL, "<CENTER><P ALIGN=\"CENTER\">\n"
						"<IMG SRC=\"country%02d%02d" IMG_SFX "\" ALT=\"%s\""
						" WIDTH=\"492\" HEIGHT=\"320\"></P>\n</CENTER>\n",
						t.start.mon+1, EPOCH(t.start.year), GETMSG(271, "Country chart"));

				openTable(ofp, NULL, 498, tblfmt[FMT_CNTRY], NULL, NULL);
				prTblHead(ofp, NULL, tblfmt[FMT_CNTRY], NULL, GETMSG(272, "Country"));

				for (idx=0; idx < (int)num_cntry; idx++) {
					prTblRow(ofp, NULL, tblfmt[FMT_CNTRY],
						idx, NULL, &clist[idx]->cnt, &total, NULL);
					prString(ofp, NULL, FONT_TEXT,
						"<TD NOWRAP ALIGN=\"LEFT\">", "</TD></TR>\n",
						"%s", clist[idx]->name);
				}
				closeTable(ofp, NULL);
				html_trailer(ofp);
				(void) fclose(ofp);

				if (sptab[SP_GRAPHICS].ison) {
					(void) snprintf(tbuf, sizeof tbuf, "%s/country%02d%02d" IMG_SFX,
							stdir, t.start.mon+1, EPOCH(t.start.year));
					(void) c_chart(492, 320, 28, tbuf,
							clist, NULL, num_cntry, total.hits,
							GETMSG(270, "Hits by Country"));
				}
			}
			free(clist);
		}
	}
	return;
}

/*
** Print an item form the top ten lists with it's URL if known.
*/
static void prFileURL(FILE *const ofp, NLIST *const np) {

	(void) fprintf(ofp, "<TD NOWRAP ALIGN=\"LEFT\">");
	prString(ofp, NULL, FONT_TEXT, NULL, NULL, NULL);

	if (!sptab[SP_HOTLINKS].ison || !sptab[SP_URLLIST].ison ||
	    !ISHIDDEN(np, HIDDEN_ITEMS)) {
		prCGI(ofp, HIDDEN_ITEMS, sptab[SP_HOTLINKS].ison, 0, np->str, NULL);
	} else if (hidden[HIDDEN_ITEMS].tab[np->ishidden].sref) {
		(void) fprintf(ofp, "<A TARGET=\"viewer\" HREF=\"%s%s\">%s</A>\n",
			srv_url ? srv_url : "",
			hidden[HIDDEN_ITEMS].tab[np->ishidden].sref, np->str);
	} else if (list_dir) {
		(void) fprintf(ofp, "<A TARGET=\"lists\""
			" HREF=\"%s/lfiles%02d%02d/item%d.html\">%s</A>\n",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			np->ishidden, np->str);
	} else {
		(void) fprintf(ofp, "<A TARGET=\"lists\""
			" HREF=\"%s/lfiles%02d%02d.html#Item%d\">%s</A>\n",
			PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
			np->ishidden, np->str);
	}
	(void) fprintf(ofp, "%s</TD></TR>\n", FONT_END(FONT_TEXT));
	return;
}

/*
** Translate hex string into character code.
** Returns character code of hex sequence.
*/
static u_char trHex(char const *ps) {
	u_char rc;

	++ps;
	if (is_upper(*ps))
		rc = ((*ps-'A')+10)<<4U;
	else if (is_lower(*ps))
		rc = ((*ps-'a')+10)<<4U;
	else	rc = (*ps-'0')<<4U;

	++ps;
	if (is_upper(*ps))
		rc += (*ps-'A')+10;
	else if (is_lower(*ps))
		rc += (*ps-'a')+10;
	else	rc += *ps-'0';

	return rc;
}

/*
** Print a CGI URL with special character processing.
*/
static void prCGI(FILE *const ofp, size_t const which,
		  int link, int isnoise, char *str, char const *keywd) {
	int maxchr, maxcgi, incgi;
	char *tm, *em = NULL;
	u_char rc;

	if (which == HIDDEN_REFERS) {
		if (link && strneq(str, "http://", 7) || strneq(str, "https://", 8)) {
			(void) fprintf(ofp, "<A TARGET=\"viewer\" HREF=\"");

			/*
			** Because shitty Windoze browsers are sending us broken
			** referrer URLs, skip anything after an invalid character.
			*/
			if ((em = strpbrk(str, " \t<\"")) == NULL)
				(void) fputs(str, ofp);
			else for (tm=str; tm < em; tm++)
				(void) fputc(*tm, ofp);
			(void) fputs("\">", ofp);

			if (!isnoise) {
				tm = str+7;	/* skip protocol and hostname */
				if (*tm == '/')
					tm++;
				while (*tm && *tm != '/')
					tm++;
				if (*tm == '/')
					str = tm;
			}
		} else
			link = 0;		/* no link created */
	} else if (which == HIDDEN_ITEMS) {
		if (link && *str == '/')
			(void) fprintf(ofp, "<A TARGET=\"viewer\" HREF=\"%s%s\">",
				srv_url ? srv_url : "", str);
		else
			link = 0;		/* no link created */

		if (!nocgistrip) {
			(void) fprintf(ofp, link ? "%s</A>\n" : "%s\n",str);
			return;			/* done already for items */
		}
	} else
		assert(which != which);

	for (maxchr=maxcgi=incgi = 0; *str != '\0'; str++) {
		if (!incgi) {
			if (*str == '?') {
				(void) fputs(link ? "</A> " : " ", ofp);
				incgi = 1;
				if (keywd) {		/* lookup keyword if any */
					for (tm=str; (tm=strstr(tm, keywd)) != NULL; tm += strlen(keywd))
						if (*(tm-1) == '&' || *(tm-1) == '?')
							break;
					if (tm)	str = tm-1;
					else	keywd = tm;
				}
				maxchr = 0;
				incgi++;
				continue;
			}
			if (maxchr > 120) {
				(void) fputs("[...]", ofp);
				break;
			}
		} else {
			if (*str == '&') {
				if (keywd)
					break;
				if (maxchr > 120) {
					if (maxcgi < 34)
						(void) fputs("[...]", ofp);
					break;
				}
				(void) fputc(' ', ofp);
				maxcgi = 0;
				continue;
			}
			if (!keywd && maxcgi > 32) {
				if (maxcgi == 33) {
					(void) fputs("[...]", ofp);
					maxcgi++;
				}
				continue;
			}
			maxcgi++;
		}

		/* terminate if invalid character in referrer URL */
		if (em && str == em)
			break;

		/* translate encoded characters */
		if (*str == '%' && isxdigit(str[1]) && isxdigit(str[2])) {
			rc = trHex(str);
			str += 2;
		} else	rc = (u_char)(*str == '+' ? ' ' : *str);

		/* then escape special characters */
		if (rc == '<')
			(void) fputs("&lt;", ofp);
		else if (rc == '>')
			(void) fputs("&gt;", ofp);
		else if (rc == '&')
			(void) fputs("&amp;", ofp);
		else if (rc == '"')
			(void) fputs("&quot;", ofp);
		else if (isprint(rc)) {		/* show only printable characters */
			(void) fputc(rc, ofp);
			maxchr++;
		}
	}
	(void) fputs((!incgi && link) ? "</A>\n" : "\n", ofp);
	return;
}

/*
** Print a referrer with it's URL if known.
*/

static void prRefURL(FILE *const fp, NLIST *const np) {
	char *pfx;
	int len;

	(void) fprintf(fp, "<TD NOWRAP ALIGN=\"LEFT\">");
	prString(fp, NULL, FONT_TEXT, NULL, NULL, NULL);

	if (sptab[SP_HOTLINKS].ison && ISHIDDEN(np, HIDDEN_REFERS) &&
	    (pfx = hidden[HIDDEN_REFERS].tab[np->ishidden].pfx)) {
		len = hidden[HIDDEN_REFERS].tab[np->ishidden].len;
		if (pfx == np->str) {
			(void) fprintf(fp, "<A TARGET=\"viewer\" HREF=\"%s/\">%s/</A>", pfx, pfx);
		} else if (pfx[len-1] == '/')
			(void) fprintf(fp, "<A TARGET=\"viewer\" HREF=\"%s\">%s</A>", pfx, np->str);
		else
			(void) fprintf(fp,
				"<A TARGET=\"lists\" HREF=\"%s/lrefers%02d%02d.html#Refer%d\">%s</A>",
				PRIV_DIR, t.start.mon+1, EPOCH(t.start.year),
				hidden[HIDDEN_REFERS].tab[np->ishidden].col->ishidden, np->str);
	} else
		(void) fprintf(fp, "%s", np->str);

	(void) fprintf(fp, "%s</TD></TR>\n", FONT_END(FONT_TEXT));
	return;
}

/*
** Print string, which may contain special
** characters to be urlencoded in URLs.
*/
static char HexCodes[] = { '0', '1', '2', '3', '4', '5', '6', '7',
			   '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

static void prURLencoded(FILE *const fp, char *const name, char const *value) {
	register int cc;
	static int first = 1;

	(void) fprintf(fp, "%c%s=", first ? '?' : '&', name);
	first=0;

	for ( ; (cc = *value) != '\0'; value++)
		if (isalnum(cc) || isdigit(cc) || strchr("*_-.", cc))
			(void) fputc(cc, fp);
		else if (cc == ' ')
			(void) fputc('+', fp);
		else	(void) fprintf(fp, "%%%c%c",
					HexCodes[((cc>>4)&0x0F)], HexCodes[(cc&0x0F)]);
	return;
}

/*
** Print string, which may contain special
** characters to be escaped in HTML output.
*/
static void prEscHTML(FILE *const fp, char const *str) {
	for ( ; *str != '\0'; str++)
		switch (*str) {
		  case '"':	(void) fputs("&quot;", fp);	break;
		  case '&':	(void) fputs("&amp;", fp);	break;
		  case '<':	(void) fputs("&lt;", fp);	break;
		  case '>':	(void) fputs("&gt;", fp);	break;
		  default:	if (*str < 0x20)
					(void) fprintf(fp, "^%c", (*str+0x40));
				else	(void) fputc(*str, fp);
				break;
		}
	return;
}

/*
** Print a domainname as reverse domain.
*/
static void revDomain(char *str, size_t const len, char *bp, size_t max) {
	register char *tm, *cp = str+len;

	if (*str == '*')
		str++;
	if (*str == '.')
		str++;
	while (cp > str && max > 2) {
		cp--;
		if (*cp != '.' && cp > str)
			continue;
		for (tm = (*cp == '.') ? cp+1 : cp; *tm && *tm !='.' && max > 2; tm++, max--)
			*bp++ = *tm;
		if (cp != str) {
			*bp++ = '.';
			max--;
		}
	}
	*bp = '\0';
	return;
}

static void prTextHead(FILE *const fp, char const *tblfmt, char *const label) {
	for ( ; *tblfmt != '\0'; tblfmt++)
		switch (*tblfmt) {
		  default:  break;
		  case 'H': (void) fprintf(fp, "%16s ", GETMSG(273, "Total hits"));	break;
		  case 'h': (void) fprintf(fp, "%8.8s ",GETMSG(274, "Hits"));		break;
		  case 'F': (void) fprintf(fp, "%16s ", GETMSG(275, "Files sent"));	break;
		  case 'f': (void) fprintf(fp, "%8.8s ",GETMSG(276, "Files"));		break;
		  case 'C': (void) fprintf(fp, "%16s ", GETMSG(277, "Files cached"));	break;
		  case 'c': (void) fprintf(fp, "%8.8s ",GETMSG(278, "Cached"));		break;
		  case 'P': (void) fprintf(fp, "%16s ", GETMSG(142, "Pageviews"));	break;
		  case 'p': (void) fprintf(fp, "%8.8s ",GETMSG(142, "Pageviews"));	break;
		  case 'S': (void) fprintf(fp, "%16s ", GETMSG(279, "User sessions"));	break;
		  case 's': (void) fprintf(fp, "%8.8s ",GETMSG(280, "Sessions"));	break;
		  case 'K': (void) fprintf(fp, "%16s ", GETMSG(281, "Data sent (KB)")); break;
		  case 'k': (void) fprintf(fp, "%8.8s ",GETMSG(282, "KB sent"));	break;
		  case 'M': (void) fprintf(fp, "%16s ", GETMSG(283, "Data sent (MB)")); break;
		  case 'm': (void) fprintf(fp, "%8.8s ",GETMSG(284, "MB sent"));	break;
		  case 'B': /*FALLTHROUGH*/
		  case 'b': (void) fprintf(fp,
				*tblfmt == 'B' ? "%22s " : "%14s ", GETMSG(285, "Bytes sent"));
			    break;
	}
	(void) fprintf(fp, "%s\n%s\n", label, hrule1);
	return;
}

static void prASCII(FILE *const fp, char const *tblfmt, COUNTER *const cntp, COUNTER *const sump) {
	u_long count;
	float pct;

	if (!tblfmt || !cntp)
		return;

	for ( ; *tblfmt != '\0'; tblfmt++) {
		if (*tblfmt == 'B') {
			(void) fprintf(fp, "%14.0f %6.2f%% ",
				cntp->bytes, PERCENT(cntp->bytes, sump->bytes));
			continue;
		}
		if (*tblfmt == 'b') {
			(void) fprintf(fp, "%14.0f ", cntp->bytes);
			continue;
		}
		count = 0L;
		pct = -1.0;

		switch (*tblfmt) {
		  default:	continue;	/*NOTREACHED*/

		  case 'H':	pct = !sump ? 0.0 : PERCENT(cntp->hits, sump->hits); /*FALLTHROUGH*/
		  case 'h':	count = cntp->hits; break;

		  case 'F':	pct = !sump ? 0.0 : PERCENT(cntp->files, sump->files); /*FALLTHROUGH*/
		  case 'f':	count = cntp->files; break;

		  case 'C':	pct = !sump ? 0.0 : PERCENT(cntp->nomod, sump->nomod); /*FALLTHROUGH*/
		  case 'c':	count = cntp->nomod; break;

		  case 'P':	pct = !sump ? 0.0 : PERCENT(cntp->views, sump->views); /*FALLTHROUGH*/
		  case 'p':	count = cntp->views; break;

		  case 'S':	pct = !sump ? 0.0 : PERCENT(cntp->sessions, sump->sessions); /*FALLTHROUGH*/
		  case 's':	count = cntp->sessions; break;

		  case 'K':	pct = !sump ? 0.0 : PERCENT(cntp->bytes, sump->bytes);	/*FALLTHROUGH*/
		  case 'k':	count = KBYTES(cntp->bytes); break;

		  case 'M':	pct = !sump ? 0.0 : PERCENT(cntp->bytes, sump->bytes);	/*FALLTHROUGH*/
		  case 'm':	count = MBYTES(cntp->bytes); break;
		}
		(void) fprintf(fp, "%8lu ", count);
		if (pct >= 0.0)
			(void) fprintf(fp, "%6.2f%% ", pct);
	}
	return;

}

/*
** Print an item from the table of all items.
*/
static void prItem(FILE *const ofp, NLIST **const lp, size_t const cnt,
		   size_t const which, COUNTER *const hsum) {
	char label[MEDIUMSIZE];
	int num, idx, ndx = -1;
	int header = 1, isnoise = 0;
	COUNTER noise = { 0L, 0L, 0L, 0L, 0L, 0.0 };
	ITEM_LIST *ip;

	switch (which) {
	  default:		assert(which != which); return;	/*NOTREACHED*/
	  case HIDDEN_ITEMS:	(void) snprintf(label, sizeof label, "%s", GETMSG(286, "    Size | URL"));
				break;
	  case HIDDEN_SITES:	(void) snprintf(label, sizeof label, "%s", GETMSG(287, "| Hostname"));
				break;
	  case HIDDEN_AGENTS:	(void) snprintf(label, sizeof label, "%s", GETMSG(288, "| Browser"));
				break;
	  case HIDDEN_REFERS:	(void) snprintf(label, sizeof label, "%s", GETMSG(289, "| Referrer URL"));
				break;
	}
	ip = hidden[which].tab;

	prString(ofp, NULL, FONT_LISTS, NULL, "<PRE>\n", NULL);

	for (idx=num=0; idx < (int)cnt; idx++) {
		if (ndx != (int)lp[idx]->ishidden) {
			if (ndx >= 0) {
				header = ip[lp[idx]->ishidden].col != ip[ndx].col;
				if (header && !isnoise) {
					(void) fprintf(ofp, "%s\n", hrule1);
					if (num > 1) {
						prASCII(ofp, tblfmt[FMT_LISTS], &ip[ndx].col->cnt, hsum);
						(void) fprintf(ofp, "\n%s\n", hrule1);
					}
					num = 0;
				}
			}
			ndx = (int)lp[idx]->ishidden;
			if (header && !isnoise) {
				if (ip[ndx].col->cnt.hits < (u_long)noiselevel) {
					(void) fprintf(ofp, "\n<A NAME=\"Noise\">%s</A>\n",
							    GETMSG(290, "Noise"));
					isnoise++;
				} else if (which == HIDDEN_ITEMS) {
					(void) fprintf(ofp, "\n<A NAME=\"Item%d\">%s</A> (%s)\n",
						ip[ndx].col->ishidden, ip[ndx].col->str, ip[ndx].pfx);
				} else if (which == HIDDEN_SITES) {
					(void) fprintf(ofp, "\n<A NAME=\"Domain%d\">%s</A>\n",
						ip[ndx].col->ishidden,
						*ip[ndx].col->str == '.' ? ip[ndx].col->str+1 : ip[ndx].col->str);
				} else if (which == HIDDEN_AGENTS) {
					(void) fprintf(ofp, "\n<A NAME=\"Agent%d\">%s%s</A>\n",
						ip[ndx].col->ishidden, ip[ndx].col->str,
						ip[ndx].pfx == ip[ndx].col->str ? "*" : "");
				} else if (which == HIDDEN_REFERS) {
					if (ip[ndx].pfx == ip[ndx].col->str)
						(void) fprintf(ofp, "\n<A NAME=\"Refer%d\""
							" TARGET=\"viewer\" HREF=\"%s/\">%s/</A>\n",
							ip[ndx].col->ishidden, ip[ndx].pfx, ip[ndx].pfx);
					else if (ip[ndx].pfx[ip[ndx].len-1] == '/')
						(void) fprintf(ofp, "\n<A NAME=\"Refer%d\""
							" TARGET=\"viewer\" HREF=\"%s\">%s</A>\n",
							ip[ndx].col->ishidden, ip[ndx].pfx, ip[ndx].col->str);
					else
						(void) fprintf(ofp, "\n<A NAME=\"Refer%d\">%s</A>\n",
							ip[ndx].col->ishidden, ip[ndx].col->str);
				}
				prTextHead(ofp, tblfmt[FMT_LISTS], label);
			}
		}
		num++;
		prASCII(ofp, tblfmt[FMT_LISTS], &lp[idx]->cnt, hsum);

		if (which == HIDDEN_ITEMS) {
			(void) fprintf(ofp, "%8lu | ", lp[idx]->size);
			prCGI(ofp, which, sptab[SP_HOTLINKS].ison, 0, lp[idx]->str, NULL);
		} else if (which == HIDDEN_REFERS) {
			(void) fprintf(ofp, "| ");
			prCGI(ofp, which, sptab[SP_HOTLINKS].ison, isnoise, lp[idx]->str, ip[ndx].sref);
		} else if (which == HIDDEN_AGENTS) {
			(void) fprintf(ofp, "| ");
			prEscHTML(ofp, lp[idx]->str);
			(void) fputc('\n', ofp);
		} else
			(void) fprintf(ofp, "| %s\n", lp[idx]->str);

		if (isnoise)
			UPDATE_CNT(noise, lp[idx]->cnt);
	}
	(void) fprintf(ofp, "%s", hrule1);
	if (num > 1) {
		(void) fputc('\n', ofp);
		if (isnoise)
			prASCII(ofp, tblfmt[FMT_LISTS], &noise, &noise);
		else	prASCII(ofp, tblfmt[FMT_LISTS], &ip[ndx].col->cnt, hsum);
		(void) fprintf(ofp, "\n%s", hrule2);
	}
	(void) fprintf(ofp, "</PRE>%s\n", FONT_END(FONT_LISTS));
	return;
}

/*
** Print an overview of all hidden items.
*/
static void prHidden(FILE *const ofp, NLIST **const lp, size_t const cnt,
		     size_t const which, COUNTER *const hsum, int const rev) {
	char dname[MEDIUMSIZE], label[MEDIUMSIZE];
	char *str;
	u_long noisecnt = 0;
	COUNTER noise = { 0L, 0L, 0L, 0L, 0L, 0.0 };
	ITEM_LIST *ip;
	size_t idx;

	switch (which) {
	  default:		assert(which != which); return;	/*NOTREACHED*/
	  case HIDDEN_ITEMS:	(void) snprintf(label, sizeof label, "%s", GETMSG(291, "Items/URLs"));
				break;
	  case HIDDEN_SITES:	(void) snprintf(label, sizeof label, "%s",
					rev ? GETMSG(292, "Reverse Domain") : GETMSG(293, "Client Domain"));
				break;
	  case HIDDEN_AGENTS:	(void) snprintf(label, sizeof label, "%s", GETMSG(294, "Browser Type"));
				break;
	  case HIDDEN_REFERS:	(void) snprintf(label, sizeof label, "%s", GETMSG(295, "Referrer URL"));
				break;
	}
	ip = hidden[which].tab;

	prString(ofp, NULL, FONT_HEAD, NULL, "\n",
		GETMSG(296, "Total Transfers by %s (Overview)"), label);

	switch (which) {
	  case HIDDEN_ITEMS:	(void) snprintf(label, sizeof label, "%s", GETMSG(297, "    Size | URL"));
				break;
	  case HIDDEN_SITES:	(void) snprintf(label, sizeof label, "%s",
					rev ? GETMSG(298, "| Reverse Domain") : GETMSG(299, "| Domain"));
				break;
	  case HIDDEN_AGENTS:	(void) snprintf(label, sizeof label, GETMSG(300, "| Browser Type"));
				break;
	  case HIDDEN_REFERS:	(void) snprintf(label, sizeof label, GETMSG(301, "| Referrer URL"));
				break;
	}
	prString(ofp, NULL, FONT_LISTS, NULL, "<PRE>\n", NULL);

	if (cnt)
		prTextHead(ofp, tblfmt[FMT_OVIEW], label);

	for (idx=0; idx < cnt; idx++) {
		NLIST *np = ISHIDDEN(lp[idx], which) ? ip[lp[idx]->ishidden].col : lp[idx];

		if (np->cnt.hits < (u_long)noiselevel) {
			UPDATE_CNT(noise, np->cnt);
			noisecnt++;
			continue;
		}

		prASCII(ofp, tblfmt[FMT_OVIEW], &lp[idx]->cnt, hsum);
		if (which == HIDDEN_ITEMS) {
			(void) fprintf(ofp, "%8lu | ", lp[idx]->size);
			if (sptab[SP_URLLIST].ison && ISHIDDEN(lp[idx], which)) {
				if (list_dir)
					(void) fprintf(ofp, "<A TARGET=\"lists\""
						" HREF=\"lfiles%02d%02d/item%d.html\">%s</A>\n",
						t.start.mon+1, EPOCH(t.start.year),
						lp[idx]->ishidden, lp[idx]->str);
				else
					(void) fprintf(ofp, "<A TARGET=\"lists\""
						" HREF=\"lfiles%02d%02d.html#Item%d\">%s</A>\n",
						t.start.mon+1, EPOCH(t.start.year),
						lp[idx]->ishidden, lp[idx]->str);
			} else
				prCGI(ofp, which, sptab[SP_HOTLINKS].ison, 0, lp[idx]->str, NULL);
		} else if (which == HIDDEN_SITES) {
			if (rev) {
				revDomain(lp[idx]->str, lp[idx]->len, dname, sizeof dname);
				str = dname;
			} else
				str = lp[idx]->str;
			if (*str == '.')
				str++;
			if (sptab[SP_SITELIST].ison && ISHIDDEN(lp[idx], which)) {
				(void) fprintf(ofp, "| <A TARGET=\"lists\""
						" HREF=\"lsites%02d%02d.html#Domain%d\">%s</A>\n",
					t.start.mon+1, EPOCH(t.start.year),
					ip[lp[idx]->ishidden].col->ishidden, str);
			} else
				(void) fprintf(ofp, "| %s\n", str);
		} else if (which == HIDDEN_AGENTS) {
			str = lp[idx]->str+lp[idx]->len;
			str = (*--str == '.' || *str == '-') ? "*" : "";
			if (sptab[SP_AGENTS].ison && ISHIDDEN(lp[idx], which)) {
				(void) fprintf(ofp, "| <A TARGET=\"lists\""
					" HREF=\"lagents%02d%02d.html#Agent%d\">%s%s</A>\n",
					t.start.mon+1, EPOCH(t.start.year),
					ip[lp[idx]->ishidden].col->ishidden, lp[idx]->str, str);
			} else
				(void) fprintf(ofp, "| %s\n", lp[idx]->str);
		} else if (which == HIDDEN_REFERS) {
			if (sptab[SP_REFERRER].ison && ISHIDDEN(lp[idx], which)) {
				(void) fprintf(ofp, "| <A TARGET=\"lists\""
					" HREF=\"lrefers%02d%02d.html#Refer%d\">%s%s</A>\n",
					t.start.mon+1, EPOCH(t.start.year),
					ip[lp[idx]->ishidden].col->ishidden, lp[idx]->str,
					ip[lp[idx]->ishidden].pfx == ip[lp[idx]->ishidden].col->str ? "/" : "");
			} else
				(void) fprintf(ofp, "| %s\n", lp[idx]->str);
		} else
			assert(which != which);
	}
	if (noise.hits != 0) {
		int ssize = 0;
		char *lfn;

		switch (which) {
		  case HIDDEN_ITEMS:	lfn = "lfiles";  ssize = 1; break;
		  case HIDDEN_SITES:	lfn = "lsites";  break;
		  case HIDDEN_AGENTS:	lfn = "lagents"; break;
		  case HIDDEN_REFERS:	lfn = "lrefers"; break;
		}

		prASCII(ofp, tblfmt[FMT_OVIEW], &noise, hsum);
		if (which == HIDDEN_ITEMS && list_dir)
			(void) fprintf(ofp,
				"%s <A TARGET=\"lists\" HREF=\"%s%02d%02d/noise.html\">%s</A> ",
				ssize ? "         |" : "|", lfn, t.start.mon+1, EPOCH(t.start.year),
				GETMSG(290, "Noise"));
		else
			(void) fprintf(ofp,
				"%s <A TARGET=\"lists\" HREF=\"%s%02d%02d.html#Noise\">%s</A> ",
				ssize ? "         |" : "|", lfn, t.start.mon+1, EPOCH(t.start.year),
				GETMSG(290, "Noise"));
		(void) fprintf(ofp, GETMSG(303, "(%lu entries below %d hits)\n"),
				noisecnt, noiselevel);
	}
	if (which == HIDDEN_ITEMS) {	/* print other codes */
		for (idx=0; idx < (int)TABSIZE(RespCode); idx++) {
			if (idx == IDX_OK || idx == IDX_NOT_MODIFIED ||
				!RespCode[idx].cnt.hits /*RespCode[idx].cnt.bytes == 0.0*/)
				continue;

			prASCII(ofp, tblfmt[FMT_OVIEW], &RespCode[idx].cnt, hsum);
			if (sptab[SP_CODE404].ison && idx == IDX_NOT_FOUND)
				(void) fprintf(ofp, "         | <A TARGET=\"_self\""
						    " HREF=\"rfiles%02d%02d.html\">%s</A>\n",
					t.start.mon+1, EPOCH(t.start.year), RespCode[idx].msg);
			else
				(void) fprintf(ofp, "         | <FONT COLOR=\"#FF0000\">%s</FONT>\n",
					RespCode[idx].msg);
		}
		/* modify label for summary */
		(void) snprintf(label, sizeof label, "%s", GETMSG(302, "| URL"));
	}
	if (which != HIDDEN_REFERS || cnt || noise.hits) {
		(void) fprintf(ofp, "%s\n", hrule1);
		prASCII(ofp, tblfmt[FMT_OVIEW], hsum, hsum);
		(void) fprintf(ofp, "\n%s", hrule2);
	}

	idx = 0;
	if (unknown[which].hits || which == HIDDEN_REFERS && unknown[SELF_REF].hits) {
		(void) fprintf(ofp, "\n\n");
		prTextHead(ofp, tblfmt[FMT_OVIEW], label);
	}

	if (unknown[which].hits) {
		prASCII(ofp, tblfmt[FMT_OVIEW], &unknown[which], &total);
		switch (which) {
		  case HIDDEN_AGENTS:	/*FALLTRHOUGH*/
		  case HIDDEN_REFERS:	/*FALLTRHOUGH*/
		  case HIDDEN_ITEMS:	(void) fprintf(ofp, GETMSG(374, "| Unknown (no %s found)\n"),
						hidden[which].what);
					break;
		  case HIDDEN_SITES:	(void) fprintf(ofp, GETMSG(375, "| Unresolved (no %s found)\n"),
						hidden[which].what);
					break;
		}
		idx++;
	}
	if (which == HIDDEN_REFERS && unknown[SELF_REF].hits) {
		prASCII(ofp, tblfmt[FMT_OVIEW], &unknown[SELF_REF], &total);
		(void) fprintf(ofp, "%s", GETMSG(376, "| Self Referrer\n"));
		idx++;
	}
	if (idx) {
		if (hsum->hits) {
			prASCII(ofp, tblfmt[FMT_OVIEW], hsum, &total);
			(void) fprintf(ofp, GETMSG(305, "| Remaining entries shown above\n"));
		}
		(void) fprintf(ofp, "%s\n", hrule1);
		prASCII(ofp, tblfmt[FMT_OVIEW], &total, &total);
		(void) fprintf(ofp, "\n%s", hrule2);
	}
	(void) fprintf(ofp, "</PRE>%s\n", FONT_END(FONT_LISTS));
	return;
}

/*
** Print detailed statistics about all unique sites.
*/
static void prSiteStats(char *const stdir, char *const period) {
	char tbuf[MAX_FNAMELEN];	/* filename templates */
	char label[MEDIUMSIZE];		/* label in graphic */
	size_t cnt = (size_t)uniq_sites;/* list size is total # of unique sites */
	ITEM_LIST *ip = hidden[HIDDEN_SITES].tab;
	COUNTER hsum;			/* correction for totals */
	NLIST *np, **list;		/* temp ptr */
	int idx, ndx;			/* indexes must be signed */
	FILE *ofp;

	if (verbose)
		prmsg(0, GETMSG(306, "... processing hostnames\n"));

	if ((list = (NLIST **)calloc(cnt, sizeof(NLIST *))) == NULL) {
		prmsg(1, GETMSG(307, "Failed to allocate %u more bytes.\n"
				     "The list of sites will be omitted from the report\n"),
			cnt*sizeof(NLIST *));
		sptab[SP_SITES].ison = 0;
		return;
	}

	/* sort the hidden domain table */
	if ((hidden[HIDDEN_SITES].t_count-hidden[HIDDEN_SITES].t_start) > 1)
		qsort((void *)(ip+hidden[HIDDEN_SITES].t_start),
			hidden[HIDDEN_SITES].t_count-hidden[HIDDEN_SITES].t_start,
			sizeof(ITEM_LIST), sort_by_casestr);

	/* create a linear list of all sites */
	for (idx=0, cnt=0; idx < HASHSIZE; idx++) {
		if ((np = sitetab[idx]) == NULL)
			continue;

		do {
			if (isHiddenSite(np))
				continue;
			if (IS_TYPE(np->ftype, TYPE_NODNS)) {
				UPDATE_CNT(unknown[HIDDEN_SITES], np->cnt);
			} else
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)uniq_sites);
	}

	/* add collected hidden sites to the list */
	for (idx=0; idx < (int)TABSIZE(hlist[HIDDEN_SITES]); idx++) {
		if ((np=hlist[HIDDEN_SITES][idx]) == NULL)
			continue;
		do {
			if (np->cnt.hits && cnt < (size_t)uniq_sites)
				list[cnt++] = np;
		} while ((np=np->next) != NULL);
	}
	assert(cnt <= (size_t)uniq_sites);

	if (cnt > 1)		/* now sort the list by accesses */
		qsort((void *)list, cnt, sizeof(NLIST *), sort_by_hits);

	hsum.hits  = total.hits-unknown[HIDDEN_SITES].hits;
	hsum.files = total.files-unknown[HIDDEN_SITES].files;
	hsum.nomod = total.nomod-unknown[HIDDEN_SITES].nomod;
	hsum.views = total.views-unknown[HIDDEN_SITES].views;
	hsum.sessions = total.sessions-unknown[HIDDEN_SITES].sessions;
	hsum.bytes = total.bytes-unknown[HIDDEN_SITES].bytes;

	if (topn_sites) {	/* create top site list, skip hidden sites */
		for (idx=ndx=0; idx < topn_sites && ndx < (int)cnt; ndx++) {
			if (*list[ndx]->str == '[' || list[ndx]->cnt.hits < (u_long)noiselevel)
				continue;
			top_sites[idx++] = list[ndx];
		}
		lntab[FNAME_TOPSITES] = (idx > 1) ? idx : 0;
		if (sptab[SP_GRAPHICS].ison && lntab[FNAME_TOPSITES]) {	/* create pie chart image */
			(void) snprintf(label, sizeof label,
				GETMSG(308, "The Top %u Client Domains"), lntab[FNAME_TOPSITES]);
			(void) snprintf(tbuf, sizeof tbuf,
				"%s/domains%02d%02d" IMG_SFX, stdir, t.start.mon+1, EPOCH(t.start.year));
			(void) c_chart(492, 320, 28, tbuf, NULL, list, cnt, hsum.hits, label);
		}
	}

	if (sptab[SP_COUNTRY].ison) {	/* generate country list */
		num_cntry = (size_t)addCountry(&hidden[HIDDEN_SITES], &unknown[HIDDEN_SITES], list, cnt);
		assert(num_cntry != 0);
	}

	if (!sptab[SP_SITES].ison) {	/* done already */
		free(list);
		return;
	}

	/* total transfers by client domain */
	if ((ofp=efopen("%s/%s/sites%02d%02d.html",
		stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
		prmsg(1, GETMSG(309, "The list of domains will be omitted from the report\n"));
		sptab[SP_SITES].ison = 0;
		free(list);
		return;
	}
	lntab[FNAME_SITES] = cnt;

	html_header(ofp, doc_title, period, NULL);
	prHidden(ofp, list, cnt, HIDDEN_SITES, &hsum, 0);
	html_trailer(ofp);
	(void) fclose(ofp);

	/* total transfers by reverse domain */
	if (sptab[SP_RSITES].ison && (ofp=efopen("%s/%s/rsites%02d%02d.html",
		stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
		prmsg(1, GETMSG(310, "The list of reverse domains will be omitted from the report\n"));
		sptab[SP_RSITES].ison = 0;
	}
	if (sptab[SP_RSITES].ison) {
		if ((lntab[FNAME_RSITES] = cnt) > 1)
			qsort((void *)list, cnt, sizeof(NLIST *), sort_by_revdom);

		html_header(ofp, doc_title, period, NULL);
		prHidden(ofp, list, cnt, HIDDEN_SITES, &hsum, 1);
		html_trailer(ofp);
		(void) fclose(ofp);
	}

	/* total transfers by hostname */
	if (sptab[SP_SITELIST].ison) {
		/* create a linear list of all hidden items */
		for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)uniq_sites; idx++) {
			if ((np = sitetab[idx]) == NULL)
				continue;

			do {
				if (ISHIDDEN(np, HIDDEN_SITES) &&
				    ip[np->ishidden].pfx != NULL && ip[np->ishidden].col->cnt.hits)
					list[cnt++] = np;
			} while ((np=np->next) != NULL && cnt < (size_t)uniq_sites);
		}
		if (cnt != 0) {
			if ((ofp=efopen("%s/%s/lsites%02d%02d.html",
				stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
				prmsg(1, GETMSG(311, "The detailed list of hostnames will "
						     "be omitted from the report\n"));
				sptab[SP_SITELIST].ison = 0;
				free(list);
				return;
			}
			lntab[FNAME_LSITES] = cnt;

			if (cnt > 1)
				qsort((void *)list, cnt, sizeof(NLIST *), sort_by_domain);

			html_header(ofp, doc_title, period, NULL);
			prString(ofp, NULL, FONT_HEAD, NULL, "\n",
				GETMSG(312, "Total Transfers by Client Domain"));

			prItem(ofp, list, cnt, HIDDEN_SITES, &hsum);
			html_trailer(ofp);
			(void) fclose(ofp);	/* cleanup */
		}
	}
	free(list);
	return;
}

/*
** Print detailed statistics for all requested URLs.
*/
static void prURLStats(char *const stdir, char *const period) {
	char tbuf[MAX_FNAMELEN];	/* filename templates */
	char label[MEDIUMSIZE];		/* label in graphic */
	size_t cnt = (size_t)uniq_urls;	/* list size is total # of unique URLs */
	ITEM_LIST *ip = hidden[HIDDEN_ITEMS].tab;
	COUNTER hsum;			/* correction for totals */
	NLIST *np, **list;		/* temp ptr */
	int idx, ndx;			/* indexes must be signed */
	FILE *ofp;

	if (verbose)
		prmsg(0, GETMSG(313, "... processing URLs\n"));

	if ((list = (NLIST **)calloc(cnt, sizeof(NLIST *))) == NULL) {
		prmsg(1, GETMSG(314, "Failed to allocate %u more bytes.\n"
			 	     "The list of files will be omitted "
				     "from the report\n"), cnt*sizeof(NLIST *));
		sptab[SP_URLS].ison = 0;
		return;
	}

	/* sort the hidden file table */
	if ((hidden[HIDDEN_ITEMS].t_count-hidden[HIDDEN_ITEMS].t_start) > 1)
		qsort((void *)(ip+hidden[HIDDEN_ITEMS].t_start),
			hidden[HIDDEN_ITEMS].t_count-hidden[HIDDEN_ITEMS].t_start,
			sizeof(ITEM_LIST), sort_by_slen);

	/* create a linear list of hidden items */
	for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)uniq_urls; idx++) {
		if ((np = urltab[idx]) == NULL)
			continue;

		do {	/* compute total bytes saved, check for hidden item */
			total_kbsaved += ((np->cnt.nomod*np->size)+1023L)/1024L;
			if (isHiddenItem(np))
				continue;
			/*
			** Skip Code 404's, which have been logged as 304's
			** due to customized error documents (tricky).
			*/
			if (np->cnt.hits <= np->cnt.nomod) {
				UPDATE_CNT(unknown[HIDDEN_ITEMS], np->cnt);
			} else
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)uniq_urls);
	}

	/* add collected hidden items to the list */
	for (idx=0; idx < (int)TABSIZE(hlist[HIDDEN_ITEMS]); idx++) {
		if ((np=hlist[HIDDEN_ITEMS][idx]) == NULL)
			continue;
		do {
			if (np->cnt.hits && cnt < (size_t)uniq_urls)
				list[cnt++] = np;
		} while ((np=np->next) != NULL);
	}
	assert(cnt <= (size_t)uniq_urls);

	if (cnt > 1)			/* now sort the list by accesses */
		qsort((void *)list, cnt, sizeof(NLIST *), sort_by_hits);

	hsum.hits  = total.hits-unknown[HIDDEN_ITEMS].hits;
	hsum.files = total.files-unknown[HIDDEN_ITEMS].files;
	hsum.nomod = total.nomod-unknown[HIDDEN_ITEMS].nomod;
	hsum.views = total.views-unknown[HIDDEN_ITEMS].views;
	hsum.sessions = total.sessions-unknown[HIDDEN_ITEMS].sessions;
	hsum.bytes = total.bytes-unknown[HIDDEN_ITEMS].bytes;

	if (topn_urls) {	/* create top URL list, skip hidden items */
		for (idx=ndx=0; idx < topn_urls && ndx < (int)cnt; ndx++) {
			if (*list[ndx]->str == '[' || (list[ndx]->cnt.hits < (u_long)noiselevel))
				continue;
			top_urls[idx++] = list[ndx];
		}
		lntab[FNAME_TOPFILES] = (idx > 1) ? idx : 0;
	}

	if (lstn_urls &&	/* conditionally create list of most boring URLs */
	    (lstn_urls+topn_urls < (int)cnt)) {
		for (idx=0, ndx=(int)cnt-1; idx < lstn_urls && ndx >= 0; ndx--) {
			if (*list[ndx]->str == '[')
				continue;
			lst_urls[idx++] = list[ndx];
		}
		lntab[FNAME_TOPLFILES] = (idx > 1) ? idx : 0;
	}

	if (sptab[SP_GRAPHICS].ison && topn_urls && lntab[FNAME_TOPFILES]) {	/* create pie chart image */
		(void) snprintf(label, sizeof label, GETMSG(315, "The Top %u Items/URLs"),
				lntab[FNAME_TOPFILES]);
		(void) snprintf(tbuf, sizeof tbuf, "%s/files%02d%02d" IMG_SFX,
				stdir, t.start.mon+1, EPOCH(t.start.year));
		(void) c_chart(492, 320, 28, tbuf, NULL, list, cnt, hsum.hits, label);
	}

	if (!sptab[SP_URLS].ison) {	/* we already have the list of the top URLs */
		free(list);
		return;
	}

	/* print the list of items/files */
	if ((ofp=efopen("%s/%s/files%02d%02d.html",
			stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
		prmsg(1, GETMSG(316, "The overview of filenames (URLs) "
				     "will be omitted from the report\n"));
		sptab[SP_URLS].ison = 0;
		free(list);
		return;
	}
	lntab[FNAME_FILES] = cnt;

	html_header(ofp, doc_title, period, NULL);
	prHidden(ofp, list, cnt, HIDDEN_ITEMS, &hsum, 0);
	html_trailer(ofp);
	(void) fclose(ofp);

	if (sptab[SP_URLLIST].ison) {
		/* create a linear list of all hidden items */
		for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)uniq_urls; idx++) {
			if ((np = urltab[idx]) == NULL)
				continue;

			do {
				if (ISHIDDEN(np, HIDDEN_ITEMS) && ip[np->ishidden].pfx != NULL)
					list[cnt++] = np;
			} while ((np=np->next) != NULL && cnt < (size_t)uniq_urls);
		}
		if (cnt != 0) {
			(void) snprintf(tbuf, sizeof tbuf, "%s/%s/lfiles%02d%02d",
				stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year));

			if (cnt > 1)
				qsort((void *)list, cnt, sizeof(NLIST *), sort_by_item);
#if 0
			if (list_dir) {
				if (!prSepItem(tbuf, period, list, cnt, &hsum)) {
					prmsg(1, GETMSG(317,
						"The list of filenames (URLs) "
						"will be omitted from the report\n"));
					sptab[SP_URLLIST].ison = 0;
				} else
					lntab[FNAME_LFILES] = cnt;
			} else
#endif
			if ((ofp=efopen("%s/%s/lfiles%02d%02d.html",
					stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
				prmsg(1, GETMSG(317, "The list of filenames (URLs) "
						     "will be omitted from the report\n"));
				sptab[SP_URLLIST].ison = 0;
			} else {
				lntab[FNAME_LFILES] = cnt;
				html_header(ofp, doc_title, period, NULL);
				prString(ofp, NULL, FONT_HEAD, NULL, "\n",
					GETMSG(318, "Total Transfers by Items/URLs"));
				prItem(ofp, list, cnt, HIDDEN_ITEMS, &hsum);
				html_trailer(ofp);
				(void) fclose(ofp);
			}
		}
	}
	if (sptab[SP_CODE404].ison && RespCode[IDX_NOT_FOUND].cnt.hits) {
		if ((ofp=efopen("%s/%s/rfiles%02d%02d.html",
			stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
			prmsg(1, GETMSG(319, "The list of Code 404 NotFound responses "
					     "will be omitted from the report\n"));
			sptab[SP_CODE404].ison = 0;
			free(list);
			return;
		}
		/* create a list of all Code 404 requests if it fits into the memory */
		for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)uniq_urls; idx++) {
			if ((np = errtab[idx]) == NULL)
				continue;

			do {
				list[cnt++] = np;
			} while ((np=np->next) != NULL && cnt < (size_t)uniq_urls);
		}
		if ((lntab[FNAME_RFILES] = cnt) != 0) {
			if (cnt > 1)
				qsort((void *)list, cnt, sizeof(NLIST *), sort_by_hits);

			html_header(ofp, doc_title, period, NULL);
			prString(ofp, NULL, FONT_HEAD, NULL, "\n",
				GETMSG(320, "Code 404 Not Found Requests"));
			prString(ofp, NULL, FONT_LISTS, NULL, "<PRE>\n", NULL);

			prTextHead(ofp, tblfmt[FMT_NFOUND], GETMSG(321, "| URL"));
			for (idx=0; idx < (int)cnt; idx++) {
				prASCII(ofp, tblfmt[FMT_NFOUND], &list[idx]->cnt, &hsum);
				(void) fprintf(ofp, "| ");
				prEscHTML(ofp, list[idx]->str);
				(void) fputc('\n', ofp);
			}
			(void) fprintf(ofp, "%s\n", hrule1);
			prASCII(ofp, tblfmt[FMT_NFOUND], &RespCode[IDX_NOT_FOUND].cnt, &hsum);
			(void) fprintf(ofp, "\n%s</PRE>%s\n", hrule2, FONT_END(FONT_LISTS));
			html_trailer(ofp);
		}
		(void) fclose(ofp);
	}
	free(list);
	return;
}

/*
** Print detailed statistics about all unique browsers.
*/
static void prAgentStats(char *const stdir, char *const period) {
	char tbuf[MAX_FNAMELEN];	/* filename templates */
	char label[MEDIUMSIZE];		/* label in graphic */
	size_t cnt = (size_t)total_agents; /* list size is total # of unique agents */
	ITEM_LIST *ip = hidden[HIDDEN_AGENTS].tab;
	COUNTER hsum;			/* correction for total hits */
	NLIST *np, **list;		/* temp ptr */
	int idx, ndx;			/* indexes must be signed */
	FILE *ofp;

	if (verbose)
		prmsg(0, GETMSG(322, "... processing user agents\n"));

	if ((list = (NLIST **)calloc(cnt, sizeof(NLIST *))) == NULL) {
		prmsg(1, GETMSG(323, "Failed to allocate %u more bytes.\n"
			 	     "The list of user agents will be omitted "
				     "from the report\n"), cnt*sizeof(NLIST *));
		sptab[SP_AGENTS].ison = 0;
		return;
	}

	/* sort the hidden agent table */
	if ((hidden[HIDDEN_AGENTS].t_count-hidden[HIDDEN_AGENTS].t_start) > 1)
		qsort((void *)(ip+hidden[HIDDEN_AGENTS].t_start),
			hidden[HIDDEN_AGENTS].t_count-hidden[HIDDEN_AGENTS].t_start,
			sizeof(ITEM_LIST), sort_by_string);

	/* create a linear list of hidden agents */
	for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)total_agents; idx++) {
		if ((np = uatab[idx]) == NULL)
			continue;

		do {	/* check for hidden agent, collect values */
			if (!isHiddenAgent(np))
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)total_agents);
	}

	/* add collected user agents to the list */
	for (idx=0; idx < (int)TABSIZE(hlist[HIDDEN_AGENTS]); idx++) {
		if ((np=hlist[HIDDEN_AGENTS][idx]) == NULL)
			continue;
		do {
			if (np->cnt.hits && cnt < (size_t)total_agents)
				list[cnt++] = np;
		} while ((np=np->next) != NULL);
	}
	assert(cnt <= (size_t)total_agents);

	if (cnt > 1)		/* now sort the list by accesses */
		qsort((void *)list, cnt, sizeof(NLIST *), sort_by_hits);

	hsum.hits  = total.hits-unknown[HIDDEN_AGENTS].hits;
	hsum.files = total.files-unknown[HIDDEN_AGENTS].files;
	hsum.nomod = total.nomod-unknown[HIDDEN_AGENTS].nomod;
	hsum.views = total.views-unknown[HIDDEN_AGENTS].views;
	hsum.sessions = total.sessions-unknown[HIDDEN_AGENTS].sessions;
	hsum.bytes = total.bytes-unknown[HIDDEN_AGENTS].bytes;

	if (topn_agent) {	/* create top user agent list */
		for (idx=ndx=0; idx < topn_agent && ndx < (int)cnt; ndx++) {
			if (list[ndx]->cnt.hits < (u_long)noiselevel)
				continue;
			top_agent[idx++] = list[ndx];
		}
		lntab[FNAME_TOPAGENTS] = (idx > 1) ? idx : 0;
		if (sptab[SP_GRAPHICS].ison && lntab[FNAME_TOPAGENTS]) {	/* create pie chart image */
			(void) snprintf(label, sizeof label,
				GETMSG(324, "The Top %u Browser Types"), lntab[FNAME_TOPAGENTS]);
			(void) snprintf(tbuf, sizeof tbuf, "%s/agents%02d%02d" IMG_SFX,
					stdir, t.start.mon+1, EPOCH(t.start.year));
			(void) c_chart(492, 320, 28, tbuf, NULL, list, cnt, hsum.hits, label);
		}
	}
	if (!sptab[SP_AGENTS].ison) {	/* done already */
		free(list);
		return;
	}

	if ((ofp=efopen("%s/%s/agents%02d%02d.html",
			stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
		prmsg(1, GETMSG(325, "The overview of browser types "
				     "will be omitted from the report\n"));
		sptab[SP_AGENTS].ison = 0;
		free(list);
		return;
	}
	lntab[FNAME_AGENTS] = cnt;

	html_header(ofp, doc_title, period, NULL);
	prHidden(ofp, list, cnt, HIDDEN_AGENTS, &hsum, 0);
	html_trailer(ofp);
	(void) fclose(ofp);

	/* create a linear list of all agents */
	for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)total_agents; idx++) {
		if ((np = uatab[idx]) == NULL)
			continue;

		do {
			if (ISHIDDEN(np, HIDDEN_AGENTS) && ip[np->ishidden].pfx != NULL)
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)total_agents);
	}
	if (cnt != 0) {
		if ((ofp=efopen("%s/%s/lagents%02d%02d.html",
			stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
			prmsg(1, GETMSG(326, "The list of user agents will "
					     "be omitted from the report\n"));
			free(list);
			return;
		}
		if ((lntab[FNAME_LAGENTS] = cnt) > 1)
			qsort((void *)list, cnt, sizeof(NLIST *), sort_by_agent);

		html_header(ofp, doc_title, period, NULL);
		prString(ofp, NULL, FONT_HEAD, NULL, "\n",
				GETMSG(327, "Total Transfers by User Agent (Browser)"));
		prItem(ofp, list, cnt, HIDDEN_AGENTS, &hsum);
		html_trailer(ofp);
		(void) fclose(ofp);	/* cleanup */
	}
	free(list);
	return;
}

/*
** Print statistics about all referrer URLs.
*/
static void prReferStats(char *const stdir, char *const period) {
	char tbuf[MAX_FNAMELEN];	/* filename templates */
	char label[MEDIUMSIZE];		/* label in graphic */
	size_t cnt = (size_t)total_refer;/* list size is total # of unique referrer URLs */
	ITEM_LIST *ip = hidden[HIDDEN_REFERS].tab;
	COUNTER hsum;			/* correction for total hits */
	NLIST *np, **list;		/* temp ptr */
	int idx, ndx;
	FILE *ofp;

	if (verbose)
		prmsg(0, GETMSG(328, "... processing referrer URLs\n"));

	if ((list = (NLIST **)calloc(cnt, sizeof(NLIST *))) == NULL) {
		prmsg(1, GETMSG(329, "Failed to allocate %u more bytes.\n"
			 	     "The list of referrer URLs will be "
				     "omitted from the report\n"), cnt*sizeof(NLIST *));
		sptab[SP_REFERRER].ison = 0;
		return;
	}

	/* sort the hidden referrer table */
	if ((hidden[HIDDEN_REFERS].t_count-hidden[HIDDEN_REFERS].t_start) > 1)
		qsort((void *)(ip+hidden[HIDDEN_REFERS].t_start),
			hidden[HIDDEN_REFERS].t_count-hidden[HIDDEN_REFERS].t_start,
			sizeof(ITEM_LIST), sort_by_casestr);

	/* create a linear list of all referrers */
	for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)total_refer; idx++) {
		if ((np = reftab[idx]) == NULL)
			continue;

		do {	/* check for hidden referrer, collect values */
			if (!isHiddenRefer(np))
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)total_refer);
	}

	/* add collected referrers to the list */
	for (idx=0; idx < (int)TABSIZE(hlist[HIDDEN_REFERS]); idx++) {
		if ((np=hlist[HIDDEN_REFERS][idx]) == NULL)
			continue;
		do {
			if (isSelfRefer(np->str, np->len)) {
				UPDATE_CNT(unknown[SELF_REF], np->cnt);
			} else if (np->cnt.hits)
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)total_refer);
	}
	assert(cnt <= (size_t)total_refer);

	if (cnt > 1)		/* now sort the list by accesses */
		qsort((void *)list, cnt, sizeof(NLIST *), sort_by_hits);

	hsum.hits  = total.hits-(unknown[HIDDEN_REFERS].hits+unknown[SELF_REF].hits);
	hsum.files = total.files-(unknown[HIDDEN_REFERS].files+unknown[SELF_REF].files);
	hsum.nomod = total.nomod-(unknown[HIDDEN_REFERS].nomod+unknown[SELF_REF].nomod);
	hsum.views = total.views-(unknown[HIDDEN_REFERS].views+unknown[SELF_REF].views);
	hsum.sessions = total.sessions-(unknown[HIDDEN_REFERS].sessions+unknown[SELF_REF].sessions);
	hsum.bytes = total.bytes-(unknown[HIDDEN_REFERS].bytes+unknown[SELF_REF].bytes);

	if (topn_refer) {	/* create top referrer list */
		for (idx=ndx=0; idx < topn_refer && ndx < (int)cnt; ndx++) {
			if (list[ndx]->cnt.hits < (u_long)noiselevel)
				continue;
			top_refer[idx++] = list[ndx];
		}
		lntab[FNAME_TOPREFERS] = (idx > 1) ? idx : 0;
		if (sptab[SP_GRAPHICS].ison && lntab[FNAME_TOPREFERS]) {
			(void) snprintf(label, sizeof label,
				GETMSG(330, "The Top %u Referrer URLs"), lntab[FNAME_TOPREFERS]);
			(void) snprintf(tbuf, sizeof tbuf, "%s/refers%02d%02d" IMG_SFX,
					stdir, t.start.mon+1, EPOCH(t.start.year));
			(void) c_chart(492, 320, 28, tbuf, NULL, list, cnt, hsum.hits, label);
		}
	}

	if (!sptab[SP_REFERRER].ison) {	/* done already */
		free(list);
		return;
	}

	if ((ofp=efopen("%s/%s/refers%02d%02d.html",
			stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
		prmsg(1, GETMSG(331, "The overview of referrer URLs will "
				     "be omitted from the report\n"));
		sptab[SP_REFERRER].ison = 0;
		free(list);
		return;
	}
	lntab[FNAME_REFERS] = cnt;

	html_header(ofp, doc_title, period, NULL);
	prHidden(ofp, list, cnt, HIDDEN_REFERS, &hsum, 0);
	html_trailer(ofp);
	(void) fclose(ofp);

	/* create a linear list of all referrers */
	for (idx=0, cnt=0; idx < HASHSIZE && cnt < (size_t)total_refer; idx++) {
		if ((np = reftab[idx]) == NULL)
			continue;

		do {
			if (ISHIDDEN(np, HIDDEN_REFERS) && ip[np->ishidden].pfx != NULL &&
			    !isSelfRefer(ip[np->ishidden].pfx, ip[np->ishidden].len))
				list[cnt++] = np;
		} while ((np=np->next) != NULL && cnt < (size_t)total_refer);
	}
	if (cnt != 0) {
		if ((ofp=efopen("%s/%s/lrefers%02d%02d.html",
				stdir, PRIV_DIR, t.start.mon+1, EPOCH(t.start.year))) == NULL) {
			prmsg(1, GETMSG(332, "The list of referrer URLs will "
					     "be omitted from the report\n"));
			free(list);
			return;
		}
		if ((lntab[FNAME_LREFERS] = cnt) > 1)
			qsort((void *)list, cnt, sizeof(NLIST *), sort_by_refer);

		html_header(ofp, doc_title, period, NULL);
		prString(ofp, NULL, FONT_HEAD, NULL, "\n",
			GETMSG(333, "Total Transfers by Referrer URL"));
		prItem(ofp, list, cnt, HIDDEN_REFERS, &hsum);
		html_trailer(ofp);
		(void) fclose(ofp);
	}
	free(list);
	return;
}

/*
** Set the logfile format.
*/
static int setLogFmt(char *const rq) {
	int fmt;

	if (streq(rq, "default") || strneq(rq, "auto", 4))
		fmt = LOGF_UNKNOWN;	/* automatic recognition */
	else if (streq(rq, "clf"))	/* Common Logfile Format (CLF) */
		fmt = LOGF_CLF;
	else if (streq(rq, "dlf"))	/* Combined Format: CLF "referrer" "uagent" */
		fmt = LOGF_NCSA;
	else if (streq(rq, "elf"))	/* Extended Format: CLF uagent referrer */
		fmt = LOGF_ELF;
	else
		fmt = -1;		/* unknown */
	return fmt;
}

/*
** Read the logfile, scan the entries, fill in the
** elements of a LOGENT structure. Returns a ptr
** to the logfile entry, NULL on error or EOF.
** Highly optimized version.
*/
#define SKIPMSG(msg,ln,lb) if (verbose) prmsg(1, (msg), (ln), (lb))

static LOGENT *readLog(FILE *const lfp, LOGTIME *const stp, LOGTIME *const etp) {
	static char lbuf[BIGSIZE];	/* line buffer */
	static u_long dtstart = 0L;	/* dayticks start time */
	static u_long dtend = 0L;	/* dayticks end time */
	static LOGENT np;		/* buffer for logfile entry */
	register int len;		/* string length */
	register char *cp, *tm;		/* temp */
	HSTRING sitename, request;	/* DNS sitename, URL request */
	HSTRING uagent, refer;		/* browser type, referrer URL */
	HSTRING authuser, uatype;	/* auth username, uagent type */
	HSTRING tldomain, refhost;	/* 2nd level domain, referrer host */
	HSTRING reqbase, virthost;	/* last component of request, virthost */
	char *subdomain[5];		/* ptr to last 5 subdomains */
	int strip, nogbg = 0;		/* strip part of string, errmsg flag */
	size_t idx, reqmethod;		/* temp storage */
	u_int resp, ftype;		/* response code, file type */
	u_long reqsize;			/* size of request */
	u_long ltick;			/* last tick */
	LOGTIME *tp;			/* temp */

	if (lfp == NULL)
		return NULL;

	if (!dtstart && stp->mday)	/* set time window, assume 00:00:00 */
		dtstart = TICKS_PDAY(stp->mday-1)+TICKS_PMON(stp->mon)+TICKS_PYEAR(stp->year);
	if (!dtend && etp->mday)
		dtend = TICKS_PDAY(etp->mday-1)+TICKS_PMON(etp->mon)+TICKS_PYEAR(etp->year);

#if defined(USE_FGETS)
# define NEXT_LINE	((cp=fgets(lbuf, sizeof lbuf, lfp)) != NULL)
#else
# define NEXT_LINE	((len=readLine(lbuf, sizeof lbuf, lfp)) >= 0)
#endif
	while (NEXT_LINE) {
#if defined(USE_FGETS)
		for (len=0, tm=cp; *tm != '\0' && *tm != '\n' && *tm != '\r'; tm++)
			len++;			/* determine string length */
		if (*tm == '\n' || *tm == '\r')	/* delete trailing newline */
			*tm = '\0';
#else
		cp = lbuf;			/* the optimized version did this already */
#endif
		if (!len || *cp == '#')		/* skip empty and comment lines */
			continue;

		/*
		** Try to detect binary garbagge. Skip first format lines for
		** Netscape Enterprise and Fasttrack servers.
		*/
		if (!is_print(*cp)) {
			if (verbose && !nogbg) {
				nogbg = 1;
				prmsg(1, GETMSG(357, "Garbagge detected: %02X, skip binary data "
						     "until next valid line ...\n"), *cp);
			}
			continue;
		}
		if (!lnum++ && !strncmp(lbuf, "format", 6)) {
			if (verbose)
				prmsg(1, GETMSG(358,
					"Skip Netscape log format definition: `%.23s ...'\n"), lbuf);
			continue;
		}

		/*
		** Save ptr to end of line, search for the sitename
		** and compute the hash value.
		*/
		request.str = refer.str = cp+len;
		tldomain.str = NULL;
		tldomain.len = 0;
		tldomain.hval = 0;
		nogbg = strip = 0;
		ftype = 0U;

		subdomain[strip] = lbuf;
		for (sitename.hval=0; *cp && *cp != ' '; cp++) {
			if (*cp == '.')
				subdomain[++strip % TABSIZE(subdomain)] = cp;
			sitename.hval = (sitename.hval<<1)+(u_char)*cp;
		}
		if (*cp == '\0') {
			SKIPMSG(GETMSG(359, "Couldn't find the sitename, "
					    "skip line %lu: %s\n"), lnum, lbuf);
			corrupt++;
			continue;
		}
		if (strip == 3 &&	/* separate IP addresses from names */
		    is_digit(subdomain[0][0]) && is_digit(subdomain[1][1]) &&
		    is_digit(subdomain[2][1]) && is_digit(subdomain[3][1])) {
			ftype |= TYPE_NODNS;
		} else {		/* save top-level domain */
			if (show_domain > 2 && strip == show_domain-1)
				tldomain.str = subdomain[(strip-(show_domain-2)) % TABSIZE(subdomain)];
			else if (strip > show_domain-1)
				tldomain.str = subdomain[(strip-(show_domain-1)) % TABSIZE(subdomain)];
			else	tldomain.str = subdomain[0];
			tldomain.len = (size_t)(cp-tldomain.str);
		}
		sitename.str = lbuf;
		sitename.len = (size_t)(cp-lbuf);
		sitename.hval %= TABSIZE(sitetab);
		*cp++ = '\0';

		/* Ignore certain sites if requested */
		if (hidden[IGNORED_SITES].t_count && isIgnoredItem(IGNORED_SITES, &sitename)) {
			ignored++;
			continue;
		}

		while (*cp == ' ')			/* skip spaces */
			cp++;

		/*
		** Parse the (normally unused) field for a virtual hostname,
		** skip entry if desired.
		*/
		virthost.str = NULL;
		virthost.len = 0;

		if (*cp != '-') {
			for (tm=cp; *cp && *cp != ' '; cp++)
				/* no-op */;

			if (*cp == '\0') {
				SKIPMSG(GETMSG(360, "Couldn't find the virtual hostname, "
						    "skip line %lu: %s\n"), lnum, tm);
				corrupt++;
				continue;
			}
			virthost.str = tm;
			virthost.len = (size_t)(cp-tm);
			*cp++ = '\0';

		} else				/* skip empty field */
			cp++;

		/* Check for exact, case-independant match of virtual host if desired */
		if (virt_host && (virthost.len != vrlen || !streq(virthost.str, virt_host))) {
			ignored++;
			continue;
		}

		while (*cp == ' ')			/* skip spaces */
			cp++;

		/*
		** Parse the authentication field for an username,
		** count all requests which required authentication,
		** and skip the entry if desired.
		*/
		authuser.str = NULL;
		authuser.len = 0;
		authuser.hval = 0;

		if (*cp != '-') {
			for (tm=cp; *cp && *cp != ' '; cp++)
				authuser.hval = (authuser.hval<<1)+(u_char)*cp;

			if (*cp == '\0') {
				SKIPMSG(GETMSG(361, "Couldn't find the authentication field, "
						    "skip line %lu: %s\n"), lnum, tm);
				corrupt++;
				continue;
			}
			authuser.str = tm;
			authuser.len = (size_t)(cp-tm);
			*cp++ = '\0';

			reqauth++;
			if (!sptab[SP_AUTHREQ].ison) {
				/* ignored++; already accounted for in reqauth */
				continue;
			}
		} else					/* skip empty field */
			cp++;

		while (*cp == ' ')			/* skip spaces */
			cp++;

		/*
		** Parse the date in format [DD/MMM/YYYY:HH:MM:SS sZZZZ]
		** and fill in the elements of the LOGTIME structure.
		*/
		if (*cp++ != '[' || refer.str-cp < 27 || cp[26] != ']' ||
		    cp[2] != '/' || cp[6] != '/' || cp[11] != ':' ||
		    cp[14] != ':' || cp[17] != ':') {
			SKIPMSG(GETMSG(362, "Couldn't find the date, "
					    "skip line %lu: %s\n"), lnum, cp);
			corrupt++;
			continue;
		}
		tm = cp;
		cp += 26;
		*cp++ = '\0';

		tp = &np.tm;
		tp->hour = (u_short)((tm[12]-'0') * 10  + (tm[13]-'0'));
		tp->min  = (u_short)((tm[15]-'0') * 10  + (tm[16]-'0'));
		tp->sec  = (u_short)((tm[18]-'0') * 10  + (tm[19]-'0'));
		tp->mday = (u_short)((tm[0]-'0')  * 10   + (tm[1]-'0'));
		tp->year = (u_short)((tm[7]-'0')  * 1000 + (tm[8]-'0')*100 +
				     (tm[9]-'0')  * 10   + (tm[10]-'0'));

		switch (tm[4]) {
		  case 'a':		/* jan, mar, may */
			switch (tm[5]) {
			  case 'n':	tp->mon = 0;	break;
			  case 'r':	tp->mon = 2;	break;
			  default:	tp->mon = 4;	break;
			}
			break;

		  case 'u':		/* jun, jul, aug */
			switch (tm[5]) {
			  case 'n':	tp->mon = 5;	break;
			  case 'l':	tp->mon = 6;	break;
			  default:	tp->mon = 7;	break;
			}
			break;

		  case 'e':		/* feb, sec, dec */
			switch (tm[3]) {
			  case 'F':	tp->mon = 1;	break;
			  case 'S':	tp->mon = 8;	break;
			  default:	tp->mon = 11;	break;
			}
			break;

		  default:		/* apr, oct, nov */
			switch (tm[3]) {
			  case 'A':	tp->mon = 3;	break;
			  case 'O':	tp->mon = 9;	break;
			  default:	tp->mon = 10;	break;
			}
			break;
		}

		/* Check the timestamp to detect overflow (Netscape Enterprise) */
		if (tp->mon > 11 || tp->mday > 31 ||
		    tp->hour > 23 || tp->min > 59 || tp->sec > 61) {
			SKIPMSG(GETMSG(363, "Invalid timestamp detected in line %lu: %s\n"), lnum, tm);
			corrupt++;
			continue;
		}

		/* Compute ticks, ignore entries of a certain period if desired. */
		ltick = TICKS_PSEC(np.tm.sec)+TICKS_PMIN(np.tm.min)+TICKS_PHOUR(np.tm.hour)+
			TICKS_PDAY(np.tm.mday-1)+TICKS_PMON(np.tm.mon)+TICKS_PYEAR(np.tm.year);

		if (dtstart || dtend) {
			if (dtstart && ltick < dtstart) {
				ignored++;
				continue;
			}
			if (dtend && ltick >= dtend)
				break;

			dtstart = 0L;
		}
		while (*cp != '\0' && *cp != '"')	/* check request */
			cp++;

		if (*cp != '"' || *++cp == '\0') {
			SKIPMSG(GETMSG(364, "Couldn't find start of request, "
					    "skip line %lu: %s\n"), lnum, cp);
			corrupt++;
			continue;
		}
		/*
		** Determine the request method and isolate the URL.
		** Take care for embedded `"' characters.
		*/
		tm = cp;
		switch (*cp) {
		  default:	reqmethod = METHOD_EXTENDED;
				break;

		  case 'G':	cp++;
				if (*cp++ == 'E' && *cp++ == 'T' && *cp++ == ' ')
					reqmethod = METHOD_GET;
				break;
		  case 'H':	cp++;
				if (*cp++ == 'E' && *cp++ == 'A' && *cp++ == 'D' && *cp++ == ' ')
					reqmethod = METHOD_HEAD;
				break;
		  case 'P':	cp++;
				if (*cp == 'O') {
					if (*++cp == 'S' && *++cp == 'T' && *++cp == ' ') {
						reqmethod = METHOD_POST;
						cp++;
					}
				} else if (*cp++ == 'U' && *cp++ == 'T' && *cp++ == ' ')
					reqmethod = METHOD_PUT;
				break;
		  case 'C':	cp++;
				if (*cp++ == 'O' && *cp++ == 'N' && *cp++ == 'N' &&
				    *cp++ == 'E' && *cp++ == 'C' && *cp++ == 'T' &&
				    *cp++ == ' ')
					reqmethod = METHOD_CONNECT;
				break;
		  case 'O':	cp++;
				if (*cp++ == 'P' && *cp++ == 'T' && *cp++ == 'I' &&
				    *cp++ == 'O' && *cp++ == 'N' && *cp++ == 'S' && *cp++ == ' ')
					reqmethod = METHOD_OPTIONS;
				break;
		  case 'D':	cp++;
				if (*cp++ == 'E' && *cp++ == 'L' && *cp++ == 'E' &&
				    *cp++ == 'T' && *cp++ == 'E' && *cp++ == ' ')
					reqmethod = METHOD_DELETE;
				break;
		  case 'T':	cp++;
				if (*cp++ == 'R' && *cp++ == 'A' && *cp++ == 'C' &&
				    *cp++ == 'E' && *cp++ == ' ')
					reqmethod = METHOD_TRACE;
				break;
		  case '-':	cp++;	/* the Apache way to log timeouts :-( */
				if (*cp++ == '"' && *cp++ == ' ' && *cp++ == '4' &&
				    *cp++ == '0' && *cp++ == '8') {
					reqempty++;	/* account for as empty request */
					continue;
				}
				break;
		}
#if 0
		if (reqmethod == METHOD_UNKNOWN) {
			if (verbose > 1)
				SKIPMSG(GETMSG(365, "Unknown request method, "
						    "skip line %lu: %s\n"), lnum, tm);
			reqinval++;
			continue;
		}
#endif

		/*
		** Save request method, then search for end of request.
		*/
		ftype |= (reqmethod & METHOD_MASK);	/* save request method */
		for (request.str = cp; *cp != '\0'; cp++) {
			if (*cp == ' ')			/* end of URI part */
				*cp = '\0';
			else if (*cp == '"' && cp[1] == ' ' && (is_digit(cp[2]) || cp[2] == '-'))
				break;			/* end of req-url */
		}
		if (*cp != '"') {
			SKIPMSG(GETMSG(366, "Couldn't find end of request, "
					    "skip line %lu: %s\n"), lnum, request.str);
			corrupt++;
			continue;
		}
		*cp++ = '\0';

		while (*cp == ' ')			/* skip spaces */
			cp++;

		if (!is_digit(*cp)) {			/* obtain response code */
			SKIPMSG(GETMSG(367, "Couldn't find the response code, "
					    "skip line %lu: %s\n"), lnum, cp);
			corrupt++;
			continue;
		}
		resp = 0;
		while (is_digit(*cp))
			resp = 10*resp + (u_int)(*cp++ - '0');

		while (*cp == ' ')			/* skip spaces */
			cp++;

		reqsize = 0L;				/* obtain request size */
		if (is_digit(*cp))
			while (is_digit(*cp))
				reqsize = 10L*reqsize + (u_long)(*cp++ - '0');
		else if (*cp == '-')
			cp++;
		else {
			SKIPMSG(GETMSG(368, "Couldn't find the request size, "
					    "skip line %lu: %s\n"), lnum, cp);
			corrupt++;
			continue;
		}
		if (*cp != '\0' && *cp != ' ') {
			SKIPMSG(GETMSG(369, "Invalid request size, "
					    "skip line %lu: %s\n"), lnum, cp);
			corrupt++;
			continue;
		}

		/* don't account for document size if request method was HEAD */
		if (reqmethod == METHOD_HEAD)
			reqsize = 0L;

		/*
		** Parse the user agent and referrer in Extended Logfile Format.
		** Switch to appropriate type of logile format if still unknown.
		**
		** Correct ELF format is:
		**	UserAgent[ (WinSys; OS; CPU)] Referrer
		** For example:
		**	Mozilla/1.0S (X11; IRIX 5.3; IP22) http://foo/bar.html
		**
		** A rather strange, although common used format is:
		**	"referrer" "uagent"
		** For example:
		**	"http://foo/bar.html" "Mozilla/1.0S (X11; IRIX 5.3; IP22)"
		** This format is not supported yet.
		*/

		while (*cp == ' ')			/* skip spaces */
			cp++;

		if (logfmt == LOGF_UNKNOWN) {
			if (*cp == '\0') {		/* fall back to CLF */
				if (total.hits > 50L) {
					logfmt = LOGF_CLF;
					if (verbose)
						prmsg(0, "%s", GETMSG(370, "Common Logfile Format (CLF) detected\n"));
				}
			} else if (*cp == '"' && *(refer.str-1) == '"') {
				logfmt = LOGF_NCSA;	/* NCSA combined format */
				if (verbose)
					prmsg(0, "%s", GETMSG(371, "Hmm, looks like Combined Logfile Format (DLF)\n"));
			} else {
				logfmt = LOGF_ELF;	/* unambiguous extended format */
				if (verbose)
					prmsg(0, "%s", GETMSG(372, "Hmm, looks like Extended Logfile Format (ELF)\n"));
			}
		}

		uatype.str = refhost.str = NULL;
		uatype.len = refhost.len = 0;
		uatype.hval = refhost.hval = 0;

		/*
		** Handle ambiguous NCSA format.
		*/
		if (*cp == '\0' || logfmt == LOGF_CLF) {
			uagent.len = refer.len = 0;
			uagent.str = refer.str = NULL;
		} else if (logfmt == LOGF_NCSA) {
			tm = refer.str;			/* save ptr to end of line */
			uagent.len = refer.len = 0;
			uagent.str = refer.str = NULL;

			if (*cp == '"')
				cp++;

			for (refer.str=cp; *cp != '\0'; cp++)	/* find end of referrer field */
				if (*cp == '"' && (cp[1] == ' ' || cp[1] == '\0'))
					break;

			if ((refer.len = (size_t)(cp-refer.str)) == 0)
				refer.str = NULL;
			else if (refer.len == 1 && *refer.str == '-') {
				*refer.str = '\0'; /* no referrer URL given */
				refer.len = 0;
			}
			if (*cp == '"') *cp++ = '\0';
			if (*cp == ' ') *cp++ = '\0';

			if (*cp == '"') {
				cp++;
				if (*(tm-1) == '"')
					*--tm = '\0';
			}
			if (cp < tm) {
				uagent.len = (size_t)(tm-cp);
				uagent.str = cp;
				if (uagent.len == 1 && *uagent.str == '-') {
					*uagent.str = '\0';	/* no user agent given */
					uagent.len = 0;
				} else {		/* compute hash value */
					strip = 0;
					uagent.hval = 0;
					for (cp=uagent.str; *cp != '\0'; cp++) {
						if (strip > 0 && *cp == ' ') {
							uatype.str = uagent.str;
							uatype.len = (size_t)(cp-uagent.str);
							uatype.hval = uagent.hval%HIDELIST_SIZE;
							strip = -1;
						}
						uagent.hval = (uagent.hval<<1) + (u_char)*cp;
						if (*cp == ')') {
							*++cp = '\0';
							uagent.len = (size_t)(cp-uagent.str);
							break;
						}
						if (strip < 0)
							continue;

						if (!strip) {
							if (is_digit(*cp))
								strip++;
							else if (*cp == '(')
								strip = -1;
						} else if (*cp == '.' || *cp == '-') {
							uatype.str = uagent.str;
							uatype.len = (size_t)(cp-uagent.str)+1;
							uatype.hval = uagent.hval%HIDELIST_SIZE;
							strip = -1;
						}
					}
					if (!uatype.len) {
						uatype.str = uagent.str;
						uatype.len = uagent.len;
						uatype.hval = uagent.hval%HIDELIST_SIZE;
					}
					uagent.hval %= TABSIZE(uatab);
				}
			}
		} else {			/* handle unambiguous extended format */
			uagent.str = cp;
			cp = refer.str-1;

			if (*cp == '-' && cp-1 > uagent.str && *(cp-1) == ' ') {
				refer.str = cp;	/* no referrer URL given */
				refer.len = 0;
				*cp-- = '\0';	/* separate user agent from referrer */
				*cp = '\0';
				uagent.len = (size_t)(cp-uagent.str);
			} else {		/* try to find the <prot>:// part */
				while (cp > uagent.str && *cp != ':')
					cp--;
				while (cp > uagent.str && *cp != ' ')
					cp--;
				if (cp == uagent.str) {	/* no referrer found */
					while (refer.str-1 > uagent.str && *(refer.str-1) == ' ')
						*--refer.str = '\0';	/* delete trailing blanks */
					uagent.len = (size_t)(refer.str-uagent.str);
					refer.str = NULL;
					refer.len = 0;
				} else {	/* compute length of referrer URL */
					uagent.len = (size_t)(cp-uagent.str);
					*cp++ = '\0';
					refer.len = (size_t)(refer.str-cp);
					refer.str = cp;
				}
			}
			if (uagent.len == 1 && *uagent.str == '-') {
				*uagent.str = '\0';	/* has user agent field, but none given */
				uagent.len = 0;
			} else {			/* find type, compute hash value */
				strip = 0;
				uagent.hval = 0;
				for (cp=uagent.str; *cp != '\0'; cp++) {
					if (strip > 0 && *cp == ' ') {
						uatype.str = uagent.str;
						uatype.len = (size_t)(cp-uagent.str);
						uatype.hval = uagent.hval%HIDELIST_SIZE;
						strip = -1;
					}
					uagent.hval = (uagent.hval<<1) + (u_char)*cp;
					if (*cp == ')') {
						*++cp = '\0';
						uagent.len = (size_t)(cp-uagent.str);
						break;
					}
					if (strip < 0)
						continue;

					if (!strip) {
						if (is_digit(*cp))
							strip++;
						else if (*cp == '(')
							strip = -1;
					} else if (*cp == '.' || *cp == '-') {
						uatype.str = uagent.str;
						uatype.len = (size_t)(cp-uagent.str)+1;
						uatype.hval = uagent.hval%HIDELIST_SIZE;
						strip = -1;
					}
				}
				if (!uatype.len) {
					uatype.str = uagent.str;
					uatype.len = uagent.len;
					uatype.hval = uagent.hval%HIDELIST_SIZE;
				}
				uagent.hval %= TABSIZE(uatab);
			}
		}

		/*
		** Strip cgi-bin arguments, target names, and the HTTP protocol.
		** Decode hex sequences into character codes.
		** Since the decoded string must be always shorter than the
		** encoded version, we can safely use the same array for the
		** resulting string. Precompute hash value. Remember last
		** component of URL.
		*/
		request.hval = 0;
		tm = reqbase.str = request.str;
		for (cp=request.str; *cp && *cp != '#'; cp++) {
			if (msiis_mode && is_upper(*cp))
				*cp = to_lower(*cp);

			if (*cp == '/')
				reqbase.str = tm;	/* remember last slash */
			else if (*cp == '?') {
				if (!nocgistrip)
					break;
			} else if (*cp == '%' &&
				   isxdigit(cp[1]) && isxdigit(cp[2])) {
				u_char rc = trHex(cp);
				*tm++ = rc;
				request.hval = (request.hval<<1)+rc;
				cp += 2;
				continue;
			}
			*tm++ = *cp;
			request.hval = (request.hval<<1)+(u_char)*cp;
		}

		/*
		** Check for empty requests.
		*/
		if ((request.len = (size_t)(tm-request.str)) == 0) {
			if (verbose > 2)
				prmsg(0, GETMSG(373, "Empty request?!? Skip line %lu\n"), lnum);
			reqempty++;
			continue;
		}
		request.hval %= TABSIZE(urltab);
		reqbase.hval = 0;
		reqbase.len = (size_t)(tm-reqbase.str);
		*tm = '\0';			/* terminate string */

		/*
		** Check for partial match of document root if given.
		*/
		if (vrlen > 1 && virt_root != NULL) {
			if (request.len >= vrlen) {
				tm = virt_root;
				cp = request.str;
				while (*tm && *tm == *cp)
					tm++, cp++;
				if (drneg ? *tm == '\0' : *tm != '\0') {
					ignored++;
					continue;
				}
			} else if (!drneg) {
				ignored++;
				continue;
			}
		}

		/*
		** Ignore certain URLs if requested
		*/
		if (hidden[IGNORED_ITEMS].t_count && isIgnoredItem(IGNORED_ITEMS, &request)) {
			ignored++;
			continue;
		}

		/*
		** For GET and POST methods, truncate the name of directory
		** index files and it's variations so they merge with `/'.
		*/
		if (reqmethod == METHOD_GET || reqmethod == METHOD_POST) {
			if (request.str[request.len-1] == '/')
				ftype |= TYPE_PGVIEW;
			else for (idx=0; idx < MAX(ipnum, ptnum); idx++) {
				if (idx < ipnum && reqbase.len == indexpg[idx].len &&
				    reqbase.str[1] == indexpg[idx].str[1]) {
					len = indexpg[idx].len;
					tm = indexpg[idx].str;
					cp = reqbase.str;
					while (*tm && *tm++ == *cp++)
						len--;
					if (len == 0) {		/* must re-compute hash value */
						request.len -= (size_t)indexpg[idx].len-1;
						*(reqbase.str+1) = '\0';
						reqbase.len = 1;
						request.hval = 0;
						for (cp = request.str; *cp; cp++)
							request.hval = (request.hval<<1) + (u_char)*cp;
						request.hval %= TABSIZE(urltab);
						ftype |= TYPE_PGVIEW;
						break;
					}
				}
				/*
				** Check whether we rate this file as a pageview.
				*/
				if (idx < ptnum &&
				    (*pvtab[idx].str == '.' ? reqbase.len > pvtab[idx].len
							    : request.len >= pvtab[idx].len)) {
					len = pvtab[idx].len;
					tm = pvtab[idx].str;
					cp = (*tm == '.') ? request.str + (request.len-pvtab[idx].len)
							  : request.str;
					while (*tm && *tm++ == *cp++)
						len--;
					if (len == 0)
						ftype |= TYPE_PGVIEW;
				}
			}
		}
		if (reqbase.len) {
			reqbase.len = (size_t)((reqbase.str+1)-request.str);
			reqbase.str = request.str;
		}

		/*
		** Massage the referrer URL, delete usernames and passwords,
		** find referrer host, compute hash value.
		*/
		if (refer.len) {	/* massage the referrer URL, compute hash value */
			refer.hval = 0;
			strip = 0;

			for (cp=refer.str; !strip && *cp != '\0' && *cp != '/'; cp++) {
				refer.hval = (refer.hval<<1) + (u_char)*cp;
				if (*cp == ':' && cp[1] == '/' && cp[2] == '/') {
					refer.hval = (refer.hval<<1) + (u_char)*++cp;
					refer.hval = (refer.hval<<1) + (u_char)*++cp;
					strip++;
				}
			}
			if (strip) {			/* found hostname part */
				for (tm = cp; *tm != '\0'; tm++)
					if (*tm == '@' || *tm == '/')
						break;

				if (*tm == '@') {	/* delete username and password */
					char *dp = cp;
					while ((*dp++ = *++tm) != '\0')
						/* no-op */ ;
				}
				while (*cp != '\0') {	/* compute rest of hash value */
					if (*cp == '/' || *cp == ':' || (*cp == '.' && cp[1] == '/'))
						if (++strip == 2) {
							refhost.str = refer.str;
							refhost.len = (size_t)(cp-refer.str);
							refhost.hval = refer.hval%HIDELIST_SIZE;
						}
					refer.hval = (refer.hval<<1) + (u_char)*cp++;
				}
				refer.len = (size_t)(cp-refer.str);
				if (strip == 1) {
					refhost.str = refer.str;
					refhost.len = refer.len;
					refhost.hval = refer.hval%HIDELIST_SIZE;
				}
			} else while (*cp != '\0')
				refer.hval = (refer.hval<<1) + (u_char)*cp++;


			refer.hval %= TABSIZE(reftab);
		}

		/*
		** Delete authuser in case server has logged it
		** with responses other than OK or Not Modified.
		*/
		if (authuser.str && resp != RES_OK && resp != RES_NOT_MODIFIED) {
			authuser.str = NULL;
			authuser.len = 0;
			authuser.hval = 0;
		}

		/* copy data */
		np.sitename = sitename;
		np.tldomain = tldomain;
		np.authuser = authuser;
		np.request  = request;
		np.reqbase  = reqbase;
		np.uagent   = uagent;
		np.uatype   = uatype;
		np.refer    = refer;
		np.refhost  = refhost;
		np.reqsize  = reqsize;
		np.ltick    = ltick;
		np.ftype    = ftype;

		switch (resp) {
		  default:			np.respidx = IDX_UNKNOWN;	break;
		  case RES_CONTINUE:		np.respidx = IDX_CONTINUE;	break;
		  case RES_SWITCH_PROTO:	np.respidx = IDX_SWITCH_PROTO;	break;
		  case RES_OK:			np.respidx = IDX_OK;		break;
		  case RES_CREATED:		np.respidx = IDX_CREATED;	break;
		  case RES_ACCEPTED:		np.respidx = IDX_ACCEPTED;	break;
		  case RES_NON_AUTH:		np.respidx = IDX_NON_AUTH;	break;
		  case RES_NO_CONTENT:		np.respidx = IDX_NO_CONTENT;	break;
		  case RES_RSET_CONTENT:	np.respidx = IDX_RSET_CONTENT;	break;
		  case RES_PART_CONTENT:	np.respidx = IDX_PART_CONTENT;	break;
		  case RES_MULT_CHOICES:	np.respidx = IDX_MULT_CHOICES;	break;
		  case RES_MOVED_PERM:		np.respidx = IDX_MOVED_PERM;	break;
		  case RES_MOVED_TEMP:		np.respidx = IDX_MOVED_TEMP;	break;
		  case RES_SEE_OTHER:		np.respidx = IDX_SEE_OTHER;	break;
		  case RES_NOT_MODIFIED:	np.respidx = IDX_NOT_MODIFIED;	break;
		  case RES_USE_PROXY:		np.respidx = IDX_USE_PROXY;	break;
		  case RES_TEMP_REDIR:		np.respidx = IDX_TEMP_REDIR;	break;
		  case RES_BAD_REQUEST:		np.respidx = IDX_BAD_REQUEST;	break;
		  case RES_UNAUTHORIZED:	np.respidx = IDX_UNAUTHORIZED;	break;
		  case RES_PAYMENT_REQ:		np.respidx = IDX_PAYMENT_REQ;	break;
		  case RES_FORBIDDEN:		np.respidx = IDX_FORBIDDEN;	break;
		  case RES_NOT_FOUND:		np.respidx = IDX_NOT_FOUND;	break;
		  case RES_METHOD_NALLOWED:	np.respidx = IDX_METHOD_NALLOWED;break;
		  case RES_NOT_ACCEPTABLE:	np.respidx = IDX_NOT_ACCEPTABLE;break;
		  case RES_PROXY_AUTHREQ:	np.respidx = IDX_PROXY_AUTHREQ;	break;
		  case RES_REQ_TIMEOUT:		np.respidx = IDX_REQ_TIMEOUT;	break;
		  case RES_CONFLICT:		np.respidx = IDX_CONFLICT;	break;
		  case RES_GONE:		np.respidx = IDX_GONE;		break;
		  case RES_LENGTH_REQ:		np.respidx = IDX_LENGTH_REQ;	break;
		  case RES_PRECOND_FAILED:	np.respidx = IDX_PRECOND_FAILED;break;
		  case RES_ENT_TOO_LARGE:	np.respidx = IDX_ENT_TOO_LARGE;	break;
		  case RES_URI_TOO_LONG:	np.respidx = IDX_URI_TOO_LONG;	break;
		  case RES_UNSUPPORTED:		np.respidx = IDX_UNSUPPORTED;	break;
		  case RES_RANGE_NOT_SAT:	np.respidx = IDX_RANGE_NOT_SAT;	break;
		  case RES_EXPECT_FAILED:	np.respidx = IDX_EXPECT_FAILED;	break;
		  case RES_SERVER_ERROR:	np.respidx = IDX_SERVER_ERROR;	break;
		  case RES_NOT_IMPLEMENTED:	np.respidx = IDX_NOT_IMPLEMENTED;break;
		  case RES_BAD_GATEWAY:		np.respidx = IDX_BAD_GATEWAY;	break;
		  case RES_SERVICE_UNAVAIL:	np.respidx = IDX_SERVICE_UNAVAIL;break;
		  case RES_GATEWAY_TIMEOUT:	np.respidx = IDX_GATEWAY_TIMEOUT;break;
		  case RES_VERS_NSUPPORTED:	np.respidx = IDX_VERS_NSUPPORTED;break;
		}

		if (verbose > 2) {
			if (verbose > 3)
				(void) fputc('\n', stderr);
			(void) fprintf(stderr,
				"%7lu %02hu/%.3s/%hu:%02hu:%02hu:%02hu [%lu], "
				"req=\"%s %s\", sz=%lu <- %s%s",
				lnum, np.tm.mday, monnam[np.tm.mon], np.tm.year,
				np.tm.hour, np.tm.min, np.tm.sec, np.ltick,
				ReqMethod[(np.ftype&METHOD_MASK)].msg,
				np.request.str, np.reqsize, RespCode[np.respidx].msg,
				IS_TYPE(ftype, TYPE_PGVIEW) ? ", PAGEVIEW" : "");
			if (np.authuser.str)
				(void) fprintf(stderr, ", AUTHREQ");
			if (virthost.str)
				(void) fprintf(stderr, ", VIRTHOST: %s", virthost.str);
			(void) fputc('\n', stderr);

			if (verbose > 3) {
				if (!np.tldomain.len)
					(void) fprintf(stderr, "\thost=%s, dom=%s\n", np.sitename.str,
						IS_TYPE(np.ftype, TYPE_NODNS) ? "[IP]" : "[none]");
				else	(void) fprintf(stderr, "\thost=%s, dom=%s\n",
						np.sitename.str, np.tldomain.str);
				if (np.uagent.len) {
					if (np.uatype.len)
						(void) fprintf(stderr, "\tuag=%s, uatype=%.*s\n",
							np.uagent.str, (int)np.uatype.len, np.uatype.str);
					else	(void) fprintf(stderr, "\tuag:%s\n", np.uagent.str);
				}
				if (np.refer.len) {
					if (np.refhost.len)
						(void) fprintf(stderr, "\tref=%s, refhost=%.*s\n",
							np.refer.str, (int)np.refhost.len, np.refhost.str);
					else	(void) fprintf(stderr, "\tref:%s\n", np.refer.str);
				}
			}
		}
		return &np;		/* found an entry */
	}
	return NULL;
}

/*
** Return a hashed string.
** Needed only for few constant strings, since
** values are computed "on the fly" elsewhere.
*/
static HSTRING *hashedString(u_int const hsize, char *str) {
	static HSTRING hstr;

	hstr.hval = 0;
	hstr.len = 0;
	for (hstr.str=str; *str != '\0'; str++)
		hstr.hval = (hstr.hval<<1) + (u_char)*str;

	hstr.hval %= hsize;
	hstr.len = (size_t)(str-hstr.str);
	return &hstr;
}

/*
** Lookup item in hash list.
*/
static int nomem = 0;

static NLIST *lookupItem(NLIST **const htab, HSTRING *const item, u_int const sslen) {
	register char *s1, *s2;
	register NLIST *np;

	/* lookup the item in the given list */
	for (np=htab[item->hval]; np != NULL; np = np->next)
		if (np->len == item->len && !strcmp(np->str, item->str))
			break;

	if (np != NULL)		/* known already */
		return np;

	if (nomem)		/* new entry, but no more memory available */
		return NULL;	/* we can't do anything useful */

	/* create new entry */
	if (!(np = (NLIST *)malloc(sizeof(NLIST))) || !(np->str = malloc(item->len+1))) {
		prmsg(1, GETMSG(337, enomem), sizeof(NLIST));
		nomem = 1;
		return NULL;
	}
	for (s1=np->str, s2=item->str; (*s1 = *s2) != '\0'; s1++, s2++)
		/* copy string */ ;
	
	np->len = item->len;		/* initialize NLIST values */
        np->ishidden = -1;
        np->sslen = sslen;
	np->size = np->ltick = 0L;
	CLEAR_CNT(np->cnt);
	np->next = htab[item->hval];	/* insert element into hash list */
	htab[item->hval] = np;
	return np;
}

/*
** Clear all items from the given list.
*/
static void clearItems(NLIST **const htab, int const max) {
	NLIST *node, *np;
	int idx;

	for (idx=0; idx < max; idx++) {
		if ((node = htab[idx]) == NULL)
			continue;
			
		do {	np = node->next;
			free((void *)node->str);
			free((void *)node);
		} while ((node = np) != NULL);
		htab[idx] = NULL;
	}
	nomem = 0;	/* try again */
	return;
}

/*
** Clear all or some counters.
*/
static void clearCounter(int const all) {
	size_t idx;

	this_hits += total.hits;	/* add total hits to hits processed ever */
	ndays = 1UL;			/* no of days processed for avg values */

	corrupt = ignored = reqempty = reqinval = reqauth = 0L;
	total_agents = total_refer = total_kbsaved = uniq_urls = uniq_sites = 0L;
	max_avhits = max_avdhits = max_avhhits = max_whhits = 0L;

	if (all) {
		(void) memset((void *)monly, 0, sizeof monly);
		for (idx=0; idx < TABSIZE(monly); idx++)
			monly[idx].bytes = 0.0;

		(void) memset((void *)&cksum, 0, sizeof cksum);
		cksum.bytes = 0.0;
	}

	(void) memset((void *)&total, 0, sizeof total);
	(void) memset((void *)&avg_day, 0, sizeof avg_day);
	(void) memset((void *)&max_day, 0, sizeof max_day);
	total.bytes = avg_day.bytes = max_day.bytes = 0.0;

	(void) memset((void *)avg_hour, 0, sizeof avg_hour);
	(void) memset((void *)avg_wday, 0, sizeof avg_wday);
	(void) memset((void *)avg_whour, 0, sizeof avg_whour);
	(void) memset((void *)wh_hits, 0, sizeof wh_hits);
	(void) memset((void *)wh_cnt, 0, sizeof wh_cnt);
	(void) memset((void *)daily, 0, sizeof daily);
	(void) memset((void *)weekly, 0, sizeof weekly);

	for (idx=0; idx < TABSIZE(daily); idx++)
		daily[idx].bytes = 0.0;

	for (idx=0; idx < TABSIZE(weekly); idx++)
		weekly[idx].bytes = 0.0;

	(void) memset((void *)unknown, 0, sizeof unknown);
	unknown[HIDDEN_ITEMS].bytes = unknown[HIDDEN_SITES].bytes =
	unknown[HIDDEN_AGENTS].bytes = unknown[HIDDEN_REFERS].bytes =
	unknown[SELF_REF].bytes = 0.0;

	if (top_sites != NULL)
		(void) memset((void *)top_sites, 0, (size_t)topn_sites*sizeof(NLIST *));
	if (top_agent != NULL)
		(void) memset((void *)top_agent, 0, (size_t)topn_agent*sizeof(NLIST *));
	if (top_refer != NULL)
		(void) memset((void *)top_refer, 0, (size_t)topn_refer*sizeof(NLIST *));
	if (top_urls != NULL)
		(void) memset((void *)top_urls, 0, (size_t)topn_urls*sizeof(NLIST *));
	if (lst_urls != NULL)
		(void) memset((void *)lst_urls, 0, (size_t)lstn_urls*sizeof(NLIST *));

	if (top_day) {
		(void) memset((void *)top_day, 0, (size_t)topn_day*sizeof(TOP_COUNTER));
		for (idx=0; idx < (size_t)topn_day; idx++)
			top_day[idx].cnt.bytes = 0.0;
	}
	if (top_hrs) {
		(void) memset((void *)top_hrs, 0, (size_t)topn_hrs*sizeof(TOP_COUNTER));
		for (idx=0; idx < (size_t)topn_hrs; idx++)
			top_hrs[idx].cnt.bytes = 0.0;
	}
	if (top_min) {
		(void) memset((void *)top_min, 0, (size_t)topn_min*sizeof(TOP_COUNTER));
		for (idx=0; idx < (size_t)topn_min; idx++)
			top_min[idx].cnt.bytes = 0.0;
	}
	if (top_sec) {
		(void) memset((void *)top_sec, 0, (size_t)topn_sec*sizeof(TOP_COUNTER));
		for (idx=0; idx < (size_t)topn_sec; idx++)
			top_sec[idx].cnt.bytes = 0.0;
	}

	for (idx=0; idx < TABSIZE(RespCode); idx++) {
		CLEAR_CNT(RespCode[idx].cnt);
	}
	for (idx=0; idx < TABSIZE(ReqMethod); idx++) {
		CLEAR_CNT(ReqMethod[idx].cnt);
	}
	return;
}

/*
** Transform str into a valid URL.
*/
static HSTRING *validURL(char *const host, char *const prot) {
	static HSTRING this;
	char *tm = strstr(host, "://");		/* look for protocol specifier */

	if (prot == NULL) {
		if (!tm)
			return NULL;

		if ((this.len = strlen(host)) == 0 ||
		    (this.str = (char *)malloc(this.len+1)) == NULL)
			return NULL;

		(void) strcpy(this.str, host);
	} else {				/* create URL with given proto */
		tm = tm ? tm+3 : host;		/* skip potential proto spec in host */
		while (*tm == '/')		/* skip leading slashes */
			tm++;

		if ((this.len = strlen(prot)+strlen(tm)) == 0 ||
		    (this.str = (char *)malloc(this.len+1)) == NULL)
			return NULL;

		(void) strcpy(this.str, prot);
		(void) strcat(this.str, tm);
	}
	while (this.str[this.len-1] == '/')
		this.str[--this.len] = '\0';	/* delete trailing slashes */

	for (tm=this.str; *tm; tm++)		/* convert to lowercase */
		if (isupper(*tm)) *tm = tolower(*tm);

	return this.len != 0 ? &this : NULL;
}


/*
** Create a table with the weekdays for this month.
** Note that in Germany a week starts at Monday, so
** we have to adjust the table entries for the values
** used by Unix time functions.
*/
static void mkdtab(LOGTIME *const lt) {
	size_t wday;
	size_t idx;
	time_t now;
	struct tm *tp;

	tp = localtime(&now);		/* get current time to compensate for timezone */
	tp->tm_mday = 1;		/* tick back to first day of month, 00:00:00 */
	tp->tm_mon = (int)lt->mon;
	tp->tm_year = (int)lt->year-1900;
	tp->tm_hour = tp->tm_min = tp->tm_sec = 0;

	(void) mktime(tp);		/* adjust tm_wday */

	if ((wday = (size_t)tp->tm_wday) == 0)	/* get first day of week, create table */
		wday = 6;
	else	wday--;			/* localization */

	for (idx=0; idx < TABSIZE(wdtab); idx++, wday++)
		wdtab[idx] = wday % 7;
	return;
}

/*
** Add an URL or a hostname to the list of ignored items.
*/
#define MEM_CHUNK	1000

static void addIgnoredItem(int const which, char *const pfx) {
	size_t idx, plen = 0;

	if (pfx != NULL)
		plen = strlen(pfx);

	if (!plen) {
		prmsg(1, GETMSG(379,
			"Can't add zero length URL/hostname to the list of ignored items?!?\n"));
		return;
	}

	switch (which) {	/* cover wrong parameters even if assertion is turned off */
	  default:		assert(which != which); return; /*NOTREACHED*/
	  case IGNORED_ITEMS:	/* FALLTHROUGH */
	  case IGNORED_SITES:	if (plen && (*pfx == '*' || *(pfx+plen-1) == '*'))
					plen--;
				break;
	}

	if (hidden[which].t_errmsg)	/* table overflow */
		return;

	if ((idx = hidden[which].t_count) == hidden[which].t_avail) {
		ITEM_LIST *newcore = !idx
				   ? (ITEM_LIST *)calloc(MEM_CHUNK, sizeof(ITEM_LIST))
				   : (ITEM_LIST *)realloc((void *)hidden[which].tab,
					(hidden[which].t_avail+MEM_CHUNK)*sizeof(ITEM_LIST));

		if (newcore != NULL) {
			hidden[which].t_avail += MEM_CHUNK;
			hidden[which].tab = newcore;
		} else {
			hidden[which].t_errmsg++;
			prmsg(1, "%s", which == IGNORED_SITES
					? GETMSG(377, "Table overflow in ignore list, "
						      "some host definitions will be skipped.\n")
					: GETMSG(378, "Table overflow in ignore list, "
						      "some URL definitions will be skipped.\n"));
			return;
		}
	}

	hidden[which].tab[idx].len = plen;
	hidden[which].tab[idx].pfx = pfx;
	hidden[which].tab[idx].col = NULL;
	hidden[which].tab[idx].sref = NULL;
	hidden[which].t_count++;
	return;
}

/*
** Save hidden item.
*/
static void saveHiddenItem(int const which, HSTRING *const item) {
	register size_t len, max;
	char nbuf[MEDIUMSIZE];
	HSTRING nitem;

	max = (item->len < sizeof(nbuf)-1) ? item->len : sizeof(nbuf)-1;

	for (nitem.hval=0, len=0; len < max; len++) {
		if ((nbuf[len] = item->str[len]) == '\0')
			break;
		nitem.hval = (nitem.hval<<1) + (u_char)nbuf[len];
	}
	nbuf[len] = '\0';
	nitem.len = len;
	nitem.str = nbuf;
	nitem.hval %= HIDELIST_SIZE;

	if (verbose > 3)
		prmsg(0, GETMSG(188, "save %s: %s [%d;%d]\n"),
			hidden[which].what, nitem.str, nitem.len, nitem.hval);

	addHiddenName(which, NULL, NULL, &nitem);
	return;
}

/*
** Add an item to a list of hidden items.
*/
static void addHiddenName(size_t const which, char *pfx, char *const sref, HSTRING *const dsc) {
	size_t idx, plen = 0;
	NLIST *np;

	if (pfx != NULL)
		plen = strlen(pfx);

	switch (which) {
	  default:		assert(which != which); return; /*NOTREACHED*/

	  case HIDDEN_SITES:	/*FALLTHROUGH*/
	  case HIDDEN_ITEMS:	if (plen && (*pfx == '*' || *(pfx+plen-1) == '*'))
					plen--;
				break;

	  case HIDDEN_AGENTS:	/*FALLTHROUGH*/
	  case HIDDEN_REFERS:	if (plen) {
					if (*pfx == '*') {
						pfx++;
						plen--;
					} else if (*(pfx+plen-1) == '*')
						pfx[--plen] = '\0';
				}
				break;
	}

	if (hidden[which].t_errmsg)	/* table overflow */
		return;

	if ((np = lookupItem(hlist[which], dsc, 0)) == NULL) {
		hidden[which].t_errmsg++;
		prmsg(2, GETMSG(380, "Not enough memory to add %s `%s'?!?\n"),
			hidden[which].what, dsc->str);
		return;
	}
	if (!pfx && !np->ishidden)
		return;					/* known already */

	np->ishidden = 0;				/* make it known */
	if ((idx = hidden[which].t_count) == hidden[which].t_avail) {
		ITEM_LIST *newcore = !idx
				   ? (ITEM_LIST *)calloc(MEM_CHUNK, sizeof(ITEM_LIST))
				   : (ITEM_LIST *)realloc((void *)hidden[which].tab,
					(hidden[which].t_avail+MEM_CHUNK)*sizeof(ITEM_LIST));
		if (newcore != NULL) {
			hidden[which].t_avail += MEM_CHUNK;
			hidden[which].tab = newcore;
		} else {
			hidden[which].t_errmsg++;
			prmsg(1, GETMSG(381, "Not enough memory for %s list, some %ss are ignored.\n"),
				hidden[which].what, hidden[which].what);
			return;
		}
	}
	hidden[which].tab[idx].col = np;		/* description */
	hidden[which].tab[idx].len = pfx ? plen : np->len; /* length of prefix/desc */
	hidden[which].tab[idx].pfx = pfx ? pfx  : np->str; /* prefix or desc */
	hidden[which].tab[idx].sref = sref ? strsave(sref) : sref; /* opt value */
	hidden[which].t_count++;
	return;
}
#undef MEM_CHUNK

/*
** Append image suffixes as defaults to the list of hidden items.
*/
static char *imglist[] = {
	"*.gif", "*.ief", "*.jpg", "*.jpeg", "*.pcd",
	"*.png", "*.rgb", "*.xbm", "*.xpm", "*.xwd",
	"*.tif", "*.tiff", NULL };

static void defHiddenImages(void) {
	HSTRING *hsp;
	char **img;

	hsp = hashedString(HIDELIST_SIZE, GETMSG(335, "All images"));
	for (img=imglist; *img != NULL; img++)
		addHiddenName(HIDDEN_ITEMS, *img, NULL, hsp);
	return;
}

/*
** Set the default hidden referrer URLs.
*/
static void defHiddenRefers(void) {
	HSTRING *hsp;

	hsp = hashedString(HIDELIST_SIZE, GETMSG(382, "FILE REFERRER"));
	addHiddenName(HIDDEN_REFERS, "about:", NULL, hsp);
	addHiddenName(HIDDEN_REFERS, "file:", NULL, hsp);
	hsp = hashedString(HIDELIST_SIZE, GETMSG(383, "USENET REFERRER"));
	addHiddenName(HIDDEN_REFERS, "news:", NULL, hsp);
	hsp = hashedString(HIDELIST_SIZE, GETMSG(384, "FTP REFERRER"));
	addHiddenName(HIDDEN_REFERS, "ftp:", NULL, hsp);
	hsp = hashedString(HIDELIST_SIZE, GETMSG(385, "MAILTO REFERRER"));
	addHiddenName(HIDDEN_REFERS, "mailto:", NULL, hsp);
	return;
}
static size_t refn_urls = 0;
static size_t refn_max = 0;

/*
** Add self referrer names.
*/
static void addSelfRefer(char *const str, size_t const len) {
	HSTRING *morecore = NULL;

	if (!str || !len) {			/* invalid referrer URL */
		prmsg(0, "%s", GETMSG(386, "Invalid self referrer URL (zero length)\n"));
		return;
	}

	if (!refn_max || refn_max == refn_urls) {
		if (!refn_max)
			morecore = (HSTRING *)malloc(10*sizeof(HSTRING));
		else	morecore = (HSTRING *)realloc((void *)ref_urls, (refn_max+10)*sizeof(HSTRING));

		if (morecore == NULL) {
			prmsg(1, GETMSG(337, enomem), (refn_max+10)*sizeof(HSTRING));
			return;
		}
		refn_max += 10;
		ref_urls = morecore;
	}
	ref_urls[refn_urls].str = str;
	ref_urls[refn_urls++].len = len;
	return;
}

/*
** Check for self referrer.
*/
static int isSelfRefer(char *const host, size_t const hlen) {
	register char *cp, *tm;
	register size_t idx;

	if (!ref_urls || !refn_urls)
		return 0;

	for (idx=0; idx < refn_urls; idx++) {
		if (hlen == ref_urls[idx].len) {
			tm = ref_urls[idx].str+ref_urls[idx].len;
			cp = host+ref_urls[idx].len;
			do {
				--cp;
				if (*--tm != (is_upper(*cp) ? to_lower(*cp) : *cp))
					break;
			} while (tm > ref_urls[idx].str && cp > host);
			if (tm == ref_urls[idx].str && cp == host)
				return 1;
		}
	}
	return 0;
}

/*
** Check for ignored item. If prefix begins with `*', check only for
** a match of the suffix. If prefix ends with `*', check only for a
** match of the leading part, otherwise check for an exact match.
** We use case-independant comparison for URLs and sitenames.
*/
static int isIgnoredItem(int const which, HSTRING *const hsp) {
	register char *pfx;
	register size_t idx, plen;
	register ITEM_LIST *ip;

	switch (which) {	/* cover wrong parameters even if assertion is turned off */
	  default:		assert(which != which); return 0; /*NOTREACHED*/
	  case IGNORED_ITEMS:	/* FALLTHROUGH */
	  case IGNORED_SITES:	break;
	}
	ip = hidden[which].tab;

	for (idx=0; idx < hidden[which].t_count; idx++) {
		pfx = ip[idx].pfx;
		plen = ip[idx].len;
		if (*pfx == '*') {			/* handle `*' prefix */
			if (hsp->len >= plen) {
				plen = hsp->len - plen;
				if (hsp->str[plen] == *++pfx && streq(hsp->str+plen, pfx))
					break;
			}
		} else if (*(pfx+plen) == '*') {	/* handle `*' suffix */
			if (hsp->len >= plen &&
			   *hsp->str == *pfx && strneq(hsp->str, pfx, plen))
				break;
		} else if (hsp->len == plen &&		/* exact match */
			  *hsp->str == *pfx && streq(hsp->str, pfx))
			break;
	}
	return idx != hidden[which].t_count;
}

/*
** Check for hidden item, collect data. If prefix begins with `*',
** check only for a match of the suffix. If prefix ends with `*',
** check only for a match of the leading part, otherwise check
** for an exact match.
*/
static int isHiddenItem(NLIST *const np) {
	register char *pfx;
	register size_t plen;
	register int idx, rc, low, high;
	register ITEM_LIST *ip;

	idx = 0;
	ip = hidden[HIDDEN_ITEMS].tab;
	if (hidden[HIDDEN_ITEMS].t_start) {
		for ( ; idx < (int)hidden[HIDDEN_ITEMS].t_start; idx++) {
			pfx = ip[idx].pfx;
			plen = ip[idx].len;
			if (*pfx == '*') {			/* handle `*' prefix */
				if (np->len >= plen) {
					plen = np->len - plen;
					if (*++pfx == np->str[plen] &&
					    (msiis_mode ? streq(pfx, np->str+plen)
							: !strcmp(pfx, np->str+plen)))
						break;
				}
			} else if (*(pfx+plen) == '*') {	/* handle `*' suffix */
				if (np->len >= plen && *pfx == *np->str &&
				    (msiis_mode ? strneq(pfx, np->str, plen)
						: !strncmp(pfx, np->str, plen)))
					break;
			} else if (np->len == plen && *pfx == *np->str &&
				   (msiis_mode ? streq(pfx, np->str)
					       : !strcmp(pfx, np->str)))
				break;
		}
	}
	/* binary search for rest of the list */
	if (idx == (int)hidden[HIDDEN_ITEMS].t_start) {
		if ((hidden[HIDDEN_ITEMS].t_start == hidden[HIDDEN_ITEMS].t_count) || !np->sslen) {
			np->ishidden = -1;	/* done already */
			return 0;
		}
		low = hidden[HIDDEN_ITEMS].t_start;
		high = hidden[HIDDEN_ITEMS].t_count-1;

		while (low <= high) {
			idx = (low+high) / 2;
			if (np->sslen < ip[idx].len)
				high = idx-1;
			else if (np->sslen > ip[idx].len)
				low = idx+1;
			else {
				if (msiis_mode)
					rc = strncasecmp(np->str, ip[idx].pfx, np->sslen);
				else	rc = strncmp(np->str, ip[idx].pfx, np->sslen);
				if (rc < 0)
					high = idx-1;
				else if (rc > 0)
					low = idx+1;
				else	break;
			}
		}
		if (high < low) {
			np->ishidden = -1;
			return 0;
		}
	}
	if (ip[idx].col->str == NULL) {
		np->ishidden = -1;
		return 0;
	}

	UPDATE_CNT(ip[idx].col->cnt, np->cnt);
	ip[idx].col->ishidden = np->ishidden = (short)idx;	/* stamp it */
	return 1;
}

/*
** Check for hidden site.
*/
static int isHiddenSite(NLIST *const np) {
	register char *tm;
	register size_t dlen, plen;
	register int idx, rc, low, high;
	register ITEM_LIST *ip;

	idx = 0;
	tm = np->str;
	dlen = np->len;
	ip = hidden[HIDDEN_SITES].tab;
	if (hidden[HIDDEN_SITES].t_start) {		/* linear search for pre-defined domains */
		for ( ; idx < (int)hidden[HIDDEN_SITES].t_start; idx++) {
			plen = ip[idx].len;
			if (*ip[idx].pfx == '*') {			/* handle `*' prefix */
				if (dlen >= plen && streq(ip[idx].pfx+1, tm+(dlen-plen)))
					break;
			} else if (*(ip[idx].pfx+plen) == '*') {	/* handle `*' suffix */
				if (dlen >= plen && strneq(ip[idx].pfx, tm, plen))
					break;
			} else if (dlen == plen && streq(ip[idx].pfx, tm))
				break;					/* exact match */
		}
	}
	if (idx == (int)hidden[HIDDEN_SITES].t_start) {	/* binary search for rest of the list */
		if (np->sslen < dlen) {			/* sanity check */
			tm += np->sslen;
			dlen -= np->sslen;
		}
		low = hidden[HIDDEN_SITES].t_start;
		high = hidden[HIDDEN_SITES].t_count-1;

		while (low <= high) {
			idx = (low+high) / 2;
			if ((rc = strcasecmp(tm, ip[idx].pfx)) < 0)
				high = idx-1;
			else if (rc > 0)
				low = idx+1;
			else	break;
		}
		if (high < low) {
			np->ishidden = -1;
			return 0;
		}
	}
	if (ip[idx].col->str == NULL) {
		np->ishidden = -1;
		return 0;
	}

	UPDATE_CNT(ip[idx].col->cnt, np->cnt);
	ip[idx].col->ishidden = np->ishidden = (short)idx;	/* stamp it */
	return 1;
}

/*
** Check for hidden agent.
*/
static int isHiddenAgent(NLIST *const np) {
	register int idx, rc, low, high;
	register ITEM_LIST *ip;

	idx = 0;
	ip = hidden[HIDDEN_AGENTS].tab;
	if (hidden[HIDDEN_AGENTS].t_start) {		/* linear search for pre-defined agents */
		for ( ; idx < (int)hidden[HIDDEN_AGENTS].t_start; idx++)
			if (np->len >= ip[idx].len && strneq(np->str, ip[idx].pfx, ip[idx].len))
				break;
	}
	if (idx == (int)hidden[HIDDEN_AGENTS].t_start) {/* binary search for rest of the list */
		if (!np->sslen) {			/* done already */
			np->ishidden = -1;
			return 0;
		}
		low = hidden[HIDDEN_AGENTS].t_start;
		high = hidden[HIDDEN_AGENTS].t_count-1;

		while (low <= high) {
			idx = (low+high) / 2;
			rc = strncmp(np->str, ip[idx].pfx, np->sslen);
			if (!rc && np->sslen < ip[idx].len)
				rc = -ip[idx].pfx[np->sslen];
			if (rc < 0)
				high = idx-1;
			else if (rc > 0)
				low = idx+1;
			else	break;
		}
		if (high < low) {
			np->ishidden = -1;
			return 0;
		}
	}
	if (ip[idx].col->str == NULL) {
		np->ishidden = -1;
		return 0;
	}

	UPDATE_CNT(ip[idx].col->cnt, np->cnt);
	ip[idx].col->ishidden = np->ishidden = (short)idx;	/* stamp it */
	return 1;
}

/*
** Check for hidden referrer.
*/
static int isHiddenRefer(NLIST *const np) {
	register int rc, idx, low, high;
	register ITEM_LIST *ip;

	idx = 0;
	ip = hidden[HIDDEN_REFERS].tab;
	if (hidden[HIDDEN_REFERS].t_start) {		/* linear search for pre-defined referrer URLs */
		for ( ; idx < (int)hidden[HIDDEN_REFERS].t_start; idx++)
			if (np->len >= ip[idx].len && strneq(np->str, ip[idx].pfx, ip[idx].len))
				break;
	}
	if (idx == (int)hidden[HIDDEN_REFERS].t_start) {
		if (!np->sslen) {			/* done already */
			np->ishidden = -1;
			return 0;
		}
		low = hidden[HIDDEN_REFERS].t_start;
		high = hidden[HIDDEN_REFERS].t_count-1;

		while (low <= high) {			/* binary search for rest of the list */
			idx = (low+high) / 2;
			rc = strncasecmp(np->str, ip[idx].pfx, np->sslen);
			if (!rc && np->sslen < ip[idx].len)
				rc = -ip[idx].pfx[np->sslen];
			if (rc < 0)
				high = idx-1;
			else if (rc > 0)
				low = idx+1;
			else	break;
		}
		if (high < low) {
			np->ishidden = -1;
			return 0;
		}
	}
	if (ip[idx].col->str == NULL) {			/* sanity check */
		np->ishidden = -1;
		return 0;
	}

	UPDATE_CNT(ip[idx].col->cnt, np->cnt);
	ip[idx].col->ishidden = np->ishidden = (short)idx;	/* stamp it */
	return 1;
}

/*
** Initialize list of hidden items.
*/
static void initHiddenItems(int const which) {
	size_t idx;
	ITEM_LIST *ip;

	if ((ip = hidden[which].tab) != NULL) {
		for (idx=0; idx < hidden[which].t_count; idx++) {
			ip[idx].col->ishidden = 0;
			ip[idx].col->ltick = 0L;
			CLEAR_CNT(ip[idx].col->cnt);
		}
	}
	return;
}

/*
** Process arguments for hidden items, add them to the list.
*/
static void hideArgs(int const which, char *const s1, char *s2) {
	char *tm, nbuf[MEDIUMSIZE];
	size_t len;
	HSTRING *hsp;

	for (len=0; len < sizeof(nbuf)-1 && *s2 != '\0'; len++) {
		nbuf[len] = *s2++;
		if (nbuf[len] == ' ' && *s2 == '[')
			break;
	}
	nbuf[len] = '\0';
	if (*s2 == '[') {
		s2++;
		for (tm=s2; *tm && *tm != ']'; tm++)
			/* no-op */ ;
		if (*tm == ']')
			*tm = '\0';
	} else
		s2 = NULL;

	hsp = hashedString(HIDELIST_SIZE, nbuf);
	addHiddenName(which, s1, s2, hsp);
	return;
}

/*
** Set table format according to specification.
*/
static void setTblfmt(char *const cp, char *const spec) {
	char *def = strsave(spec);

	if (!def)
		prmsg(2, GETMSG(304, "Not enough memory for table format specification?!?\n"));
	else if (streq(cp, "Month"))
		tblfmt[FMT_MON] = def;
	else if (streq(cp, "Day"))
		tblfmt[FMT_DAY] = def;
	else if (streq(cp, "Load"))
		tblfmt[FMT_LOAD] = def;
	else if (streq(cp, "Country"))
		tblfmt[FMT_CNTRY] = def;
	else if (streq(cp, "TopTen"))
		tblfmt[FMT_TOPTEN] = def;
	else if (streq(cp, "Overview"))
		tblfmt[FMT_OVIEW] = def;
	else if (streq(cp, "Lists"))
		tblfmt[FMT_LISTS] = def;
	else if (streq(cp, "NotFound"))
		tblfmt[FMT_NFOUND] = def;
	else {
		prmsg(1, GETMSG(171, "Invalid name in table format definition: `%s'\n"), cp);
		free(def);
	}
	return;
}

/*
** Check plausibility of font sizes.
*/
static u_short chkFontSize(char *const cp, char *const type, u_short const dval) {
	u_short sval = (u_short)strtol(cp, NULL, 10);

	if (!sval || sval > 5) {
		prmsg(1, GETMSG(387, "Invalid font size for `%s': %d ([1-5], "
				     "reverting to %d)\n"), type, sval, dval);
		return dval;
	}
	return sval;
}

/* check wheter value is or is not [Nn]o, [Ff]alse, 0 or Off */
#define IS_OFF(val)	(strchr("nNfF0", *(val)) || streq(val, "off"))
#define IS_ON(val)	(!strchr("nNfF0", *(val)) && !streq(val, "off"))

/*
** Read configuration file, set global variables.
*/
/* WARNING: the following macro evaluates it's argument more than once! */
#define SKIPWS(ptr)	while (*(ptr) == '\t' || *(ptr) == ' ') (ptr)++

static int readConfigFile(char *const filename, char *const init_cfg) {
	char missing[MEDIUMSIZE];
	char lbuf[LBUFSIZE]; 		/* line buffer */
	char *cp, *args[5];		/* entry from configuration file */
	size_t len, cnt;		/* line counter */
	FILE *cfp = fopen(filename, "r");

	if (cfp == NULL)
		return 0;

	missing[0] = '\0';
	(void) strncat(missing, GETMSG(388,
			"Missing third value field in `%s' entry for `%s'.\n"), sizeof(missing)-1);

	for (cnt=1; fgets(lbuf, sizeof lbuf, cfp) != NULL; cnt++) {
		len = strlen(lbuf)-1;
		if (lbuf[len] == '\n')
			lbuf[len] = '\0'; 	/* delete trailing newline */

		cp = lbuf;
		SKIPWS(cp);
		if (*cp == '#' || *cp == '\0')
			continue;		/* ignore empty and comment lines */

		/* split the line into arguments */
		if ((len = (size_t)getargs(lbuf, args, TABSIZE(args))) < 2 || len > 3) {
			prmsg(1, GETMSG(389, "Skip invalid entry in file `%s', line %d: %s\n"),
				filename, cnt, lbuf);
			continue;		/* skip invalid lines */
		}
		/* save value */
		if ((cp=strsave(args[1])) == NULL) {
			prmsg(2, GETMSG(390, "Too few memory for definitions from file `%s', line %d?!?\n"),
				filename, cnt);
			exit(1);
		}
		if (streq(args[0], "ServerName")) {
			if (!srv_name)
				srv_name = cp;
			else	free(cp);
		} else if (streq(args[0], "ServerURL")) {
			if (!srv_url)
				srv_url = cp;
			else	free(cp);
		} else if (streq(args[0], "DocRoot")) {
			if (!virt_root)
				virt_root = cp;
			else	free(cp);
		} else if (streq(args[0], "DefaultMode")) {
			if (monthly == -1)
				monthly = (*cp == 'd' || *cp == 'D') ? 0 : 1;
			free(cp);
		} else if (streq(args[0], "LogFile") || streq(args[0], "HTTPLogFile")) {
			if (!log_file)
				log_file = cp;
			else	free(cp);
		} else if (streq(args[0], "LogFormat") || streq(args[0], "HTTPLogFormat")) {
			if (!log_format)
				log_format = cp;
			else	free(cp);
		} else if (streq(args[0], "Session")) {
			if (!time_win)
				time_win = cp;
			else	free(cp);
		} else if (streq(args[0], "OutputDir") || streq(args[0], "HTMLDir")) {
			if (!out_dir)
				out_dir = cp;
			else	free(cp);
		} else if (streq(args[0], "PrivateDir")) {
			if (!priv_dir)
				priv_dir = cp;
			else	free(cp);
		} else if (streq(args[0], "TLDFile")) {
			if (!tld_file)
				tld_file = cp;
			else	free(cp);
		} else if (streq(args[0], "VRMLProlog")) {
			if (!vrml_prlg)
				vrml_prlg = cp;
			else	free(cp);
		} else if (streq(args[0], "AuthURL")) {
			sptab[SP_AUTHREQ].ison = IS_ON(cp);
			free(cp);
		} else if (streq(args[0], "StripCGI")) {
			nocgistrip = IS_OFF(cp);
			free(cp);
		} else if (streq(args[0], "BtnSymlink")) {
#if defined(NO_SYMLINK)
			prmsg(0, GETMSG(450,
				"Symlinks are not available on this platform, `BtnSymlink' ignored.\n"));
#else
			btn_symlink = IS_ON(cp);
#endif
			free(cp);
		} else if (streq(args[0], "MSIISmode")) {
			msiis_mode = IS_ON(cp);
			free(cp);
		} else if (streq(args[0], "3DWindow") || streq(args[0], "VRMLWindow")) {
			vrml_win = (*cp == 'i' || *cp == 'I') ? INT_WIN : EXT_WIN;
			free(cp);
		} else if (streq(args[0], "NavWinSize") || streq(args[0], "NavWindow")) {
			if (strchr("nNfF0", *cp))
				nonavpanel++;		/* don't create separate window */
			else if (sscanf(cp, "%d x %d", &navwid, &navht) != 2)
				navwid = navht = 0;	/* invalid */
			free(cp);
		} else if (streq(args[0], "3DWinSize") || streq(args[0], "VRMLWinSize")) {
			if (sscanf(cp, "%d x %d", &w3wid, &w3ht) != 2)
				w3wid = w3ht = 0;	/* invalid */
			free(cp);
		} else if (streq(args[0], "ReportTitle") || streq(args[0], "DocTitle")) {
			if (!doc_title)
				doc_title = cp;
			else	free(cp);
		} else if (streq(args[0], "HTMLPrefix") || streq(args[0], "HeadPrefix")) {
			html_str[HTML_HEADPFX] = cp;
			if (ISFULLPATH(cp) && !init_cfg) {
				html_str[HTML_HEADPFX] = readHTML(args[0], cp);
				free(cp);
			}
		} else if (streq(args[0], "HTMLSuffix") || streq(args[0], "HeadSuffix")) {
			html_str[HTML_HEADSFX] = cp;
			if (ISFULLPATH(cp) && !init_cfg) {
				html_str[HTML_HEADSFX] = readHTML(args[0], cp);
				free(cp);
			}
		} else if (streq(args[0], "HTMLTrailer") || streq(args[0], "DocTrailer")) {
			html_str[HTML_TRAILER] = cp;
			if (ISFULLPATH(cp) && !init_cfg) {
				html_str[HTML_TRAILER] = readHTML(args[0], cp);
				free(cp);
			}
		} else if (streq(args[0], "HTMLCharSet")) {
			if (!htmlcset)
				htmlcset = cp;
			else	free(cp);
		} else if (streq(args[0], "Language")) {
			if (!language)
				language = cp;
			else	free(cp);
		} else if (streq(args[0], "HeadSize")) {
			if ((font[FONT_HEAD].fsize = chkFontSize(cp, args[0], 3)) == 3)
				font[FONT_HEAD].fsize = 0;
			free(cp);
		} else if (streq(args[0], "TextSize")) {
			if ((font[FONT_TEXT].fsize = chkFontSize(cp, args[0], 2)) == 3)
				font[FONT_TEXT].fsize = 0;
			free(cp);
		} else if (streq(args[0], "SmallSize")) {
			if ((font[FONT_SMALL].fsize = chkFontSize(cp, args[0], 1)) == 3)
				font[FONT_SMALL].fsize = 0;
			free(cp);
		} else if (streq(args[0], "ListSize") || streq(args[0], "FontSize")) {
			if ((font[FONT_LISTS].fsize = chkFontSize(cp, args[0], 2)) == 3)
				font[FONT_LISTS].fsize = 0;
			free(cp);
		} else if (streq(args[0], "HeadFont")) {
			if (!streq(cp, "default"))
				font[FONT_HEAD].face = cp;
			else {
				font[FONT_HEAD].face = NULL;
				free(cp);
			}
		} else if (streq(args[0], "TextFont")) {
			if (!streq(cp, "default"))
				font[FONT_TEXT].face = font[FONT_SMALL].face = cp;
			else {
				font[FONT_TEXT].face = font[FONT_SMALL].face = NULL;
				free(cp);
			}
		} else if (streq(args[0], "ListFont")) {
			if (!streq(cp, "default"))
				font[FONT_LISTS].face = cp;
			else {
				font[FONT_LISTS].face = NULL;
				free(cp);
			}
		} else if (streq(args[0], "ShowDomain")) {
			if (show_domain == -1)
				show_domain = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "NavigFrame") || streq(args[0], "FrameSize")) {
			if (nav_frame == -1)
				nav_frame = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "IndexFiles") || streq(args[0], "HomePage")) {
			char *tm = strtok(cp, ", ");
			do {	/* name of additional index files */
				if (ipnum < TABSIZE(indexpg))
					indexpg[ipnum++].str = tm;
				else	prmsg(1, GETMSG(391, "Too many index filenames (max %u), ignore `%s'\n"),
						ipnum, tm);
			} while ((tm=strtok(NULL, ", ")) != NULL);
		} else if (streq(args[0], "PageView")) {
			char *tm = strtok(cp, ", ");
			do {	/* name of additional pageview suffixes */
				if (ptnum < TABSIZE(pvtab))
					pvtab[ptnum++].str = tm;
				else	prmsg(1, GETMSG(392, "Too many pageview items (max %u), ignore `%s'\n"),
						ptnum, tm);
			} while ((tm=strtok(NULL, ", ")) != NULL);
		} else if (streq(args[0], "VirtualNames")) {
			HSTRING *sref;
			char *tm = strtok(cp, ", ");
			do {
				if ((sref = validURL(tm, NULL)) == NULL) {
					if ((sref = validURL(tm, "https://")) != NULL)
						addSelfRefer(sref->str, sref->len);
					sref = validURL(tm, "http://");
				}
				if (sref)	/* may have changed meanwhile */
					addSelfRefer(sref->str, sref->len);
			} while ((tm=strtok(NULL, ", ")) != NULL);
		} else if (streq(args[0], "Suppress")) {
			char *tp = strtok(cp, ", ");
			do {
				size_t idx;
				for (idx=0; idx < SP_MAX; idx++)
					if (streq(cp, sptab[idx].subopt)) {
						sptab[idx].ison = 0;
						break;
					}

				if (idx == SP_MAX) {
					prmsg(1, GETMSG(393, "Invalid value (%s) for `%s' directive in line %d\n"),
						tp, args[0], cnt);
				}
			} while ((tp=strtok(NULL, ", ")) != NULL);
			free(cp);
		} else if (streq(args[0], "TopURLs")) {
			if (topn_urls == -1)
				topn_urls = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "LeastURLs") || streq(args[0], "LastURLs")) {
			if (lstn_urls == -1)
				lstn_urls = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopSites")) {
			if (topn_sites == -1)
				topn_sites = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopAgents")) {
			if (topn_agent == -1)
				topn_agent = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "NoiseLevel")) {
			if (noiselevel == -1)
				noiselevel = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopRefers")) {
			if (topn_refer == -1)
				topn_refer = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopDays")) {
			if (topn_day == -1)
				topn_day = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopHours")) {
			if (topn_hrs == -1)
				topn_hrs = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopMinutes")) {
			if (topn_min == -1)
				topn_min = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "TopSeconds")) {
			if (topn_sec == -1)
				topn_sec = (int)strtol(cp, NULL, 10);
			free(cp);
		} else if (streq(args[0], "RegInfo")) {
			if (args[2] == NULL)
				prmsg(1, missing, args[0], args[1]);
			else	lic = getRegID(NULL, cp, args[2]);
			free(cp);
		} else if (streq(args[0], "TblFormat")) {
			if (args[2] == NULL)
				prmsg(1, missing, args[0], args[1]);
			else	setTblfmt(cp, args[2]);
			free(cp);
		} else if (strneq(args[0], "CustLogo", 8)) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else if (args[0][8] == 'W') {	/* add customer's logos */
				buttons[BTN_CUSTOMW].name = cp;
				buttons[BTN_CUSTOMW].text = strsave(args[2]);
			} else {
				buttons[BTN_CUSTOMB].name = cp;
				buttons[BTN_CUSTOMB].text = strsave(args[2]);
			}
		} else if (streq(args[0], "HideURL")) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else if (*cp != '*' && *cp != '/') { /* wrong syntax, skip */
				prmsg(1, GETMSG(394, "%s value in line %d (%s) must start "
					 "with either a '/' or '*'.\n"), args[0], cnt, cp);
				free(cp);
			} else	 	/* append to list of hidden URLs */
				hideArgs(HIDDEN_ITEMS, cp, args[2]);
		} else if (streq(args[0], "HideSys")) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else		/* append to list of hidden sites */
				hideArgs(HIDDEN_SITES, cp, args[2]);
		} else if (streq(args[0], "HideAgent") || streq(args[0], "AddAgent")) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else		/* append to list of user agents */
				hideArgs(HIDDEN_AGENTS, cp, args[2]);
		} else if (streq(args[0], "HideRefer") || streq(args[0], "AddRefer")) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else		/* append to list of referrers */
				hideArgs(HIDDEN_REFERS, cp, args[2]);
		} else if (strneq(args[0], "AddDom", 6)) {
			if (args[2] == NULL) {
				prmsg(1, missing, args[0], args[1]);
				free(cp);
			} else		/* append to list of countries */
				addTLD(cp, args[2]);
		} else if (streq(args[0], "IgnURL")) {	/* append to list of ignored items */
			char *tm = strtok(cp, ", ");
			do {
				addIgnoredItem(IGNORED_ITEMS, tm);
			} while ((tm=strtok(NULL, ", ")) != NULL);
		} else if (streq(args[0], "IgnSys")) {	/* append to list of ignored sites */
			char *tm = strtok(cp, ", ");
			do {
				addIgnoredItem(IGNORED_SITES, tm);
			} while ((tm=strtok(NULL, ", ")) != NULL);
		} else {			/* skip invalid lines */
			prmsg(1, GETMSG(389, "Skip invalid entry in file `%s', line %d: %s\n"),
				filename, cnt, lbuf);
			free(cp);
		}
	}
	(void) fclose(cfp);
	return 1;
}
#undef SKIPWS

/*
** Write configuration file, fill in variables.
*/
static int writeConfigFile(char *const filename, char *const locale) {
	size_t idx, fnd;
	FILE *cfp;

	if (*filename == '-')
		cfp = stdout;
	else if ((cfp = fopen(filename, "w")) == NULL) {
		prmsg(2, GETMSG(734, "Can't create configuration file `%s' (%s)\n"),
				filename, strerror(errno));
		return 1;
	}

	(void) fprintf(cfp, GETMSG(736, "#\n"
		"# Configuration file for http-analyze\n"
		"# Generated by %s at %s\n"), creator, last_update);

	(void) fputs(GETMSG(737, "#\n"
		"# Entries are separated by one or more tabulators.\n"
		"# The first field is the directive (case-insensitive).\n"
		"# The second and an optional third field contain the\n"
		"# string, numerical or boolean values. Most definitions\n"
		"# here may be overwritten by command line options.\n"), cfp);

	(void) fputs(GETMSG(738, "\n"
		"# Registration ID (all versions)\n"
		"#RegInfo\tPersonal Edition\tRegistration-ID\n\n"
		"# Customer logos (commercial version only)\n"
		"# One (W) for use on white background, one (B) for black background.\n"
		"# Second field is name of logo, third is URL to link to.\n"), cfp);
	(void) fputs(
		"#CustLogoW\tbtn/RAG_sw" IMG_SFX "\t\thttp://www.rent-a-guru.de/\n"
		"#CustLogoB\tbtn/RAG_sb" IMG_SFX "\t\thttp://www.rent-a-guru.de/\n", cfp);

	(void) fputs(GETMSG(739, "\n"
		"# The name of your server (defaults to the local hostname).\n"
		"# Must be a full qualified domain name (FQDN) here, not an URL.\n"), cfp);
	if (!srv_name)
		(void) fputs("#ServerName\twww.mycompany.com\n", cfp);
	else	(void) fprintf(cfp, "ServerName\t%s\n", srv_name);

	(void) fputs(GETMSG(740, "\n"
		"# The prefix to use in URLs for hotlinks. Needed only if the\n"
		"# statistics report is hosted on another server than the pages\n"
		"# listed in the report. If the protocol specifier is not given,\n"
		"# 'http' is assumed. Trailing slashes are removed.\n"), cfp);
	if (!srv_url)
		(void) fputs("#ServerURL\thttp://www.mycompany.com\n", cfp);
	else	(void) fprintf(cfp, "ServerURL\t%s\n", srv_url);

	(void) fputs(GETMSG(741, "\n"
		"# Other (virtual) names for this host. If no protocol specifier\n"
		"# (http, https) is specified explicitely, http-analyze creates\n"
		"# two entries per name, one with the `http' and another one with\n"
		"# the `https' protocol specifier. Either the ServerURL or the\n"
		"# ServerName is added automatically to this list, whichever\n"
		"# is defined. No additional protocols are added for the latter\n"
		"# two except the 'http' default. Trailing slashes are removed.\n"), cfp);
	if (!ref_urls || refn_urls < 2)
		(void) fputs("\n#VirtualNames\thttps://www.mycompany.com\n"
			     "#VirtualNames\thttp://www.customer.com,http://customer.com\n", cfp);
	else {
		(void) fputc('#', cfp);
		for (idx=0; idx < refn_urls-1; idx++)
			if ((idx%2) == 0)
				(void) fprintf(cfp, "\nVirtualNames\t%s", ref_urls[idx].str);
			else	(void) fprintf(cfp, ",%s", ref_urls[idx].str);
		(void) fputc('\n', cfp);
	}
	(void) fputs(GETMSG(742, "\n"
		"# The name of a virtual server document root. If defined,\n"
		"# http-analyze restricts analysis to the given document root.\n"
		"# If the name is prefixed by a `!', analysis takes place for\n"
		"# all directories except this subdirctory.  If docroot does\n"
		"# not start with a slash ('/'), it is interpreted as the name\n"
		"# of a virtual server, which is matched against the (normally\n"
		"# unused) second field of a logfile entry.  Intented for use\n"
		"# with (software-) virtual servers with a separate Document\n"
		"# Root or for which the hostname is recorded in the second\n"
		"# field of a logfile entry.\n"), cfp);
	if (!virt_root)
		(void) fputs("#DocRoot\t/~customer/\n"
			     "#DocRoot\twww.customer.com\n", cfp);
	else	(void) fprintf(cfp, "DocRoot\t%s\n", virt_root);

	(void) fputs(GETMSG(743, "\n"
		"# The name of the default logfile to be used if none given\n"
		"# at invocation of http-analyze.\n"), cfp);
	if (!log_file)
		(void) fputs("#LogFile\t/usr/ns-home/www.foo.com/logs/access\n", cfp);
	else	(void) fprintf(cfp, "LogFile\t%s\n", log_file);

	(void) fputs(GETMSG(744, "\n"
		"# The format of the logfile:\n"
		"#\tauto\tAutomatically determine format (default)\n"
		"#\tclf\tCommon Logfile Format (CLF)\n"
		"#\tdlf\tCombined Logfile Format (CLF + Referrer + UserAgent)\n"
		"#\telf\tExtended Logfile Format (CLF + UserAgent + Referrer)\n"), cfp);
	if (!log_format)
		(void) fputs("#LogFormat\tauto\n", cfp);
	else	(void) fprintf(cfp, "LogFormat\t%s\n", log_format);

	(void) fputs(GETMSG(745, "\n"
		"# The default mode of operation now is full statistics (\"monthly\") mode.\n"
		"#DefaultMode\tmonthly\n\n"
		"# The name of the directory where the output files of the statistics\n"
		"# report are to be created.\n"), cfp);
	if (!out_dir)
		(void) fputs("#OutputDir\t/usr/www/stats\n", cfp);
	else	(void) fprintf(cfp, "OutputDir\t%s\n", out_dir);

#if !defined(NO_SYMLINK)
	(void) fputs(GETMSG(784, "\n"
		"# Use symlinks for the required files and buttons if missing.\n"
		"# Requires installation of all files/buttons in HA_LIBDIR.\n"), cfp);
	if (!btn_symlink)
		(void) fputs("#BtnSymlink\tNo\n", cfp);
	else	(void) fputs("BtnSymlink\tYes\n", cfp);
#endif

	(void) fputs(GETMSG(746, "\n"
		"# Multi-language support.\n"
		"# To use a language for every message, define the 'LANG' or the\n"
		"# 'LC_MESSAGES' environment variable before invoking http-analyze.\n#\n"
		"# The 'Language' directive can be used to provide statistics\n"
		"# in other languages, e.g. for customers of an ISP. If set, it\n"
		"# will change the language every message is displayed in after\n"
		"# the settings from the configuration file have been loaded.\n#\n"
		"# HTMLCharSet defines the Content-Encoding to use for the files\n"
		"# of the statistics report. This may be necessary if the selected\n"
		"# language requires another char set than the browser's default\n"
		"# (usually iso-8859-1/latin1). If left undefined, the default is\n"
		"# 'iso-8859-1', which includes 'us-ascii' as a subset.\n#\n"
		"# Here are some suggestions for Language (Locale) and\n"
		"# HTMLCharSet (Encoding) values:\n"), cfp);
	(void) fputs(GETMSG(747, "#\n"
		"#  Country\t\tLocale\tEncoding\n"
		"#  --------------------------------------------------------\n"
		"#  Standard C\t\tC\tus-ascii\n"
		"#  Arabic Countries\tar\tiso-8859-6\n"
		"#  Belarus\t\tbe\tiso-8859-5\n"
		"#  Bulgaria\t\tbg\tiso-8859-5\n"
		"#  Czech Republic\tcs\tiso-8859-2\n"
		"#  Denmark\t\tda\tiso-8859-1\n"
		"#  Germany\t\tde\tiso-8859-1\n"
		"#  Greece\t\tel\tiso-8859-7\n"
		"#  Great Britain\ten\tiso-8859-1\n"
		"#  United States\ten_US\tiso-8859-1\n"
		"#  Spain\t\tes\tiso-8859-1\n"
		"#  Mexico\t\tes_MX\tiso-8859-1\n"
		"#  Finland\t\tfi\tiso-8859-1\n"), cfp);
	(void) fputs(GETMSG(748,
		"#  France\t\tfr\tiso-8859-1\n"
		"#  Belgium\t\tfr_BE\tiso-8859-1\n"
		"#  Canada\t\tfr_CA\tiso-8859-1\n"
		"#  Switzerland\t\tfr_CH\tiso-8859-1\n"
		"#  Croatia\t\thr\tiso-8859-2\n"
		"#  Hungary\t\thu\tiso-8859-2\n"
		"#  Iceland\t\tis\tiso-8859-1\n"
		"#  Italy\t\tit\tiso-8859-1\n"
		"#  Israel\t\tiw\tiso-8859-8\n"
		"#  Japan\t\tja\tShift_JIS or iso-2022-jp\n"
		"#  Korea\t\tko\tEUC-kr or iso-2022-kr\n"), cfp);
	(void) fputs(GETMSG(749,
		"#  Netherlands\t\tnl\tiso-8859-1\n"
		"#  Belgium\t\tnl_BE\tiso-8859-1\n"
		"#  Norway\t\tno\tiso-8859-1\n"
		"#  Poland\t\tpl\tiso-8859-2\n"
		"#  Portugal\t\tpt\tiso-8859-1\n"
		"#  Brazil\t\tpt_BR\tiso-8859-1\n"
		"#  Romania\t\tro\tiso-8859-2\n"
		"#  Russia\t\tru\tKOI8-R or iso-8859-5\n"
		"#  Sweden\t\tsv\tiso-8859-1\n"
		"#  Turkey\t\ttr\tiso-8859-9\n"
		"#  Chinese\t\tzh\tbig5\n"
		"#  --------------------------------------------------------\n#\n"), cfp);
	if (language)		/* active language */
		(void) fprintf(cfp, "Language\t%s\n", language);
	else if (locale)	/* inactive locale */
		(void) fprintf(cfp, "#Language\t%s\n", locale);
	else	(void) fputs("#Language\tC\n", cfp);
	if (!htmlcset)
		(void) fputs("#HTMLCharSet\tiso-8859-1\n", cfp);
	else	(void) fprintf(cfp, "HTMLCharSet\t%s\n", htmlcset);

	(void) fputs(GETMSG(750, "\n"
		"# The name of a private directory where detailed lists are to be placed.\n"
		"# Must be a subdirectory of OutputDir and may contain no slashes. Note\n"
		"# that you have to set up server authentication if you want to protect\n"
		"# those lists. http-analyze just creates the detailed list of URLs, sites,\n"
		"# agents and referrers in this subdirectory. See the online documentation\n"
		"# for an example.\n"), cfp);
	if (!priv_dir)
		(void) fputs("#PrivateDir\tlists\n", cfp);
	else	(void) fprintf(cfp, "PrivateDir\t%s\n", priv_dir);

	(void) fputs(GETMSG(751, "\n"
		"# Alternate names for directory index files other than \"index.html\".\n"
		"# Note: The leading slash is important!\n"), cfp);
	if (ipnum < 2)
		(void) fputs("#IndexFiles\t/Welcome.html,/home.html\n", cfp);
	else	for (idx=1; idx < ipnum; idx++)
			(void) fprintf(cfp, "IndexFiles\t%s\n", indexpg[idx].str);

	(void) fputs(GETMSG(752, "\n"
		"# Skip all URLs which required authentication. By default, such URLs\n"
		"# are handled just like all other URLs. Setting AuthURL to Off, No,\n"
		"# None, False, or 0 causes the analyzer to skip those private URLs\n"
		"# in the logfile.\n"), cfp);
	(void) fprintf(cfp, "%sAuthURL\tNo\n", sptab[SP_AUTHREQ].ison ? "#" : "");

	(void) fputs(GETMSG(753, "\n"
		"# Remove arguments from CGI-URLs in the overview and detailed lists\n"
		"# (default: true). Can be set to Off, No, None, False, 0 to have CGI-\n"
		"# URLs with different arguments listed separately in the report. Note\n"
		"# that arguments to a CGI-script are recorded in the logfile only for\n"
		"# scripts using the GET method for passing parameters.\n"), cfp);
	(void) fprintf(cfp, "%sStripCGI\tNo\n", nocgistrip ? "" : "#");

	(void) fputs(GETMSG(754, "\n"
		"# Definitions for Pageviews: If the value starts with a slash (/),\n"
		"# it defines the prefix of an URL which is counted as s pageview\n"
		"# if hit. If it does not start with a slash, it defines the suffix\n"
		"# of such an URL. In the latter case, the analyzer prepends a dot\n"
		"# to the suffix automatically for backward compatibility. Use this\n"
		"# directive to specify alternate suffixes for text files other than\n"
		"# \".html\" (which is added automatically) and to specify prefixes\n"
		"# of documents generated by CGI scripts (for example: /cgi-bin/).\n"), cfp);
	if (ptnum < 2)
		(void) fputs("#PageView\t.shtml,.text,.htm,/cgi-bin/\n", cfp);
	else {
		(void) fputs("PageView\t", cfp);
		for (idx=1; idx < ptnum; idx++)
			(void) fprintf(cfp, "%s%s",
				pvtab[idx].str, idx == ptnum-1 ? "\n" : ",");
	}

	(void) fputs(GETMSG(755, "\n"
		"# Time-window for accounting user sessions (default: 24 hours).\n"
		"# Use t[icks], s[econds], m[inutes], h[ours] or d[ays] after\n"
		"# the number as a scaling unit.\n"), cfp);
	if (!time_win)
		(void) fputs("#Session\t30 Minutes\n", cfp);
	else	(void) fprintf(cfp, "Session\t%s\n", time_win);

	(void) fputs(GETMSG(756, "\n"
		"# Level of subdomains in hostnames to use in the Top N sites list as an\n"
		"# item, under which all hostnames from this domain are lumped together.\n"
		"# Valid range: 1-5, Default: 2\n"), cfp);
	(void) fprintf(cfp, "%sShowDomain\t%d\n",
		show_domain == 2 ? "#" : "", show_domain);

	(void) fputs(GETMSG(757, "\n"
		"# Noise level: suppress details about all items with hits below\n"
		"# this level in order to keep the size of reports manageable.\n"), cfp);
	if (!noiselevel)
		(void) fputs("#NoiseLevel\t7\n", cfp);
	else	(void) fprintf(cfp, "NoiseLevel\t%d\n", noiselevel);

	(void) fputs(GETMSG(758, "\n# The title to display in the statistics reports.\n"), cfp);
	(void) fprintf(cfp, "ReportTitle\t%s\n", doc_title);

	(void) fputs(GETMSG(759, "\n"
		"# The name of a file containing all valid domains.\n"
		"# You may add top-level domains with up to 6 characters\n"
		"# in length. See the included file TLD for an example.\n"
		"# Not needed usually unless you want change the built-in\n"
		"# list of country names. If TLDFile is set to `none', no\n"
		"# country list is produced in the summary.\n"), cfp);
	if (!tld_file)
		(void) fputs("#TLDFile\t/usr/local/lib/http-analyze/TLD\n"
			     "#TLDFile\tnone\n", cfp);
	else	(void) fprintf(cfp, "TLDFile\t%s\n", tld_file);

	(void) fputs(GETMSG(760, "\n"
		"# The name of the VRML prolog file for yearly models.\n"
		"# For use on graphic workstations only!\n"), cfp);
	if (!vrml_prlg)
		(void) fputs("#VRMLProlog\t3Dprolog.wrl\n", cfp);
	else	(void) fprintf(cfp, "VRMLProlog\t%s\n", vrml_prlg);

	(void) fputs(GETMSG(761, "\n"
		"# Font faces and sizes. HeadFont and HeadSize are used for headers,\n"
		"# while TextFont and TextSize are used for normal text. ListSize (the\n"
		"# former FontSize directive) is the size of the preformatted text in\n"
		"# the detailed lists. SmallSize is the size used for small text like\n"
		"# percentages following the actual numbers, etc.\n#\n"
		"# Valid values for the font face directives are name lists of browser\n"
		"# fonts or the keyword \"default\" to use the browser's standard font.\n"), cfp);
	if (!font[FONT_HEAD].face || strcmp(font[FONT_HEAD].face, deffont) == 0)
		(void) fprintf(cfp, "#HeadFont\t%s\n", deffont);
	else	(void) fprintf(cfp, "HeadFont\t%s\n", font[FONT_HEAD].face);
	if (!font[FONT_TEXT].face || strcmp(font[FONT_TEXT].face, deffont) == 0)
		(void) fprintf(cfp, "#TextFont\t%s\n", deffont);
	else	(void) fprintf(cfp, "TextFont\t%s\n", font[FONT_TEXT].face);
	if (!font[FONT_LISTS].face)
		(void) fputs("#ListFont\tmonospaced\n\n", cfp);
	else	(void) fprintf(cfp, "ListFont\t%s\n\n", font[FONT_LISTS].face);

	if (!font[FONT_HEAD].fsize || font[FONT_HEAD].fsize == 3)
		(void) fputs("#HeadSize\t3\n", cfp);
	else	(void) fprintf(cfp, "HeadSize\t%d\n", font[FONT_HEAD].fsize);
	if (!font[FONT_TEXT].fsize || font[FONT_TEXT].fsize == 2)
		(void) fputs("#TextSize\t2\n", cfp);
	else	(void) fprintf(cfp, "TextSize\t%d\n", font[FONT_TEXT].fsize);
	if (!font[FONT_LISTS].fsize || font[FONT_LISTS].fsize == 2)
		(void) fputs("#ListSize\t2\n", cfp);
	else	(void) fprintf(cfp, "ListSize\t%d\n", font[FONT_LISTS].fsize);
	if (!font[FONT_SMALL].fsize || font[FONT_SMALL].fsize == 1)
		(void) fputs("#SmallSize\t1\n", cfp);
	else	(void) fprintf(cfp, "SmallSize\t%d\n", font[FONT_SMALL].fsize);

	(void) fputs(GETMSG(764, "\n"
		"# The Prefix to output after the header section (if defined, it must\n"
		"# include the <BODY> tag). If the string starts with a slash, it is\n"
		"# taken as the name of a file containing the HTML code.\n"), cfp);
	if (!html_str[HTML_HEADPFX])
		(void) fputs("#HTMLPrefix\t<BODY BGCOLOR=\"#FFFFFF\">\n"
			     "#HTMLPrefix\t/usr/www/lib/header.templ\n", cfp);
	else	(void) fprintf(cfp, "HTMLPrefix\t%s\n", html_str[HTML_HEADPFX]);

	(void) fputs(GETMSG(765, "\n"
		"# The Trailer to output at the end of a page, immediately before the\n"
		"# copyright note. If the string starts with a slash, it is taken as\n"
		"# the name of a file containing the HTML code.\n"), cfp);
	if (!html_str[HTML_TRAILER])
		(void) fputs("#HTMLTrailer\t<A HREF=\"/staff/\">Back</A> to the internal server\n"
			     "#HTMLTrailer\t/usr/www/lib/trailer.templ\n", cfp);
	else	(void) fprintf(cfp, "HTMLTrailer\t%s\n", html_str[HTML_TRAILER]);

	(void) fputs(GETMSG(766, "\n# Suppress certain parts of the summary.\n"), cfp);
	(void) fputs( "#Suppress\tURLs,URLList,Code404,Sites,RSites,SiteList,Agents,Referrer\n"
		"#Suppress\tAVLoad,Country,AuthReq,Pageviews,Graphics,Hotlinks,Interpol\n", cfp);

	if (!sptab[SP_URLS].ison || !sptab[SP_URLLIST].ison || !sptab[SP_CODE404].ison ||
	    !sptab[SP_SITES].ison || !sptab[SP_RSITES].ison || !sptab[SP_SITELIST].ison ||
	    !sptab[SP_AGENTS].ison || !sptab[SP_REFERRER].ison) {
		fnd = 0;
		(void) fputs("Suppress", cfp);
		for (idx=SP_URLS; idx < SP_AVLOAD; idx++)
			if (!sptab[idx].ison) {
				(void) fprintf(cfp, "%c%s", !fnd ? '\t' : ',', sptab[idx].subopt);
				fnd++;
			}
		(void) fputc('\n', cfp);
	}
	if (!sptab[SP_AVLOAD].ison || !sptab[SP_COUNTRY].ison || !sptab[SP_PAGEVIEWS].ison ||
	    !sptab[SP_GRAPHICS].ison || !sptab[SP_HOTLINKS].ison || !sptab[SP_INTERPOL].ison) {
		fnd = 0;
		(void) fputs("Suppress", cfp);
		for (idx=SP_AVLOAD; idx < SP_MAX; idx++)
			if (idx != SP_AUTHREQ && !sptab[idx].ison) {
				(void) fprintf(cfp, "%c%s", !fnd ? '\t' : ',', sptab[idx].subopt);
				fnd++;
			}
		(void) fputc('\n', cfp);
	}

	(void) fputs(GETMSG(767, "\n"
		"# The number of URLs, sites, agents and referrers in the \"top N\" lists.\n"
		"# If set to zero, the appropriate parts of the summary will be supressed.\n"), cfp);
	(void) fprintf(cfp,
		"%sTopURLs\t%d\n"	"%sLeastURLs\t%d\n"	"%sTopSites\t%d\n"
		"%sTopAgents\t%d\n"	"%sTopRefers\t%d\n"	"%sTopDays\t%d\n"
		"%sTopHours\t%d\n"	"%sTopMinutes\t%d\n"	"%sTopSeconds\t%d\n",
		topn_urls == 30 ? "#" : "", topn_urls,
		lstn_urls == 10 ? "#" : "", lstn_urls,
		topn_sites == 30 ? "#" : "", topn_sites,
		topn_agent == 30 ? "#" : "", topn_agent,
		topn_refer == 30 ? "#" : "", topn_refer,
		topn_day == 7 ? "#" : "", topn_day,
		topn_hrs == 24 ? "#" : "", topn_hrs,
		topn_min == 5 ? "#" : "", topn_min,
		topn_sec == 5 ? "#" : "", topn_sec);

	(void) fputs(GETMSG(768, "\n"
		"# TblFormat defines the layout of the tables in the report.\n"
		"# The syntax is:\n"
		"#   TblFormat\ttblname\t\tspecifier\n"
		"#\n# where `tblname'\tstands for the\n"
		"#\tMonth\t\tstatistics of the last 12 months (main page)\n"
		"#\tDay\t\tdaily stats in short & full summaries\n"
		"#\tLoad\t\taverage load by weekday, hour, minute, second\n"
		"#\tCountry\t\tCountry list\n"
		"#\tTopTen\t\tall Top N lists\n"
		"#\tOverview\tall overviews\n"
		"#\tLists\t\tall detailed lists (preformatted text)\n"
		"#\tNotFound\tlist of NotFound responses\n"), cfp);
	(void) fputs(GETMSG(769, "#\n"
		"# and `specifier' is a list of the following characters:\n#\n"
		"#\tn\tAn index number/label (don't remove!)\n"
		"#\th\tThe number of hits (any request)\n"
		"#\tf\tThe number of files sent (Code 200 OK)\n"
		"#\tc\tThe number of files saved by cache (Code 304 Not Modified)\n"
		"#\tp\tThe number of pageviews\n"
		"#\ts\tThe number of user sessions\n"
		"#\tk\tThe data sent in KBytes (integer representation)\n"
		"#\tB\tThe data sent in Bytes (float representation)\n"
		"#\tL\tA changing label (don't remove!)\n#\n"
		"# This are the built-in table formats:\n"), cfp);
	(void) fprintf(cfp, "#TblFormat\tMonth\t\t%s\n", tblfmt[FMT_MON]);
	(void) fprintf(cfp, "#TblFormat\tDay\t\t%s\n", tblfmt[FMT_DAY]);
	(void) fprintf(cfp, "#TblFormat\tLoad\t\t%s\n", tblfmt[FMT_LOAD]);
	(void) fprintf(cfp, "#TblFormat\tCountry\t\t%s\n", tblfmt[FMT_CNTRY]);
	(void) fprintf(cfp, "#TblFormat\tTopTen\t\t%s\n", tblfmt[FMT_TOPTEN]);
	(void) fprintf(cfp, "#TblFormat\tOverview\t%s\n", tblfmt[FMT_OVIEW]);
	(void) fprintf(cfp, "#TblFormat\tLists\t\t%s\n", tblfmt[FMT_LISTS]);
	(void) fprintf(cfp, "#TblFormat\tNotFound\t%s\n", tblfmt[FMT_NFOUND]);

	(void) fputs(GETMSG(770, "\n# The size of the navigation frame in pixels.\n"), cfp);
	(void) fprintf(cfp, "%sNavigFrame\t%d\n",
		nav_frame == 124 ? "#" : "", nav_frame);

	(void) fputs(GETMSG(771, "\n"
		"# The type of the 3D window:\n"
		"# extern (new window) or intern (inside frame).\n"), cfp);
	if (!vrml_win)
		(void) fputs("#3DWindow\textern\n", cfp);
	else	(void) fprintf(cfp, "3DWindow\t%s\n", vrml_win == EXT_WIN ? "extern" : "intern");

	(void) fputs(GETMSG(772,
		"\n# The size of the 3D window in pixels (width x height).\n"), cfp);
	(void) fprintf(cfp, "%s3DWinSize\t%dx%d\n",
		w3wid == 520 && w3ht == 420 ? "#" : "", w3wid, w3ht);

	(void) fputs(GETMSG(773, "\n"
		"# The size of the navigation window in pixels (width x height).\n"), cfp);
	(void) fprintf(cfp, "%sNavWinSize\t%dx%d\n",
		navwid == 420 && navht == 190 ? "#" : "", navwid, navht);

	(void) fputs(GETMSG(774, "\n"
		"# MSIISMode: Use case-insensitive comparison for URLs. Needed for MS IIS\n"
		"# which makes no difference between upper- and lower-case characters.\n"
		"# MS users may regard this as an enhancement, while for the rest of\n"
		"# the world this is just a violation of RFC 2068 and should be ignored.\n"), cfp);
	if (!msiis_mode)
		(void) fputs("#MSIISMode\tNo\n", cfp);
	else	(void) fputs("MSIISMode\tYes\n", cfp);

	(void) fputs(GETMSG(775, "\n#\n"
		"# List of sites and URLs to ignore or hide.\n"
		"# Format:\n"
		"#\tIgnSys <tab> HOST\n"
		"#\tIgnURL <tab> URL\n"
		"#\tHideSys <tab> HOST <tab> DESC [TLD]\n"
		"#\tHideURL <tab> URL <tab> DESC\n#\n"
		"#\tURL is the file's URL relative to the Document Root of the server\n"
		"#\tHOST is a full qualified domain name\n"
		"#\tDESC is the new category this item is hidden under\n"), cfp);
	(void) fputs(GETMSG(776, "#\n"
		"# The URL/hostname may either begin or end with a `*'\n"
		"# wildcard. There is only one wildcard allowed. The `*'\n"
		"# must be the first or very last character of the string.\n"
		"# Inside the string, a `*' is taken literal.\n#\n"
		"# If an URL doesn't start with a `*', it's first character\n"
		"# must be a slash (`/').\n"
		"# If DESC begins with the character `[', the item is not\n"
		"# shown in any of the \"Top Ten\" lists.\n"), cfp);

	(void) fputs(GETMSG(777, "\n"
		"# Ignore this hostnames. Increases processing time by a\n"
		"# significant amount, so keep this list small or don't\n"
		"# use it at all if speed is a concern.\n"), cfp);
	if (!hidden[IGNORED_SITES].t_count)
		(void) fputs("#IgnSys\t*.foo.com\n", cfp);
	else for (idx=0; idx < hidden[IGNORED_SITES].t_count; idx++)
		(void) fprintf(cfp, "IgnSys\t%s\n", hidden[IGNORED_SITES].tab[idx].pfx);

	(void) fputs(GETMSG(778, "\n"
		"# Ignore this URLs. Increases processing time by a\n"
		"# significant amount, so keep this list small or don't\n"
		"# use it at all if speed is a concern.\n"), cfp);
	if (!hidden[IGNORED_ITEMS].t_count)
		(void) fputs("#IgnURL\t*.gif,*.png,*.tif,*.tiff,*.jpg,*.jpeg\n", cfp);
	else {
		for (idx=0; idx < hidden[IGNORED_ITEMS].t_count; idx++)
			if ((idx%4) == 0)
				(void) fprintf(cfp, "\nIgnURL\t%s", hidden[IGNORED_ITEMS].tab[idx].pfx);
			else	(void) fprintf(cfp, ",%s", hidden[IGNORED_ITEMS].tab[idx].pfx);
		(void) fputc('\n', cfp);
	}

	(void) fputs(GETMSG(779, "\n"
		"# Hide this hostnames. May be used to map local IP numbers\n"
		"# to hostnames. See the online documentation for examples.\n"), cfp);
	if (!hidden[HIDDEN_SITES].t_count)
		(void) fputs(
			"#HideSys\t*.myname.com\t\tMYCOMPANY\n"
			"#HideSys\t192.168.1.*\t\tUNRESOLVED.IP [COM]\n"
			"#HideSys\tlocal.host\t\tLOCAL.NETWORK [COM]\n", cfp);
	else for (idx=0; idx < hidden[HIDDEN_SITES].t_count; idx++) {
		(void) fprintf(cfp, "HideSys\t%s\t%s",
			hidden[HIDDEN_SITES].tab[idx].pfx,
			hidden[HIDDEN_SITES].tab[idx].col->str);
		if (hidden[HIDDEN_SITES].tab[idx].sref)
			(void) fprintf(cfp, " [%s]\n", hidden[HIDDEN_SITES].tab[idx].sref);
		else	(void) fputc('\n', cfp);
	}

	(void) fputs(GETMSG(780, "\n"
		"# Hide this URLs.\n"
		"# Square brackets around the item means to suppress\n"
		"# the item from the Top N lists.\n"), cfp);
	if (!hidden[HIDDEN_ITEMS].t_count)
		(void) fputs(
			"#HideURL\t*.map\t\t\t[All image maps]\n"
			"#HideURL\t*.class\t\t\t[All java applets]\n"
			"#HideURL\t/robots.txt\t\t[Robot control file]\n"
			"#HideURL\t/content.html\t\tFoo Table of Content\n"
			"#HideURL\t/help.html\t\tFoo Help\n"
			"#HideURL\t/news/*\t\t\tFoo News\n"
			"#HideURL\t/stats/*\t\tFoo Access Statistics\n"
			"#HideURL\t/cgi-bin/*\t\tCGI scripts\n", cfp);
	else for (idx=0; idx < hidden[HIDDEN_ITEMS].t_count; idx++)
		if (hidden[HIDDEN_ITEMS].tab[idx].sref)
			(void) fprintf(cfp, "HideURL\t%s\t%s [%s]\n",
				hidden[HIDDEN_ITEMS].tab[idx].pfx,
				hidden[HIDDEN_ITEMS].tab[idx].col->str,
				hidden[HIDDEN_ITEMS].tab[idx].sref);
		else
			(void) fprintf(cfp, "HideURL\t%s\t%s\n",
				hidden[HIDDEN_ITEMS].tab[idx].pfx,
				hidden[HIDDEN_ITEMS].tab[idx].col->str);

	(void) fputs(GETMSG(781, "\n"
		"# Browser types to be added to the browser list.\n"
		"# Needed for a certain browser type whose vendor\n"
		"# still can't spell it's name correctly.\n"), cfp);
	if (!hidden[HIDDEN_AGENTS].t_count)
		(void) fputs(
			"HideAgent\tMozilla/4.0 (compatible; MSIE 5.\tMSIE 5.*\n"
			"HideAgent\tMozilla/4.0 (compatible; MSIE 4.\tMSIE 4.*\n"
			"HideAgent\tMozilla/3.0 (compatible; MSIE 4.\tMSIE 4.*\n"
			"HideAgent\tMozilla/3.0 (compatible; MSIE 3.\tMSIE 3.*\n"
			"HideAgent\tMozilla/2.0 (compatible;\t\tMSIE 2.*\n", cfp);
	else for (idx=0; idx < hidden[HIDDEN_AGENTS].t_count; idx++)
		(void) fprintf(cfp, "HideAgent\t%s\t%s\n",
			hidden[HIDDEN_AGENTS].tab[idx].pfx,
			hidden[HIDDEN_AGENTS].tab[idx].col->str);

	(void) fputs(GETMSG(782, "\n"
		"# Referrers to be added to the referrer list. If a string in\n"
		"# square brackets is given, this is the CGI parameter which\n"
		"# specifies the search key for search engines.\n"), cfp);
	if (!hidden[HIDDEN_REFERS].t_count)
		(void) fputs(
			"HideRefer\thttp://www.yahoo.com/\t\t\tYahoo\n"
			"HideRefer\thttp://av.yahoo.com/\t\t\tYahoo [p=]\n"
			"HideRefer\thttp://search.yahoo.com/\t\tYahoo [p=]\n"
			"HideRefer\thttp://www.altavista.digital.com/\tAltaVista [q=]\n"
			"HideRefer\thttp://ie4.altavista.digital.com/\tAltaVista [q=]\n"
			"HideRefer\thttp://altavista.digital.com/\t\tAltaVista [q=]\n", cfp);
	else for (idx=0; idx < hidden[HIDDEN_REFERS].t_count; idx++) {
		(void) fprintf(cfp, "HideRefer\t%s\t%s",
			hidden[HIDDEN_REFERS].tab[idx].pfx,
			hidden[HIDDEN_REFERS].tab[idx].col->str);
		if (hidden[HIDDEN_REFERS].tab[idx].sref)
			(void) fprintf(cfp, " [%s]\n", hidden[HIDDEN_REFERS].tab[idx].sref);
		else	(void) fputc('\n', cfp);
	}

	(void) fputs(GETMSG(783, "\n"
		"# Mock domains to be added to the Country list.\n"), cfp);
	prMockDom(cfp);

	if (*filename != '-') {
		(void) fclose(cfp);
		if (verbose)
			prmsg(0, GETMSG(735,
				"Configuration file `%s' successfully created\n"), filename);
	}
	return 0;
}

/*
** Read values from history file, initialize counters.
*/
static int readHistory(int const mflag, LOGTIME *const tp) {
	char *hname = "www-stats.hist";	/* name of history file */
	char lbuf[LBUFSIZE]; 		/* line buffer */
	COUNTER *mp, *dp;		/* ptr to monthly & daily COUNTER structure */
	int rc, newfmt = -1;
	u_short md, mn, yr, lmn = 0, lyr = 0;
	u_long hits, files, nomod, views, sessions, kbytes;
	float bytes;
	FILE *hfp;

	if ((hfp = fopen(hname, "r")) == NULL)
		return 0;

	while (fgets(lbuf, sizeof lbuf, hfp) != NULL) {
		if (newfmt < 0) {
			if (!strncmp(lbuf, "# WWW History 2.4", 17) ||
			    !strncmp(lbuf, "# WWW History 2.3", 17) ||
			    !strncmp(lbuf, "# WWW History 2.2", 17) ||
			    !strncmp(lbuf, "# WWW History 2.01", 18))
				newfmt = 2;	/* 2.x including page views */
			else if (!strncmp(lbuf, "# WWW History 2.", 16))
				newfmt = 1;	/* 2.0 beta version */
			else	newfmt = 0;	/* 1.9e version */
			if (newfmt)
				continue;
		}
		if (lbuf[0] == '\n' || lbuf[0] == '#')
			continue;	/* skip empty and comment lines */

		if (newfmt) {
			if (2 == sscanf(lbuf, "LASTMON: %2hu/%4hu", &lmn, &lyr)) {
				if (--lmn > 11)
					lmn = 0;
				continue;
			}
			if (newfmt > 1)
				rc = (8 == sscanf(lbuf, "MON %hu/%hu: %lu %lu %lu %lu %lu %f",
					&mn, &yr, &hits, &files, &nomod, &views, &sessions, &bytes));
			else {
				rc = (7 == sscanf(lbuf, "MON %hu/%hu: %lu %lu %lu %lu %f",
					&mn, &yr, &hits, &files, &nomod, &sessions, &bytes));
				views = 0L;
			}
		} else {
			rc = (7 == sscanf(lbuf, "MON %hu/%hu: %lu %lu %lu %lu %lu",
				&mn, &yr, &hits, &files, &nomod, &sessions, &kbytes));
			bytes = 1024.0 * (float)kbytes;
			views = 0L;
		}
		if (rc) {
			mn--;
			assert(mn < (u_short)TABSIZE(monly));

			if ((yr == tp->year && mn == tp->mon) ||	/* skip current month */
			    (mn < tp->mon && yr != tp->year) ||		/* skip older/newer periods */
			    (mn > tp->mon && yr != tp->year-1))
				continue;

			mp = &monly[mn];

			if ((mp->hits = hits) > max_hits)		/* remember top month */
				max_hits = hits;
			mp->files = files;
			mp->nomod = nomod;
			mp->views = views;
			mp->sessions = sessions;
			mp->bytes = bytes;
			continue;
		}
		if (mflag)			/* skip daily stats for monthly summary */
			continue;

		if (newfmt > 1)
			rc = (9 == sscanf(lbuf, "DAY %hu/%hu/%hu: %lu %lu %lu %lu %lu %f",
				&md, &mn, &yr, &hits, &files, &nomod, &views, &sessions, &bytes));
		else if (newfmt) {
			rc = (8 == sscanf(lbuf, "DAY %hu/%hu/%hu: %lu %lu %lu %lu %f",
				&md, &mn, &yr, &hits, &files, &nomod, &sessions, &bytes));
			views = 0L;
		} else {
			rc = (8 == sscanf(lbuf, "DAY %hu/%hu/%hu: %lu %lu %lu %lu %lu",
				&md, &mn, &yr, &hits, &files, &nomod, &sessions, &kbytes));
			bytes = 1024.0 * (float)kbytes;
			views = 0L;
		}
		if (rc) {
			md--;
			assert(md < (u_short)TABSIZE(daily));

			mn--;
			assert(mn < (u_short)TABSIZE(monly));

			if (mn != t.current.mon || yr != t.current.year)	/* skip expired data */
				continue;

			dp = &daily[md];
			total.hits  += (dp->hits = hits);
			total.files += (dp->files = files);
			total.nomod += (dp->nomod = nomod);
			total.views += (dp->views = views);
			total.sessions += (dp->sessions = sessions);
			total.bytes += (dp->bytes = bytes);

			tp->mday = md+2;
			tp->mon  = mn;
			tp->year = yr;
		}
	}
	(void) fclose(hfp);
	if (mflag == 2) {			/* save month/year of last run */
		tp->mon  = lmn;
		tp->year = lyr;
	}
	return 1;
}

/*
** Create or update the history file.
*/
static void writeHistory(int const mflag) {
	char *hname = "www-stats.hist";	/* name of history file */
	COUNTER *mp;			/* ptr to COUNTER structure */
	u_short sti;
	size_t idx;
	FILE *hfp;

	errno = 0;
	if ((hfp = fopen(hname, "w")) == NULL) {
		prmsg(1, GETMSG(83, enoent), hname, strerror(errno));
		return;
	}
	/*
	** Save version in history, use hardcoded number
	** which changes only in major releases.
	*/
	(void) fprintf(hfp, "# WWW History %s\n", VERSION);

	if (!mflag)
		sti = t.end.mon;
	else {
		sti = t.end.mon+1;	/* update counter */
		monly[t.start.mon] = total;
	}
	if (!mflag && t.end.mday > 1) {	/* save daily counters until last day done */
		(void) fprintf(hfp, "# DAILY COUNTERS for summary period 1-%d %3.3s %d\n",
			t.end.mday, monnam[t.end.mon], t.end.year);
		for (idx=0; idx < (u_int)t.end.mday-1; idx++) {
			mp = &daily[idx];
			(void) fprintf(hfp, "DAY %02d/%02d/%04d:\t%7lu %7lu %7lu %7lu %7lu %1.0f\n",
				idx+1, t.end.mon+1, t.end.year,
				mp->hits, mp->files, mp->nomod, mp->views, mp->sessions, mp->bytes);
		}
		mp = &daily[idx];
		(void) fprintf(hfp, "CUR %02d/%02d/%04d:\t%7lu %7lu %7lu %7lu %7lu %1.0f\n",
				idx+1, t.end.mon+1, t.end.year,
				mp->hits, mp->files, mp->nomod, mp->views, mp->sessions, mp->bytes);
		(void) fprintf(hfp, "checksum\t%7lu %7lu %7lu %7lu %7lu %1.0f\n\n",
			total.hits, total.files, total.nomod, total.views, total.sessions, total.bytes);
	}

	(void) memset((void *)&cksum, 0, sizeof cksum);
	cksum.bytes = 0.0;

	(void) fprintf(hfp, "# MONTHLY COUNTERS for the last 12 months\n");
	(void) fprintf(hfp, "LASTMON: %02hu/%04hu\n", t.end.mon+1, t.end.year);
	for (idx=0; idx < 12; idx++) {
		mp = &monly[idx];
		(void) fprintf(hfp, "MON %02d/%04d:\t%7lu %7lu %7lu %7lu %7lu %1.0f\n",
			idx+1, idx >= (size_t)sti ? (int)t.end.year-1 : (int)t.end.year,
			mp->hits, mp->files, mp->nomod, mp->views, mp->sessions, mp->bytes);

		UPDATE_CNT(cksum, *mp);
	}
	(void) fprintf(hfp, "checksum\t%7lu %7lu %7lu %7lu %7lu %1.0f\n\n",
		cksum.hits, cksum.files, cksum.nomod, cksum.views, cksum.sessions, cksum.bytes);

	(void) fclose(hfp);
	return;
}

/*
** Read in HTML file if name is given.
*/
static char *readHTML(char *const key, char *const filename) {
	char lbuf[LBUFSIZE]; 		/* line buffer */
	size_t nbytes;
	FILE *hfp;

	if ((hfp=fopen(filename, "r")) == NULL) {
		prmsg(1, GETMSG(395, "Can't open %s file `%s'\n"), key, filename);
		return NULL;
	}
	if ((nbytes=fread(lbuf, 1, sizeof(lbuf)-1, hfp)) <= 0) {
		prmsg(1, GETMSG(396, "%s file `%s' unreadable or empty\n"), key, filename);
		(void) fclose(hfp);
		return NULL;
	}
	lbuf[nbytes] = '\0';
	(void) fclose(hfp);
	return strsave(lbuf);		/* error condition checked elsewhere */
}
