/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/
#pragma prototyped

#include	"neato.h"

#ifdef DMALLOC
#include "dmalloc.h"
#endif

void neato_nodesize(node_t* n, boolean flip)
{
    int         w;

    w = n->u.xsize = POINTS(n->u.width);
    n->u.lw  = n->u.rw = w / 2;
    n->u.ht = n->u.ysize = POINTS(n->u.height);
}

void neato_init_node(node_t* n)
{
	char	*str;

	n->u.width = late_float(n,N_width,DEFAULT_NODEWIDTH,MIN_NODEWIDTH);
	n->u.height = late_float(n,N_height,DEFAULT_NODEHEIGHT,MIN_NODEWIDTH);
	if (N_label == NULL) str = n->name;
	else {
		str = agxget(n,N_label->index);
		if (strcmp(str,NODENAME_ESC) == 0) str = n->name;
	}
	n->u.label = make_label(str,
		late_float(n,N_fontsize,DEFAULT_FONTSIZE,MIN_FONTSIZE),
		late_nnstring(n,N_fontname,DEFAULT_FONTNAME),
		late_nnstring(n,N_fontcolor,DEFAULT_COLOR),n->graph);
	n->u.shape = bind_shape(late_nnstring(n,N_shape,DEFAULT_NODESHAPE));
	n->u.shape->initfn(n); /* ### need to quantize ? */
	neato_nodesize(n,n->graph->u.left_to_right);
}

void neato_init_edge(edge_t* e)
{
	char	*p;

	e->u.factor = late_float(e,E_weight,1.0,1.0);

	if (E_label && (p = agxget(e,E_label->index)) && (p[0])) {
		e->u.label = make_label(agxget(e,E_label->index),
			late_float(e,E_fontsize,DEFAULT_FONTSIZE,MIN_FONTSIZE),
			late_nnstring(e,E_fontname,DEFAULT_FONTNAME),
			late_nnstring(e,E_fontcolor,DEFAULT_COLOR),e->tail->graph);
	}

    /* vladimir */
	if (E_headlabel && (p = agxget(e,E_headlabel->index)) && (p[0])) {
		e->u.head_label = make_label(agxget(e,E_headlabel->index),
			late_float(e,E_labelfontsize,DEFAULT_FONTSIZE,MIN_FONTSIZE),
			late_nnstring(e,E_labelfontname,DEFAULT_FONTNAME),
			late_nnstring(e,E_labelfontcolor,DEFAULT_COLOR),e->tail->graph);
	}
	if (E_taillabel && (p = agxget(e,E_taillabel->index)) && (p[0])) {
		e->u.tail_label = make_label(agxget(e,E_taillabel->index),
			late_float(e,E_labelfontsize,DEFAULT_FONTSIZE,MIN_FONTSIZE),
			late_nnstring(e,E_labelfontname,DEFAULT_FONTNAME),
			late_nnstring(e,E_labelfontcolor,DEFAULT_COLOR),e->tail->graph);
	}
    /* end vladimir */

	init_port(e->tail,e,agget(e,"tailport"));
	init_port(e->head,e,agget(e,"headport"));
}

void neato_init_node_edge(graph_t *g)
{
	node_t *n;
	edge_t *e;

    for (n = agfstnode(g); n; n = agnxtnode(g,n)) neato_init_node(n);
    for (n = agfstnode(g); n; n = agnxtnode(g,n)) {
        for (e = agfstout(g,n); e; e = agnxtout(g,e)) neato_init_edge(e);
    }
}

int init_port(node_t* n, edge_t* e, char* name)
{
	port_t	port;

	if (name == NULL) return FALSE;
	port = n->u.shape->portfn(n,name);
#ifdef NOTDEF
	if (n->graph->u.left_to_right) port.p = invflip_pt(port.p);
#endif 
	port.order = 0;
	if (e->tail == n) e->u.tail_port = port; else e->u.head_port = port;
	return TRUE;
}

void neato_cleanup_node(node_t* n)
{
	if (n->u.shape)
		n->u.shape->freefn(n);
	free_label(n->u.label);
	memset(&(n->u),0,sizeof(Agnodeinfo_t));
}

void neato_free_splines(edge_t* e)
{
	int		i;
	if (e->u.spl) {
		for (i = 0; i < e->u.spl->size; i++) free(e->u.spl->list[i].list);
		free(e->u.spl->list);
		free(e->u.spl);
	}
	e->u.spl = NULL;
}

void neato_cleanup_edge(edge_t* e)
{
	neato_free_splines(e);
	free_label(e->u.label);
	memset(&(e->u),0,sizeof(Agedgeinfo_t));
}

void neato_cleanup_graph(graph_t* g)
{
	free_scan_graph(g);
	free_ugraph(g);
	free_label(g->u.label);
	memset(&(g->u),0,sizeof(Agraphinfo_t));
}

void neato_cleanup(graph_t* g)
{
	node_t  *n;
	edge_t  *e;

	for (n = agfstnode(g); n; n = agnxtnode(g, n)) {
		for (e = agfstedge(g, n); e; e = agnxtedge(g, e, n)) {
			neato_cleanup_edge(e);
		}
		neato_cleanup_node(n);
	}
	neato_cleanup_graph(g);
}

void neato_layout(Agraph_t *g)
{
    int         nG;
    attrsym_t*  sym;
   
    /* setting rankdir=LR is currently undefined in neato,
     * but having it set causes has effects in the common routines.
     * So, we turn it off.
     */
    sym = agfindattr(g,"rankdir");
    if (sym)
      agxset (g, sym->index, "");

    graph_init(g);
    g->u.drawing->engine = NEATO;
    neato_init_node_edge(g);
    nG = scan_graph(g);
	if (Nop) {
	    initial_positions(g, nG);
	}
	else {
    	shortest_path(g, nG);
    	initial_positions(g, nG);
    	diffeq_model(g, nG);
    	solve_model(g, nG);
    	final_energy(g, nG); 
    	adjustNodes(g);
	}
   	spline_edges(g);
	dotneato_postprocess(g, neato_nodesize);
}   
